/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.common.CapitalHelper;
import com.kingdee.eas.fm.mobile.util.CapitalDistributionVo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NtDistributionHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.liquid.common.NtDistributionHelper");

    public Map getInitData(Context ctx) throws BOSException, EASBizException {
        Map<String, Object> result = new HashMap<String, Object>();
        Set<String> idSet = CapitalHelper.getPermissionOrgSet(ctx, "FIN_STORE_USE");
        if (idSet.size() == 0) {
            result.put("error", 1);
            result.put("errorMsg", "\u8be5\u7528\u6237\u65e0\u4efb\u4f55\u8d22\u52a1\u7ec4\u7ec7\u6295\u878d\u8d44\u53ca\u7968\u636e\u5b58\u91cf\u67e5\u8be2\u6743\u9650");
        } else {
            List<CompanyOrgUnitInfo> companyList = CapitalHelper.getTopLevelCompanySet(ctx, idSet);
            CompanyOrgUnitInfo company = null;
            if (companyList.size() == 1) {
                company = companyList.get(0);
            }
            if (companyList.size() > 1) {
                company = CapitalHelper.getDefaultCompany(ctx, companyList);
            }
            if (company != null) {
                String companyId = company.getId().toString();
                result = this.getDataByFilter(ctx, companyId, 10000);
            }
            result.put("idSet", idSet);
        }
        return result;
    }

    protected void dealCompanyData(Context ctx, Map result, CompanyOrgUnitInfo company, int unitValue) throws BOSException, EASBizException {
        BigDecimal sumPayAmt = BigDecimal.ZERO;
        BigDecimal sumRecAmt = BigDecimal.ZERO;
        ArrayList<CapitalDistributionVo> detail = new ArrayList<CapitalDistributionVo>();
        if (company.isIsLeaf()) {
            StringBuilder sb = new StringBuilder();
            sb.append(" select sum(t0.FPayBillAmt) payAmt, sum(t0.FRecBillAmt) recAmt from T_ORG_COMPANY com ");
            sb.append(" left join T_LI_NtBalance t0 on com.FID=t0.FCompanyID ");
            sb.append(" where com.FID = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getId().toString()});
            try {
                while (rs.next()) {
                    BigDecimal payAmt = rs.getBigDecimal("payAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("payAmt");
                    BigDecimal recAmt = rs.getBigDecimal("recAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("recAmt");
                    sumPayAmt = sumPayAmt.add(payAmt);
                    sumRecAmt = sumRecAmt.add(recAmt);
                    CapitalDistributionVo vo = new CapitalDistributionVo();
                    vo.setType("company");
                    vo.setUnitValue(unitValue);
                    vo.setCompanyId(company.getId().toString());
                    vo.setCurrencyId("");
                    vo.setSign("\uffe5");
                    vo.setName(company.getName());
                    vo.setObjId(company.getId().toString());
                    vo.setValue(payAmt);
                    vo.setValue2(recAmt);
                    detail.add(vo);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>> \u7968\u636edealCompanyData\u5355\u4e2a\u516c\u53f8\u6570\u636e\u5c55\u793a\u5f02\u5e38 ");
                logger.error((Object)e);
            }
        } else {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)false));
            filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
            filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)company.getId().toString()));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entityViewInfo);
            for (int i = 0; i < companyCol.size(); ++i) {
                CompanyOrgUnitInfo companyInfo = companyCol.get(i);
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT sum(t0.FPayBillAmt) payAmt, sum(t0.FRecBillAmt) recAmt from T_ORG_COMPANY com ");
                sb.append(" left join T_LI_NtBalance t0 on com.FID=t0.FCompanyID ");
                sb.append(" where ( com.flongnumber like ? or com.fid=? ) ");
                sb.append(" and com.fISFREEZE=0 and com.fIsSealUp=0 ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{companyInfo.getLongNumber() + "!%", companyInfo.getId().toString()});
                try {
                    while (rs.next()) {
                        BigDecimal payAmt = rs.getBigDecimal("payAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("payAmt");
                        BigDecimal recAmt = rs.getBigDecimal("recAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("recAmt");
                        sumPayAmt = sumPayAmt.add(payAmt);
                        sumRecAmt = sumRecAmt.add(recAmt);
                        CapitalDistributionVo vo = new CapitalDistributionVo();
                        vo.setType("company");
                        vo.setUnitValue(unitValue);
                        vo.setCompanyId(company.getId().toString());
                        vo.setCurrencyId("");
                        vo.setSign("\uffe5");
                        vo.setName(companyInfo.getName());
                        vo.setObjId(companyInfo.getId().toString());
                        vo.setValue(payAmt);
                        vo.setValue2(recAmt);
                        detail.add(vo);
                    }
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>> \u7968\u636edealCompanyData\u591a\u4e2a\u516c\u53f8\u6570\u636e\u5c55\u793a\u5f02\u5e38");
                    logger.error((Object)e);
                }
            }
        }
        result.put("CompanySumTitle", company.getName());
        this.sortAndShow("company", detail, result, sumPayAmt, sumRecAmt, company, unitValue);
    }

    protected void dealNtTypeData(Context ctx, Map result, CompanyOrgUnitInfo company, int unitValue) throws BOSException, EASBizException {
        ArrayList<CapitalDistributionVo> detail = new ArrayList<CapitalDistributionVo>();
        BigDecimal sumPayAmt = BigDecimal.ZERO;
        BigDecimal sumRecAmt = BigDecimal.ZERO;
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT type.FGroup typeId, sum(t2.FPayBillAmt) payAmt, sum(t2.FRecBillAmt) recAmt ");
        sb.append(" FROM T_NT_NTType type ");
        sb.append(" left join T_LI_NtBalance t2 on t2.FNtTypeID = type.FID ");
        sb.append(" left join T_ORG_COMPANY t3 on t3.FID=t2.FCompanyID ");
        sb.append(" where ( t3.flongnumber like ? or t3.FID=? ) ");
        sb.append(" and t3.fISFREEZE=0 and t3.fIsSealUp=0 ");
        sb.append(" group by type.FGroup");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{company.getLongNumber() + "!%", company.getId().toString()});
        HashMap<Integer, BigDecimal> paymap = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> recmap = new HashMap<Integer, BigDecimal>();
        try {
            while (rs.next()) {
                BigDecimal payAmt = rs.getBigDecimal("payAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("payAmt");
                BigDecimal recAmt = rs.getBigDecimal("recAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("recAmt");
                sumPayAmt = sumPayAmt.add(payAmt);
                sumRecAmt = sumRecAmt.add(recAmt);
                paymap.put(rs.getInt("typeId"), payAmt);
                recmap.put(rs.getInt("typeId"), recAmt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u8d44\u91d1\u6d1e\u5bdf>> \u7968\u636edealNtTypeData\u7968\u636e\u7c7b\u578b \u7968\u636e\u6570\u636e\u5c55\u793a\u5f02\u5e38 ");
            logger.error((Object)e);
        }
        BigDecimal amt51 = paymap.get(51) != null ? (BigDecimal)paymap.get(51) : BigDecimal.ZERO;
        BigDecimal amt52 = paymap.get(52) != null ? (BigDecimal)paymap.get(52) : BigDecimal.ZERO;
        BigDecimal amt41 = recmap.get(41) != null ? (BigDecimal)recmap.get(41) : BigDecimal.ZERO;
        BigDecimal amt42 = recmap.get(42) != null ? (BigDecimal)recmap.get(42) : BigDecimal.ZERO;
        CapitalDistributionVo vo = new CapitalDistributionVo();
        vo.setType("ntType");
        vo.setUnitValue(unitValue);
        vo.setCompanyId(company.getId().toString());
        vo.setCurrencyId("");
        vo.setSign("\uffe5");
        vo.setName("\u94f6\u884c\u627f\u5151\u6c47\u7968");
        vo.setObjId("541");
        vo.setValue(amt51);
        vo.setValue2(amt41);
        detail.add(vo);
        CapitalDistributionVo vo1 = new CapitalDistributionVo();
        vo1.setType("ntType");
        vo1.setUnitValue(unitValue);
        vo1.setCompanyId(company.getId().toString());
        vo1.setCurrencyId("");
        vo1.setSign("\uffe5");
        vo1.setName("\u5546\u4e1a\u627f\u5151\u6c47\u7968");
        vo1.setObjId("542");
        vo1.setValue(amt52);
        vo1.setValue2(amt42);
        detail.add(vo1);
        BigDecimal otherPayAmt = sumPayAmt.subtract(amt51).subtract(amt52);
        BigDecimal otherRecAmt = sumRecAmt.subtract(amt41).subtract(amt42);
        if (otherPayAmt.add(otherRecAmt).compareTo(BigDecimal.ZERO) > 0) {
            CapitalDistributionVo vo2 = new CapitalDistributionVo();
            vo2.setType("ntType");
            vo2.setUnitValue(unitValue);
            vo2.setCompanyId(company.getId().toString());
            vo2.setCurrencyId("");
            vo2.setSign("\uffe5");
            vo2.setName("\u5176\u4ed6");
            vo2.setObjId("543");
            vo2.setValue(otherPayAmt);
            vo2.setValue2(otherRecAmt);
            detail.add(vo2);
        }
        this.sortAndShow("ntType", detail, result, sumPayAmt, sumRecAmt, company, unitValue);
    }

    private void sortAndShow(String typeName, List<CapitalDistributionVo> detail, Map result, BigDecimal sumPayAmt, BigDecimal sumRecAmt, CompanyOrgUnitInfo company, int unitValue) {
        Collections.sort(detail, (Comparator)new Comparator<CapitalDistributionVo>(){

            @Override
            public int compare(CapitalDistributionVo o1, CapitalDistributionVo o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        result.put(typeName + "SumPayAmt", new DecimalFormat("###,##0.00").format(sumPayAmt.divide(new BigDecimal(String.valueOf(unitValue)))));
        result.put(typeName + "SumRecAmt", new DecimalFormat("###,##0.00").format(sumRecAmt.divide(new BigDecimal(String.valueOf(unitValue)))));
        ArrayList<String> legend = new ArrayList<String>();
        if (detail.size() <= 10) {
            for (int i = 0; i < detail.size(); ++i) {
                CapitalDistributionVo vo = detail.get(i);
                legend.add(vo.getName());
            }
            result.put("legendDataFor" + typeName, legend);
            result.put("detailDataFor" + typeName, detail);
        } else {
            BigDecimal elsePayAmt = sumPayAmt;
            BigDecimal elseRecAmt = sumRecAmt;
            ArrayList<CapitalDistributionVo> realDetail = new ArrayList<CapitalDistributionVo>();
            for (int i = 0; i < 10; ++i) {
                CapitalDistributionVo vo = detail.get(i);
                legend.add(vo.getName());
                realDetail.add(vo);
                elsePayAmt = elsePayAmt.subtract(vo.getValue());
                elseRecAmt = elseRecAmt.subtract(vo.getValue2());
            }
            CapitalDistributionVo vo = new CapitalDistributionVo();
            vo.setType(typeName);
            vo.setUnitValue(unitValue);
            vo.setCompanyId(company.getId().toString());
            vo.setCurrencyId("");
            vo.setSign("\uffe5");
            vo.setName("\u5176\u4ed6");
            vo.setObjId("");
            vo.setValue(elsePayAmt);
            vo.setValue2(elseRecAmt);
            realDetail.add(vo);
            legend.add("\u5176\u4ed6");
            result.put("legendDataFor" + typeName, legend);
            result.put("detailDataFor" + typeName, realDetail);
        }
    }

    public Map getDataByFilter(Context ctx, String companyId, int unitValue) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        result.put("currencyId", "");
        result.put("currencySign", "\uffe5");
        result.put("company", (String)company);
        switch (unitValue) {
            case 10000: {
                result.put("unit", "\u4e07\u5143");
                break;
            }
            case 1000000: {
                result.put("unit", "\u767e\u4e07\u5143");
                break;
            }
            case 10000000: {
                result.put("unit", "\u5343\u4e07\u5143");
                break;
            }
            case 100000000: {
                result.put("unit", "\u4ebf\u5143");
            }
        }
        this.dealCompanyData(ctx, result, company, unitValue);
        this.dealNtTypeData(ctx, result, company, unitValue);
        return result;
    }

    public Map getCompanySubData(Context ctx, String companyId, int unitValue) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        this.dealCompanyData(ctx, result, company, unitValue);
        return result;
    }
}

