/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.mobile.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public final class TimestampSetUtil {
    private final Date date;

    public TimestampSetUtil(Date date) {
        this.date = date;
    }

    public final List<Date> getDaysWithDayOfWeek() {
        Calendar cal = this.getCalendarWithFirstDayOfWeek();
        ArrayList<Date> result = new ArrayList<Date>();
        for (int i = 0; i <= this.getFirstDayOfWeek(); ++i) {
            result.add(cal.getTime());
            cal.add(5, 1);
        }
        return result;
    }

    private Calendar getCalendarWithFirstDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, -this.getFirstDayOfWeek());
        return cal;
    }

    private int getFirstDayOfWeek() {
        int dayOfWeek = this.getDayOfWeek(this.date);
        int dayOfMonth = this.getDayOfMonth(this.date);
        int firstDayOfWeek = Math.min(dayOfWeek, dayOfMonth);
        return firstDayOfWeek;
    }

    private int getDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5) - 1;
    }

    private int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) - 1;
    }

    public final List<Date> getDaysWithWeekOfMonth() {
        int dayOfWeek = this.getDayOfWeek(this.date);
        int dayOfMonth = this.getDayOfMonth(this.date);
        ArrayList<Date> result = new ArrayList<Date>();
        if (dayOfMonth > dayOfWeek) {
            Calendar cal = this.getCalendarWithFirstWeekendOfMonth(this.date, dayOfWeek, dayOfMonth);
            for (int i = 0; i < this.getWeekendCountWithMonth(dayOfWeek, dayOfMonth); ++i) {
                result.add(cal.getTime());
                cal.add(5, 7);
            }
        }
        result.add(this.date);
        return result;
    }

    private Calendar getCalendarWithFirstWeekendOfMonth(Date date, int dayOfWeek, int dayOfMonth) {
        int firstDay = this.getFirstWeekend(dayOfWeek, dayOfMonth);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, firstDay);
        return cal;
    }

    int getFirstWeekend(int dayOfWeek, int dayOfMonth) {
        return (dayOfMonth - dayOfWeek + 7 - 1) % 7 + 1;
    }

    int getWeekendCountWithMonth(int dayOfWeek, int dayOfMonth) {
        return (dayOfMonth - dayOfWeek + 6) / 7;
    }

    public int getFirstMonthWithQuarter() {
        int quarter = this.getQuarter(this.date);
        Calendar cal = this.getCalendarWithFirstMonthendOfQuarter(this.date, quarter);
        return cal.get(2);
    }

    public List<Date> getDaysWithMonthOfQuarter() {
        int quarter = this.getQuarter(this.date);
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar cal = this.getCalendarWithFirstMonthendOfQuarter(this.date, quarter);
        for (int i = this.getMonthOfYear(cal.getTime()); i < this.getMonthOfYear(this.date); ++i) {
            result.add(cal.getTime());
            this.nextMonth(cal);
        }
        result.add(this.date);
        return result;
    }

    private int getQuarter(Date date) {
        return this.getMonthOfYear(date) / 3;
    }

    private Calendar getCalendarWithFirstMonthendOfQuarter(Date date, int quarter) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, quarter * 3);
        cal.add(2, -1);
        this.nextMonth(cal);
        return cal;
    }

    private int getMonthOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2);
    }

    private void nextMonth(Calendar cal) {
        cal.add(2, 2);
        cal.set(5, 1);
        cal.add(5, -1);
    }

    public List<Date> getDaysWithMonthOfYear() {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar cal = this.getCalendarWithFirstMonthendOfQuarter(this.date, 0);
        for (int i = this.getMonthOfYear(cal.getTime()); i < this.getMonthOfYear(this.date); ++i) {
            result.add(cal.getTime());
            this.nextMonth(cal);
        }
        result.add(this.date);
        return result;
    }

    public Date getBeforeMonth(int monthNumber) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(2, monthNumber);
        return cal.getTime();
    }
}

