/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.nt.BankDraftFactory;
import com.kingdee.eas.fm.nt.BankDraftInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.Locale;

public class BankDraftBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        BankDraftInfo loanInfo = this.getBankDraftInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfo = this.createJournalInfoAmt(ctx, loanInfo);
        journalColl.add(journalInfo);
        return journalColl;
    }

    private JournalInfo createJournalInfoAmt(Context ctx, BankDraftInfo info) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getPayAccountBank());
        journalInfo.setCurrency(info.getCurrency());
        journalInfo.setCreateDate(new Date());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(info.getPayAmount());
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(info.getPayerDate());
        journalInfo.setAccountView(info.getPayAccountBank().getAccount());
        journalInfo.setOppAccountView(info.getOppSubject());
        journalInfo.setBillType(BillTypeEnum.bankFactor);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setDescription(ResourceBase.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"416_BankDraftBookNotifyBuilder", (Locale)ctx.getLocale()));
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private BankDraftInfo getBankDraftInfo(Context ctx, String billId) throws EASBizException, BOSException {
        BankDraftInfo info = BankDraftFactory.getLocalInstance(ctx).getBankDraftInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payAccountBank.account.*");
        return sic;
    }
}

