/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PayableBillImportVerify {
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    private static Logger logger = Logger.getLogger((String)PayableBillImportVerify.class.getName());

    public void verifyHead(Context ctx, CoreBaseInfo head) throws TaskExternalException {
        if (!(head instanceof PayableBillInfo)) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"61_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        PayableBillInfo info = (PayableBillInfo)head;
        this.checkEmpty(info.getNumber(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"62_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        if (info.getBillMedium() == BillMediumEnum.PAPERY) {
            this.checkEmpty(info.getDraftNumber(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"453_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        }
        this.checkEmpty((Object)info.getBillMedium(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"548_PayableBillDataImport", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getCompany(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"63_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.checkEmpty(info.getType(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"395_PayableBillDataImport", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getApplyUnit(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"394_PayableBillDataImport", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getCurrency(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"71_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getAmount(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"396_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getIssueDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"64_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getExpiredDate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"68_ReceivableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getPayeeName(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"397_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getLocalCurExRate(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"398_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        this.checkEmpty(info.getGaranteeType(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"399_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        if (!info.getMakeType().equals((Object)BillMakeTypeEnum.ENTRUST)) {
            this.checkEmpty(info.getOutBankAccountName(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"400_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
        }
        if (info.getBillMedium() != null && info.getBillMedium() == BillMediumEnum.ELECTRONIC) {
            this.checkEmpty(info.getDrawerBankNumber(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"544_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
            this.checkEmpty(info.getPayeeBankNumber(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"545_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
            if (info.isIsAccept()) {
                this.checkEmpty(info.getAcceptorAccountName(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"546_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
                this.checkEmpty(info.getAcceptorBankNum(), ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"547_PayableBillImportVerify", (Locale)ctx.getLocale()), ctx);
            }
        }
        if (info.getAmount().compareTo(Constants.ZERO) <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"401_PayableBillImportVerify", (Locale)ctx.getLocale()));
        }
        CurrencyInfo currency = info.getCurrency();
        if (info.getLocalCurExRate().compareTo(Constants.ZERO) < 0) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"74_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        if (info.getAssureProportion().compareTo(Constants.ZERO) < 0 || info.getAssureProportion().compareTo(Constants.ONE) > 0) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"402_PayableBillImportVerify", (Locale)ctx.getLocale()));
        }
        CurrencyInfo localCurrency = companyInfo.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId()) && info.getLocalCurExRate().compareTo(Constants.ONE) != 0) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"76_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
        if (info.getExpiredDate().before(info.getIssueDate())) {
            throw new TaskExternalException(ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"403_PayableBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private void checkEmpty(Object obj, String msg, Context ctx) throws TaskExternalException {
        if (obj == null) {
            throw new TaskExternalException(msg + ResourceBase.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"79_ReceivableBillImportVerify", (Locale)ctx.getLocale()));
        }
    }
}

