/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.PledgeExchangeCondStrategy;
import com.kingdee.eas.fm.nt.PledgeExchangeOnlyAmountSame;
import com.kingdee.eas.fm.nt.PledgeExchangeOnlyBankSame;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import java.math.BigDecimal;
import java.util.List;

public class PledgeExchangeAllSame
extends PledgeExchangeCondStrategy {
    public PledgeExchangeAllSame(String wageBankName) {
        super(wageBankName);
    }

    @Override
    public void checkExchangeCond(List arrExchangeOut, List arrExchangeIn) throws NTException {
        new PledgeExchangeOnlyAmountSame(this.getWageBankName()).checkExchangeCond(arrExchangeOut, arrExchangeIn);
        new PledgeExchangeOnlyBankSame(this.getWageBankName()).checkExchangeCond(arrExchangeOut, arrExchangeIn);
    }

    @Override
    public FilterInfo getExchangeFindCond(List arrExchangeOut) {
        FilterInfo fi = super.getExchangeFindCond(arrExchangeOut);
        BigDecimal outAmt = new BigDecimal("0");
        for (int i = 0; i < arrExchangeOut.size(); ++i) {
            ReceivableBillInfo billInfo = (ReceivableBillInfo)arrExchangeOut.get(i);
            outAmt = outAmt.add(billInfo.getBillAmt());
        }
        fi.getFilterItems().add(new FilterItemInfo("billAmt", (Object)outAmt, CompareType.LESS_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("acceptanceBankName", (Object)this.getWageBankName(), CompareType.EQUALS));
        return fi;
    }
}

