/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillFacadeFactory;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillFactory;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillInfo;
import com.kingdee.eas.fm.nt.AssureAmountReturnStateEnum;
import com.kingdee.eas.fm.nt.IAssureAmountReturnBillFacade;
import com.kingdee.eas.fm.nt.client.AbstractAssureAmountReturnBillListUI;
import com.kingdee.eas.fm.nt.client.AssureAmountReturnBillFilterUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AssureAmountReturnBillListUI
extends AbstractAssureAmountReturnBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(AssureAmountReturnBillListUI.class);
    private AssureAmountReturnBillFilterUI filterUI;
    private IContextHelper iContextHelper;
    private Map currencyCache = new HashMap();

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompanyCommon);
        this.iContextHelper = ContextHelperFactory.getRemoteInstance();
        super.onLoad();
        this.appendFootRow();
        FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"localCurAmount", (String)this.currentCompanyCommon.getBaseCurrency().getId().toString());
        this.tblMain.getColumn("interestRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)5));
        this.actionAddNew.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setVisible(true);
        this.actionCopyTo.setVisible(false);
        ItemAction[] actions = new ItemAction[]{this.actionBook, this.actionAntiBook, this.actionGenRec, this.actionCancelRec};
        FMClientHelper.setActionEnable((ItemAction[])actions, (boolean)false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            return;
        }
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(indexs[0]);
        BizEnumValueDTO status = (BizEnumValueDTO)row.getCell("returnState").getValue();
        boolean submitStatus = status.getInt() == 0;
        boolean genRecStatus = status.getInt() == 1;
        boolean isGenRec = (Boolean)row.getCell("isGenRec").getValue();
        boolean isBooked = false;
        isBooked = row.getCell("cashier").getValue() != null;
        this.actionBook.setEnabled(genRecStatus && !isGenRec && !isBooked);
        this.actionAntiBook.setEnabled(isBooked);
        this.actionGenRec.setEnabled(submitStatus);
        this.actionCancelRec.setEnabled(genRecStatus && !isBooked);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(indexs[0]);
        BizEnumValueDTO status = (BizEnumValueDTO)row.getCell("returnState").getValue();
        String pk = this.getSelectedKeyValue();
        if (status.getInt() != 0 || !AssureAmountReturnBillFactory.getRemoteInstance().checkCanOprt(pk)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"435_AssureAmountReturnBillListUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(indexs[0]);
        BizEnumValueDTO status = (BizEnumValueDTO)row.getCell("returnState").getValue();
        String pk = this.getSelectedKeyValue();
        if (status.getInt() != 0 || !AssureAmountReturnBillFactory.getRemoteInstance().checkCanOprt(pk)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"436_AssureAmountReturnBillListUI"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        BizEnumValueDTO status = null;
        Boolean isGenRec = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("returnState").getValue();
            isGenRec = (Boolean)row.getCell("isGenRec").getValue();
            if (status.getInt() != 1 || isGenRec.booleanValue()) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"145_ConsignmentBillListUI"));
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            IAssureAmountReturnBillFacade facade = AssureAmountReturnBillFacadeFactory.getRemoteInstance();
            facade.book(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"146_ConsignmentBillListUI"))) == 0) {
            IAssureAmountReturnBillFacade facade = AssureAmountReturnBillFacadeFactory.getRemoteInstance();
            facade.book(ids);
            this.showMsg(e);
        }
    }

    @Override
    public void actionAntiBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        Object cashier = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            cashier = row.getCell("cashier").getValue();
            if (cashier == null) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"147_ConsignmentBillListUI"));
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            IAssureAmountReturnBillFacade facade = AssureAmountReturnBillFacadeFactory.getRemoteInstance();
            facade.antiBook(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.cl.CLAutoGenerateResource", (String)"148_ConsignmentBillListUI"))) == 0) {
            IAssureAmountReturnBillFacade facade = AssureAmountReturnBillFacadeFactory.getRemoteInstance();
            facade.antiBook(ids);
            this.showMsg(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionGenRec_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedids = this.getSelectedIdValues();
        ArrayList usedIds = new ArrayList();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            Map mutexRequest = iMutex.batchRequestObjIDForUpdate((List)selectedids);
            int size = selectedids.size();
            for (int index = 0; index < size; ++index) {
                Boolean boolRequest = (Boolean)mutexRequest.get(selectedids.get(index));
                if (boolRequest.booleanValue()) continue;
                usedIds.add(selectedids.get(index));
                selectedids.remove(index);
            }
            if (usedIds.size() > 0) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"billIsLocked")});
            }
            HashSet idSet = new HashSet(selectedids);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            CoreBillBaseCollection coll = AssureAmountReturnBillFactory.getRemoteInstance().getCoreBillBaseCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                AssureAmountReturnBillInfo info = (AssureAmountReturnBillInfo)coll.get(i);
                if (!info.isIsGenRec()) continue;
                String failDetail = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"589_AssureAmountListUI") + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"592_AssureAmountReturnBillListUI");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"591_AssureAmountListUI"), (String)failDetail, (int)2);
                SysUtil.abort();
                this.refresh(e);
            }
            boolean isCreateRec = false;
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"438_AssureAmountReturnBillListUI"));
            if (result != 2 && result == 0) {
                FMClientHelper.generateDestBillAss((CoreBillListUI)this, (String)new AssureAmountReturnBillInfo().getBOSType().toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (CoreBillBaseCollection)coll);
                isCreateRec = true;
            }
            AssureAmountReturnBillFactory.getRemoteInstance().batchDoGenRecBill(idSet, isCreateRec);
        }
        finally {
            if (selectedids.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate((List)selectedids);
            }
        }
        this.refresh(e);
    }

    @Override
    public void actionCancelRec_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        AssureAmountReturnBillInfo info = AssureAmountReturnBillFactory.getRemoteInstance().getAssureAmountReturnBillInfo((IObjectPK)new ObjectUuidPK(pk));
        if (info.getReturnState() == AssureAmountReturnStateEnum.RECED && info.getCashier() == null) {
            AssureAmountReturnBillFactory.getRemoteInstance().doDelRecBill(pk);
        }
        this.showMsg(e);
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        this.processPrecision();
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AssureAmountReturnBillFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AssureAmountReturnBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fm.nt.client.AssureAmountReturnBillEditUI";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionAntiBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionGenRec.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
        this.actionCancelRec.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_ungathering"));
        int bookType = this.iContextHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId()));
        if (bookType != 0) {
            this.actionBook.setVisible(false);
            this.actionAntiBook.setVisible(false);
        } else {
            this.actionBook.setVisible(true);
            this.actionAntiBook.setVisible(true);
        }
    }

    protected int queryCurrencyPrecision(String curId) throws EASBizException, BOSException {
        if (this.currencyCache.containsKey(curId)) {
            Integer intPrec = (Integer)this.currencyCache.get(curId);
            return intPrec;
        }
        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(curId));
        Integer intPrec = new Integer(cur.getPrecision());
        this.currencyCache.put(curId, intPrec);
        return intPrec;
    }

    private void processPrecision() {
        try {
            for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
                IRow row = this.tblMain.getRow(i);
                if (row.isStat()) {
                    IRow rowUpOne = this.tblMain.getRow(i - 1);
                    String formatString = FMClientHelper.getNumberFtm((int)this.queryCurrencyPrecision((String)rowUpOne.getCell("currency.id").getValue()));
                    int ratePre = FMClientHelper.getPrecOfExRate((String)this.currentCompanyCommon.getId().toString(), (String)((String)rowUpOne.getCell("currency.id").getValue()), null, (Date)new Date());
                    String rateFormatString = FMClientHelper.getNumberFtm((int)ratePre);
                    row.getCell("rate").getStyleAttributes().setNumberFormat(rateFormatString);
                    row.getCell("assureAmount").getStyleAttributes().setNumberFormat(formatString);
                    row.getCell("assureInterest").getStyleAttributes().setNumberFormat(formatString);
                    row.getCell("totalAmount").getStyleAttributes().setNumberFormat(formatString);
                    continue;
                }
                String formatString = FMClientHelper.getNumberFtm((int)this.queryCurrencyPrecision((String)row.getCell("currency.id").getValue()));
                int ratePre = FMClientHelper.getPrecOfExRate((String)this.currentCompanyCommon.getId().toString(), (String)((String)row.getCell("currency.id").getValue()), null, (Date)new Date());
                String rateFormatString = FMClientHelper.getNumberFtm((int)ratePre);
                row.getCell("rate").getStyleAttributes().setNumberFormat(rateFormatString);
                row.getCell("assureAmount").getStyleAttributes().setNumberFormat(formatString);
                row.getCell("assureInterest").getStyleAttributes().setNumberFormat(formatString);
                row.getCell("totalAmount").getStyleAttributes().setNumberFormat(formatString);
            }
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        IRow rowLongTime = this.tblMain.getGroupManager().getStatRowTemplate(0);
        rowLongTime.getStyleAttributes().setBackground(new Color(0xF6F6B6));
    }

    public void executeQuery(FilterParam param) throws BOSException {
        super.executeQuery(param);
        this.processPrecision();
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.appendFootRow();
        this.processPrecision();
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        if (row != null && this.getBOTPViewStatus() == 0) {
            for (int i = 0; i < this.getPrecColName().length; ++i) {
                this.tblMain.getFootRow(0).getCell(this.getPrecColName()[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)4));
            }
        }
        return row;
    }

    protected String[] getPrecColName() {
        return new String[]{"localCurAmount", "assureAmount", "assureInterest", "totalAmount", "id"};
    }
}

