/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.BizUnitControlUtilHelper;
import com.kingdee.eas.fm.common.util.FMBillUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.fm.fpl.client.FpItemClientHelper;
import com.kingdee.eas.fm.nt.BankDraftCollection;
import com.kingdee.eas.fm.nt.BankDraftEnum;
import com.kingdee.eas.fm.nt.BankDraftFacadeFactory;
import com.kingdee.eas.fm.nt.BankDraftFactory;
import com.kingdee.eas.fm.nt.BankDraftInfo;
import com.kingdee.eas.fm.nt.IBankDraftFacade;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.client.AbstractBankDraftEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankDraftEditUI
extends AbstractBankDraftEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BankDraftEditUI.class);
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();
    private boolean isCopy = false;
    private boolean isBalance = false;
    private int flagPayAccountBank = 0;
    private BizUnitControlUtilHelper bizUnitControlUtilHelper;
    private Locale locale = SysContext.getSysContext().getLocale();

    @Override
    public void loadFields() {
        Map lisener = null;
        try {
            lisener = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBudgetSubject, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (null != this.editData.getSourceBillId()) {
            this.txtRemittor.setEditable(false);
            this.prmtPayAccountBank.setEnabled(false);
            this.prmtPayBank.setEnabled(false);
            this.prmtRecPerson.setEnabled(false);
            this.prmtRecAccount.setEnabled(false);
            this.txtRecAcount.setEnabled(false);
            this.prmtProxyCashBank.setEnabled(false);
            this.txtCashAddress.setEditable(false);
            this.comCurrency.setEnabled(false);
            this.txtPayAmount.setEditable(false);
            this.txtUsage.setEditable(false);
            this.prmtBudgetSubject.setEnabled(false);
        } else {
            this.txtRemittor.setEditable(true);
            this.prmtPayAccountBank.setEnabled(true);
            this.prmtPayBank.setEnabled(true);
            this.prmtRecPerson.setEnabled(true);
            this.prmtRecAccount.setEnabled(true);
            this.txtRecAcount.setEnabled(true);
            this.prmtProxyCashBank.setEnabled(true);
            this.txtCashAddress.setEditable(true);
            this.comCurrency.setEnabled(true);
            this.txtPayAmount.setEditable(true);
            this.txtUsage.setEditable(true);
            this.prmtBudgetSubject.setEnabled(true);
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)this.editData.getCurrency());
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        this.txtExchangeRate.setValue((Object)this.editData.getExchangeRate());
        this.prmtOppSubject.setValue((Object)this.editData.getOppSubject());
        try {
            this.currencyManageLoad("");
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
        this.verifyAmtIsZero();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)lisener);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        try {
            this.changeEntryBtn();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.pkPayerDate.setValue((Object)this.editData.getPayerDate());
        this.pkMatureDate.setValue((Object)this.editData.getMatureDate());
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBudgetSubject, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionReturnBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_returnticket"));
        this.actionCancelReturnBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelreturnticket"));
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAudit.setVisible(false);
        this.actionAntiAudit.setVisible(false);
    }

    private void verifyAmtIsZero() {
        if (null != this.editData.getPNaturalAmt()) {
            if (this.editData.getPNaturalAmt().compareTo(new BigDecimal("0.00")) > 0) {
                this.txtPCapital.setText(GlUtils.getChineseFormat((BigDecimal)this.getDecimal(this.txtPNaturalAmt), (boolean)true, (Locale)this.locale));
            } else if (this.editData.getPNaturalAmt().compareTo(new BigDecimal("0.00")) == 0) {
                this.txtPCapital.setText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"163_BankDraftEditUI"));
            }
        }
        if (null != this.editData.getANaturalAmt()) {
            if (this.editData.getANaturalAmt().compareTo(new BigDecimal("0.00")) > 0) {
                this.txtACapital.setText(GlUtils.getChineseFormat((BigDecimal)this.getDecimal(this.txtANaturalAmt), (boolean)true, (Locale)this.locale));
            } else if (this.editData.getANaturalAmt().compareTo(new BigDecimal("0.00")) == 0) {
                this.txtACapital.setText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"163_BankDraftEditUI"));
            }
        }
        if (null != this.editData.getENaturalAmt()) {
            if (this.editData.getENaturalAmt().compareTo(new BigDecimal("0.00")) > 0) {
                this.txtECapital.setText(GlUtils.getChineseFormat((BigDecimal)this.getDecimal(this.txtENaturalAmt), (boolean)true, (Locale)this.locale));
            } else if (this.editData.getENaturalAmt().compareTo(new BigDecimal("0.00")) == 0) {
                this.txtECapital.setText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"163_BankDraftEditUI"));
            }
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        BankDraftInfo info = (BankDraftInfo)dataObject;
        if (this.getBOTPViewStatus() == 1) {
            info.setMatureDate(DateUtil.getNextMonth((Date)info.getPayerDate()));
            info.setBillState(BankDraftEnum.SAVE);
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            if (this.txtPNaturalAmt.getBigDecimalValue().compareTo(new BigDecimal("0.00")) > 0) {
                info.setPCapital(GlUtils.getChineseFormat((BigDecimal)this.txtPNaturalAmt.getBigDecimalValue(), (boolean)true, (Locale)this.locale));
            } else if (this.txtPNaturalAmt.getBigDecimalValue().compareTo(new BigDecimal("0.00")) == 0) {
                info.setPCapital(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"163_BankDraftEditUI"));
            }
            if (info.getPayAccountBank() != null && info.getPayAccountBank().getName() == null) {
                try {
                    AccountBankInfo abInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayAccountBank().getId()));
                    info.setPayAccountBank(abInfo);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            info.setFiVouchered(false);
        }
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.BankDraft", null, (IObjectValue)this.editData);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.actionSave.setEnabled(false);
        this.btnSave.setEnabled(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BankDraftInfo info = BankDraftFactory.getRemoteInstance().getBankDraftInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (info.getBillState() == BankDraftEnum.SAVE || info.getBillState() == BankDraftEnum.REGISTED) {
            super.actionEdit_actionPerformed(e);
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"164_BankDraftEditUI");
            msg = MessageFormat.format(msg, new Object[]{info.getBillState()});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BankDraftInfo info = BankDraftFactory.getRemoteInstance().getBankDraftInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (info.getBillState() == BankDraftEnum.SAVE || info.getBillState() == BankDraftEnum.REGISTED) {
            super.actionRemove_actionPerformed(e);
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"165_BankDraftEditUI");
            msg = MessageFormat.format(msg, new Object[]{info.getBillState()});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkModified();
        if (this.editData != null) {
            BankDraftInfo newEditData = this.editData.copy();
            newEditData.setPayerDate(FMBillUtil.getServerDate());
            newEditData.setMatureDate(DateUtil.getNextMonth((Date)newEditData.getPayerDate()));
            this.unLockUI();
            this.setOprtState("ADDNEW");
            this.setDataObject((IObjectValue)newEditData);
            this.loadFields();
            this.showCopyAddNew();
            this.actionCopy.setEnabled(false);
        }
    }

    @Override
    public void actionVoucher2_actionPerformed(ActionEvent e) throws Exception {
        BankDraftInfo info = BankDraftFactory.getRemoteInstance().getBankDraftInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (!info.isFiVouchered() && info.getBillState() == BankDraftEnum.AUDIT) {
            super.actionVoucher_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"175_BankDraftListUI"));
        }
    }

    @Override
    public void actionDelVoucher2_actionPerformed(ActionEvent e) throws Exception {
        BankDraftInfo info = BankDraftFactory.getRemoteInstance().getBankDraftInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (info.isFiVouchered() && info.getBillState() == BankDraftEnum.AUDIT) {
            super.actionDelVoucher_actionPerformed(e);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"167_BankDraftEditUI"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"176_BankDraftListUI"));
        }
    }

    @Override
    public void actionBalance_actionPerformed(ActionEvent e) throws Exception {
        this.isBalance = true;
        this.txtActualBalanceAccount.setEnabled(true);
        this.txtActualBalanceAccount.setRequired(true);
        this.txtActualBalanceAccount.setValue((Object)this.txtPayAmount.getBigDecimalValue());
        this.editData.setBillState(BankDraftEnum.FOOTUP);
        this.editData.setCashDate(FMBillUtil.getServerDate());
    }

    @Override
    public void actionReturnBill_actionPerformed(ActionEvent e) throws Exception {
        this.txtActualBalanceAccount.setEnabled(false);
        this.txtActualBalanceAccount.setValue((Object)new BigDecimal("0.00"));
        this.txtANaturalAmt.setEnabled(false);
        this.txtANaturalAmt.setValue((Object)new BigDecimal("0.00"));
        this.txtExtraAccount.setEditable(false);
        this.txtExtraAccount.setValue((Object)this.txtPayAmount.getBigDecimalValue());
        this.txtENaturalAmt.setEditable(false);
        this.txtENaturalAmt.setValue((Object)this.txtPNaturalAmt.getBigDecimalValue());
        this.editData.setBillState(BankDraftEnum.BOUNCED);
    }

    @Override
    public void actionCancelReturnBill_actionPerformed(ActionEvent e) throws Exception {
        this.txtExtraAccount.setEditable(false);
        this.txtExtraAccount.setValue((Object)Constants.ZERO);
        this.txtENaturalAmt.setEditable(false);
        this.txtENaturalAmt.setValue((Object)Constants.ZERO);
        this.editData.setBillState(BankDraftEnum.AUDIT);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankDraftFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        BankDraftInfo info = null;
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (action != null && id != null && action.equals("COPY")) {
            info = new BankDraftInfo();
            try {
                BankDraftInfo oldInfo = (BankDraftInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                info = oldInfo.copy();
                info.setPayerDate(FMBillUtil.getServerDate());
                info.setMatureDate(DateUtil.getNextMonth((Date)info.getPayerDate()));
                this.isCopy = true;
                map.remove("COPY");
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
        } else {
            info = new BankDraftInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setPayerDate(FMBillUtil.getServerDate());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(info.getPayerDate());
            calendar.add(2, 1);
            info.setMatureDate(calendar.getTime());
            info.setRemittor(SysContext.getSysContext().getCurrentFIUnit().getName());
            info.setPNaturalAmt(new BigDecimal("0.00"));
            info.setExchangeRate(new BigDecimal("1"));
            info.setPayAmount(new BigDecimal("0.00"));
            info.setPNaturalAmt(new BigDecimal("0.00"));
            info.setBillState(BankDraftEnum.SAVE);
            info.setFiVouchered(false);
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            info.setCurrency(this.contextHelp.getCurrentCompany().getBaseCurrency());
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comCurrency.getSelectedItem();
            boolean isLocalCurrency = RecPayHandler.isLocalCurrency((CurrencyInfo)currencyInfo, null);
            if (isLocalCurrency) {
                this.txtExchangeRate.setEnabled(false);
            } else {
                this.txtExchangeRate.setEnabled(true);
            }
            this.txtActualBalanceAccount.setEnabled(false);
            this.txtExtraAccount.setEnabled(false);
        }
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("proxyCashBank");
        sic.add("fpItem");
        sic.add("oppSubject");
        sic.add("payBank");
        sic.add("operator");
        sic.add("remittor");
        sic.add("company");
        sic.add("proxyCashBank");
        sic.add("fiVouchered");
        sic.add("bgOutItemID");
        sic.add("bgOutItemNumber");
        sic.add("bgOutItemName");
        sic.add("fundFlowItem.*");
        sic.add("mbgNumber");
        sic.add("mbgName");
        return sic;
    }

    public void onLoad() throws Exception {
        BankDraftInfo info;
        this.bizUnitControlUtilHelper = new BizUnitControlUtilHelper((Object)this, 5);
        Map lisener = null;
        try {
            lisener = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtPayBank, (Boolean)Boolean.TRUE, (boolean)true);
        this.pkPayerDate.setSupportedEmpty(false);
        super.onLoad();
        this.actionViewBdgBalance.setVisible(true);
        ExtendParser fpItemParser = new ExtendParser(this.prmtFpItem);
        this.prmtFpItem.setCommitParser((IParser)fpItemParser);
        this.prmtFpItem.setMaxLength(80);
        ExtendParser remittorParser = new ExtendParser(this.prmtRecPerson);
        this.prmtRecPerson.setCommitParser((IParser)remittorParser);
        this.prmtRecPerson.setMaxLength(80);
        ExtendParser companyParser = new ExtendParser(this.prmtCompany);
        this.prmtCompany.setCommitParser((IParser)companyParser);
        this.prmtCompany.setMaxLength(80);
        ExtendParser proxyCashBankParser = new ExtendParser(this.prmtProxyCashBank);
        this.prmtProxyCashBank.setCommitParser((IParser)proxyCashBankParser);
        this.prmtProxyCashBank.setMaxLength(80);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBudgetSubject, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.txtTestKey.setRequired(false);
        this.btnAudit.setEnabled(false);
        this.menuItemAntiAudit.setEnabled(false);
        this.btnAntiAudit.setEnabled(false);
        this.menuItemAudit.setEnabled(false);
        this.actionReturnBill.setEnabled(false);
        this.btnReturnBill.setEnabled(false);
        this.menuItemReturnBill.setEnabled(false);
        this.actionCancelReturnBill.setEnabled(false);
        this.btnCancelReturnBill.setEnabled(false);
        this.menuItemCancelReturnBill.setEnabled(false);
        this.actionBalance.setEnabled(false);
        this.btnBalance.setEnabled(false);
        this.menuItemBalance.setEnabled(false);
        this.actionVoucher.setEnabled(false);
        this.btnVoucher.setEnabled(false);
        this.MenuItemVoucher.setEnabled(false);
        this.actionDelVoucher.setEnabled(false);
        this.btnDelVoucher.setEnabled(false);
        this.menuItemDelVoucher.setEnabled(false);
        String uiState = this.getOprtState();
        if ((uiState.equals(OprtState.COPYADDNEW) || uiState.equals(OprtState.EDIT)) && null != (info = this.editData) && null != this.editData.getBillState()) {
            if (info.getBillState() == BankDraftEnum.FOOTUP) {
                this.btnReturnBill.setEnabled(false);
                this.menuItemReturnBill.setEnabled(false);
            } else if (info.getBillState() == BankDraftEnum.BOUNCED) {
                this.btnBalance.setEnabled(false);
                this.menuItemBalance.setEnabled(false);
            } else if (info.getBillState() == BankDraftEnum.AUDIT) {
                this.actionReturnBill.setEnabled(true);
                this.btnReturnBill.setEnabled(true);
                this.menuItemReturnBill.setEnabled(true);
                this.actionBalance.setEnabled(true);
                this.btnBalance.setEnabled(true);
                this.menuItemBalance.setEnabled(true);
            } else if (info.getBillState() == BankDraftEnum.BOUNCED) {
                this.actionCancelReturnBill.setEnabled(true);
                this.btnCancelReturnBill.setEnabled(true);
                this.menuItemCancelReturnBill.setEnabled(true);
            } else if (info.getBillState() == BankDraftEnum.REGISTED) {
                this.actionSave.setEnabled(false);
                this.btnSave.setEnabled(false);
            }
            if (info.getBillState() == BankDraftEnum.AUDIT && !info.isFiVouchered() && info.getBillState() != BankDraftEnum.FOOTUP && info.getBillState() != BankDraftEnum.BOUNCED) {
                this.btnAntiAudit.setEnabled(true);
                this.menuItemAntiAudit.setEnabled(true);
            }
            if (!info.isFiVouchered() && info.getBillState() == BankDraftEnum.AUDIT) {
                this.actionVoucher.setEnabled(true);
                this.btnVoucher.setEnabled(true);
                this.MenuItemVoucher.setEnabled(true);
            } else if (info.isFiVouchered() && (info.getBillState() == BankDraftEnum.AUDIT || info.getBillState() != BankDraftEnum.FOOTUP || info.getBillState() != BankDraftEnum.BOUNCED)) {
                this.actionDelVoucher.setEnabled(true);
                this.btnDelVoucher.setEnabled(true);
                this.menuItemDelVoucher.setEnabled(true);
            }
        }
        if (uiState.equals(OprtState.VIEW)) {
            info = this.editData;
            if (!info.isFiVouchered()) {
                this.actionVoucher.setEnabled(true);
                this.btnVoucher.setEnabled(true);
                this.MenuItemVoucher.setEnabled(true);
            } else if (info.getBillState() == BankDraftEnum.AUDIT || info.getBillState() != BankDraftEnum.FOOTUP || info.getBillState() != BankDraftEnum.BOUNCED) {
                this.actionDelVoucher.setEnabled(true);
                this.btnDelVoucher.setEnabled(true);
                this.menuItemDelVoucher.setEnabled(true);
            }
            if (info.getBillState() == BankDraftEnum.AUDIT) {
                if (!info.isFiVouchered()) {
                    this.actionVoucher2.setEnabled(true);
                }
                this.actionReturnBill.setEnabled(true);
            }
        }
        this.txtActualBalanceAccount.setEnabled(false);
        this.txtExtraAccount.setEnabled(false);
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)lisener);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.actionEntryAccount.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
        this.actionCancelEntryAccount.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        this.menuItemView.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.bizUnitControlUtilHelper.resetActionWithBlackWhiteList();
        if (this.bizUnitControlUtilHelper.isBizUnit()) {
            this.menuEdit.setVisible(false);
            this.menuBiz.setVisible(false);
            this.MenuService.setVisible(false);
        }
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBudgetSubject, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
        this.initF7AccountBank(this.prmtPayAccountBank);
    }

    @Override
    protected void pkPayerDate_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void txtPayAmount_dataChanged(DataChangeEvent e) throws Exception {
        String uiState;
        if (null != this.txtPayAmount.getText() && !this.txtPayAmount.getText().trim().equals("") && null != this.txtExchangeRate.getText() && !this.txtExchangeRate.getText().trim().equals("")) {
            this.txtPNaturalAmt.setValue((Object)this.txtPayAmount.getBigDecimalValue().multiply(this.txtExchangeRate.getBigDecimalValue()));
        }
        if (!(uiState = this.getOprtState()).equals(OprtState.ADDNEW) && this.isBalance) {
            this.calExtraAmount();
        }
    }

    @Override
    protected void txtActualBalanceAccount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtActualBalanceAccount.getBigDecimalValue().compareTo(this.txtPayAmount.getBigDecimalValue()) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"169_BankDraftEditUI"));
            SysUtil.abort();
        }
        if (null != this.txtActualBalanceAccount.getText() && !this.txtActualBalanceAccount.getText().trim().equals("") && null != this.txtExchangeRate.getText() && !this.txtExchangeRate.getText().trim().equals("")) {
            this.txtANaturalAmt.setValue((Object)this.txtActualBalanceAccount.getBigDecimalValue().multiply(this.txtExchangeRate.getBigDecimalValue()));
        }
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.isBalance) {
            this.calExtraAmount();
        }
    }

    private void calExtraAmount() {
        if (this.txtPayAmount.getText() != null && !this.txtPayAmount.getText().trim().equals("") && this.txtActualBalanceAccount.getText() != null && !this.txtActualBalanceAccount.getText().trim().equals("")) {
            this.txtExtraAccount.setValue((Object)this.txtPayAmount.getBigDecimalValue().subtract(this.txtActualBalanceAccount.getBigDecimalValue()));
        }
    }

    @Override
    protected void txtPNaturalAmt_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtPNaturalAmt.getBigDecimalValue().compareTo(new BigDecimal("0.00")) > 0) {
            this.txtPCapital.setText(GlUtils.getChineseFormat((BigDecimal)this.getDecimal(this.txtPNaturalAmt), (boolean)true, (Locale)this.locale));
        } else if (this.txtPNaturalAmt.getBigDecimalValue().compareTo(new BigDecimal("0.00")) == 0) {
            this.txtPCapital.setText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"163_BankDraftEditUI"));
        }
    }

    @Override
    protected void txtANaturalAmt_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtANaturalAmt.getBigDecimalValue().compareTo(new BigDecimal("0.00")) > 0) {
            this.txtACapital.setText(GlUtils.getChineseFormat((BigDecimal)this.getDecimal(this.txtANaturalAmt), (boolean)true, (Locale)this.locale));
        } else if (this.txtANaturalAmt.getBigDecimalValue().compareTo(new BigDecimal("0.00")) == 0) {
            this.txtACapital.setText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"163_BankDraftEditUI"));
        }
    }

    private void calENaturalAmt() {
        if (null != this.txtPNaturalAmt.getText() && !this.txtPNaturalAmt.getText().trim().equals("") && null != this.txtANaturalAmt.getText() && !this.txtANaturalAmt.getText().trim().equals("")) {
            this.txtENaturalAmt.setValue((Object)this.txtPNaturalAmt.getBigDecimalValue().subtract(this.txtANaturalAmt.getBigDecimalValue()));
        }
    }

    @Override
    protected void txtENaturalAmt_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtENaturalAmt.getBigDecimalValue().compareTo(new BigDecimal("0.00")) > 0) {
            this.txtECapital.setText(GlUtils.getChineseFormat((BigDecimal)this.getDecimal(this.txtENaturalAmt), (boolean)true, (Locale)this.locale));
        } else if (this.txtENaturalAmt.getBigDecimalValue().compareTo(new BigDecimal("0.00")) == 0) {
            this.txtECapital.setText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"163_BankDraftEditUI"));
        }
    }

    @Override
    protected void comCurrency_itemStateChanged(ItemEvent e) throws Exception {
        this.currencyManage();
    }

    private void currencyManageLoad(String type) throws Exception {
        CurrencyInfo info = (CurrencyInfo)this.comCurrency.getSelectedItem();
        if (null != info) {
            String baseCurrencyId = this.contextHelp.getCompanyBaseCurrency(this.currentCompany).getId().toString();
            int baseCurrPre = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)baseCurrencyId));
            this.txtPayAmount.setPrecision(info.getPrecision());
            this.txtPNaturalAmt.setPrecision(baseCurrPre);
            this.txtActualBalanceAccount.setPrecision(info.getPrecision());
            this.txtANaturalAmt.setPrecision(baseCurrPre);
            this.txtExtraAccount.setPrecision(info.getPrecision());
            this.txtENaturalAmt.setPrecision(baseCurrPre);
            this.txtExchangeRate.setPrecision(info.getPrecision());
            this.txtPayAmount.setRemoveingZeroInDispaly(false);
            this.txtPNaturalAmt.setRemoveingZeroInDispaly(false);
            this.txtActualBalanceAccount.setRemoveingZeroInDispaly(false);
            this.txtANaturalAmt.setRemoveingZeroInDispaly(false);
            this.txtExtraAccount.setRemoveingZeroInDispaly(false);
            this.txtENaturalAmt.setRemoveingZeroInDispaly(false);
            this.txtExchangeRate.setRemoveingZeroInDispaly(false);
            int prec = CasRecPayHandler.getExRatePrec((String)info.getId().toString(), null, (CompanyOrgUnitInfo)this.currentCompany, (Date)((Date)this.pkPayerDate.getValue()));
            this.txtExchangeRate.setPrecision(prec);
            if (type.equals("currencyManage")) {
                try {
                    this.txtExchangeRate.setValue((Object)RecPayHandler.getExchangeRate((CurrencyInfo)info, null, (Date)((Date)this.pkPayerDate.getValue())));
                }
                catch (Exception e1) {
                    this.handUIExceptionAndAbort(e1);
                }
            }
            this.txtExchangeRate.setRemoveingZeroInDispaly(false);
            this.txtExchangeRate.setRemoveingZeroInEdit(true);
            boolean isLocalCurrency = RecPayHandler.isLocalCurrency((CurrencyInfo)info, null);
            if (isLocalCurrency) {
                this.txtExchangeRate.setEnabled(false);
            } else {
                this.txtExchangeRate.setEnabled(true);
            }
        }
    }

    private void currencyManage() throws Exception {
        this.currencyManageLoad("currencyManage");
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtPNaturalAmt.setValue((Object)this.txtPayAmount.getBigDecimalValue().multiply(this.txtExchangeRate.getBigDecimalValue()));
    }

    @Override
    protected void prmtPayAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        Object o = e.getNewValue();
        if (null == o) {
            this.prmtPayAccountBank.setValue(null);
            return;
        }
        if (o instanceof AccountBankInfo) {
            AccountBankInfo accountBankInfo = (AccountBankInfo)o;
            if (null != accountBankInfo) {
                try {
                    BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getBank().getId()));
                    if (!bankInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
                        this.prmtPayBank.setData((Object)bankInfo);
                    } else {
                        this.prmtPayBank.setData(null);
                    }
                    AccountViewInfo accountViewInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getAccount().getId()));
                    if (null != accountViewInfo) {
                        this.prmtPayAccountSubject.setData((Object)accountViewInfo);
                        this.flagPayAccountBank = 1;
                        this.initF7AccountBank(this.prmtPayAccountBank);
                    }
                }
                catch (EASBizException e1) {
                    this.handUIExceptionAndAbort((Exception)((Object)e1));
                }
                catch (BOSException e1) {
                    this.handUIExceptionAndAbort((Exception)((Object)e1));
                }
            } else {
                this.prmtPayBank.setData(null);
            }
        }
    }

    @Override
    protected void prmtPayAccountSubject_dataChanged(DataChangeEvent e) throws Exception {
        this.flagPayAccountBank = 0;
        this.initF7AccountBank(this.prmtPayAccountBank);
    }

    @Override
    protected void prmtRecPerson_dataChanged(DataChangeEvent e) throws Exception {
        block13: {
            CustomerInfo cust;
            Object payee = this.prmtRecPerson.getValue();
            if (payee instanceof SupplierInfo) {
                SupplierInfo supplier = BankDraftEditUI.getSupplier(this.prmtRecPerson.getData());
                if (supplier != null) {
                    try {
                        SupplierInfo realSupplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplier.getId()));
                        SupplierCompanyInfoInfo supplierCompany = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supplier.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
                        if (supplierCompany != null) {
                            CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supplier, (String)this.currentCompany.getId().toString());
                            this.prmtProxyCashBank.setData((Object)bankInfo.getBank());
                            this.txtRecAcount.setText(bankInfo.getBankAccount());
                            break block13;
                        }
                        this.prmtProxyCashBank.setData(null);
                        this.txtRecAcount.setText(null);
                    }
                    catch (EASBizException eas) {
                        this.handUIExceptionAndAbort((Exception)((Object)eas));
                    }
                    catch (BOSException boe) {
                        this.handUIExceptionAndAbort((Exception)((Object)boe));
                    }
                }
            } else if (payee instanceof CustomerInfo && (cust = BankDraftEditUI.getCustomer(this.prmtRecPerson.getData())) != null) {
                try {
                    CustomerInfo realCust = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(cust.getId()));
                    CustomerCompanyInfoInfo custCompany = CustomerFactory.getRemoteInstance().getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(cust.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
                    if (custCompany != null) {
                        CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)cust, (String)this.currentCompany.getId().toString());
                        this.prmtProxyCashBank.setData((Object)bankInfo.getBank());
                        this.txtRecAcount.setText(bankInfo.getBankAccount());
                    } else {
                        this.prmtProxyCashBank.setData(null);
                        this.txtRecAcount.setText(null);
                    }
                }
                catch (EASBizException eas) {
                    this.handUIExceptionAndAbort((Exception)((Object)eas));
                }
                catch (BOSException boe) {
                    this.handUIExceptionAndAbort((Exception)((Object)boe));
                }
            }
        }
    }

    @Override
    protected void prmtRecAccount_willShow(SelectorEvent e) throws Exception {
        this.setPayeeAccountBank();
    }

    private void setPayeeAccountBank() throws BOSException, EASBizException {
        Object payer = this.prmtRecPerson.getValue();
        boolean isSupplier = false;
        boolean isCustomer = false;
        boolean isInnerSupplierOrCustomer = false;
        SupplierInfo supplier = null;
        CustomerInfo customer = null;
        if (payer instanceof CurrentInfo) {
            if (payer != null && ((CurrentInfo)payer).getId() != null) {
                String id = ((CurrentInfo)payer).getId().toString();
                if (BOSUuid.read((String)id).getType().equals((Object)new SupplierInfo().getBOSType())) {
                    isSupplier = true;
                    supplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(id));
                    isInnerSupplierOrCustomer = supplier.isIsInternalCompany();
                } else if (BOSUuid.read((String)id).getType().equals((Object)new CustomerInfo().getBOSType())) {
                    isCustomer = true;
                    customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(id));
                    isInnerSupplierOrCustomer = customer.isIsInternalCompany();
                }
            }
        } else if (payer instanceof SupplierInfo) {
            isSupplier = true;
            supplier = (SupplierInfo)payer;
            if (supplier != null) {
                supplier = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplier.getId()));
                isInnerSupplierOrCustomer = supplier.isIsInternalCompany();
            }
        } else if (payer instanceof CustomerInfo) {
            isCustomer = true;
            customer = (CustomerInfo)payer;
            if (customer != null) {
                customer = CustomerFactory.getRemoteInstance().getCustomerInfo((IObjectPK)new ObjectUuidPK(customer.getId()));
                isInnerSupplierOrCustomer = customer.isIsInternalCompany();
            }
        }
        if (isSupplier && !isInnerSupplierOrCustomer) {
            this.initSupplierCompanyInfoBank((DataBaseInfo)supplier, this.prmtRecAccount);
        } else if (isCustomer && !isInnerSupplierOrCustomer) {
            this.initCustomerCompanyInfoBank((DataBaseInfo)customer, this.prmtRecAccount);
        } else {
            this.initPayeeAcctBankASAcctBank();
        }
    }

    private void initSupplierCompanyInfoBank(DataBaseInfo supply, KDBizPromptBox txtPayeeAccountBank) {
        txtPayeeAccountBank.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
        txtPayeeAccountBank.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (supply != null) {
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supply.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        txtPayeeAccountBank.setEntityViewInfo(view);
        txtPayeeAccountBank.setEditFormat("$bankAccount$");
        txtPayeeAccountBank.setDisplayFormat("$bankAccount$");
        txtPayeeAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initCustomerCompanyInfoBank(DataBaseInfo customer, KDBizPromptBox txtPayeeAccountBank) {
        txtPayeeAccountBank.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyInfoBankQuery");
        txtPayeeAccountBank.setHasCUDefaultFilter(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (customer != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customer.getId()));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
        view.setFilter(filter);
        txtPayeeAccountBank.setEntityViewInfo(view);
        txtPayeeAccountBank.setEditFormat("$bankAccount$");
        txtPayeeAccountBank.setDisplayFormat("$bankAccount$");
        txtPayeeAccountBank.setCommitFormat("$bankAccount$");
        txtPayeeAccountBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPayeeAcctBankASAcctBank() {
        Object payeeName = this.prmtRecPerson.getData();
        Object payeeType = this.prmtRecPerson.getValue();
        this.initPayeeAccountBankEV(payeeType, payeeName);
        this.prmtRecAccount.setEditFormat("$bankAccountNumber$");
        this.prmtRecAccount.setDisplayFormat("$bankAccountNumber$");
        this.prmtRecAccount.setCommitFormat("$simpleCode$;$number$;$name$;$bankAccountNumber$");
        this.prmtRecAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private void initPayeeAccountBankEV(Object payeeType, Object payeeName) {
        FilterInfo filterName;
        this.prmtRecAccount.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"0"));
        String realPayeeName = "";
        if (payeeType instanceof SupplierInfo && !FMHelper.isEmpty((Object)payeeName)) {
            if (payeeName instanceof DataBaseInfo) {
                SupplierInfo supplierInfo = (SupplierInfo)payeeName;
                realPayeeName = supplierInfo.getName();
            }
            if (realPayeeName != null) {
                filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realPayeeName));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realPayeeName));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realPayeeName));
                filterName.setMaskString("#0 or #1 or #2");
                try {
                    filter.mergeFilter(filterName, "and");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        if (payeeType instanceof CustomerInfo && !FMHelper.isEmpty((Object)payeeName)) {
            if (payeeName instanceof DataBaseInfo) {
                CustomerInfo customerInfo = (CustomerInfo)payeeName;
                realPayeeName = customerInfo.getName();
            }
            if (realPayeeName != null) {
                filterName = new FilterInfo();
                filterName.getFilterItems().add(new FilterItemInfo("company.name", (Object)realPayeeName));
                filterName.getFilterItems().add(new FilterItemInfo("name", (Object)realPayeeName));
                filterName.getFilterItems().add(new FilterItemInfo("acctName", (Object)realPayeeName));
                filterName.setMaskString("#0 or #1 or #2");
                try {
                    filter.mergeFilter(filterName, "and");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtRecAccount.setEntityViewInfo(evi);
        this.prmtRecAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtRecAccount_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo accountBank;
        Object recAccount = this.prmtRecAccount.getValue();
        if (null != recAccount && null != (accountBank = BankDraftEditUI.getAccountbank(recAccount))) {
            AccountBankInfo realAccountBank = null;
            try {
                BankInfo realBank;
                realAccountBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId()));
                if (null != realAccountBank && null != (realBank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(realAccountBank.getBank().getId())))) {
                    this.prmtProxyCashBank.setData((Object)realBank);
                }
            }
            catch (EASBizException eas) {
                this.handUIExceptionAndAbort((Exception)((Object)eas));
            }
            catch (BOSException boe) {
                this.handUIExceptionAndAbort((Exception)((Object)boe));
            }
        }
    }

    @Override
    protected void prmtOppSubject_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOppSubject_dataChanged(e);
        AccountViewInfo AccountView = (AccountViewInfo)this.prmtOppSubject.getData();
        if (AccountView == null) {
            this.prmtRecPerson.setData(null);
            return;
        }
    }

    protected void initUIProp() throws Exception {
        this.pkPayerDate.setSupportedEmpty(false);
        this.prmtProxyCashBank.setEditable(true);
        EntityViewInfo evi = CasRecPayHandler.getFpItemEvi((FPItemDirectionEnum)FPItemDirectionEnum.OUTWARD_MOVEMENT);
        this.prmtFpItem.setEntityViewInfo(evi);
        FpItemClientHelper.setOrgView((KDBizPromptBox)this.prmtFpItem);
        CashHelper.initCombCurrency((KDComboBox)this.comCurrency, (boolean)false);
        NTHelper.initCSF7((IUIObject)this, this.prmtRecPerson, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign");
        if (this.prmtPayAccountBank.getValue() != null) {
            this.initF7AccountBank(this.prmtPayAccountBank);
        }
        this.txtExchangeRate.setDataType(1);
        this.txtPayAmount.setDataType(1);
        this.txtPayAmount.setHorizontalAlignment(4);
        this.txtPayAmount.setPrecision(2);
        this.txtPayAmount.setRemoveingZeroInDispaly(false);
        this.txtPNaturalAmt.setDataType(1);
        this.txtPNaturalAmt.setHorizontalAlignment(4);
        this.txtPNaturalAmt.setPrecision(2);
        this.txtPNaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtActualBalanceAccount.setDataType(1);
        this.txtActualBalanceAccount.setHorizontalAlignment(4);
        this.txtActualBalanceAccount.setPrecision(2);
        this.txtActualBalanceAccount.setRemoveingZeroInDispaly(false);
        this.txtANaturalAmt.setDataType(1);
        this.txtANaturalAmt.setHorizontalAlignment(4);
        this.txtANaturalAmt.setPrecision(2);
        this.txtANaturalAmt.setRemoveingZeroInDispaly(false);
        this.txtExtraAccount.setDataType(1);
        this.txtExtraAccount.setHorizontalAlignment(4);
        this.txtExtraAccount.setPrecision(2);
        this.txtExtraAccount.setRemoveingZeroInDispaly(false);
        this.txtENaturalAmt.setDataType(1);
        this.txtENaturalAmt.setHorizontalAlignment(4);
        this.txtENaturalAmt.setPrecision(2);
        this.txtENaturalAmt.setRemoveingZeroInDispaly(false);
    }

    private void initF7AccountBank(KDBizPromptBox prmtPayAccountBank) {
        if (this.flagPayAccountBank == 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.contextHelp.getCurrentCompany().getId()));
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            prmtPayAccountBank.setEntityViewInfo(evi);
        } else {
            FilterInfo filter = new FilterInfo();
            AccountViewInfo payAccountSubject = (AccountViewInfo)this.prmtPayAccountSubject.getData();
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)payAccountSubject.getId()));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            prmtPayAccountBank.setEntityViewInfo(evi);
        }
    }

    @Override
    protected void prmtPayAccountSubject_willShow(SelectorEvent e) throws Exception {
        this.setAcctViewF7(this.prmtPayAccountSubject);
    }

    @Override
    protected void prmtPayAccountSubject_willCommit(CommitEvent e) throws Exception {
        this.setAcctViewF7(this.prmtPayAccountSubject);
    }

    @Override
    protected void prmtOppSubject_willShow(SelectorEvent e) throws Exception {
        this.setAcctViewF7(this.prmtOppSubject);
    }

    @Override
    protected void prmtOppSubject_willCommit(CommitEvent e) throws Exception {
        this.setAcctViewF7(this.prmtOppSubject);
    }

    private void setAcctViewF7(KDBizPromptBox f7Box) throws EASBizException, BOSException {
        String cuId = this.currentCompany.getCU().getId().toString();
        String currencyId = AccessHelper.getId((Object)this.comCurrency.getSelectedItem());
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.currentCompany.getId().toString(), (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        f7Box.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.currentCompany.getId().toString(), (String)currencyId, (boolean)true);
        f7Box.setEntityViewInfo(evi);
        f7Box.getQueryAgent().resetRuntimeEntityView();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String sourceId;
        BankDraftCollection bd;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtRemittor);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayAccountBank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayBank);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtRecPerson);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtPayAmount);
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtPayAmount);
        if ("ADDNEW".equals(this.getOprtState()) && null != (bd = BankDraftFactory.getRemoteInstance().getBankDraftCollection("select * where number = '" + this.editData.getNumber() + "'")) && bd.size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"170_BankDraftEditUI"));
            this.txtNumber.setText("");
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getPayAmount().compareTo(new BigDecimal("0")) <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"171_BankDraftEditUI"));
            this.txtPayAmount.requestFocus();
            SysUtil.abort();
        }
        if (BankDraftEditUI.getSysParamOfInOut() && null == (sourceId = this.editData.getSourceBillId())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"172_BankDraftEditUI"));
            SysUtil.abort();
        }
        if (null != this.editData.getActualBalanceAccount() && this.editData.getActualBalanceAccount().compareTo(this.editData.getPayAmount()) > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"173_BankDraftEditUI"));
            this.txtActualBalanceAccount.requestFocus();
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((String)this.prmtRecPerson.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"456_BankDraftEditUI"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((String)this.prmtPayAccountBank.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"457_BankDraftEditUI"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((String)this.prmtRecPerson.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"458_BankDraftEditUI"));
            SysUtil.abort();
        }
        if (!((Date)this.pkPayerDate.getValue()).before((Date)this.pkMatureDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"459_BankDraftEditUI"));
            SysUtil.abort();
        }
    }

    public static boolean getSysParamOfInOut() throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), "NT018");
        if (param == null) {
            return false;
        }
        return Boolean.valueOf(param);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        IBTPBillEdit billEdit = this.getBillEdit();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "BankDraft");
        billEdit.createFrom(null, map);
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    public static SupplierInfo getSupplier(Object objCust) {
        if (objCust instanceof SupplierInfo) {
            return (SupplierInfo)objCust;
        }
        return null;
    }

    public static CustomerInfo getCustomer(Object objCust) {
        if (objCust instanceof CustomerInfo) {
            return (CustomerInfo)objCust;
        }
        return null;
    }

    public static AccountBankInfo getAccountbank(Object objAccount) {
        if (objAccount instanceof AccountBankInfo) {
            return (AccountBankInfo)objAccount;
        }
        return null;
    }

    private BigDecimal getDecimal(KDFormattedTextField txt) {
        if (!FMHelper.isEmpty((Object)txt.getBigDecimalValue())) {
            if (!FMHelper.isEmpty((Object)txt.getPrecision())) {
                return GlUtils.getScaleBigDecimal((BigDecimal)txt.getBigDecimalValue(), (int)txt.getPrecision());
            }
            return txt.getBigDecimalValue();
        }
        return Constants.ZERO;
    }

    @Override
    public void actionEntryAccount_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        IBankDraftFacade facade = BankDraftFacadeFactory.getRemoteInstance();
        facade.book(ids);
        this.showMsg(e);
        this.changeEntryBtn();
    }

    @Override
    public void actionCancelEntryAccount_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        IBankDraftFacade facade = BankDraftFacadeFactory.getRemoteInstance();
        facade.antiBook(ids);
        this.showMsg(e);
        this.changeEntryBtn();
    }

    private void showMsg(ActionEvent e) throws Exception {
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    private void changeEntryBtn() throws Exception {
        if (OprtState.ADDNEW == this.getOprtState() || OprtState.COPYADDNEW == this.getOprtState()) {
            this.actionEntryAccount.setEnabled(false);
            this.actionCancelEntryAccount.setEnabled(false);
        } else {
            BankDraftInfo info = BankDraftFactory.getRemoteInstance().getBankDraftInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            BankDraftEnum status = info.getBillState();
            String chuna = info.getChuna();
            if (status == BankDraftEnum.AUDIT && chuna == null) {
                this.actionEntryAccount.setEnabled(true);
            } else {
                this.actionEntryAccount.setEnabled(false);
            }
            if (status != BankDraftEnum.BOUNCED && chuna != null) {
                this.actionCancelEntryAccount.setEnabled(true);
            } else {
                this.actionCancelEntryAccount.setEnabled(false);
            }
        }
    }

    protected void initDataStatus() {
        BankDraftInfo info;
        super.initDataStatus();
        if (OprtState.VIEW == this.getOprtState()) {
            this.actionReturnBill.setVisible(false);
            this.actionCancelReturnBill.setVisible(false);
        }
        if ((info = (BankDraftInfo)this.getDataObject()).getId() != null && info.getCompany() != null) {
            FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString());
            if (null != info.getSourceBillId()) {
                this.txtRemittor.setEditable(false);
                this.prmtPayAccountBank.setEnabled(false);
                this.prmtPayBank.setEnabled(false);
                this.prmtRecPerson.setEnabled(false);
                this.prmtRecAccount.setEnabled(false);
                this.txtRecAcount.setEnabled(false);
                this.prmtProxyCashBank.setEnabled(false);
                this.txtCashAddress.setEditable(false);
                this.comCurrency.setEnabled(false);
                this.txtPayAmount.setEditable(false);
                this.txtUsage.setEditable(false);
                this.prmtBudgetSubject.setEnabled(false);
            } else {
                this.txtRemittor.setEditable(true);
                this.prmtPayAccountBank.setEnabled(true);
                this.prmtPayBank.setEnabled(true);
                this.prmtRecPerson.setEnabled(true);
                this.prmtRecAccount.setEnabled(true);
                this.txtRecAcount.setEnabled(true);
                this.prmtProxyCashBank.setEnabled(true);
                this.txtCashAddress.setEditable(true);
                this.comCurrency.setEnabled(true);
                this.txtPayAmount.setEditable(true);
                this.txtUsage.setEditable(true);
                this.prmtBudgetSubject.setEnabled(true);
            }
            CurrencyInfo currencyInfo = (CurrencyInfo)this.comCurrency.getSelectedItem();
            if (null != currencyInfo) {
                boolean isLocalCurrency = RecPayHandler.isLocalCurrency((CurrencyInfo)currencyInfo, null);
                if (isLocalCurrency) {
                    this.txtExchangeRate.setEnabled(false);
                } else {
                    this.txtExchangeRate.setEnabled(true);
                }
            }
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "payerDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit", "actionEdit", "actionRemove", "actionAntiAudit"};
    }
}

