/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterParamBase;
import com.kingdee.eas.fm.nt.BankDraftEnum;
import com.kingdee.eas.util.SysUtil;
import java.util.Collection;
import java.util.Date;

public class BankDraftFilterParam
extends FMFilterParamBase {
    private static final long serialVersionUID = 4917785723990950105L;
    private Date queryDate;
    private Date toDate;
    private BankInfo bankInfo;
    private String currencyId;
    private BankDraftEnum billState;

    public SorterItemCollection getSorterItems() {
        return new SorterItemCollection();
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        if (null != this.queryDate) {
            filter.getFilterItems().add(new FilterItemInfo("payerDate", (Object)this.queryDate, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("payerDate", (Object)DateUtil.getNextDay((Date)this.toDate), CompareType.LESS_EQUALS));
        }
        if (null != this.toDate) {
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("matureDate", (Object)this.queryDate, CompareType.GREATER_EQUALS));
            filter2.getFilterItems().add(new FilterItemInfo("matureDate", (Object)DateUtil.getNextDay((Date)this.toDate), CompareType.LESS_EQUALS));
            try {
                filter.mergeFilter(filter2, "OR");
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
        }
        FilterInfo filter3 = new FilterInfo();
        if (null != this.bankInfo) {
            filter3.getFilterItems().add(new FilterItemInfo("payBank.name", (Object)this.bankInfo.getName()));
        }
        if (null != this.currencyId) {
            filter3.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (null != this.billState) {
            filter3.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(this.billState.getValue())));
        }
        CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (!FMHelper.isEmpty((Collection)this.getCompanyIdSet())) {
            filter3.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        } else if (this.getCompanyIdSet() == null) {
            filter3.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString(), CompareType.EQUALS));
        }
        try {
            filter.mergeFilter(filter3, "AND");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return filter;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public BankInfo getBankInfo() {
        return this.bankInfo;
    }

    public void setBankInfo(BankInfo bankInfo) {
        this.bankInfo = bankInfo;
    }

    public Date getQueryDate() {
        return this.queryDate;
    }

    public void setQueryDate(Date queryDate) {
        this.queryDate = queryDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public BankDraftEnum getBillState() {
        return this.billState;
    }

    public void setBillState(BankDraftEnum billState) {
        this.billState = billState;
    }
}

