/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.BizUnitControlUtilHelper;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.fm.nt.BankDraftEnum;
import com.kingdee.eas.fm.nt.BankDraftFacadeFactory;
import com.kingdee.eas.fm.nt.BankDraftFactory;
import com.kingdee.eas.fm.nt.BankDraftInfo;
import com.kingdee.eas.fm.nt.IBankDraftFacade;
import com.kingdee.eas.fm.nt.client.AbstractBankDraftListUI;
import com.kingdee.eas.fm.nt.client.BankDraftEditUI;
import com.kingdee.eas.fm.nt.client.BankDraftFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankDraftListUI
extends AbstractBankDraftListUI {
    private static final Logger logger = CoreUIObject.getLogger(BankDraftListUI.class);
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();
    public static final String OPER_COPY = "COPY";
    FMFilterBaseUI filterUI = null;
    private BizUnitControlUtilHelper bizUnitControlUtilHelper;
    FillListener fillListener = new FillListener();

    public BankDraftListUI() throws Exception {
        this.bizUnitControlUtilHelper = new BizUnitControlUtilHelper((Object)this, 4);
    }

    public void onLoad() throws Exception {
        this.menuItemVoucher.setEnabled(true);
        this.menuItemDelVoucher.setEnabled(true);
        this.btnBalance.setEnabled(true);
        this.btnCancelBalance.setEnabled(true);
        this.btnReturnBill.setEnabled(true);
        this.btnCancelReturnBill.setEnabled(true);
        this.menuItemBudgetLook.setVisible(true);
        this.menuItemBudgetLook.setEnabled(true);
        this.menuItemCopy.setEnabled(true);
        this.btnCopy.setEnabled(true);
        this.btnCreateTo.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
        super.onLoad();
        this.actionViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.actionEntryAccount.setEnabled(false);
        this.actionEntryAccount.setVisible(false);
        this.btnEntryAccount.setEnabled(false);
        this.btnEntryAccount.setVisible(false);
        this.menuItemEntryAccount.setEnabled(false);
        this.actionCancelEntryAccount.setEnabled(false);
        this.actionCancelEntryAccount.setVisible(false);
        this.btnCancelEntryAccount.setEnabled(false);
        this.btnCancelEntryAccount.setVisible(false);
        this.menuCancelEntryAccount.setEnabled(false);
        this.menuCancelEntryAccount.setVisible(false);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
            this.actionCancelBalance.setVisible(false);
            this.actionCancelEntryAccount.setVisible(false);
            this.actionEntryAccount.setVisible(false);
            this.actionDelVoucher.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAutiAudit.setVisible(false);
            this.actionReturnBill.setVisible(false);
            this.actionCancelReturnBill.setVisible(false);
            this.actionViewBdgBalance.setVisible(false);
            this.actionAttachment.setVisible(false);
            this.actionAuditResult.setVisible(false);
        }
        this.bizUnitControlUtilHelper.resetActionWithBlackWhiteList();
        if (this.bizUnitControlUtilHelper.isBizUnit()) {
            this.actionVoucher.setVisible(false);
            this.actionDelVoucher.setVisible(false);
            this.menuEdit.setVisible(false);
            this.menuBiz.setVisible(false);
            this.MenuService.setVisible(false);
        }
    }

    protected void initWorkButton() {
        String attachText = this.btnAttachment.getText();
        super.initWorkButton();
        this.btnAttachment.setTextIconDisStyle((short)3);
        this.btnAttachment.setText(attachText);
        this.actionCopy.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
        this.actionAntiBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionAutiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionReturnBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_returnticket"));
        this.actionCancelReturnBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelreturnticket"));
        int bookType = this.contextHelp.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId()));
        if (bookType != 0) {
            this.actionBook.setEnabled(false);
            this.actionAntiBook.setEnabled(false);
        } else {
            this.actionBook.setEnabled(true);
            this.actionAntiBook.setEnabled(true);
        }
    }

    protected boolean isFootVisible() {
        return true;
    }

    public static boolean getSysParamOfInOut() throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), "NT018");
        if (param == null) {
            return false;
        }
        return Boolean.valueOf(param);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        this.btnBalance.setEnabled(true);
        this.menuItemBalance.setEnabled(true);
        this.btnCancelBalance.setEnabled(true);
        this.menuItemCancelBalance.setEnabled(true);
        this.btnAudit.setEnabled(false);
        this.menuItemAntiAudit.setEnabled(false);
        this.btnAntiAudit.setEnabled(false);
        this.menuItemAudit.setEnabled(false);
        this.actionReturnBill.setEnabled(false);
        this.btnReturnBill.setEnabled(false);
        this.menuItemReturnBill.setEnabled(false);
        this.actionCancelReturnBill.setEnabled(false);
        this.btnCancelReturnBill.setEnabled(false);
        this.menuItemCancelReturnBill.setEnabled(false);
        this.actionVoucher.setEnabled(false);
        this.btnVoucher.setEnabled(false);
        this.menuItemVoucher.setEnabled(false);
        this.actionDelVoucher.setEnabled(false);
        this.btnDelVoucher.setEnabled(false);
        this.menuItemDelVoucher.setEnabled(false);
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (info.getBillState() == BankDraftEnum.FOOTUP) {
            this.btnReturnBill.setEnabled(false);
            this.menuItemReturnBill.setEnabled(false);
        }
        if (info.getChuna() == null || "".equals(info.getChuna())) {
            this.actionBook.setEnabled(true);
            this.actionAntiBook.setEnabled(false);
        } else {
            this.actionBook.setEnabled(false);
            this.actionAntiBook.setEnabled(true);
        }
        if (info.getBillState() == BankDraftEnum.BOUNCED) {
            this.btnBalance.setEnabled(false);
            this.menuItemBalance.setEnabled(false);
        }
        if (info.getBillState() == BankDraftEnum.AUDIT) {
            this.actionReturnBill.setEnabled(true);
            this.btnReturnBill.setEnabled(true);
            this.menuItemReturnBill.setEnabled(true);
        } else if (info.getBillState() == BankDraftEnum.REGISTED) {
            this.btnAudit.setEnabled(true);
            this.menuItemAudit.setEnabled(true);
        } else if (info.getBillState() == BankDraftEnum.BOUNCED) {
            this.actionCancelReturnBill.setEnabled(true);
            this.btnCancelReturnBill.setEnabled(true);
            this.menuItemCancelReturnBill.setEnabled(true);
        }
        if (info.getBillState() == BankDraftEnum.AUDIT && !info.isFiVouchered() && info.getBillState() != BankDraftEnum.FOOTUP && info.getBillState() != BankDraftEnum.BOUNCED && info.getChuna() == null) {
            this.btnAntiAudit.setEnabled(true);
            this.menuItemAntiAudit.setEnabled(true);
        }
        if (!info.isFiVouchered() && info.getBillState() == BankDraftEnum.AUDIT) {
            this.actionVoucher.setEnabled(true);
            this.btnVoucher.setEnabled(true);
            this.menuItemVoucher.setEnabled(true);
        } else if (info.isFiVouchered() && (info.getBillState() != BankDraftEnum.FOOTUP || info.getBillState() != BankDraftEnum.BOUNCED)) {
            this.actionDelVoucher.setEnabled(true);
            this.btnDelVoucher.setEnabled(true);
            this.menuItemDelVoucher.setEnabled(true);
        }
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        try {
            BankDraftFactory.getRemoteInstance().audit((IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"460_BankDraftListUI"));
            this.refresh(e);
        }
        catch (Exception e2) {
            MsgBox.showInfo((String)e2.getMessage());
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        try {
            BankDraftFactory.getRemoteInstance().antiAudit((IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"461_BankDraftListUI"));
            this.refresh(e);
        }
        catch (Exception e2) {
            MsgBox.showInfo((String)e2.getMessage());
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (info.getBillState() == BankDraftEnum.SAVE || info.getBillState() == BankDraftEnum.REGISTED) {
            super.actionRemove_actionPerformed(e);
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"165_BankDraftEditUI");
            msg = MessageFormat.format(msg, new Object[]{info.getBillState()});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (info.getBillState() == BankDraftEnum.SAVE || info.getBillState() == BankDraftEnum.REGISTED) {
            super.actionEdit_actionPerformed(e);
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"164_BankDraftEditUI");
            msg = MessageFormat.format(msg, new Object[]{info.getBillState()});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)OPER_COPY, (Object)OPER_COPY);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void checkObjectExists() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    public void actionBalance_actionPerformed(ActionEvent e) throws Exception {
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (info.getBillState() == BankDraftEnum.AUDIT) {
            info.setBillState(BankDraftEnum.FOOTUP);
            BankDraftFactory.getRemoteInstance().save((CoreBaseInfo)info);
            this.refresh(e);
        } else if (info.getBillState() == BankDraftEnum.BOUNCED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"174_BankDraftListUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancelBalance_actionPerformed(ActionEvent e) throws Exception {
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (info.getBillState() == BankDraftEnum.FOOTUP) {
            info.setBillState(BankDraftEnum.AUDIT);
            BankDraftFactory.getRemoteInstance().save((CoreBaseInfo)info);
            this.refresh(e);
        }
    }

    @Override
    public void actionReturnBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (info.getBillState() == BankDraftEnum.AUDIT) {
            info.setActualBalanceAccount(new BigDecimal("0.00"));
            info.setANaturalAmt(new BigDecimal("0.00"));
            info.setExtraAccount(info.getPayAmount());
            info.setENaturalAmt(info.getPNaturalAmt());
            info.setBillState(BankDraftEnum.BOUNCED);
            BankDraftFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"462_BankDraftListUI"));
            this.refresh(e);
        }
    }

    @Override
    public void actionCancelReturnBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (info.getBillState() == BankDraftEnum.BOUNCED) {
            info.setBillState(BankDraftEnum.AUDIT);
            info.setExtraAccount(Constants.ZERO);
            info.setENaturalAmt(Constants.ZERO);
            BankDraftFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"463_BankDraftListUI"));
            this.refresh(e);
        }
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkOnlyUnion();
        this.checkSelected();
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (!info.isFiVouchered() && info.getBillState() == BankDraftEnum.AUDIT) {
            super.actionVoucher_actionPerformed(e);
            this.refresh(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"175_BankDraftListUI"));
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkOnlyUnion();
        this.checkSelected();
        BankDraftInfo info = this.getSelectedBankDraftInfo();
        if (info.isFiVouchered()) {
            if (info.getBillState() != BankDraftEnum.FOOTUP || info.getBillState() != BankDraftEnum.BOUNCED) {
                super.actionDelVoucher_actionPerformed(e);
                this.refresh(e);
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"176_BankDraftListUI"));
        }
    }

    @Override
    public void actionBudgetLook_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionMultiapprove_actionPerformed(e);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filterUI) {
            this.filterUI = new BankDraftFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankDraftFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BankDraftEditUI.class.getName();
    }

    private BankDraftInfo getSelectedBankDraftInfo() throws Exception {
        return BankDraftFactory.getRemoteInstance().getBankDraftInfo((IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add("bgOutItemID");
        sic.add("bgOutItemNumber");
        sic.add("bgOutItemName");
        return sic;
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        FMClientHelper.checkOnlyUnion();
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        BizEnumValueDTO status = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (status.getInt() != 5) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"412_BankDraftListUI"));
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            IBankDraftFacade facade = BankDraftFacadeFactory.getRemoteInstance();
            facade.book(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"413_BankDraftListUI"))) == 0) {
            IBankDraftFacade facade = BankDraftFacadeFactory.getRemoteInstance();
            facade.book(ids);
            this.showMsg(e);
        }
    }

    @Override
    public void actionAntiBook_actionPerformed(ActionEvent e) throws Exception {
        int result;
        FMClientHelper.checkOnlyUnion();
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<String> ids = new ArrayList<String>();
        Object cashier = null;
        BizEnumValueDTO status = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            cashier = row.getCell("chuna").getValue();
            status = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (cashier == null || status.getInt() == 4) continue;
            ids.add(row.getCell("id").getValue().toString());
        }
        if (ids.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"414_BankDraftListUI"));
            SysUtil.abort();
        } else if (ids.size() == indexs.length) {
            IBankDraftFacade facade = BankDraftFacadeFactory.getRemoteInstance();
            facade.antiBook(ids);
            this.showMsg(e);
        } else if (ids.size() < indexs.length && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"415_BankDraftListUI"))) == 0) {
            IBankDraftFacade facade = BankDraftFacadeFactory.getRemoteInstance();
            facade.antiBook(ids);
            this.showMsg(e);
        }
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "payerDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAudit"};
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            IRow currentRow = null;
            String currencyID = null;
            String baseCurrencyId = null;
            try {
                baseCurrencyId = BankDraftListUI.this.contextHelp.getCompanyBaseCurrency(BankDraftListUI.this.contextHelp.getCurrentCompany()).getId().toString();
            }
            catch (Exception e1) {
                BankDraftListUI.this.handUIExceptionAndAbort(e1);
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                currentRow = BankDraftListUI.this.tblMain.getRow(i);
                currencyID = (String)currentRow.getCell("currency.id").getValue();
                if (currencyID != null) {
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)"payAmount", (String)currencyID);
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)"pNaturalAmt", (String)baseCurrencyId);
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)"actualBalanceAccount", (String)currencyID);
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)"aNaturalAmt", (String)baseCurrencyId);
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)"extraAccount", (String)currencyID);
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)"eNaturalAmt", (String)baseCurrencyId);
                }
                int prec = CasRecPayHandler.getExRatePrec((String)currencyID, null, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany(), (Date)((Date)currentRow.getCell("payerDate").getValue()));
                FMARAPUtil.setPrecision((ICell)currentRow.getCell("exchangeRate"), (int)prec);
            }
            String type = "%r-[ ]0.2n";
            if (BankDraftListUI.this.tblMain.getFootManager() != null) {
                StyleAttributes footStyle = BankDraftListUI.this.tblMain.getFootManager().getFootRow(0).getCell("payAmount").getStyleAttributes();
                footStyle.setNumberFormat(type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footStyle = BankDraftListUI.this.tblMain.getFootManager().getFootRow(0).getCell("pNaturalAmt").getStyleAttributes();
                footStyle.setNumberFormat(type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footStyle = BankDraftListUI.this.tblMain.getFootManager().getFootRow(0).getCell("actualBalanceAccount").getStyleAttributes();
                footStyle.setNumberFormat(type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footStyle = BankDraftListUI.this.tblMain.getFootManager().getFootRow(0).getCell("aNaturalAmt").getStyleAttributes();
                footStyle.setNumberFormat(type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footStyle = BankDraftListUI.this.tblMain.getFootManager().getFootRow(0).getCell("extraAccount").getStyleAttributes();
                footStyle.setNumberFormat(type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footStyle = BankDraftListUI.this.tblMain.getFootManager().getFootRow(0).getCell("eNaturalAmt").getStyleAttributes();
                footStyle.setNumberFormat(type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

