/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.MessageUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeAssociateProviderFactory;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.IChequeAssosicateProvider;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTNumberFormat;
import com.kingdee.eas.fm.nt.client.AbstractChequeAssociateUI;
import com.kingdee.eas.fm.nt.client.ChequeEditUI;
import com.kingdee.eas.fm.nt.client.ChequeTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ChequeAssociateUI
extends AbstractChequeAssociateUI {
    private static final String CHEQUE_QUERY = "com.kingdee.eas.fm.nt.app.F7ChequeQuery";
    private static final String ASSOCIATE_IDS = "associateIds";
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private IChequeAssosicateProvider chequeProvider = null;
    private String[] billIds = null;
    private UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
    String settletypeid;
    String currencyid;
    String bankacctId;

    @Override
    public void actionTDPreView_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData.getId().toString() != null) {
            if (this.editData.getState() == ChequeStatusEnum.NEW) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveBeforeTD"));
            }
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        super.actionTDPreView_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        if (this.editData.getId().toString() != null) {
            if (this.editData.getState() == ChequeStatusEnum.NEW) {
                FMClientHelper.showCanNotInfo((Component)((Object)this), (ItemAction)this.actionTDPrint);
            }
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"saveBeforeTD"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public ChequeAssociateUI() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.comboState.getSelectedItem() == ChequeStatusEnum.NEW) {
            ChequeAppRecInfo recInfo = new ChequeAppRecInfo();
            recInfo.setApplicant((PersonInfo)this.prmtApplicant.getData());
            recInfo.setAuditor((PersonInfo)this.prmtAuditor.getData());
            recInfo.setDepartment((AdminOrgUnitInfo)this.prmtDepartment.getData());
            recInfo.setRemindDate(TypeConversionUtils.objToDate((Object)this.pkRemindDate.getValue()));
            recInfo.setApplyDate(TypeConversionUtils.objToDate((Object)this.pkApplyDate.getValue()));
            recInfo.setReimburser((PersonInfo)this.prmtReimburser.getData());
            recInfo.setCeiling(this.txtCeiling.getBigDecimalValue());
            if (this.editData == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"195_ChequeAssociateUI"));
            }
            this.editData.setApplyRec(recInfo);
        } else if (this.comboState.getSelectedItem() == ChequeStatusEnum.APPLIED) {
            if (this.editData == null || this.editData.getApplyRec() == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"195_ChequeAssociateUI"));
            }
            this.editData.getApplyRec().setReimburser((PersonInfo)this.prmtReimburser.getData());
        }
    }

    @Override
    protected String getEditUIName() {
        return ChequeEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ChequeInfo objectValue = new ChequeInfo();
        return objectValue;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.chkIsMe_itemStateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.f7InAccountNum.setValue((Object)this.editData.getTurnInAcctBank());
        this.txtPayeeName.setText(this.editData.getPayeeName());
        this.f7OppAcct.setValue((Object)this.editData.getOppAccount());
        this.txtPayeeBank.setText(this.editData.getPayeeAcctBank());
        this.txtPayeeAcctBankNum.setText(this.editData.getPayeeAcctNumber());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        ChequeStatusEnum state = this.editData.getState();
        if (state == null) {
            return;
        }
        this.actionCancelBook.setEnabled(false);
        this.actionBook.setEnabled(false);
        if (state.equals((Object)ChequeStatusEnum.APPLIED)) {
            this.prmtApplicant.setEnabled(false);
            this.prmtAuditor.setEnabled(false);
            this.prmtDepartment.setEnabled(false);
            this.pkApplyDate.setEnabled(false);
            this.pkRemindDate.setEnabled(false);
            this.txtCeiling.setEnabled(false);
        } else if (state.equals((Object)ChequeStatusEnum.NEW)) {
            this.pkApplyDate.setEnabled(false);
            this.pkRemindDate.setEnabled(false);
            this.txtCeiling.setValue((Object)this.txtAmount.getBigDecimalValue());
        } else if (this.editData.isIsVC()) {
            try {
                ChequeInfo chequeInfo = ChequeFactory.getRemoteInstance().getChequeInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (this.prmtCreator.getValue() == null) {
            UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            this.prmtCreator.setValue((Object)userInfo);
        }
    }

    public void onLoad() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency);
        super.onLoad();
        this.btnBook.setVisible(false);
        this.billIds = (String[])this.getUIContext().get(ASSOCIATE_IDS);
        MutexUtils.requestMutex((CoreUI)this, (String[])this.billIds);
        this.initUI();
        if (!FMHelper.isEmpty((Object[])this.billIds)) {
            this.chequeProvider = ChequeAssociateProviderFactory.getProvider(null, this.billIds[0]);
            this.chequeProvider.fillBilllist(this.tblBillList, this.billIds);
            this.comboState.addItem((Object)ChequeStatusEnum.NEW);
            this.comboState.addItem((Object)ChequeStatusEnum.APPLIED);
            this.comboState.setSelectedItem((Object)ChequeStatusEnum.NEW);
            IRow row = this.tblBillList.getRow(0);
            this.settletypeid = (String)row.getCell("settleTypeId").getValue();
            this.currencyid = (String)row.getCell("currencyId").getValue();
            this.bankacctId = (String)row.getCell("bankAccountId").getValue();
        }
        this.setOprtState("EDIT");
        this.lockUIForViewStatus();
        this.comboState.setAccessAuthority(0);
        this.txtCeiling.setHorizontalAlignment(4);
        this.f7ChequeBill.setAccessAuthority(0);
        this.actionBook.setVisible(false);
        this.actionCancelBook.setVisible(false);
        IContextHelper localInstance = ContextHelperFactory.getRemoteInstance();
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(localInstance.getCurrentCompany().getId()));
        this.actionBook.setVisible(false);
        this.actionCancelBook.setVisible(false);
        this.prmtApplicant.setRequired(false);
        this.prmtDepartment.setRequired(false);
        this.prmtAuditor.setRequired(false);
        this.prmtReimburser.setRequired(false);
        if (val == 0 && !GlUtils.isCompanyUnion((CompanyOrgUnitInfo)localInstance.getCurrentCompany())) {
            this.actionCancelBook.setVisible(true);
        }
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    private void initUI() throws EASBizException, BOSException {
        this.actionLast.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.f7ChequeBill.setQueryInfo(CHEQUE_QUERY);
        this.f7ChequeBill.setEditable(true);
        this.f7ChequeBill.setDisplayFormat("$number$");
        this.f7ChequeBill.setEditFormat("$number$");
        this.f7ChequeBill.setCommitFormat("$number$");
        FMClientHelper.clearF7((KDBizPromptBox)this.f7ChequeBill);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtAmount.setRemoveingZeroInEdit(true);
        this.txtCeiling.setRemoveingZeroInDispaly(false);
        this.txtCeiling.setRemoveingZeroInEdit(true);
        this.f7OppAcct.setEditable(true);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)this, currentCompany, filter, false, true);
        this.f7OppAcct.setSelector((KDPromptSelector)acctPromptBox);
        this.f7OppAcct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.f7OppAcct.setDisplayFormat("$number$ $name$");
        this.f7OppAcct.setCommitFormat("$number$");
        this.f7OppAcct.setEditFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String controlUnitId = currentCompany.getCU().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)currentCompany.getAccountTable().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)controlUnitId));
        evi.setFilter(filterInfo);
        this.f7OppAcct.setEntityViewInfo(evi);
        this.f7InAccountNum.setEditable(true);
        this.f7InAccountNum.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        this.txtSettleNumber.setEnabled(false);
        this.txtSettleType.setEnabled(false);
        this.txtSettleType.setText(null);
        this.txtSettleNumber.setText(null);
        this.tblBillList.checkParsed();
        this.tblBillList.getStyleAttributes().setLocked(true);
        this.comboCurrency.setEnabled(false);
        this.txtAmount.setEnabled(false);
        this.txtPayeeAcctBankNum.setText(null);
        this.txtPayeeBank.setText(null);
    }

    @Override
    protected void btnWriteOff_actionPerformed(ActionEvent e) throws Exception {
        super.btnWriteOff_actionPerformed(e);
        if (FMHelper.isEmpty((Object[])this.billIds)) {
            return;
        }
        ChequeInfo cheque = (ChequeInfo)this.f7ChequeBill.getValue();
        if (cheque == null) {
            return;
        }
        ICheque ch = ChequeFactory.getRemoteInstance();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("creator.*");
        selector.add("payeeAcctNumber");
        selector.add("payeeAcctBank");
        selector.add("payeeName");
        selector.addObjectCollection((IObjectCollection)this.getSelectors());
        cheque = ch.getChequeInfo((IObjectPK)new ObjectUuidPK(cheque.getId()), selector);
        this.chequeProvider.writeAssosicateCheque(cheque, this.billIds);
        if (cheque.getAmount() == null || cheque.getAmount().compareTo(Constants.ZERO) <= 0) {
            throw new NTException(NTException.AMOUT_BIGTHAN_ZERO);
        }
        String iso = cheque.getCurrency().getIsoCode();
        NTNumberFormat f = NTNumberFormat.getInstance(iso);
        String amountString = f.format(cheque.getAmount());
        cheque.setCapitalization(amountString);
        this.setDataObject((IObjectValue)cheque);
        this.unLockUI();
        this.loadFields();
        this.comboState.setAccessAuthority(1);
        this.f7ChequeBill.setAccessAuthority(1);
        int precision = FMClientHelper.getPrecOfCurrency((BOSUuid)cheque.getCurrency().getId());
        this.txtAmount.setPrecision(precision);
        this.txtCeiling.setPrecision(precision);
        this.f7ChequeBill.setValue((Object)cheque);
        this.chkIsMe_itemStateChanged(null);
        if (this.f7InAccountNum.isEnabled()) {
            this.f7InAccountNum.setValue((Object)this.editData.getTurnInAcctBank());
        }
        if (this.txtPayeeName.isEnabled()) {
            this.txtPayeeName.setText(this.editData.getPayeeName());
        }
        if (this.f7OppAcct.isEnabled()) {
            this.f7OppAcct.setValue((Object)this.editData.getOppAccount());
        }
        if (this.txtPayeeBank.isEnabled()) {
            this.txtPayeeBank.setText(this.editData.getPayeeAcctBank());
        }
        if (this.txtPayeeAcctBankNum.isEnabled()) {
            this.txtPayeeAcctBankNum.setText(this.editData.getPayeeAcctNumber());
        }
        this.txtPayeeName.setText(this.editData.getPayeeName());
        this.txtPayeeBank.setText(this.editData.getPayeeAcctBank());
        this.txtPayeeAcctBankNum.setText(this.editData.getPayeeAcctNumber());
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo curInfo;
        BigDecimal value = this.txtAmount.getBigDecimalValue();
        if (value == null) {
            return;
        }
        if (value.compareTo(Constants.MAX_VALUE) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.txtAmount.setValue((Object)Constants.ZERO);
            this.txtCapitalization.setText(null);
            this.txtCeiling.setValue((Object)Constants.ZERO);
            SysUtil.abort();
        }
        if ((curInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem()) == null) {
            return;
        }
        String iso = curInfo.getIsoCode();
        NTNumberFormat f = NTNumberFormat.getInstance(iso);
        String amount = f.format(this.txtAmount.getBigDecimalValue());
        this.txtCapitalization.setText(amount);
        if (this.editData.getState() == ChequeStatusEnum.NEW) {
            this.txtCeiling.setValue((Object)this.txtAmount.getBigDecimalValue());
        }
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.pkIssueDate.getTimestamp() != null) {
            this.pkExpiredDate.setValue((Object)TypeConversionUtils.objToDate((Object)DateTimeUtils.addDay((Date)this.pkIssueDate.getTimestamp(), (long)10L)));
            if (this.editData.getState() == ChequeStatusEnum.NEW) {
                this.pkApplyDate.setValue((Object)TypeConversionUtils.objToDate((Object)this.pkIssueDate.getValue()));
                this.pkRemindDate.setValue((Object)TypeConversionUtils.objToDate((Object)this.pkIssueDate.getValue()));
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (!((Date)this.pkExpiredDate.getValue()).after((Date)this.pkIssueDate.getValue())) {
            throw new NTException(NTException.EXPIREDATE_LESSTHAN_ISSUEDATE);
        }
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo person = user.getPerson();
        if (person == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{user + EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"196_ChequeAssociateUI")});
        }
        if (!this.prmtAuditor.getText().equals("") && ((PersonInfo)this.prmtAuditor.getData()).getId().toString().equals(person.getId().toString())) {
            throw new NTException(NTException.NOT_SAME_PERSON);
        }
        if (!this.prmtApplicant.getText().equals("") && !this.prmtAuditor.getText().equals("") && ((PersonInfo)this.prmtAuditor.getData()).getId().toString().equals(((PersonInfo)this.prmtApplicant.getData()).getId().toString())) {
            throw new NTException(NTException.NOT_SAME_PERSON);
        }
        BigDecimal zero = new BigDecimal("0");
        BigDecimal amount = this.txtAmount.getBigDecimalValue();
        BigDecimal ceiling = this.txtCeiling.getBigDecimalValue();
        if (amount != null && amount.compareTo(zero) <= 0) {
            throw new NTException(NTException.AMOUT_BIGTHAN_ZERO);
        }
        if (amount != null && ceiling != null && amount.compareTo(ceiling) > 0) {
            throw new NTException(NTException.AMOUT_BIGTHAN_CEILING);
        }
    }

    @Override
    protected void txtCeiling_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal value = this.txtCeiling.getBigDecimalValue();
        if (value == null) {
            return;
        }
        if (value.compareTo(Constants.MAX_VALUE) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.txtCeiling.setValue((Object)Constants.ZERO);
            SysUtil.abort();
        }
    }

    @Override
    protected void comboState_actionPerformed(ActionEvent e) throws Exception {
        super.comboState_actionPerformed(e);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        ChequeStatusEnum state = (ChequeStatusEnum)((Object)this.comboState.getSelectedItem());
        if (state == null) {
            return;
        }
        this.f7ChequeBill.setValue(null);
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyid));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter.getFilterItems().add(new FilterItemInfo("bankAcct.id", (Object)this.bankacctId));
        filter.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)this.settletypeid));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(state.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("isAbandon", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        filter.setMaskString("(#0 or #1) and #2 and #3 and #4 and #5 and #6");
        this.f7ChequeBill.setEntityViewInfo(view);
    }

    public static void showDialogWindows(IUIObject ui, String[] ids) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ASSOCIATE_IDS, (Object)ids);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChequeAssociateUI.class.getName(), (Map)uiContext, null, "ADDNEW");
        uiWindow.show();
    }

    @Override
    protected void chkIsMe_itemStateChanged(ItemEvent e) throws Exception {
        ChequeInfo cheque = (ChequeInfo)this.f7ChequeBill.getValue();
        if (cheque == null) {
            return;
        }
        boolean isCash = cheque.getNtType().isIsCash();
        boolean isMe = this.chkIsMe.isSelected();
        EntityViewInfo oppAcctEV = this.getOppAcctEV(isMe, isCash);
        this.f7OppAcct.setEntityViewInfo(oppAcctEV);
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)this, company, oppAcctEV.getFilter(), false, true);
        this.f7OppAcct.setSelector((KDPromptSelector)acctPromptBox);
        if (cheque.getBankAcct() != null) {
            this.f7InAccountNum.setEntityViewInfo(ChequeUtil.getInAcctBank(isMe, isCash, cheque.getBankAcct().getId().toString(), company.getId().toString()));
        }
        if (this.chkIsMe.isSelected()) {
            this.f7InAccountNum.setEnabled(true);
            this.txtPayeeName.setEnabled(false);
            this.txtPayeeAcctBankNum.setEnabled(false);
            this.txtPayeeName.setEnabled(false);
            this.txtPayeeName.setText(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getName());
        } else {
            this.f7InAccountNum.setEnabled(false);
            this.txtPayeeName.setEnabled(true);
            this.txtPayeeAcctBankNum.setEnabled(true);
            this.txtPayeeName.setEnabled(true);
            this.txtPayeeName.setText(null);
            this.f7OppAcct.setValue(null);
            this.txtPayeeAcctBankNum.setText(null);
            this.f7InAccountNum.setValue(null);
        }
        this.f7InAccountNum.setEnabled(false);
        this.txtPayeeName.setEnabled(false);
        this.txtPayeeAcctBankNum.setEnabled(false);
        this.txtPayeeBank.setEnabled(false);
        this.f7InAccountNum.setValue(null);
        this.txtPayeeName.setText(null);
        this.f7OppAcct.setValue(null);
        this.txtPayeeAcctBankNum.setText(null);
        this.txtPayeeBank.setText(null);
        if (this.chkIsMe.isSelected()) {
            if (!isCash) {
                this.f7InAccountNum.setEnabled(true);
            }
            this.txtPayeeName.setText(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getName());
        } else {
            this.txtPayeeName.setEnabled(true);
            this.txtPayeeAcctBankNum.setEnabled(true);
            this.txtPayeeBank.setEnabled(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("company.*");
        sic.add("cashier.*");
        sic.add("oppAccount.*");
        sic.add("turnInAcctBank.*");
        sic.add("ntType.*");
        sic.add("settleType.*");
        sic.add("bankAcct.*");
        sic.add("applyRec.*");
        sic.add("applyRec.id");
        sic.add("applyRec.department.id");
        sic.add("applyRec.department.name");
        sic.add("applyRec.department.number");
        sic.add("applyRec.applicant.id");
        sic.add("applyRec.applicant.name");
        sic.add("applyRec.applicant.number");
        sic.add("applyRec.auditor.id");
        sic.add("applyRec.auditor.name");
        sic.add("applyRec.auditor.number");
        sic.add("applyRec.reimburser.id");
        sic.add("applyRec.reimburser.name");
        sic.add("applyRec.reimburser.number");
        sic.add("applyRec.creator.id");
        sic.add("applyRec.creator.name");
        sic.add("applyRec.creator.number");
        return sic;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.chequeProvider.saveAssosicateCheque(this.editData, this.billIds);
        this.setSave(true);
        IObjectValue value = this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.setDataObject(value);
        this.loadFields();
        MessageUtil.showSuccessInfo((CoreUI)this, (ItemAction)this.actionSubmit);
        this.actionSubmit.setEnabled(false);
        this.btnWriteOff.setEnabled(false);
    }

    @Override
    protected void prmtApplicant_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtApplicant_dataChanged(e);
        PersonInfo person = null;
        Object id = null;
        if (e.getNewValue() == null) {
            return;
        }
        person = (PersonInfo)e.getNewValue();
        AdminOrgUnitInfo org = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(person.getId());
        if (org != null) {
            this.prmtDepartment.setValue((Object)org);
        }
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.editData.getId().toString());
        ((ICheque)this.getBizInterface()).book(ids);
        this.actionTDPreView.setEnabled(false);
        this.actionTDPrint.setEnabled(false);
        this.actionBook.setEnabled(false);
        MessageUtil.showSuccessInfo((CoreUI)this, (ItemAction)this.actionBook);
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.editData.getId().toString());
        ((ICheque)this.getBizInterface()).cancelBook(ids);
        MessageUtil.showSuccessInfo((CoreUI)this, (ItemAction)this.actionCancelBook);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBook.setIcon(EASResource.getIcon((String)"imgTbtn_post"));
        this.btnBook.setVisible(false);
        this.btnTDPrint.setIcon(EASResource.getIcon((String)"imgTbtn_credenceprint"));
    }

    public boolean isModify() {
        return false;
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        MutexUtils.requestMutex((CoreUI)this, (String[])this.billIds);
        return b;
    }

    private EntityViewInfo getOppAcctEV(boolean isMe, boolean isCash) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String cuid = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        ev.setFilter(filter);
        if (isMe && isCash) {
            filter.getFilterItems().add(new FilterItemInfo("iscash", (Object)Constants.TRUE));
        }
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cuid));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getAccountTable().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)Constants.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        return ev;
    }
}

