/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.IdentityTypeEnum;
import com.kingdee.eas.fm.nt.NTDateFormat;
import com.kingdee.eas.fm.nt.NTNumberFormat;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChequeTDQueryDelegate
implements BOSQueryDelegate {
    private static final Logger logger = CoreUIObject.getLogger(ChequeTDQueryDelegate.class);
    private final Set ids;
    public static final IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fm.nt.app.ChequeTDQuery");

    public ChequeTDQueryDelegate(Set id) {
        this.ids = id;
    }

    public ChequeTDQueryDelegate(List id) {
        this.ids = new HashSet(id);
    }

    public static void main(String[] args) throws BOSException {
        FMClientHelper.printTDMetaDataField((String)qpk.getFullName());
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qpk);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashSet<Integer> statusSet = new HashSet<Integer>();
            statusSet.add(new Integer(0));
            statusSet.add(new Integer(5));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("state", statusSet, CompareType.NOTINCLUDE));
            ev.getSorter().add(new SorterItemInfo("number"));
            ArrayList param = ds.getParams();
            FMHelper.addDataFilter((FilterInfo)filter, (ArrayList)param);
            ev.setFilter(filter);
            exec.setObjectView(ev);
            logger.info((Object)exec.getSQL());
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                String identityType;
                int signTwo;
                int signOne;
                String capDate;
                NTDateFormat format;
                Date issueDate = iRowSet.getDate("issueDate");
                Date applyDate = iRowSet.getDate("applyRec.applyDate");
                if (issueDate != null) {
                    format = new NTDateFormat();
                    capDate = format.format(issueDate);
                    signOne = capDate.indexOf(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"213_ChequeTDQueryDelegate"));
                    signTwo = capDate.indexOf(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"214_ChequeTDQueryDelegate"));
                    String year = capDate.substring(0, signOne);
                    String month = capDate.substring(signOne + 1, signTwo);
                    String day = capDate.substring(signTwo + 1);
                    day = day.substring(0, day.length() - 1);
                    iRowSet.updateString("year", year);
                    iRowSet.updateString("month", month);
                    iRowSet.updateString("day", day);
                }
                if (applyDate != null) {
                    format = new NTDateFormat();
                    capDate = format.format(applyDate);
                    signOne = capDate.indexOf(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"213_ChequeTDQueryDelegate"));
                    signTwo = capDate.indexOf(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"214_ChequeTDQueryDelegate"));
                    String applyYear = capDate.substring(0, signOne);
                    String applyMonth = capDate.substring(signOne + 1, signTwo);
                    String applyDay = capDate.substring(signTwo + 1);
                    applyDay = applyDay.substring(0, applyDay.length() - 1);
                    iRowSet.updateString("applyYear", applyYear);
                    iRowSet.updateString("applyMonth", applyMonth);
                    iRowSet.updateString("applyDay", applyDay);
                }
                int precision = 2;
                BigDecimal ceil = iRowSet.getBigDecimal("applyrec.ceiling");
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setMaximumFractionDigits(precision);
                nf.setMinimumFractionDigits(precision);
                nf.setGroupingUsed(false);
                String ceiling = "";
                if (ceil != null) {
                    ceiling = nf.format(ceil);
                }
                StringBuffer ceilingamount = new StringBuffer();
                for (int i = 0; i < ceiling.length(); ++i) {
                    ceilingamount.append(" ");
                }
                iRowSet.updateString("ceilingMasterString", ceilingamount.toString());
                BigDecimal amount = iRowSet.getBigDecimal("amount");
                if (amount != null) {
                    iRowSet.updateBigDecimal("amount", amount.setScale(precision, 4));
                    String capitalization = iRowSet.getString("capitalization");
                    if (capitalization == null || capitalization.length() == 0) {
                        String isoCode = iRowSet.getString("currency.isoCode");
                        NTNumberFormat f = NTNumberFormat.getInstance(isoCode);
                        iRowSet.updateString("capitalization", f.format(amount));
                    }
                }
                if (FMHelper.isEmpty((String)(identityType = iRowSet.getString("identityType")))) continue;
                IdentityTypeEnum aEnum = IdentityTypeEnum.getEnum(Integer.parseInt(identityType));
                if (!FMHelper.isEmpty((Object)((Object)aEnum))) {
                    iRowSet.updateString("identityType", aEnum.getAlias());
                    continue;
                }
                iRowSet.updateString("identityType", "");
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return iRowSet;
    }

    public static String yearToChineseYear(int year) {
        String yyyy = Integer.toString(year);
        StringBuffer chineseYear = new StringBuffer();
        for (int i = 1; i <= yyyy.length(); ++i) {
            chineseYear.append(ChequeTDQueryDelegate.numberToChineseChar(Integer.parseInt(yyyy.substring(i - 1, i))));
        }
        return chineseYear.toString();
    }

    public static String dateToChineseDate(java.util.Date date) {
        GregorianCalendar dt = new GregorianCalendar();
        dt.setTime(date);
        StringBuffer chineseDate = new StringBuffer();
        chineseDate.append(ChequeTDQueryDelegate.yearToChineseYear(dt.get(1)));
        chineseDate.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"213_ChequeTDQueryDelegate"));
        chineseDate.append(ChequeTDQueryDelegate.monthToChineseMonth(dt.get(2)));
        chineseDate.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"214_ChequeTDQueryDelegate"));
        chineseDate.append(ChequeTDQueryDelegate.dayToChineseDay(dt.get(5)));
        chineseDate.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"215_ChequeTDQueryDelegate"));
        return chineseDate.toString();
    }

    public static String monthToChineseMonth(int month) {
        return ChequeTDQueryDelegate.numberToChineseChar(month);
    }

    public static String dayToChineseDay(int day) {
        StringBuffer dd = new StringBuffer();
        switch (day) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 30: {
                dd = dd.append(ChequeTDQueryDelegate.numberToChineseChar(day));
                break;
            }
            default: {
                dd.append(ChequeTDQueryDelegate.numberToChineseChar(day / 10 * 10));
                dd.append(ChequeTDQueryDelegate.numberToChineseChar(day % 10));
            }
        }
        return dd.toString();
    }

    private static String numberToChineseChar(int number) {
        String str = "";
        switch (number) {
            case 0: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"216_ChequeTDQueryDelegate");
                break;
            }
            case 1: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"217_ChequeTDQueryDelegate");
                break;
            }
            case 2: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"218_ChequeTDQueryDelegate");
                break;
            }
            case 3: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"219_ChequeTDQueryDelegate");
                break;
            }
            case 4: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"220_ChequeTDQueryDelegate");
                break;
            }
            case 5: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"221_ChequeTDQueryDelegate");
                break;
            }
            case 6: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"222_ChequeTDQueryDelegate");
                break;
            }
            case 7: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"223_ChequeTDQueryDelegate");
                break;
            }
            case 8: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"224_ChequeTDQueryDelegate");
                break;
            }
            case 9: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"225_ChequeTDQueryDelegate");
                break;
            }
            case 10: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"226_ChequeTDQueryDelegate");
                break;
            }
            case 11: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"227_ChequeTDQueryDelegate");
                break;
            }
            case 12: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"228_ChequeTDQueryDelegate");
                break;
            }
            case 20: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"229_ChequeTDQueryDelegate");
                break;
            }
            case 30: {
                str = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"230_ChequeTDQueryDelegate");
            }
        }
        return str;
    }
}

