/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.client.AbstractChequeVCChooseUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChequeVCChooseUI
extends AbstractChequeVCChooseUI {
    private HashMap chequeMap;
    private Set setFailure;
    private ArrayList listSuccess;

    public ChequeVCChooseUI() throws Exception {
        this.tableCheque.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
        this.kdtBizDetail.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chequeMap = (HashMap)this.getUIContext().get("cheques");
        this.setFailure = (Set)this.getUIContext().get("mapFailure");
        this.listSuccess = (ArrayList)this.getUIContext().get("listSuccess");
        this.kdtBizDetail.getStyleAttributes().setLocked(true);
        this.fillTable(this.tableCheque, this.getChequeCollection());
    }

    public void onShow() throws Exception {
        this.tableCheque.getSelectManager().setActiveRowIndex(0);
        super.onShow();
    }

    private IObjectCollection getChequeCollection() {
        HashSet idList = new HashSet(this.chequeMap.keySet());
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("bankAcct.*"));
        view.getSelector().add(new SelectorItemInfo("currency.*"));
        view.getSelector().add(new SelectorItemInfo("ntType.*"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("amount"));
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idList, CompareType.INCLUDE));
        view.setFilter(filter);
        ChequeCollection cheque = null;
        try {
            cheque = ChequeFactory.getRemoteInstance().getChequeCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return cheque;
    }

    private void fillTable(KDTable table, IObjectCollection coll) {
        table.removeRows();
        table.checkParsed();
        int len = coll.size();
        for (int i = 0; i < len; ++i) {
            IRow row = table.addRow();
            CoreBaseInfo vo = (CoreBaseInfo)coll.getObject(i);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)vo, (Field)new Field(table.getColumnKey(j))));
            }
        }
        this.setListUITable(table, null);
    }

    @Override
    protected void tableCheque_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tableCheque_tableSelectChanged(e);
        this.checkSelected(this.tableCheque);
        int selectRow = this.tableCheque.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        String id = this.tableCheque.getRow(selectRow).getCell("id").getValue().toString();
        FilterInfo filter = (FilterInfo)this.chequeMap.get(id);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("settlementType.*"));
        view.getSelector().add(new SelectorItemInfo("currency.*"));
        view.getSelector().add(new SelectorItemInfo("accountView.*"));
        view.getSelector().add(new SelectorItemInfo("billType.*"));
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(filter);
        JournalCollection journalColl = JournalFactory.getRemoteInstance().getJournalCollection(view);
        this.fillTable(this.kdtBizDetail, (IObjectCollection)journalColl);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.checkSelected(this.kdtBizDetail);
        if (this.tableCheque.getSelectManager().size() == 0 || this.kdtBizDetail.getSelectManager().size() == 0) {
            return;
        }
        String sourceId = this.tableCheque.getRow(this.tableCheque.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        String id = this.kdtBizDetail.getRow(this.kdtBizDetail.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        JournalInfo joural = JournalFactory.getRemoteInstance().getJournalInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        ChequeFactory.getRemoteInstance().vc(sourceId, joural);
        this.listSuccess.add(this.tableCheque.getRow(this.tableCheque.getSelectManager().getActiveRowIndex()).getCell("number").getValue().toString());
        this.kdtBizDetail.removeRows();
        this.tableCheque.removeRow(this.tableCheque.getSelectManager().getActiveRowIndex());
        if (this.tableCheque.getRowCount() > 0) {
            this.tableCheque_tableSelectChanged(null);
        }
        if (this.tableCheque.getRowCount() == 0) {
            this.showVCMessage();
            this.destroyWindow();
        }
    }

    private void showVCMessage() {
        StringBuffer info = new StringBuffer();
        String msg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"231_ChequeVCChooseUI");
        msg = MessageFormat.format(msg, this.listSuccess.size());
        info.append(msg);
        Object[] ids = this.setFailure.toArray();
        if (ids.length > 0) {
            info.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"233_ChequeVCChooseUI"));
        }
        for (int i = 0; i < ids.length; ++i) {
            Map mapFailure = (Map)ids[i];
            String number = (String)mapFailure.keySet().iterator().next();
            info.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"234_ChequeVCChooseUI"));
            info.append(mapFailure.get(number));
            info.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"235_ChequeVCChooseUI"));
            info.append(ids[i].toString());
            info.append(";\n");
        }
        MsgBox.showInfo((String)info.toString());
    }

    @Override
    protected void kdtBizDetail_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdtBizDetail_tableClicked(e);
        this.checkSelected(this.kdtBizDetail);
        String sourceId = this.tableCheque.getRow(this.tableCheque.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        if (e.getClickCount() == 2) {
            String id = this.kdtBizDetail.getRow(e.getRowIndex()).getCell("id").getValue().toString();
            JournalInfo joural = JournalFactory.getRemoteInstance().getJournalInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            ChequeFactory.getRemoteInstance().vc(sourceId, joural);
            this.listSuccess.add(this.tableCheque.getRow(this.tableCheque.getSelectManager().getActiveRowIndex()).getCell("number").getValue().toString());
            this.tableCheque.removeRow(this.tableCheque.getSelectManager().getActiveRowIndex());
            this.kdtBizDetail.removeRows();
            if (this.tableCheque.getRowCount() > 0) {
                this.tableCheque_tableSelectChanged(null);
            }
        }
    }

    private void checkSelected(KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.showVCMessage();
        this.destroyWindow();
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        for (int i = 0; i <= tblMain.getRowCount() - 1; ++i) {
            row = tblMain.getRow(i);
            currencyId = row.getCell("currency.id").getValue().toString();
            if (currencyId == null) continue;
            String[] formatCol = this.getPrecColName(tblMain);
            for (int j = 0; j < formatCol.length; ++j) {
                FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
            }
        }
    }

    private String[] getPrecColName(KDTable tblMain) {
        if (tblMain.equals(this.tableCheque)) {
            return new String[]{"amount"};
        }
        if (tblMain.equals(this.kdtBizDetail)) {
            return new String[]{"creditAmount"};
        }
        return null;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e.getSource().equals(ChequeVCChooseUI.this.tableCheque)) {
                ChequeVCChooseUI.this.setListUITable(ChequeVCChooseUI.this.tableCheque, e);
            } else if (e.getSource().equals(ChequeVCChooseUI.this.kdtBizDetail)) {
                ChequeVCChooseUI.this.setListUITable(ChequeVCChooseUI.this.kdtBizDetail, e);
            }
        }
    }
}

