/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.ent.client.DiscountBillBatch4ElecEditUI;
import com.kingdee.eas.fm.nt.DiscountApplyBillFactory;
import com.kingdee.eas.fm.nt.DiscountApplyBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractChooseDiscountApplyBillEditUI;
import com.kingdee.eas.fm.nt.client.DiscountBillBatchEditUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChooseDiscountApplyBillEditUI
extends AbstractChooseDiscountApplyBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ChooseDiscountApplyBillEditUI.class);
    private IObjectCollection billCollection = null;
    protected boolean isECDS = false;
    private Date disDate = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.billCollection = (IObjectCollection)this.getUIContext().get("ReceivableColl");
        this.isECDS = (Boolean)this.getUIContext().get("isECDS");
        this.toolBar.setEnabled(false);
        this.toolBar.setVisible(false);
        this.btnConfirm.setEnabled(true);
        this.btnCanc.setEnabled(true);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String curCompanyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)curCompanyId));
        this.disDate = (Date)this.getUIContext().get("disDate");
        if (this.disDate == null) {
            this.disDate = new Date();
        }
        this.disDate = DateTimeUtils.truncateDate((Date)this.disDate);
        filterInfo.getFilterItems().add(new FilterItemInfo("bizValidDateStart", (Object)this.disDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizValidDateEnd", null, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizValidDateEnd", (Object)this.disDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("localAmount - usedLocalAmt", (Object)0, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("draftNumber", null, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1 and (#2 or #3) and  #4 and #5 and #6");
        evi.setFilter(filterInfo);
        this.prmtDiscontApplyBill.setEntityViewInfo(evi);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public boolean destroyWindow() {
        if (!EmptyUtil.isEmpty((Object)this.billCollection)) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            for (int i = 0; i < this.billCollection.size(); ++i) {
                iMutex.releaseObjIDForUpdate(((ReceivableBillInfo)this.billCollection.getObject(i)).getId().toString());
            }
        }
        return super.destroyWindow();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkConfirm();
        super.actionConfirm_actionPerformed(e);
        this.disposeUIWindow();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ReceivableColl", (Object)this.billCollection);
        uiContext.put((Object)"disDate", (Object)this.disDate);
        DiscountApplyBillInfo info = (DiscountApplyBillInfo)this.prmtDiscontApplyBill.getValue();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("id", (Object)info.getId());
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("accountBank.id"));
        view.getSelector().add(new SelectorItemInfo("accountBank.name"));
        view.getSelector().add(new SelectorItemInfo("accountBank.number"));
        view.getSelector().add(new SelectorItemInfo("accountBank.bank.*"));
        view.getSelector().add(new SelectorItemInfo("accountBank.bank.accountBank.*"));
        view.setFilter(filter);
        CoreBillBaseCollection collection = DiscountApplyBillFactory.getRemoteInstance().getCoreBillBaseCollection(view);
        if (collection != null && collection.size() > 0) {
            info = (DiscountApplyBillInfo)collection.get(0);
            uiContext.put((Object)"DiscountApplyBill", (Object)info);
        }
        IUIWindow uiWindow = null;
        if (this.isECDS) {
            uiContext.put((Object)"isECDS", (Object)true);
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DiscountBillBatch4ElecEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        } else {
            uiContext.put((Object)"isECDS", (Object)false);
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DiscountBillBatchEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        }
        uiWindow.show();
    }

    private void checkConfirm() {
        Object value = this.prmtDiscontApplyBill.getValue();
        if (value == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.client.DiscountApplyClientResource", (String)"15_Choose_DiscountApplyBill"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCanc_actionPerformed(ActionEvent e) throws Exception {
        super.actionCanc_actionPerformed(e);
        this.disposeUIWindow();
    }
}

