/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ent.client.DiscountBillBatch4ElecEditUI;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.DiscountApplyBillCollection;
import com.kingdee.eas.fm.nt.DiscountApplyBillFactory;
import com.kingdee.eas.fm.nt.DiscountApplyBillInfo;
import com.kingdee.eas.fm.nt.DiscountApplyBillStateEnum;
import com.kingdee.eas.fm.nt.IDiscountApplyBill;
import com.kingdee.eas.fm.nt.NTPHelper;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractDiscountApplyBillListUI;
import com.kingdee.eas.fm.nt.client.DiscountApplyBillBatchEditUI;
import com.kingdee.eas.fm.nt.client.DiscountApplyBillEditUI;
import com.kingdee.eas.fm.nt.client.DiscountApplyBillFilterUI;
import com.kingdee.eas.fm.nt.client.DiscountBillBatchEditUI;
import com.kingdee.eas.fm.nt.client.DraftUpdateStatusListUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DiscountApplyBillListUI
extends AbstractDiscountApplyBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(DiscountApplyBillListUI.class);
    private DiscountApplyBillFilterUI filterUI;
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.nt.client.DiscountApplyClientResource";
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    private CompanyOrgUnitInfo currentCompany;
    public static final String OPER_COPY = "COPY";
    FillListener fillListener = new FillListener();

    public DiscountApplyBillListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public void onLoad() throws Exception {
        if (!this.currentCompany.isIsBizUnit()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"16_ChangeBaseCompany"));
            SysUtil.abort();
        }
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!NTPHelper.getParamValue(null, "IS_ELEC")) {
            this.actionDiscount.setVisible(false);
            this.actionCommitToBe.setVisible(false);
            this.actionSynStatus.setVisible(false);
            this.actionEditStatus.setVisible(false);
            this.actionReleaseFailedBill.setVisible(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopyTo.setText("");
        this.actionDiscount.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DiscountApplyBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        DiscountApplyBillInfo objectValue = new DiscountApplyBillInfo();
        return objectValue;
    }

    protected void execQuery() {
        super.execQuery();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DiscountApplyBillFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return DiscountApplyBillEditUI.class.getName();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkAudit();
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)this.getSelectedIdValues());
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        HashSet IDs = new HashSet(this.getSelectedIdValues());
        DiscountApplyBillFactory.getRemoteInstance().batchAudit(IDs);
        this.refreshList();
    }

    private void checkAudit() throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO status = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (status.getValue().equals("0")) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"5_SAVE_BILL_AUDIT_ERROR", (Object[])new Object[]{row.getCell("number").getValue()}));
                SysUtil.abort();
            }
            if (!status.getValue().equals("2")) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"6_AUDITED_BILL_AUDIT_ERROR", (Object[])new Object[]{row.getCell("number").getValue()}));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkAntiAudit();
        HashSet IDs = new HashSet(this.getSelectedIdValues());
        DiscountApplyBillFactory.getRemoteInstance().batchAntiAudit(IDs);
        this.refreshList();
    }

    private void checkAntiAudit() throws Exception {
        this.checkSelected();
        DiscountApplyBillCollection discountApplyBillCol = this.getDiscountApplyCol(new HashSet(this.getSelectedIdValues()));
        DiscountApplyBillInfo tempInfo = null;
        for (int i = 0; i < discountApplyBillCol.size(); ++i) {
            tempInfo = discountApplyBillCol.get(i);
            if (tempInfo.isIsGenDiscountBill()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"7_Gen_Discount_AntiAudit_Error", (Object[])new Object[]{tempInfo.getNumber()}));
                SysUtil.abort();
            }
            if (tempInfo.getBillState() == DiscountApplyBillStateEnum.Audit) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"8_Not_AuditedBIll_Error", (Object[])new Object[]{tempInfo.getNumber()}));
            SysUtil.abort();
        }
    }

    private DiscountApplyBillCollection getDiscountApplyCol(Set idSet) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillCollection(evi);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkEdit();
        String id = this.getSelectedKeyValue();
        DiscountApplyBillInfo applyBillInfo = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        if (applyBillInfo.getReceivableEntrys().size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = this.getReceSelectors();
            view.getSelector().addObjectCollection((IObjectCollection)selector);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("discountApplyBill.id", (Object)applyBillInfo.getId().toString(), CompareType.EQUALS));
            view.setFilter(fi);
            CoreBaseCollection coll = ReceivableBillFactory.getRemoteInstance().getCollection(view);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ReceivableColl", (Object)coll);
            uiContext.put((Object)"ID", (Object)id);
            uiContext.put((Object)"applyId", (Object)id);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DiscountApplyBillBatchEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            this.refreshList();
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    private void checkEdit() throws Exception {
        this.checkSelected();
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO status = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (!status.getValue().equals("2")) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"9_Audited_Bill_Edit_Error", (Object[])new Object[]{row.getCell("number").getValue()}));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        DiscountApplyBillInfo info = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(pk), this.getSelectors());
        if (info.getBillState() == DiscountApplyBillStateEnum.Audit) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"10_Audited_Bill_Remove_Error", (Object[])new Object[]{info.getNumber()}));
            SysUtil.abort();
        } else if (FMHelper.hasWFInstance(null, (String)pk)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"19_bill_inProcess", (Object[])new Object[]{info.getNumber()}));
            SysUtil.abort();
        }
        if (info.getReceivableEntrys().size() > 0) {
            DiscountApplyBillFactory.getRemoteInstance().cancelDiscountApply((IObjectPK)new ObjectUuidPK(pk));
        } else {
            DiscountApplyBillFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(pk));
        }
        this.refreshList();
    }

    private void checkRemove() throws Exception {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO status = null;
        String id = null;
        for (int i = 0; i < indexs.length; ++i) {
            boolean idsInProcess;
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (status.getValue().equals("2")) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"10_Audited_Bill_Remove_Error", (Object[])new Object[]{row.getCell("number").getValue()}));
                SysUtil.abort();
            }
            if (!(idsInProcess = FMHelper.hasWFInstance(null, (String)(id = row.getCell("id").getValue().toString())))) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"19_bill_inProcess", (Object[])new Object[]{row.getCell("number").getValue()}));
            SysUtil.abort();
        }
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBatchSubmit();
        List returnMsg = new ArrayList();
        this.checkSelected();
        try {
            returnMsg = DiscountApplyBillFactory.getRemoteInstance().batchSubmit(new HashSet(this.getSelectedIdValues()));
        }
        catch (Exception ex) {
            if (!(ex instanceof AbortException)) {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        this.showMsg(returnMsg);
        this.refreshList();
    }

    private void checkBatchSubmit() {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        BizEnumValueDTO status = null;
        for (int i = 0; i < indexs.length; ++i) {
            row = this.tblMain.getRow(indexs[i]);
            status = (BizEnumValueDTO)row.getCell("billState").getValue();
            if (status.getValue().equals("2")) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"18_billState_audited_Error", (Object[])new Object[]{row.getCell("number").getValue()}));
                SysUtil.abort();
            }
            if (!status.getValue().equals("1")) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"17_billState_submited_Error", (Object[])new Object[]{row.getCell("number").getValue()}));
            SysUtil.abort();
        }
    }

    private void showMsg(List returnMsg) {
        String msg = this.getMsgFromList(returnMsg);
        MsgBox.showInfo((String)msg);
    }

    private String getMsgFromList(List returnMsg) {
        if (returnMsg.size() == 0) {
            return EASResource.getString((String)RESOURCE_PATH, (String)"13_Submited_Succ");
        }
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < returnMsg.size(); ++i) {
            sb.append(returnMsg.get(i).toString()).append("\n");
        }
        return sb.toString();
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            this.checkObjectExists();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
            uiContext.put((Object)OPER_COPY, (Object)OPER_COPY);
            this.prepareUIContext(uiContext, e);
            uiContext.put((Object)"IDList", null);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    private void checkObjectExists() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            BizEnumValueInfo exp;
            Object enu;
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell("currency.id").getValue();
            if (currencyId != null) {
                String[] formatCol = this.getPrecColName();
                for (int j = 0; j < formatCol.length; ++j) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
                }
            }
            if ("year".equalsIgnoreCase((enu = (exp = (BizEnumValueInfo)row.getCell("intRateTypeExp").getValue()).getValue()).toString())) {
                row.getCell("discountRate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                continue;
            }
            row.getCell("discountRate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
        }
    }

    protected String[] getPrecColName() {
        return new String[]{"discountApplyAmt", "usedAmt"};
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        String id = this.getSelectedKeyValue();
        DiscountApplyBillInfo applyBillInfo = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        if (applyBillInfo.getReceivableEntrys().size() > 0) {
            this.actionCopyTo.setEnabled(false);
            this.actionCommitToBe.setEnabled(false);
            this.actionDiscount.setEnabled(false);
            if (applyBillInfo.getBillState() == DiscountApplyBillStateEnum.Audit) {
                if (!applyBillInfo.isIsCommitToBE()) {
                    this.actionCommitToBe.setEnabled(!applyBillInfo.isIsGenDiscountBill());
                } else {
                    this.actionCommitToBe.setEnabled(this.isBEAllFail(applyBillInfo, false));
                }
                if (!applyBillInfo.isIsGenDiscountBill()) {
                    if (applyBillInfo.isIsCommitToBE()) {
                        this.actionDiscount.setEnabled(this.existBESuccess(applyBillInfo));
                    } else {
                        this.actionDiscount.setEnabled(this.existFailDiscount(applyBillInfo));
                    }
                } else {
                    this.actionDiscount.setEnabled(this.existFailDiscount(applyBillInfo));
                }
                this.actionAntiAudit.setEnabled(!applyBillInfo.isIsCommitToBE() || applyBillInfo.isIsCommitToBE() && this.isBEAllFail(applyBillInfo, true));
            }
            boolean canRelease = false;
            if (applyBillInfo.isIsCommitToBE() && this.existBEFail(applyBillInfo)) {
                canRelease = true;
            }
            this.actionSynStatus.setEnabled(applyBillInfo.isIsCommitToBE());
            this.actionEditStatus.setEnabled(applyBillInfo.isIsCommitToBE() && this.existBEException(applyBillInfo));
            this.actionReleaseFailedBill.setEnabled(canRelease);
        } else {
            this.actionCopyTo.setEnabled(true);
            this.actionDiscount.setEnabled(false);
            this.actionCommitToBe.setEnabled(false);
            this.actionSynStatus.setEnabled(false);
            this.actionEditStatus.setEnabled(false);
            this.actionReleaseFailedBill.setEnabled(false);
        }
    }

    private boolean existFailDiscount(DiscountApplyBillInfo applyBillInfo) {
        boolean exist = false;
        ReceivableBillCollection coll = applyBillInfo.getReceivableEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (applyBillInfo.isIsCommitToBE()) {
                if (entry.getDiscountBill() != null || entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_SUCCESS) continue;
                exist = true;
                break;
            }
            if (entry.getDiscountBill() != null) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean existBESuccess(DiscountApplyBillInfo applyBillInfo) {
        boolean exist = false;
        ReceivableBillCollection coll = applyBillInfo.getReceivableEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (entry.getBankReturnStatus() == null || entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_SUCCESS) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean existBEFail(DiscountApplyBillInfo info) {
        boolean exist = false;
        ReceivableBillCollection coll = info.getReceivableEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (entry.getBankReturnStatus() == null || entry.getBankReturnStatus() != BankReturnStatusEnum.COMMIT_FAIL && entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_FAIL) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean isBEAllFail(DiscountApplyBillInfo applyBillInfo, boolean rejected) {
        boolean flg = true;
        ReceivableBillCollection coll = applyBillInfo.getReceivableEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo info = coll.get(i);
            if (info.getBankReturnStatus() != null) {
                if (rejected) {
                    if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
                    flg = false;
                    break;
                }
                if (info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) continue;
                flg = false;
                break;
            }
            flg = false;
            break;
        }
        return flg;
    }

    @Override
    public void actionDiscount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            String id = idList.get(0).toString();
            DiscountApplyBillInfo applyBillInfo = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = this.getReceSelectors();
            view.getSelector().addObjectCollection((IObjectCollection)selector);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("discountApplyBill.id", (Object)applyBillInfo.getId().toString(), CompareType.EQUALS));
            if (applyBillInfo.isIsCommitToBE()) {
                fi.getFilterItems().add(new FilterItemInfo("bankReturnStatus", (Object)new Integer(3), CompareType.EQUALS));
            }
            fi.getFilterItems().add(new FilterItemInfo("discountBill.id", null, CompareType.EQUALS));
            view.setFilter(fi);
            CoreBaseCollection coll = ReceivableBillFactory.getRemoteInstance().getCollection(view);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ReceivableColl", (Object)coll);
            uiContext.put((Object)"applyInfo", (Object)applyBillInfo);
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = null;
            if (((ReceivableBillInfo)coll.getObject(0)).getSource().equals((Object)BillSourceEnum.BYECDS)) {
                uiContext.put((Object)"isECDS", (Object)true);
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DiscountBillBatch4ElecEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            } else {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DiscountBillBatchEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            }
            uiWindow.show();
        }
        this.refreshList();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        DiscountApplyBillInfo applyBillInfo = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        if (applyBillInfo.getReceivableEntrys().size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = this.getReceSelectors();
            view.getSelector().addObjectCollection((IObjectCollection)selector);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("discountApplyBill.id", (Object)applyBillInfo.getId().toString(), CompareType.EQUALS));
            view.setFilter(fi);
            CoreBaseCollection coll = ReceivableBillFactory.getRemoteInstance().getCollection(view);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ReceivableColl", (Object)coll);
            uiContext.put((Object)"ID", (Object)id);
            uiContext.put((Object)"applyId", (Object)id);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DiscountApplyBillBatchEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            super.actionView_actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCommitToBe_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            String id = idList.get(0).toString();
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                DiscountApplyBillInfo applyBillInfo;
                if (!iMutex.requestObjIDForUpdate(id)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if ((applyBillInfo = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors())).getBillMedium() == BillMediumEnum.ELECTRONIC) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"140_BE_PROCESSING_WAITING"));
                    SysUtil.abort();
                } else {
                    if (applyBillInfo.isIsCommitToBE() && NTPHelper.existBEProcessing(applyBillInfo.getReceivableEntrys())) {
                        MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"012_BE_PROCESSING_WAITING"));
                        SysUtil.abort();
                    } else if (NTPHelper.isBEAllProcessed(applyBillInfo.getReceivableEntrys())) {
                        MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"043_COMMITTOBE_FINISHED"));
                        SysUtil.abort();
                    }
                    int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
                    boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
                    if (EBSstatus != 1 || !isContain) {
                        MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                        SysUtil.abort();
                    }
                    DiscountApplyBillFactory.getRemoteInstance().commitToBE((IObjectPK)new ObjectUuidPK(id));
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"044_COMMITTOBE_SUCCESS"));
                }
            }
            finally {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSynStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)idList);
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (boolResult.booleanValue()) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            IDiscountApplyBill iDiscountApplyBill = DiscountApplyBillFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("number");
            selectors.add("isCommitToBE");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            view.setSelector(selectors);
            DiscountApplyBillCollection colls = iDiscountApplyBill.getDiscountApplyBillCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                DiscountApplyBillInfo info = colls.get(i);
                if (info.isIsCommitToBE()) continue;
                MsgBox.showInfo((String)(info.getNumber() + EASResource.getString((String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS")));
                SysUtil.abort();
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            BatchExecuteResult result = (BatchExecuteResult)iDiscountApplyBill.syncBeStatus(idSet);
            NTPHelper.showActionResult((Component)((Object)this), result);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate((List)idList);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEditStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            String id = idList.get(0).toString();
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                DiscountApplyBillInfo applyBillInfo;
                if (!iMutex.requestObjIDForUpdate(id)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if (!this.existBEException(applyBillInfo = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors()))) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"054_CANNOT_EIDTSTATUS"));
                    SysUtil.abort();
                }
                int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
                boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
                if (EBSstatus != 1 || !isContain) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                    SysUtil.abort();
                }
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"InitDataObject", this.getBEExceptionColl(applyBillInfo.getReceivableEntrys()));
                String uiName = DraftUpdateStatusListUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
                List<Map<String, Object>> statusList = ((DraftUpdateStatusListUI)uiWindow.getUIObject()).getStatusList();
                if (statusList == null) {
                    return;
                }
                DiscountApplyBillFactory.getRemoteInstance().updateBeStatus(statusList);
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"063_EDITBESTATUS_SUCCESS"));
            }
            finally {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionReleaseFailedBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            String id = idList.get(0).toString();
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                DiscountApplyBillInfo applyBillInfo;
                if (!iMutex.requestObjIDForUpdate(id)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if (!this.isBEAllFail(applyBillInfo = DiscountApplyBillFactory.getRemoteInstance().getDiscountApplyBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors()), true)) {
                    if (applyBillInfo.isIsCommitToBE() && !this.isBEAllFail(applyBillInfo, true) && this.existBEFail(applyBillInfo)) {
                        int failCnt = DiscountApplyBillFactory.getRemoteInstance().releaseFailedBill((IObjectPK)new ObjectUuidPK(id));
                        MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"066_RELEASEFAILEDBILL_RESULT", (Object[])new String[]{String.valueOf(failCnt)}));
                    } else {
                        MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"139_CONDITION_CAN_RELEASE"));
                        SysUtil.abort();
                    }
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"138_BILL_BEALLFAIL"));
                    SysUtil.abort();
                }
            }
            finally {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        this.refreshList();
    }

    private List<Map<String, Object>> getBEExceptionColl(ReceivableBillCollection coll) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (entry.getBankReturnStatus() == null || entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", entry.getId().toString());
            map.put("draftNumber", entry.getDraftNumber());
            list.add(map);
        }
        return list;
    }

    private boolean existBEException(DiscountApplyBillInfo info) {
        boolean exist = false;
        ReceivableBillCollection coll = info.getReceivableEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (entry.getBankReturnStatus() == null || entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
            exist = true;
            break;
        }
        return exist;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("receivableEntrys.*"));
        sic.add(new SelectorItemInfo("billMedium"));
        sic.add(new SelectorItemInfo("costCenter.*"));
        sic.add(new SelectorItemInfo("accountBank.*"));
        sic.add(new SelectorItemInfo("DiscountBank.*"));
        sic.add(new SelectorItemInfo("isCommitToBE"));
        sic.add(new SelectorItemInfo("draftNumber"));
        return sic;
    }

    public SelectorItemCollection getReceSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add(new SelectorItemInfo("drawer.number"));
        sic.add(new SelectorItemInfo("deliver.number"));
        sic.add(new SelectorItemInfo("billMedium"));
        sic.add(new SelectorItemInfo("acceptorName"));
        sic.add(new SelectorItemInfo("acceptorAccountName"));
        sic.add(new SelectorItemInfo("acceptorBank.id"));
        sic.add(new SelectorItemInfo("acceptorBank.name"));
        sic.add(new SelectorItemInfo("acceptorBank.number"));
        sic.add(new SelectorItemInfo("acceptanceBankName"));
        sic.add(new SelectorItemInfo("acceptorBankNum"));
        sic.add(new SelectorItemInfo("holder.name"));
        sic.add(new SelectorItemInfo("elecBillStatus"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("bankReturnMsg"));
        return sic;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.nt.app.DiscountApplyBillTDQuery");
    }

    protected String getTDFileName() {
        return "/FM/NT/DiscountApply";
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            DiscountApplyBillListUI.this.setListUITable(DiscountApplyBillListUI.this.tblMain, e);
        }
    }
}

