/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.DiscountBillCollection;
import com.kingdee.eas.fm.nt.DiscountBillEntryCollection;
import com.kingdee.eas.fm.nt.DiscountBillEntryInfo;
import com.kingdee.eas.fm.nt.DiscountBillFactory;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.DiscountBillStateEnum;
import com.kingdee.eas.fm.nt.DiscountTypeEnum;
import com.kingdee.eas.fm.nt.IDiscountBill;
import com.kingdee.eas.fm.nt.NTFacadeFactory;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTPHelper;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.client.AbstractDiscountBillListUI;
import com.kingdee.eas.fm.nt.client.DiscountBillBatchEditUI;
import com.kingdee.eas.fm.nt.client.DiscountBillEditUI;
import com.kingdee.eas.fm.nt.client.DiscountBillFilterUI;
import com.kingdee.eas.fm.nt.client.DraftUpdateStatusListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DiscountBillListUI
extends AbstractDiscountBillListUI {
    protected DiscountBillFilterUI filterUI;
    protected CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static final String NTPRESOURCE = "com.kingdee.eas.fm.ntp.NtpResource";
    private static Logger logger = Logger.getLogger((String)DiscountBillListUI.class.getName());
    private boolean isShowEntry = true;

    public DiscountBillListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public boolean isIsShowEntry() {
        return this.isShowEntry;
    }

    public void setIsShowEntry(boolean isShowEntry) {
        this.isShowEntry = isShowEntry;
    }

    protected String[] getPrecColName() {
        return new String[]{"billAmount", "DiscountInt", "actDiscountInt", "actRecvAmount", "entryBillAmt", "entryDiscountInt", "entryActDiscountInt"};
    }

    protected String getCurrencyIdColName() {
        return "CurrencyID";
    }

    @Override
    protected String getEditUIName() {
        return DiscountBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DiscountBillFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionCancelDiscount.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inceptreport"));
        this.actionCancelConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_uninceptreport"));
        this.actionAuditTie.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAuditTie.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_versapost"));
        this.actionConfirmTie.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
        this.actionAntiConfirmTie.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.actionGather.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
        this.actionSubmitAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionCommitToBe.setVisible(false);
        this.actionSynStatus.setVisible(false);
        this.actionSynForceStatus.setVisible(false);
        this.actionNoteCancle.setVisible(false);
        this.actionEditStatus.setVisible(false);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        boolean isnext;
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        DiscountBillInfo sourceBill = ((IDiscountBill)this.getBizInterface()).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), this.getSelectors());
        boolean isAcceptBill = false;
        if (sourceBill.getDiscountBank() != null && sourceBill.getDiscountBank().getRelatedCompany() != null) {
            isAcceptBill = this.currentCompany.getId().toString().equals(sourceBill.getDiscountBank().getRelatedCompany().getId().toString());
        }
        if (sourceBill.getType() == DiscountTypeEnum.In) {
            this.actionVoucher.setEnabled(FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !sourceBill.isFivouchered() && sourceBill.getConfirmer() != null && !isAcceptBill);
            this.actionDelVoucher.setEnabled(sourceBill.isFivouchered() && sourceBill.getConfirmer() != null && !isAcceptBill);
        } else {
            this.actionVoucher.setEnabled(FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !sourceBill.isFivouchered() && !isAcceptBill);
            this.actionDelVoucher.setEnabled(sourceBill.isFivouchered() && !isAcceptBill);
        }
        boolean bCurCompany = sourceBill.getCompany().getId().toString().equals(this.currentCompany.getId().toString());
        this.actionBook.setEnabled(bCurCompany && sourceBill.getCashier() == null && FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !isAcceptBill);
        this.actionCancelBook.setEnabled(bCurCompany && sourceBill.getCashier() != null && FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !isAcceptBill);
        this.actionCancelDiscount.setEnabled(!isAcceptBill);
        this.actionConfirm.setEnabled(sourceBill.getConfirmer() == null && isAcceptBill);
        this.actionCancelConfirm.setEnabled(sourceBill.getConfirmer() != null && isAcceptBill);
        this.actionGather.setEnabled(sourceBill.getRpBillId() == null && !isAcceptBill);
        this.actionSubmitAntiAudit.setEnabled(true);
        boolean notAllSucAndFail = this.notAllBESuccessAndFail(sourceBill);
        boolean isAudit = true;
        if (isAudit) {
            this.actionGather.setEnabled(sourceBill.getRpBillId() == null && DiscountBillStateEnum.AUDITSTATE.equals((Object)sourceBill.getBillState()));
            this.actionCancelDiscount.setEnabled(!isAcceptBill && DiscountBillStateEnum.NEWSTATE.equals((Object)sourceBill.getBillState()));
            this.actionBook.setEnabled(DiscountBillStateEnum.CONFIRMSTATE.equals((Object)sourceBill.getBillState()) && bCurCompany && sourceBill.getCashier() == null && FMHelper.isEmpty((String)sourceBill.getRpBillId()) && !isAcceptBill);
            this.actionAuditTie.setEnabled(DiscountBillStateEnum.NEWSTATE.equals((Object)sourceBill.getBillState()) && !isAcceptBill && !sourceBill.isIsCommitToBe());
            this.actionAntiAuditTie.setEnabled(DiscountBillStateEnum.AUDITSTATE.equals((Object)sourceBill.getBillState()) && !isAcceptBill && !sourceBill.isIsCommitToBe());
            if (DiscountTypeEnum.In.equals((Object)sourceBill.getType())) {
                this.actionConfirmTie.setEnabled(false);
                this.actionAntiConfirmTie.setEnabled(false);
                this.actionConfirm.setEnabled(DiscountBillStateEnum.AUDITSTATE.equals((Object)sourceBill.getBillState()) && isAcceptBill && !sourceBill.isIsCommitToBe());
                this.actionCancelConfirm.setEnabled(DiscountBillStateEnum.CONFIRMSTATE.equals((Object)sourceBill.getBillState()) && isAcceptBill && !sourceBill.isIsCommitToBe());
            } else {
                this.actionConfirm.setEnabled(false);
                this.actionCancelConfirm.setEnabled(false);
                this.actionConfirmTie.setEnabled(DiscountBillStateEnum.AUDITSTATE.equals((Object)sourceBill.getBillState()) && !sourceBill.isIsCommitToBe());
                FilterInfo filter = new FilterInfo();
                if (sourceBill.getReceivablebill() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceBill.getReceivablebill().getIdentity().toString()));
                }
                filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(9), CompareType.NOTEQUALS));
                this.actionAntiConfirmTie.setEnabled(DiscountBillStateEnum.CONFIRMSTATE.equals((Object)sourceBill.getBillState()) && ReceivableBillFactory.getRemoteInstance().exists(filter));
            }
        }
        boolean bl = isnext = DiscountBillStateEnum.AUDITSTATE.equals((Object)sourceBill.getBillState()) && isAudit || !isAudit;
        if (sourceBill.getEntrys() != null && sourceBill.getEntrys().get(0) != null && sourceBill.getEntrys().get(0).getReceivableBill() != null) {
            boolean isBEEnable;
            boolean bl2 = isBEEnable = isnext && BillMediumEnum.ELECTRONIC.equals((Object)sourceBill.getBillMedium()) && !sourceBill.isIsCommitToBe();
            if (BillMediumEnum.ELECTRONIC.equals((Object)sourceBill.getBillMedium())) {
                this.actionCommitToBe.setEnabled(isBEEnable && notAllSucAndFail && !this.isNoteCancel(sourceBill));
                this.actionSynStatus.setEnabled(!isBEEnable && notAllSucAndFail && !this.isNoteCancel(sourceBill) && this.existProcessing(sourceBill));
                this.actionSynForceStatus.setEnabled(!isBEEnable && notAllSucAndFail && !this.isNoteCancel(sourceBill) && this.existProcessing(sourceBill));
            } else {
                this.actionCommitToBe.setEnabled(false);
                this.actionSynStatus.setEnabled(false);
                this.actionSynForceStatus.setEnabled(false);
            }
        } else {
            this.actionCommitToBe.setEnabled(false);
            this.actionSynStatus.setEnabled(false);
            this.actionSynForceStatus.setEnabled(false);
        }
        this.actionNoteCancle.setEnabled(sourceBill.isIsCommitToBe() && !this.isNoteCancel(sourceBill));
        this.actionEditStatus.setEnabled(sourceBill.isIsCommitToBe() && this.existBEException(sourceBill));
        if (sourceBill.isIsCommitToBe() && !this.existBEFail(sourceBill)) {
            this.actionCancelDiscount.setEnabled(false);
        }
    }

    @Override
    public void actionCancelDiscount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filters);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("discountDate"));
        view.setSelector(sic);
        DiscountBillCollection colls = DiscountBillFactory.getRemoteInstance().getDiscountBillCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            DiscountBillInfo discountBillInfo = colls.get(i);
            FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)discountBillInfo.getDiscountDate());
        }
        DiscountBillFactory.getRemoteInstance().batchCancelDiscount(new HashSet(idList));
        this.refreshList();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        DiscountBillInfo sourceBill = ((IDiscountBill)this.getBizInterface()).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        IObjectPK pks = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"244_DiscountBillListUI"), (BOSObjectType)new DiscountBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getId()), (String)sourceBill.getNumber(), (String)"nt_DiscountBill_voucher");
        super.actionVoucher_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pks);
        this.refreshList();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String ids = (String)idList.get(0);
        DiscountBillInfo sourceBill = ((IDiscountBill)this.getBizInterface()).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
        IObjectPK pks = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"245_DiscountBillListUI"), (BOSObjectType)new DiscountBillInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(sourceBill.getId()), (String)sourceBill.getNumber(), (String)"nt_DiscountBillt_Delvoucher");
        super.actionDelVoucher_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pks);
        this.refreshList();
    }

    protected void execQuery() {
        FilterInfo filter;
        if (this.getBOTPViewStatus() == 1) {
            filter = NTHelper.mergeFilter4RPCreateFrom(this.currentCompany, this.getUIContext(), "ReceivingBill");
            if (filter != null) {
                try {
                    this.mainQuery.getFilter().mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("payablebill.id", null));
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        FilterInfo filterInfo = this.mainQuery.getFilter();
        FilterItemCollection coll = filterInfo.getFilterItems();
        for (int i = 0; i < coll.size(); ++i) {
            if (!coll.get(i).get("propertyName").equals("DiscountBank.relatedCompany.id")) continue;
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("isCommitToBe", (Object)0));
            try {
                this.mainQuery.getFilter().mergeFilter(filter2, "and");
                continue;
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
        this.setAuditVisible();
        this.fpOrbgItemVisable();
    }

    protected IRow appendFootRow() {
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        }
        if (!this.isFootVisible()) {
            footRowManager.getFoot().removeRow(0);
            return null;
        }
        IRow footRow = footRowManager.getFootRow(0);
        if (footRow == null) {
            footRow = footRowManager.addFootRow(0);
        }
        super.appendFootRow();
        try {
            CurrencyCollection currencys = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            CurrencyInfo baseCurrency = currencys.get((Object)company.getBaseCurrency().getId());
            String format = FMClientHelper.getNumberFtm((int)baseCurrency.getPrecision());
            for (int i = 0; i < this.getPrecColName().length; ++i) {
                footRow.getCell(this.getPrecColName()[i]).getStyleAttributes().setNumberFormat(format);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return footRow;
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected void execQuery1() {
        super.execQuery();
        this.fpOrbgItemVisable();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DiscountBillFilterUI(BillSourceEnum.BYHAND);
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion();
        super.onLoad();
        this.actionViewBgBalance.setEnabled(true);
        this.setAuditVisible();
        this.fpOrbgItemVisable();
        if (!EmptyUtil.isEmpty((Object)this.tblMain.getColumn("discountInBank.name"))) {
            this.tblMain.getColumn("discountInBank.name").getStyleAttributes().setHided(true);
        }
        if (!EmptyUtil.isEmpty((Object)this.tblMain.getColumn("isCommitCancel"))) {
            this.tblMain.getColumn("isCommitCancel").getStyleAttributes().setHided(true);
        }
        if (!EmptyUtil.isEmpty((Object)this.tblMain.getColumn("isNoteCancel"))) {
            this.tblMain.getColumn("isNoteCancel").getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected String getTDFileName() {
        return "/FM/NT/Discount";
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.nt.app.DiscountBillTDQuery");
    }

    @Override
    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        DiscountBillCollection disColl = this.getDisBillColl(idList);
        String showMsg = this.getShowMsg(disColl);
        disColl = this.filterDisColl(disColl);
        DiscountBillFactory.getRemoteInstance().gather((IObjectCollection)disColl);
        if (showMsg.length() != 0) {
            String titleMsg = EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"532_PartBillDisFail");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)titleMsg, (String)showMsg, (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"533_GatherSuccess"));
        }
        this.refreshList();
    }

    private DiscountBillCollection getDisBillColl(List idList) throws Exception {
        HashSet idSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        view.setSelector(this.getSelectors());
        DiscountBillCollection coll = ((IDiscountBill)this.getBizInterface()).getDiscountBillCollection(view);
        return coll;
    }

    private String getShowMsg(DiscountBillCollection coll) {
        DiscountBillInfo billInfo = null;
        StringBuffer sb = new StringBuffer();
        boolean isAudit = true;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            billInfo = coll.get(i);
            if (billInfo.getRpBillId() != null) {
                sb.append("[").append(billInfo.getNoteBillNumber()).append("]\t ");
                sb.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"530_RpBillIdNotNull"));
                sb.append("\t\n");
                continue;
            }
            if (!isAudit || billInfo.getBillState().equals((Object)DiscountBillStateEnum.AUDITSTATE)) continue;
            sb.append("[").append(billInfo.getNoteBillNumber()).append("]\t ");
            sb.append(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"531_BillStateNotAudit"));
            sb.append("\t\n");
        }
        return sb.toString();
    }

    private DiscountBillCollection filterDisColl(DiscountBillCollection coll) {
        DiscountBillInfo billInfo = null;
        boolean isAudit = true;
        for (int i = coll.size() - 1; i >= 0; --i) {
            billInfo = coll.get(i);
            if (billInfo.getRpBillId() != null) {
                coll.removeObject((IObjectValue)billInfo);
                continue;
            }
            if (!isAudit || billInfo.getBillState().equals((Object)DiscountBillStateEnum.AUDITSTATE)) continue;
            coll.removeObject((IObjectValue)billInfo);
        }
        return coll;
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            BizEnumValueInfo exp;
            Object enu;
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue();
            if (currencyId != null) {
                String[] formatCol = this.getPrecColName();
                for (int j = 0; j < formatCol.length; ++j) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
                }
            }
            if ("year".equalsIgnoreCase((enu = (exp = (BizEnumValueInfo)row.getCell("intRateTypeExp").getValue()).getValue()).toString())) {
                row.getCell("DiscountRate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                continue;
            }
            row.getCell("DiscountRate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"noteBillNumber"};
        return locateNames;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("fpItem.*");
        sic.add("currency.*");
        sic.add("company.*");
        sic.add("DiscountBank.*");
        sic.add("fundFlowItem.*");
        sic.add("mbgNumber");
        sic.add("mbgName");
        sic.add("billMedium");
        sic.add("isCommitToBe");
        sic.add("discountApplierAcctNum");
        sic.add("discountApplierBankNum");
        sic.add("pasterBankNum");
        sic.add("receivablebill.*");
        sic.add("discountApplyBill.*");
        sic.add("discountApplyBill.receivableEntrys.*");
        sic.add("entrys.*");
        sic.add("entrys.receivableBill.*");
        sic.add("noteStatus");
        sic.add("cirStatus");
        return sic;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = this.getSelectors();
        return sic;
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        DiscountBillInfo info = ((IDiscountBill)this.getBizInterface()).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.DiscountBill", null, (IObjectValue)info);
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        NTFacadeFactory.getRemoteInstance().bookJouranl(id, "com.kingdee.eas.fm.nt.app.DiscountBillBookNotifyBuilder");
        this.refreshList();
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        NTFacadeFactory.getRemoteInstance().cancelBookJouranl(id);
        this.refreshList();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        uiCtx.put((Object)"disBillId", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DiscountBillBatchEditUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        editUI.show();
        this.refreshList();
    }

    @Override
    public void actionCancelConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        DiscountBillInfo info = ((IDiscountBill)this.getBizInterface()).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        if (info.isFivouchered()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"246_DiscountBillListUI"));
            SysUtil.abort();
        }
        DiscountBillFactory.getRemoteInstance().cancelConfirm(id);
        this.refreshList();
    }

    public void setAuditVisible() {
        boolean isAudit = true;
        this.actionAuditTie.setVisible(isAudit);
        this.actionAntiAuditTie.setVisible(isAudit);
        this.actionConfirmTie.setVisible(isAudit);
        this.actionAntiConfirmTie.setVisible(isAudit);
        if (this.tblMain.getColumn("auditDate") != null) {
            this.tblMain.getColumn("auditDate").getStyleAttributes().setHided(!isAudit);
        }
        if (this.tblMain.getColumn("auditor") != null) {
            this.tblMain.getColumn("auditor").getStyleAttributes().setHided(!isAudit);
        }
        boolean isSubmitAnti = NTHelper.getParam4Boolean(null, "NT022", this.currentCompany);
        this.actionSubmitAntiAudit.setVisible(isSubmitAnti);
        this.actionAntiAuditTie.setVisible(!isSubmitAnti);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.fpOrbgItemVisable();
    }

    private void fpOrbgItemVisable() {
        String owner = this.getUIContext().get("METADATA.PK").toString();
        if (owner.contains("DiscountBillListUI")) {
            if (!EmptyUtil.isEmpty((Object)this.tblMain.getColumn("elecBillStatus"))) {
                this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(true);
            }
            if (!EmptyUtil.isEmpty((Object)this.tblMain.getColumn("bankReturnStatus"))) {
                this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(true);
            }
            if (!EmptyUtil.isEmpty((Object)this.tblMain.getColumn("bankReturnMsg"))) {
                this.tblMain.getColumn("bankReturnMsg").getStyleAttributes().setHided(true);
            }
            if (!EmptyUtil.isEmpty((Object)this.tblMain.getColumn("noteStatus"))) {
                this.tblMain.getColumn("noteStatus").getStyleAttributes().setHided(true);
            }
            if (!EmptyUtil.isEmpty((Object)this.tblMain.getColumn("cirStatus"))) {
                this.tblMain.getColumn("cirStatus").getStyleAttributes().setHided(true);
            }
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.fpOrbgItemVisable();
    }

    @Override
    public void actionAuditTie_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        Map map = DiscountBillFactory.getRemoteInstance().batchAuditTie(idSet);
        if (map.size() > 0) {
            Set numberSet = (Set)map.get("detail");
            String error = EASResource.getString((String)NTPRESOURCE, (String)"Error_Detail");
            error = MessageFormat.format(error, idSet.size() - numberSet.size(), numberSet.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)DiscountBillListUI.setTran2String(numberSet), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)NTPRESOURCE, (String)"All_Success"));
        }
        this.refresh(e);
    }

    @Override
    public void actionAntiAuditTie_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        Map map = DiscountBillFactory.getRemoteInstance().batchAntAuditTie(idSet);
        if (map.size() > 0) {
            Set numberSet = (Set)map.get("detail");
            String error = EASResource.getString((String)NTPRESOURCE, (String)"Error_Detail");
            error = MessageFormat.format(error, idSet.size() - numberSet.size(), numberSet.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)DiscountBillListUI.setTran2String(numberSet), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)NTPRESOURCE, (String)"All_Success"));
        }
        this.refresh(e);
    }

    @Override
    public void actionConfirmTie_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        Map map = DiscountBillFactory.getRemoteInstance().batchConfirmTie(idSet);
        if (map.size() > 0) {
            Set numberSet = (Set)map.get("detail");
            String error = EASResource.getString((String)NTPRESOURCE, (String)"Error_Detail");
            error = MessageFormat.format(error, idSet.size() - numberSet.size(), numberSet.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)DiscountBillListUI.setTran2String(numberSet), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)NTPRESOURCE, (String)"All_Success"));
        }
        this.refresh(e);
    }

    @Override
    public void actionAntiConfirmTie_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        Map map = DiscountBillFactory.getRemoteInstance().batchAntConfirmTie(idSet);
        if (map.size() > 0) {
            Set numberSet = (Set)map.get("detail");
            String error = EASResource.getString((String)NTPRESOURCE, (String)"Error_Detail");
            error = MessageFormat.format(error, idSet.size() - numberSet.size(), numberSet.size());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)DiscountBillListUI.setTran2String(numberSet), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)NTPRESOURCE, (String)"All_Success"));
        }
        this.refresh(e);
    }

    @Override
    public void actionCommitToBe_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus == 1 && isContain) {
            BatchExecuteResult result = (BatchExecuteResult)DiscountBillFactory.getRemoteInstance().commitToBE(FMHelper.list2Set((List)idList));
            NTPHelper.showActionResult((Component)((Object)this), result);
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)NTPRESOURCE, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        this.refreshList();
    }

    private DiscountBillInfo getDiscountBillInfo(String pk) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("receivablebill.*");
        selector.add("currency.*");
        selector.add("recvAccount.*");
        DiscountBillInfo info = DiscountBillFactory.getRemoteInstance().getDiscountBillInfo((IObjectPK)new ObjectUuidPK(pk), selector);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSynStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet<String> idSet = new HashSet<String>();
        ArrayList<String> releaseList = new ArrayList<String>();
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus == 1 && isContain) {
            IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getRemoteInstance();
            ArrayList<String> lockIds = new ArrayList<String>();
            for (int i = 0; i < idList.size(); ++i) {
                lockIds.add(idList.get(i).toString() + "QZTB");
            }
            try {
                Map resultRequest = iMutexServiceControl.batchRequestObjIDForUpdate(lockIds);
                for (int i = 0; i < lockIds.size(); ++i) {
                    Boolean boolResult = (Boolean)resultRequest.get(lockIds.get(i));
                    if (!boolResult.booleanValue()) continue;
                    idSet.add(idList.get(i).toString());
                    releaseList.add(lockIds.get(i).toString());
                }
                if (!EmptyUtil.isEmpty(idSet)) {
                    BatchExecuteResult result = (BatchExecuteResult)DiscountBillFactory.getRemoteInstance().synStatus(idSet);
                    NTPHelper.showActionResult((Component)((Object)this), result);
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"595_DiscountBillListUI"));
                }
            }
            finally {
                if (!EmptyUtil.isEmpty(releaseList)) {
                    iMutexServiceControl.batchReleaseObjIDForUpdate(releaseList);
                }
            }
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)NTPRESOURCE, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSynForceStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet();
        ArrayList releaseList = new ArrayList();
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus == 1 && isContain) {
            IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getRemoteInstance();
            boolean is = false;
            try {
                is = iMutexServiceControl.requestBizObjIDForUpdate("discount");
                if (!is) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"596_DiscountBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                BatchExecuteResult result = (BatchExecuteResult)DiscountBillFactory.getRemoteInstance().synForceStatus(FMHelper.list2Set((List)idList));
                NTPHelper.showActionResult((Component)((Object)this), result);
            }
            finally {
                if (is) {
                    iMutexServiceControl.releaseObjIDForUpdate("discount");
                }
            }
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)NTPRESOURCE, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionEditStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        IDiscountBill iDisCountBill = DiscountBillFactory.getRemoteInstance();
        DiscountBillCollection coll = this.getDisBillColl(idList);
        if (!this.existBEException(coll)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"597_DiscountBillListUI"));
            SysUtil.abort();
        }
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus != 1 || !isContain) {
            MsgBox.showInfo((String)EASResource.getString((String)NTPRESOURCE, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", this.getBEExceptionColl(coll));
        String uiName = DraftUpdateStatusListUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        List<Map<String, Object>> statusList = ((DraftUpdateStatusListUI)uiWindow.getUIObject()).getStatusList();
        if (statusList == null) {
            return;
        }
        BatchExecuteResult result = (BatchExecuteResult)iDisCountBill.updateEntryStatus(idList, statusList);
        NTPHelper.showActionResult((Component)((Object)this), result);
        this.refreshList();
    }

    private boolean existBEException(DiscountBillCollection coll) {
        DiscountBillInfo info;
        boolean exist = false;
        for (int i = 0; i < coll.size() && !(exist = this.existBEException(info = coll.get(i))); ++i) {
        }
        return exist;
    }

    @Override
    public void actionSubmitAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSubmitAntiAudit();
        String id = this.getSelectedKeyValue();
        DiscountBillFactory.getRemoteInstance().submitAntiAudit((IObjectPK)new ObjectUuidPK(id));
    }

    private void checkSubmitAntiAudit() throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        DiscountBillInfo sourceBill = ((IDiscountBill)this.getBizInterface()).getDiscountBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), this.getSelectors());
        if (!DiscountBillStateEnum.AUDITSTATE.equals((Object)sourceBill.getBillState())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"558_submitAnti_Error"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionNoteCancle_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList entryIdList = this.getSelectedEntryIdValues();
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus == 1 && isContain) {
            BatchExecuteResult result = (BatchExecuteResult)DiscountBillFactory.getRemoteInstance().noteCancelEntrys(idList, FMHelper.list2Set((List)entryIdList));
            NTPHelper.showActionResult((Component)((Object)this), result);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)NTPRESOURCE, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        this.refreshList();
    }

    @Override
    public void actionSum_actionPerformed(ActionEvent e) throws Exception {
        super.actionSum_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        String msg = FMClientHelper.sumList((KDTable)this.tblMain, (String)"discountBill", (String)"actRecvAmount");
        MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
    }

    public static String setTran2String(Set idSet) {
        if (idSet == null || idSet.size() < 1) {
            return "";
        }
        String ids = null;
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            if (ids == null) {
                ids = "" + (String)iter.next() + "";
                continue;
            }
            ids = ids + ", " + (String)iter.next() + "";
        }
        ids = ids + "";
        return ids;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "DiscountDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionAuditTie", "actionAntiAuditTie"};
    }

    public void executeQuery(FilterParam param) throws BOSException {
        FilterInfo filter = param.getFilter();
        for (FilterItemInfo filterItem : filter.getFilterItems()) {
            Object obj;
            if (filterItem == null || filterItem.getPropertyName() == null || !"entrys.seq".equals(filterItem.getPropertyName()) || !((obj = filterItem.getCompareValue()) instanceof Integer)) continue;
            Integer cpInte = (Integer)obj;
            if (cpInte == 1) {
                this.setIsShowEntry(false);
                continue;
            }
            if (cpInte != 0) continue;
            this.setIsShowEntry(true);
        }
        super.executeQuery(param);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.refreshEntry();
    }

    private void refreshEntry() {
        String[] hideEntryRows = new String[]{"draftNumber", "ntType", "entryBillAmt", "entryDiscountInt", "entryActDiscountInt", "takeDate", "issureDate", "expiredDate", "description", "elecBillStatus", "bankReturnStatus", "bankReturnMsg", "isNoteCancel", "isCommitCancel", "noteStatus", "cirStatus"};
        this.setTableRowHide(this.tblMain, hideEntryRows, !this.isIsShowEntry());
    }

    public void setTableRowHide(KDTable kdtEntries, String[] rowNames, boolean isHide) {
        int n = rowNames.length;
        for (int i = 0; i < n; ++i) {
            if (rowNames[i] == null || kdtEntries.getColumn(rowNames[i]) == null) continue;
            kdtEntries.getColumn(rowNames[i]).getStyleAttributes().setHided(isHide);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        uiCtx.put((Object)"ID", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DiscountBillBatchEditUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        editUI.show();
    }

    private boolean existProcessing(DiscountBillInfo info) {
        boolean exist = false;
        DiscountBillEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            DiscountBillEntryInfo entry = entrys.get(i);
            if (entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION && entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_PROCESSING && entry.getBankReturnStatus() != BankReturnStatusEnum.EB_PROCESSING) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean existBEException(DiscountBillInfo info) {
        boolean exist = false;
        DiscountBillEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            DiscountBillEntryInfo entry = entrys.get(i);
            if (entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean notAllBESuccessAndFail(DiscountBillInfo sourceBill) {
        boolean notExist = false;
        DiscountBillEntryCollection entrys = sourceBill.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            DiscountBillEntryInfo entry = entrys.get(i);
            if (entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL || entry.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) continue;
            notExist = true;
            break;
        }
        return notExist;
    }

    private boolean existBEFail(DiscountBillInfo info) {
        boolean exist = false;
        DiscountBillEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            DiscountBillEntryInfo entry = entrys.get(i);
            if (entry.getBankReturnStatus() != BankReturnStatusEnum.COMMIT_FAIL && entry.getBankReturnStatus() != BankReturnStatusEnum.BANK_FAIL) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean isNoteCancel(DiscountBillInfo info) {
        boolean isNoteCancel = true;
        DiscountBillEntryCollection entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            DiscountBillEntryInfo entry = entrys.get(i);
            if (entry.isIsNoteCancel()) continue;
            isNoteCancel = false;
            break;
        }
        return isNoteCancel;
    }

    protected ArrayList getSelectedEntryIdValues() {
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            this.tblMain.setRowCount(this.getRowCountFromDB());
            this.tblMain.reLayoutAndPaint();
        }
        ArrayList selectList = new ArrayList();
        List selectKeyIdFields = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        return ListUiHelper.getSelectedIdValues((KDTable)this.tblMain, (String)this.getEntriesPKName(), selectList, selectKeyIdFields);
    }

    public String getEntriesPKName() {
        return "entrys.id";
    }

    private List<Map<String, Object>> getBEExceptionColl(DiscountBillCollection coll) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < coll.size(); ++i) {
            DiscountBillInfo discountBillInfo = coll.get(i);
            DiscountBillEntryCollection entrys = discountBillInfo.getEntrys();
            for (int j = 0; j < entrys.size(); ++j) {
                DiscountBillEntryInfo discountBillEntryInfo = entrys.get(j);
                if (discountBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", discountBillEntryInfo.getId().toString());
                map.put("draftNumber", discountBillEntryInfo.getReceivableBill().getDraftNumber());
                list.add(map);
            }
        }
        return list;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            DiscountBillListUI.this.setListUITable(DiscountBillListUI.this.tblMain, e);
        }
    }
}

