/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.AbstractDistributeUI;
import com.kingdee.eas.fm.nt.client.ChequeTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.util.ChequeCollEqulsVerifier;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.fm.nt.client.util.MyVOComparator;
import com.kingdee.eas.fm.nt.client.util.ResultInfomation;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DistributeUI
extends AbstractDistributeUI {
    private String[] updateIds = null;
    private ChequeCollection editDatas = null;
    private CompanyOrgUnitInfo currentCompany;
    private boolean ntModefied = false;
    private NTTypeInfo ntType = null;
    private boolean isCompanyFilter;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        Object[] cheques = AccessHelper.getF7Data((KDBizPromptBox)this.prmtNTNum);
        if (this.editDatas == null) {
            this.editDatas = new ChequeCollection();
        } else if (this.editDatas.size() > 0) {
            this.editDatas.clear();
        }
        if (cheques == null || cheques.length == 0) {
            return;
        }
        this.updateIds = new String[cheques.length];
        for (int i = 0; i < cheques.length; ++i) {
            ChequeInfo info = (ChequeInfo)cheques[i];
            this.editDatas.add(info);
            this.updateIds[i] = info.getId().toString();
        }
    }

    public void onLoad() throws Exception {
        this.initParam();
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        Map listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        ChequeUtil.initComboNttype(this.comboNTType, true);
        ChequeUtil.initPerson((IUIObject)this, this.f7Keeper);
        ChequeUtil.initAdminOrgUnit((IUIObject)this, this.f7KeepDepartment);
        ChequeUtil.initChequeF7((IUIObject)this, this.prmtNTNum);
        ChequeUtil.initCompanyOrgF7((IUIObject)this, this.prmtKeepCompany);
        super.onLoad();
        if (this.isCompanyFilter) {
            ChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtBankAcct, this.currentCompany, this.editData.getBank(), null);
        } else {
            ChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtBankAcct, null, this.editData.getBank(), null);
        }
        this.initUIData();
        this.ntModefied = true;
        this.initOldData((IObjectValue)this.editData);
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
    }

    private void initParam() {
        Map map = this.getUIContext();
        this.currentCompany = map.containsKey("currentCompany") ? (CompanyOrgUnitInfo)map.get("currentCompany") : ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.isCompanyFilter = map.containsKey("NT028") ? ((Boolean)map.get("NT028")).booleanValue() : ContextHelperFactory.getRemoteInstance().getBooleanParam("NT028", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
    }

    protected IObjectValue createNewData() {
        ChequeInfo objectValue = new ChequeInfo();
        this.updateIds = (String[])this.getUIContext().get("CHEQUEIDS");
        if (this.updateIds == null) {
            objectValue.setNtType((NTTypeInfo)this.comboNTType.getSelectedItem());
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])this.updateIds), CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(this.getSelectors());
            try {
                this.editDatas = ChequeFactory.getRemoteInstance().getChequeCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            if (this.editDatas != null && this.editDatas.size() > 0) {
                objectValue = this.editDatas.get(0);
                this.ntType = objectValue.getNtType();
            }
        }
        if (this.editDatas == null || this.editDatas.get(0) == null || this.editDatas.get(0).getKeepCompany() == null) {
            objectValue.setKeepCompany(this.currentCompany);
        }
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAbout.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCalculator.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionExitCurrent.setVisible(false);
        this.actionExport.setVisible(false);
        this.actionExportSelected.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionHelp.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionSubmit.setVisible(false);
        this.actionTDPrint.setVisible(true);
        this.actionDistribute.setEnabled(true);
        this.actionDistribute.setVisible(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDistribute.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_distribute"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("bankAcct.*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("keepCompany.*"));
        sic.add(new SelectorItemInfo("keepDepartment.*"));
        sic.add(new SelectorItemInfo("keeper.*"));
        return sic;
    }

    public boolean isModify() {
        return super.isModify() || this.ntModefied;
    }

    private void initUIData() {
        FMClientHelper.setSelectObject((KDComboBox)this.comboNTType, (Object)this.editData.getNtType());
        if (this.editDatas != null) {
            this.prmtNTNum.setData((Object)this.editDatas.toArray());
        }
        if (this.editData.getBankAcct() != null) {
            this.prmtBankAcct.setValue((Object)this.editData.getBankAcct());
            this.prmtBankAcct.setEnabled(false);
        } else {
            this.prmtBankAcct.setValue(null);
            this.prmtBankAcct.setEnabled(true);
        }
        this.prmtKeepCompany.setValue((Object)this.editData.getKeepCompany());
        this.f7KeepDepartment.setValue((Object)this.editData.getKeepDepartment());
        this.f7Keeper.setValue((Object)this.editData.getKeeper());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object[] v;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        Object o = this.prmtNTNum.getValue();
        if (o instanceof Object[] && (v = (Object[])o)[0] == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"247_DistributeUI"));
            SysUtil.abort();
        }
        if (!this.editData.getNtType().getId().equals((Object)this.ntType.getId())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"NTTypeNotEqual"));
            SysUtil.abort();
        }
        CompanyOrgUnitInfo keepCompany = this.editData.getKeepCompany();
        AdminOrgUnitInfo keepDepartment = this.editData.getKeepDepartment();
        PersonInfo keeper = this.editData.getKeeper();
        if (keepCompany == null && keepDepartment == null && keeper == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"199_ChequeBookInUI"));
            SysUtil.abort();
        } else if (keepCompany == null && keepDepartment != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"200_ChequeBookInUI"));
            SysUtil.abort();
        } else if ((keepCompany == null || keepDepartment == null) && keeper != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"201_ChequeBookInUI"));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.actionDistribute_actionPerformed(e);
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        super.actionDistribute_actionPerformed(e);
        this.storeFields();
        this.verifyInput(e);
        if (!this.isModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"RepeatSummit"));
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtKeepCompany.getValue();
        OrgUnitInfo department = (OrgUnitInfo)this.f7KeepDepartment.getValue();
        PersonInfo keeper = (PersonInfo)this.f7Keeper.getValue();
        MutexUtils.requestMutex((CoreUI)this, (String[])this.updateIds);
        String bankAcctId = null;
        if (this.editData.getBankAcct() != null) {
            bankAcctId = this.editData.getBankAcct().getId().toString();
        }
        String companyId = null;
        String deparmentId = null;
        String keeperId = null;
        if (company != null) {
            companyId = company.getId().toString();
        }
        if (department != null) {
            deparmentId = department.getId().toString();
        }
        if (keeper != null) {
            keeperId = keeper.getId().toString();
        }
        ChequeFactory.getRemoteInstance().distribute(this.updateIds, deparmentId, keeperId, companyId, bankAcctId, this.chkBatch.isSelected());
        MutexUtils.releaseMutex((String[])this.updateIds);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"distribute_Success"));
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.ntModefied = false;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (!this.isSave()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < this.updateIds.length; ++i) {
            idList.add(this.updateIds[i]);
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    protected void comboNTType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboNTType_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            NTTypeInfo nt = (NTTypeInfo)this.comboNTType.getSelectedItem();
            if (this.editData != null && this.editData.getNtType() != null) {
                this.editData.setNtType(nt);
            }
            this.prmtNTNum.setValue(null);
        }
    }

    @Override
    protected void f7KeepDepartment_dataChanged(DataChangeEvent e) throws Exception {
        super.f7KeepDepartment_dataChanged(e);
        if (!this.isFirstOnload()) {
            this.f7Keeper.setValue(null);
        }
    }

    @Override
    protected void prmtKeepCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtKeepCompany_dataChanged(e);
        if (!this.isFirstOnload()) {
            this.f7KeepDepartment.setValue(null);
        }
    }

    @Override
    protected void prmtNTNum_dataChanged(DataChangeEvent e) throws Exception {
        ChequeInfo cheque;
        super.prmtNTNum_dataChanged(e);
        Object[] cheques = AccessHelper.getF7Data((KDBizPromptBox)this.prmtNTNum);
        if (cheques == null || cheques.length == 0) {
            this.prmtBankAcct.setEnabled(true);
            return;
        }
        ChequeCollection cqCollection = new ChequeCollection();
        for (int i = 0; i < cheques.length; ++i) {
            cqCollection.add((ChequeInfo)cheques[i]);
        }
        String[] properties = new String[]{"bank", "bankAcct", "ntType"};
        MyVOComparator comparator = new MyVOComparator(properties);
        ChequeCollEqulsVerifier verifier = new ChequeCollEqulsVerifier(comparator);
        ResultInfomation result = new ResultInfomation();
        try {
            result = verifier.verifyEquals(cqCollection);
        }
        catch (Exception e1) {
            this.prmtNTNum.setValue(e.getOldValue());
            this.handUIException(e1);
        }
        if (!result.isEqual()) {
            MsgBox.showInfo((String)result.getResult());
            this.prmtNTNum.setValue(e.getOldValue());
            SysUtil.abort();
        }
        if ((cheque = cqCollection.get(0)).getBankAcct() == null) {
            this.prmtBankAcct.setValue(null);
            this.prmtBankAcct.setEnabled(true);
        } else {
            AccountBankInfo acct = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(cheque.getBankAcct().getId()));
            this.prmtBankAcct.setValue((Object)acct);
            this.prmtBankAcct.setEnabled(false);
        }
        this.ntModefied = true;
        this.ntType = cheque.getNtType();
        FilterItemInfo filterItem = new FilterItemInfo("bank.id", (Object)cheque.getBank().getId());
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtBankAcct, (FilterItemInfo)filterItem);
    }

    @Override
    protected void prmtNTNum_willShow(SelectorEvent e) throws Exception {
        this.prmtNTNum.getQueryAgent().resetRuntimeEntityView();
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtNTNum, (FilterItemInfo)new FilterItemInfo("NtType.id", (Object)this.editData.getNtType().getId().toString(), CompareType.EQUALS));
        super.prmtNTNum_willShow(e);
    }

    @Override
    protected void prmtNTNum_willCommit(CommitEvent e) throws Exception {
        this.prmtNTNum.getQueryAgent().resetRuntimeEntityView();
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtNTNum, (FilterItemInfo)new FilterItemInfo("NtType.id", (Object)this.editData.getNtType().getId().toString(), CompareType.EQUALS));
        super.prmtNTNum_willCommit(e);
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAcct_dataChanged(e);
        AccountBankInfo info = (AccountBankInfo)e.getNewValue();
        if (info != null) {
            this.editData.setBankAcct(info);
        }
    }

    @Override
    protected void prmtKeepCompany_preChange(PreChangeEvent e) throws Exception {
        super.prmtKeepCompany_preChange(e);
        Object value = e.getData();
        if (value instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)value;
            if (info.isIsBizUnit()) {
                e.setResult(1);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"OrgTypeError"));
                e.setResult(-1);
            }
        } else {
            e.setResult(-1);
        }
    }

    @Override
    protected void f7Keeper_willShow(SelectorEvent e) throws Exception {
        this.f7Keeper.setRefresh(false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        map.put("0", "2");
        PersonPromptBox select = new PersonPromptBox((IUIObject)this, map);
        select.setHasCUDefaultFilter(false);
        select.setIsDefaultFilterFieldsEnabled(false);
        Object department = this.f7KeepDepartment.getValue();
        Object company = this.prmtKeepCompany.getValue();
        if (department instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)department;
            select.setExpandAdmin(adminOrgUnitInfo.getId().toString());
            select.setCU(adminOrgUnitInfo.getCU().getId().toString());
        } else if (company instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo companyInfo;
            CompanyOrgUnitInfo parent = companyInfo = (CompanyOrgUnitInfo)company;
            while (companyInfo != null && !companyInfo.isIsAdminOrgUnit()) {
                companyInfo = parent = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getParent().getId()));
            }
            select.setExpandAdmin(companyInfo.getId().toString());
            select.setCU(companyInfo.getCU().getId().toString());
        }
        this.f7Keeper.setSelector((KDPromptSelector)select);
        this.f7Keeper.getQueryAgent().resetRuntimeEntityView();
        super.f7Keeper_willShow(e);
    }
}

