/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.EndorseListingCollection;
import com.kingdee.eas.fm.nt.EndorseListingFactory;
import com.kingdee.eas.fm.nt.EndorseListingInfo;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.IEndorseListing;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractEndorseListingUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EndorseListingUI
extends AbstractEndorseListingUI {
    private static final Logger logger = CoreUIObject.getLogger(EndorseListingUI.class);
    protected ReceivableBillInfo parentObj;
    private CompanyOrgUnitInfo companyInfo;
    private EndorseListingCollection endorseListColl = new EndorseListingCollection();
    private CompanyOrgUnitInfo currCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.companyInfo == null) {
            this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        this.parentObj = (ReceivableBillInfo)this.getUIContext().get("InitDataObject");
        this.init();
        this.fillTable();
    }

    private void init() {
        boolean flag = OprtState.EDIT.equals(this.getOprtState());
        if (this.parentObj != null && this.parentObj.getSourceBillId() != null) {
            BOSObjectType bosType = BOSUuid.read((String)this.parentObj.getSourceBillId().toString()).getType();
            if (bosType.equals((Object)new EndorsementBillInfo().getBOSType())) {
                flag = false;
            } else if (this.parentObj != null && BillSourceEnum.BYHAND == this.parentObj.getSource()) {
                flag = true;
            }
        }
        if (this.parentObj != null && this.parentObj.getTransferId() != null && !"".equals(this.parentObj.getTransferId())) {
            flag = false;
        } else if (this.parentObj != null && BillSourceEnum.BYHAND == this.parentObj.getSource()) {
            flag = true;
        }
        this.btnSave.setEnabled(flag);
        this.btnAddLine.setEnabled(flag);
        this.btnRemoveLine.setEnabled(flag);
        this.kdEndorse.setEnabled(flag);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void fillTable() throws BOSException {
        EndorseListingCollection coll = this.parentObj.getEndorseListColl();
        if (coll == null || coll.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            SorterItemCollection sorter = new SorterItemCollection();
            filterInfo.getFilterItems().add(new FilterItemInfo("head.id", (Object)this.parentObj.getId()));
            view.setFilter(filterInfo);
            SorterItemInfo sorterItemDate = new SorterItemInfo("endorseDate");
            SorterItemInfo sorterItemSeq = new SorterItemInfo("seq");
            sorterItemDate.setSortType(SortType.ASCEND);
            sorterItemSeq.setSortType(SortType.ASCEND);
            sorter.add(sorterItemDate);
            sorter.add(sorterItemSeq);
            view.setSorter(sorter);
            coll = EndorseListingFactory.getRemoteInstance().getEndorseListingCollection(view);
        }
        if (coll == null || coll.isEmpty()) {
            coll = new EndorseListingCollection();
        }
        this.endorseListColl = coll;
        this.kdEndorse.checkParsed();
        this.kdEndorse.setActiveCellStatus(1);
        EditorFactory.DatePickerEditor dateEditor = new EditorFactory.DatePickerEditor();
        this.kdEndorse.getColumn("endorseDate").setEditor((ICellEditor)dateEditor);
        KDCheckBox kdCheckBox = new KDCheckBox();
        kdCheckBox.setSelected(false);
        KDTDefaultCellEditor checkBox = new KDTDefaultCellEditor((JCheckBox)kdCheckBox);
        this.kdEndorse.getColumn("transferFlag").setEditor((ICellEditor)checkBox);
        KDBizPromptBox prompt = new KDBizPromptBox();
        NTHelper.initCSF7((IUIObject)this, prompt, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryForAssign");
        prompt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (EndorseListingUI.this.kdEndorse.getSelectManager().getActiveRowIndex() + 1 < EndorseListingUI.this.kdEndorse.getRowCount() && eventObj.getNewValue() != null) {
                    EndorseListingUI.this.kdEndorse.getRow(EndorseListingUI.this.kdEndorse.getSelectManager().getActiveRowIndex() + 1).getCell("endorser").setValue((Object)eventObj.getNewValue().toString());
                }
            }
        });
        ExtendParser parser = new ExtendParser(prompt);
        prompt.setCommitParser((IParser)parser);
        this.initPrompt4Custom(prompt);
        this.kdEndorse.getColumn("endorser").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prompt));
        this.kdEndorse.getColumn("endorsee").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prompt));
        this.kdEndorse.getColumn("endorser").getStyleAttributes().setLocked(true);
        this.prmtNoteNumber.setText(this.parentObj.getDraftNumber());
        this.prmtNoteNumber.setEditable(false);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            EndorseListingInfo element = (EndorseListingInfo)iter.next();
            IRow row = this.kdEndorse.addRow();
            if (element.getId() != null) {
                row.getCell("id").setValue((Object)element.getId().toString());
            }
            row.getCell("businessCode").setValue((Object)element.getBusinessCode());
            row.getCell("endorseDate").setValue((Object)element.getEndorseDate());
            row.getCell("endorser").setValue((Object)element.getEndorser());
            row.getCell("endorsee").setValue((Object)element.getEndorsee());
            row.getCell("transferFlag").setValue((Object)element.isTransferFlag());
            row.getCell("remark").setValue((Object)element.getRemark());
        }
        if (this.kdEndorse.getRowCount() != 0 || coll.size() != 0 || !this.parentObj.isIsNoUsed()) {
            // empty if block
        }
        if (this.kdEndorse.getRowCount() > 0) {
            this.kdEndorse.getRow(this.kdEndorse.getRowCount() - 1).getCell("endorsee").getStyleAttributes().setLocked(true);
        }
    }

    private void initPrompt4Custom(KDBizPromptBox promptBox) {
        promptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerQueryForDefaultAssign");
        promptBox.setVisible(true);
        promptBox.setEditable(true);
        promptBox.setDisplayFormat("$name$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setRequired(true);
    }

    private void adjustEndorser() {
        this.kdEndorse.getRow(0).getCell("endorser").setValue((Object)this.parentObj.getPayeeName());
        for (int i = 1; i < this.kdEndorse.getRowCount(); ++i) {
            IRow currRow = this.kdEndorse.getRow(i);
            IRow lastRow = this.kdEndorse.getRow(i - 1);
            this.kdEndorse.getRow(this.kdEndorse.getRowCount() - 2).getCell("endorsee").setValue((Object)this.parentObj.getDeliverName());
            currRow.getCell("endorser").setValue(lastRow.getCell("endorsee").getValue());
        }
        if (this.kdEndorse.getRowCount() == 1) {
            IRow row = this.kdEndorse.getRow(0);
            row.getCell("endorser").setValue((Object)this.parentObj.getPayeeName());
            row.getCell("endorsee").setValue((Object)this.parentObj.getDeliverName());
        }
        if (this.kdEndorse.getRowCount() > 1) {
            this.kdEndorse.getRow(this.kdEndorse.getRowCount() - 1).getCell("endorsee").setValue((Object)this.currCompany);
            this.kdEndorse.getRow(this.kdEndorse.getRowCount() - 1).getCell("endorsee").getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveData();
        this.getUIWindow().close();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdEndorse.getRowCount() == 0) {
            IRow iRow = this.kdEndorse.addRow(0);
        } else if (this.kdEndorse.getRowCount() == 1) {
            IRow iRow = this.kdEndorse.addRow(this.kdEndorse.getRowCount());
        } else {
            IRow iRow = this.kdEndorse.addRow(this.kdEndorse.getRowCount() - 1);
        }
        this.adjustEndorser();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdEndorse);
        if (this.kdEndorse.getRowCount() > 0) {
            this.adjustEndorser();
        }
    }

    @Override
    protected void kdEndorse_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.kdEndorse_tableSelectChanged(e);
        if (this.kdEndorse.getSelectManager().getActiveRowIndex() == 0 && this.kdEndorse.getRowCount() > 1) {
            this.actionRemoveLine.setEnabled(false);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.actionRemoveLine.setEnabled(true);
        }
    }

    private void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getBeginRow();
        int bottom = table.getSelectManager().get().getEndRow();
        for (int i = top; i <= bottom; ++i) {
            if (table.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            table.removeRow(top);
        }
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    private void saveData() throws Exception {
        IEndorseListing iEndorseListing = EndorseListingFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("head.id", (Object)this.parentObj.getId()));
        iEndorseListing.delete(filterInfo);
        CoreBaseCollection endorseListColl = new CoreBaseCollection();
        int count = this.kdEndorse.getRowCount();
        for (int i = 0; i < count; ++i) {
            ICell cell = null;
            EndorseListingInfo objEndorse = new EndorseListingInfo();
            objEndorse.setHead(this.parentObj);
            cell = this.kdEndorse.getCell(i, "endorseDate");
            objEndorse.setEndorseDate((Date)cell.getValue());
            cell = this.kdEndorse.getCell(i, "endorser");
            if (cell.getValue() != null) {
                objEndorse.setEndorser(cell.getValue().toString());
            }
            if ((cell = this.kdEndorse.getCell(i, "endorsee")).getValue() != null) {
                objEndorse.setEndorsee(cell.getValue().toString());
            }
            if ((cell = this.kdEndorse.getCell(i, "businessCode")).getValue() != null) {
                objEndorse.setBusinessCode(cell.getValue().toString());
            }
            if ((cell = this.kdEndorse.getCell(i, "transferFlag")).getValue() != null) {
                objEndorse.setTransferFlag((Boolean)cell.getValue());
            }
            if ((cell = this.kdEndorse.getCell(i, "remark")).getValue() != null) {
                objEndorse.setRemark(cell.getValue().toString());
            }
            objEndorse.setSeq(i + 1);
            endorseListColl.add((CoreBaseInfo)objEndorse);
        }
        iEndorseListing.submitBatchData(endorseListColl);
    }

    public EndorseListingCollection getResult() {
        return this.endorseListColl;
    }

    private void verify() throws NTException {
        for (int i = 0; i < this.kdEndorse.getRowCount(); ++i) {
            Date tmpDate;
            Date endorseDate = this.getEndorseDate(i);
            if (this.parentObj.getIssuesDate() != null && endorseDate.before(this.parentObj.getIssuesDate()) || this.parentObj.getTakeDate() != null && endorseDate.after(this.parentObj.getTakeDate())) {
                throw new NTException(NTException.NOT_BETWEEN_ISSUANDEXPDATE2);
            }
            if (i >= this.kdEndorse.getRowCount() - 1 || !(tmpDate = this.getEndorseDate(i + 1)).before(endorseDate)) continue;
            throw new NTException(NTException.NO_BEF_LASTENDORSEDATE);
        }
        if (this.kdEndorse.getRowCount() > 0) {
            IRow row = this.kdEndorse.getRow(0);
            Object endorser = row.getCell("endorser").getValue();
            Object endorsee = row.getCell("endorsee").getValue();
            if (endorser == null || !this.parentObj.getPayeeName().equals(endorser.toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"248_EndorseListingUI"));
                SysUtil.abort();
            }
            row = this.kdEndorse.getRow(this.kdEndorse.getRowCount() - 1);
            endorser = row.getCell("endorser").getValue();
            endorsee = row.getCell("endorsee").getValue();
            if (endorser == null || !this.parentObj.getDeliverName().equals(endorser.toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"249_EndorseListingUI"));
                SysUtil.abort();
            }
            if (endorsee == null || !this.companyInfo.getName().equals(endorsee.toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"250_EndorseListingUI"));
                SysUtil.abort();
            }
        }
    }

    private Date getEndorseDate(int iRow) throws NTException {
        ICell cell = this.kdEndorse.getCell(iRow, "endorseDate");
        if (cell.getValue() == null) {
            throw new NTException(NTException.NOTNULL_ENDORSEDATE);
        }
        return (Date)cell.getValue();
    }

    @Override
    public void actionTdPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.endorseListColl.size() == 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.parentObj.getId().toString());
        if (idList == null || idList.size() == 0 || this.getTDFileName() == null) {
            return;
        }
        DefaultNoteDataProvider defaultNoteDataProvider = new DefaultNoteDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)defaultNoteDataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTdPrintView_actionPerformed(ActionEvent e) throws Exception {
        if (this.endorseListColl.size() == 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.parentObj.getId().toString());
        if (idList == null || idList.size() == 0 || this.getTDFileName() == null) {
            return;
        }
        DefaultNoteDataProvider defaultNoteDataProvider = new DefaultNoteDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)defaultNoteDataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String getTDFileName() {
        return "/FM/NT/AC";
    }
}

