/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.NTRptRcvBillFilterParam;
import com.kingdee.eas.fm.nt.client.AbstractNTRptRcvBillFilterUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class NTRptRcvBillFilterUI
extends AbstractNTRptRcvBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(NTRptRcvBillFilterUI.class);

    public NTRptRcvBillFilterUI() throws Exception {
        this.initCompanyState();
        this.initCurrency();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    private void initCurrency() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void init() throws Exception {
        super.init();
        this.pkbeginTakeDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkendTakeDate.setValue((Object)DateUtil.getEndDayOfCurMonth());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.bassCurrency);
        this.KDNTType.setSelected(true);
        this.initBillMediumComb();
    }

    private void initBillMediumComb() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        List list = BillMediumEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            model.addElement(list.get(i));
        }
        model.addElement(FMSysDefinedEnum.SELECT_ALL);
        this.billMedium.setModel(model);
        this.billMedium.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    protected void initCompanyState() {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) && !FSClientHelper.isClearingHouseCompanyId((String)this.currentCompany.getId().toString())) {
            this.chkIA.setEnabled(false);
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        } else {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    protected Class getParamClass() {
        return NTRptRcvBillFilterParam.class;
    }

    public Object getParam() {
        NTRptRcvBillFilterParam param = new NTRptRcvBillFilterParam();
        Object selectedBillmedium = this.billMedium.getSelectedItem();
        param.setBeginDate((Date)this.pkbeginTakeDate.getValue());
        param.setEndDate((Date)this.pkendTakeDate.getValue());
        if (!(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        } else {
            param.setCurrencyId(null);
        }
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) && !FSClientHelper.isClearingHouseCompanyId((String)this.currentCompany.getId().toString())) {
            String[] id = new String[]{this.currentCompany.getId().toString()};
            param.setCompanyIds(id);
        } else {
            param.setCompanyIds(this.getCompanyIds());
        }
        param.setShowCom(this.checkShowCom.isSelected());
        param.setDimType(this.kDButtonGroupCDDetail.getValue() + 1);
        if (FMSysDefinedEnum.SELECT_ALL.equals(selectedBillmedium)) {
            param.setBillMediumEnum(null);
        } else {
            param.setBillMediumEnum((BillMediumEnum)((Object)selectedBillmedium));
        }
        return param;
    }

    public void setParam(Object param) {
        NTRptRcvBillFilterParam para = (NTRptRcvBillFilterParam)param;
        if (para == null) {
            return;
        }
        this.pkbeginTakeDate.setValue((Object)para.getBeginDate());
        this.pkendTakeDate.setValue((Object)para.getEndDate());
        String[] companyIds = para.getCompanyIds();
        this.setCompanyIds(companyIds);
        if (para.getCurrencyId() != null) {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)para.getCurrencyId()));
            currency.setName(para.getCurrencyName());
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (para.getBillMediumEnum() != null) {
            UIUtil.setSelectObject((KDComboBox)this.billMedium, (Object)((Object)para.getBillMediumEnum()));
        } else {
            UIUtil.setSelectObject((KDComboBox)this.billMedium, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        this.checkShowCom.setSelected(para.isShowCom());
    }

    public boolean verify() {
        NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)this.pkbeginTakeDate.getValue(), (Date)this.pkendTakeDate.getValue());
        return super.verify();
    }

    @Override
    protected void KDNTType_actionPerformed(ActionEvent e) throws Exception {
        this.checkShowCom.setEnabled(true);
        this.checkShowCom.setSelected(false);
    }

    @Override
    protected void KDDeliver_actionPerformed(ActionEvent e) throws Exception {
        this.checkShowCom.setEnabled(false);
        this.checkShowCom.setSelected(true);
    }
}

