/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMKDTableHelper;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTWarnLedgeFacadeFactory;
import com.kingdee.eas.fm.nt.NTWarnLedgerFilterParam;
import com.kingdee.eas.fm.nt.WarnCondTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;

public class NTWarnLedgerUIHandler
extends FMDetailRptBaseHandler {
    private final NTWarnLedgerFilterParam param;
    private final String[] noteKinds = new String[]{EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"285_NTWarnLedgerUIHandler"), EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"286_NTWarnLedgerUIHandler")};

    public NTWarnLedgerUIHandler(FilterParam filterParam, KDTable kdt) {
        super(filterParam.getFilter(), kdt);
        this.param = (NTWarnLedgerFilterParam)filterParam;
    }

    public IRowSet getRowSet() throws BOSException {
        return NTWarnLedgeFacadeFactory.getRemoteInstance().getRowSet(this.param);
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.removeRows();
        if (rs == null) {
            return;
        }
        this.kdt.setRefresh(false);
        EntryInfo info = new EntryInfo();
        while (rs.next()) {
            info.readData(rs);
            info.writeData(this.kdt);
        }
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
        this.kdt.setRefresh(true);
        this.kdt.reLayoutAndPaint();
    }

    public void endDataFill() {
    }

    public void initHeader() {
    }

    public void setTableStateRow() {
        this.kdt.checkParsed();
        int pre = 2;
        if (this.param.getCurrency() != null) {
            pre = FMClientHelper.getPrecOfCurrency((BOSUuid)this.param.getCurrency().getId());
        }
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdt.getColumn("amount"), (int)pre);
        if (WarnCondTypeEnum.DUE.equals((Object)this.param.getPreWarnType())) {
            this.kdt.getColumn("unMatureDays").getStyleAttributes().setHided(true);
            this.kdt.getColumn("matureDays").getStyleAttributes().setHided(false);
        } else {
            this.kdt.getColumn("unMatureDays").getStyleAttributes().setHided(false);
            this.kdt.getColumn("matureDays").getStyleAttributes().setHided(true);
        }
        this.kdt.getGroupManager().setTotalize(true);
        this.kdt.getColumn("noteKind").setGroup(true);
        this.kdt.getColumn("noteKind").setStat(true);
        this.kdt.getColumn("noteGroup").setGroup(true);
        this.kdt.getColumn("noteGroup").setStat(true);
        IRow sum = this.kdt.getGroupManager().getStatRowTemplate(-1);
        sum.getCell("noteKind").setValue((Object)FMRptClientUtils.getTotalResString());
        sum.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        sum.getCell("amount").setExpressions("SUM");
        sum.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        FMKDTableHelper.initDecimalCell((ICell)sum.getCell("amount"), (int)pre);
        IRow noteKind = this.kdt.getGroupManager().getStatRowTemplate(0);
        noteKind.getCell("noteKind").setValue((Object)FMRptClientUtils.getSumTotalResString());
        noteKind.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        noteKind.getCell("amount").setExpressions("SUM");
        FMKDTableHelper.initDecimalCell((ICell)noteKind.getCell("amount"), (int)pre);
        IRow noteGroup = this.kdt.getGroupManager().getStatRowTemplate(1);
        noteGroup.getCell("noteGroup").setValue((Object)FMRptClientUtils.getSumTotalResString());
        noteGroup.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        noteGroup.getCell("amount").setExpressions("SUM");
        FMKDTableHelper.initDecimalCell((ICell)noteGroup.getCell("amount"), (int)pre);
    }

    protected String getQueryPath() {
        return null;
    }

    public class EntryInfo {
        private String id;
        private String noteKind;
        private String ntType;
        private String number;
        private String currency;
        private BigDecimal amount;
        private java.util.Date expiredDate;
        private long days;

        public String getNoteKind() {
            return this.noteKind;
        }

        public void setNoteKind(String noteKind) {
            this.noteKind = noteKind;
        }

        public String getNtType() {
            return this.ntType;
        }

        public void setNtType(String ntType) {
            this.ntType = ntType;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public long getDays() {
            return this.days;
        }

        public void setDays(long days) {
            this.days = days;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public java.util.Date getExpiredDate() {
            return this.expiredDate;
        }

        public void setExpiredDate(java.util.Date expiredDate) {
            this.expiredDate = expiredDate;
        }

        public void readData(IRowSet rs) throws SQLException {
            this.setId(rs.getString("id"));
            this.setNoteKind(NTWarnLedgerUIHandler.this.noteKinds[rs.getInt("noteKind")]);
            this.setNtType(NTTypeGroupEnum.getEnum(rs.getInt("ntType.superGroup")).getAlias());
            this.setNumber(rs.getString("number"));
            this.setCurrency(rs.getString("currency.name"));
            this.setAmount(rs.getBigDecimal("amount"));
            Date expiredDate = rs.getDate("expiredDate");
            this.setExpiredDate(expiredDate);
            if (expiredDate != null && NTWarnLedgerUIHandler.this.param.getCurrentDate() != null) {
                long mSeconds = Math.abs(DateTimeUtils.dateDiff((java.util.Date)expiredDate, (java.util.Date)NTWarnLedgerUIHandler.this.param.getCurrentDate()));
                BigDecimal s = BigDecimal.valueOf(mSeconds);
                BigDecimal day = s.divide(Constants.ONE_THOUSAND, 2).divide(new BigDecimal("60"), 2).divide(new BigDecimal("60"), 2).divide(new BigDecimal("24"), 2);
                this.setDays(day.intValue());
            }
        }

        public void writeData(KDTable kdt) {
            IRow row = kdt.addRow();
            row.getCell("id").setValue((Object)this.getId());
            row.getCell("noteKind").setValue((Object)this.getNoteKind());
            row.getCell("noteGroup").setValue((Object)this.getNtType());
            row.getCell("number").setValue((Object)this.getNumber());
            row.getCell("currency.name").setValue((Object)this.getCurrency());
            row.getCell("amount").setValue((Object)this.getAmount());
            row.getCell("expiredDate").setValue((Object)this.getExpiredDate());
            row.getCell("unMatureDays").setValue((Object)new Long(this.getDays()));
            row.getCell("matureDays").setValue((Object)new Long(this.getDays()));
        }
    }
}

