/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.AddBatchHelper;
import com.kingdee.eas.fi.cas.ControlTake;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.CreditLimitCollection;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.IPayableBill;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractPayableBillBatchConfirmUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PayableBillBatchConfirmUI
extends AbstractPayableBillBatchConfirmUI {
    private static final Logger logger = CoreUIObject.getLogger(PayableBillBatchConfirmUI.class);
    private static final String ID_SET = "idSet";
    private static final String MAKE_TYPE = "makeType";
    private static final String ID = "id";
    private static final String BIZTYPE = "bizType";
    private static final String NUMBER = "number";
    private static final String BILLNUMBER = "billNumber";
    private static final String PAYEE = "payee";
    private static final String CURRENCY = "currency";
    private static final String AMOUNT = "amount";
    private static final String BEGINDATE = "beginDate";
    private static final String ENDDATE = "endDate";
    private static final String PAYACCOUNT = "payAccount";
    private static final String ISINCREDIT = "IsInCredit";
    private static final String ISRELBANK = "IsRelBank";
    private static final String COSTLIMIT = "costLimit";
    private static final String AGENTPRO = "agentPro";
    private static final Color requireField = new Color(250, 250, 210);
    private PayableBillCollection coll = null;
    protected CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    public static final String NT_RESOURCE = "com.kingdee.eas.fm.nt.NtResource";

    public void onLoad() throws Exception {
        super.onLoad();
        Set idSet = (Set)this.getUIContext().get(ID_SET);
        Object[] ids = idSet.toArray();
        String id = (String)ids[0];
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(ID);
        sic.add(MAKE_TYPE);
        PayableBillInfo info = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectStringPK(id), sic);
        BillMakeTypeEnum makeType = info.getMakeType();
        this.initUIProp(makeType);
        this.fillData(idSet);
    }

    protected void fillData(Set idSet) throws BOSException, EASBizException {
        PayableBillCollection coll = this.getColl(idSet);
        PayableBillInfo info = null;
        String currencyID = null;
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            info = coll.get(i);
            if (info == null) continue;
            currencyID = info.getCurrency().getId().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)AMOUNT, (String)currencyID);
            row.getCell(ID).setValue((Object)info.getId().toString());
            row.getCell(BIZTYPE).setValue((Object)info.getNtType());
            row.getCell(NUMBER).setValue((Object)info.getNumber());
            row.getCell(BILLNUMBER).setValue((Object)info.getDraftNumber());
            if (info.getOutBankAccount() != null) {
                row.getCell(PAYACCOUNT).setValue((Object)info.getOutBankAccount());
            }
            SupplierInfo payee = info.getPayee();
            CustomerInfo payee1 = info.getPayee1();
            if (payee != null) {
                row.getCell(PAYEE).setValue((Object)payee.getName());
            } else if (payee1 != null) {
                row.getCell(PAYEE).setValue((Object)payee1.getName());
            } else {
                row.getCell(PAYEE).setValue((Object)info.getPayeeName());
            }
            row.getCell(CURRENCY).setValue(info.getCurrency() != null ? info.getCurrency().getName() : null);
            row.getCell(AMOUNT).setValue((Object)info.getAmount());
            row.getCell(BEGINDATE).setValue((Object)info.getIssueDate());
            row.getCell(ENDDATE).setValue((Object)info.getExpiredDate());
            boolean isRelBank = info.isIsRelBankInCredit();
            boolean isInCredit = info.isIsInCredit();
            ICellEditor chkIsRelBankedit = ControlTake.getKDCheckBoxEditor();
            ICellEditor chkIsInCreditedit = ControlTake.getKDCheckBoxEditor();
            AddBatchHelper.bindContents((IRow)row, (String)ISRELBANK, (ICellEditor)chkIsRelBankedit);
            AddBatchHelper.bindContents((IRow)row, (String)ISINCREDIT, (ICellEditor)chkIsInCreditedit);
            CreditLimitInfo creditLimit = null;
            if (info.getPayee() != null && info.getMakeType() == BillMakeTypeEnum.ENTRUST && info.getNtType() != null) {
                creditLimit = this.getCreditOfSupplier(info.getPayee(), info.getApplyUnit(), info.getNtType());
            }
            row.getCell(COSTLIMIT).setValue(creditLimit);
            if (creditLimit != null) {
                row.getCell(ISINCREDIT).setValue((Object)Boolean.TRUE);
                row.getCell(ISRELBANK).setValue((Object)Boolean.FALSE);
                continue;
            }
            row.getCell(ISINCREDIT).setValue((Object)Boolean.FALSE);
            row.getCell(ISRELBANK).setValue((Object)Boolean.FALSE);
        }
    }

    private CreditLimitInfo getCreditOfSupplier(SupplierInfo payee, CompanyOrgUnitInfo company, NTTypeInfo ntType) throws BOSException, EASBizException {
        String companyid = company.getId().toString();
        Set companySet = CreditLimitFactory.getRemoteInstance().getPerCompanyIdSet(companyid);
        String proFinid = AccessHelper.getId((Object)ntType.getFinanceType());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \t\t\tcre.FID\t\t\tFROM T_FIN_CreditLimit AS cre ");
        sql.append("INNER JOIN T_FIN_CreditLimitEntry AS entrys\t\t\tON cre.FID = entrys.FParentID ");
        sql.append("INNER JOIN T_FIN_CreditUsage AS usage\t\t\tON cre.FCreditUsageID = usage.FID ");
        sql.append("WHERE (fIsClosed <> 1) AND (fcreditCompanyId IS NULL) AND ( entrys.fShareOrgid IN ( ");
        sql.append(BirtUtils.idListToInClause((Collection)companySet));
        sql.append(" ) AND fShareType = 1 OR entrys.fShareOrgid = '");
        sql.append(companyid);
        sql.append("') AND ( fShareType = 3 AND (fBalance > 0.0)  OR fShareType = 1 AND (fBalance > 0.0) OR fShareType = 2 AND (fBalance > 0.0)");
        sql.append(") AND ( entrys.ffinProid = '");
        sql.append(proFinid);
        sql.append("' OR (entrys.ffinProid IS NULL) OR usage.FColligateCredit = 1 ) AND fbillStatus = 1 AND FSupplier = '");
        sql.append(payee.getId().toString()).append("'");
        HashSet<String> idSet = new HashSet<String>();
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        try {
            int i = 0;
            Object row = null;
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
                ++i;
            }
            System.out.println("i =" + i);
        }
        catch (SQLException e) {
            this.handUIExceptionAndAbort(e);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        CreditLimitCollection col = CreditLimitFactory.getRemoteInstance().getCreditLimitCollection(view);
        if (col.size() == 0) {
            return null;
        }
        return col.get(0);
    }

    protected PayableBillCollection getColl(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("ntType.*"));
        evi.getSelector().add(new SelectorItemInfo("payee.*"));
        evi.getSelector().add(new SelectorItemInfo("payee1.*"));
        evi.getSelector().add(new SelectorItemInfo("Currency.*"));
        evi.getSelector().add(new SelectorItemInfo("OutBankAccount.*"));
        evi.getSelector().add(new SelectorItemInfo("CreditLimit.*"));
        evi.getSelector().add(new SelectorItemInfo("Institution.*"));
        evi.getSelector().add(new SelectorItemInfo("ApplyUnit.*"));
        SorterItemInfo sorter = new SorterItemInfo(NUMBER);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.ASCEND);
        sorterColl.add(sorter);
        evi.setSorter(sorterColl);
        IPayableBill ipayable = PayableBillFactory.getRemoteInstance();
        return ipayable.getPayableBillCollection(evi);
    }

    protected void initUIProp(BillMakeTypeEnum makeType) throws EASBizException, BOSException {
        this.setUITitle(EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_title"));
        this.tblMain.checkParsed();
        this.btnBatchConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.btnBatchConfirm.setEnabled(true);
        if (BillMakeTypeEnum.ENTRUST.equals((Object)makeType)) {
            this.tblMain.getColumn(BILLNUMBER).getStyleAttributes().setLocked(false);
            this.tblMain.getColumn(BEGINDATE).setRequired(true);
            this.tblMain.getColumn(ENDDATE).setRequired(true);
            this.tblMain.getColumn(PAYACCOUNT).setRequired(true);
        } else if (BillMakeTypeEnum.SUB.equals((Object)makeType)) {
            this.tblMain.getColumn(BILLNUMBER).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(BEGINDATE).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(ENDDATE).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(PAYACCOUNT).setRequired(false);
        }
        KDDatePicker editor1 = new KDDatePicker();
        editor1.setRequired(true);
        editor1.setVisible(true);
        editor1.setEnabled(true);
        KDTDefaultCellEditor cellEditor1 = new KDTDefaultCellEditor(editor1);
        this.tblMain.getColumn(BEGINDATE).setEditor((ICellEditor)cellEditor1);
        this.tblMain.getColumn(BEGINDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDDatePicker editor2 = new KDDatePicker();
        editor2.setRequired(true);
        editor2.setVisible(true);
        editor2.setEnabled(true);
        KDTDefaultCellEditor cellEditor2 = new KDTDefaultCellEditor(editor2);
        this.tblMain.getColumn(ENDDATE).setEditor((ICellEditor)cellEditor2);
        this.tblMain.getColumn(ENDDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDBizPromptBox editor3 = new KDBizPromptBox();
        editor3.setEditable(true);
        editor3.setDisplayFormat("$name$");
        editor3.setEditFormat("$number$");
        editor3.setCommitFormat("$simpleCode$;$number$;$name$");
        editor3.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        String companyName = this.currentCompany.getName();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"0"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        editor3.setEntityViewInfo(viewInfo);
        KDTDefaultCellEditor cellEditor3 = new KDTDefaultCellEditor((IKDEditor)editor3);
        this.tblMain.getColumn(PAYACCOUNT).setEditor((ICellEditor)cellEditor3);
        KDBizPromptBox editor4 = new KDBizPromptBox();
        FMClientHelper.initBgItemF7((KDBizPromptBox)editor4, null, (boolean)true, (boolean)true);
        KDTDefaultCellEditor cellEditor4 = new KDTDefaultCellEditor((IKDEditor)editor4);
        this.tblMain.getColumn(AGENTPRO).setEditor((ICellEditor)cellEditor4);
        KDBizPromptBox editor5 = new KDBizPromptBox();
        editor5.setEditable(true);
        editor5.setEditFormat("$number$");
        editor5.setCommitFormat("$number$");
        editor5.setDisplayFormat("$number$");
        editor5.setQueryInfo("com.kingdee.eas.fm.fin.app.F7CreditLimitQuery");
        KDTDefaultCellEditor cellEditor5 = new KDTDefaultCellEditor((IKDEditor)editor5);
        this.tblMain.getColumn(COSTLIMIT).setEditor((ICellEditor)cellEditor5);
        ObjectValueRender avrCreditLimit = new ObjectValueRender();
        avrCreditLimit.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn(COSTLIMIT).setRenderer((IBasicRender)avrCreditLimit);
        KDComboBox editor8 = new KDComboBox();
        Iterator iter = NTClientHelper.getNTTypesBySuperGroup(NTTypeGroupEnum.PAYABLE).iterator();
        while (iter.hasNext()) {
            NTTypeInfo element = (NTTypeInfo)iter.next();
            editor8.addItem((Object)element);
        }
        KDTDefaultCellEditor cellEditor8 = new KDTDefaultCellEditor((JComboBox)editor8);
        this.tblMain.getColumn(BIZTYPE).setEditor((ICellEditor)cellEditor8);
        KDFormattedTextField editor9 = new KDFormattedTextField();
        editor9.setDataType(1);
        editor9.setPrecision(2);
        editor9.setHorizontalAlignment(4);
        editor9.setSupportedEmpty(true);
        KDTDefaultCellEditor cellEditor9 = new KDTDefaultCellEditor((JTextField)editor9);
        this.tblMain.getColumn(AMOUNT).setEditor((ICellEditor)cellEditor9);
        this.tblMain.getColumn(BIZTYPE).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(NUMBER).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(PAYEE).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(CURRENCY).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(AMOUNT).getStyleAttributes().setLocked(true);
    }

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ID_SET, (Object)idSet);
        uiContext.put((Object)"selectIds", new ArrayList(idSet));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PayableBillBatchConfirmUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        return uiWindow;
    }

    public PayableBillCollection getResultColl() {
        return this.coll;
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        KDBizPromptBox prmtBox;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        int beginDateColIndex = this.tblMain.getColumn(BEGINDATE).getColumnIndex();
        int endDateColIndex = this.tblMain.getColumn(ENDDATE).getColumnIndex();
        int payAccountColIndex = this.tblMain.getColumn(PAYACCOUNT).getColumnIndex();
        int agentProColIndex = this.tblMain.getColumn(AGENTPRO).getColumnIndex();
        int costLimitColIndex = this.tblMain.getColumn(COSTLIMIT).getColumnIndex();
        int billNumberColIndex = this.tblMain.getColumn(BILLNUMBER).getColumnIndex();
        int IsRelBankColIndex = this.tblMain.getColumn(ISRELBANK).getColumnIndex();
        int IsInCreditColIndex = this.tblMain.getColumn(ISINCREDIT).getColumnIndex();
        if (colIndex != beginDateColIndex && colIndex != endDateColIndex && colIndex != agentProColIndex && colIndex != payAccountColIndex && colIndex != costLimitColIndex && colIndex != billNumberColIndex && colIndex != IsRelBankColIndex && colIndex != IsInCreditColIndex) {
            return;
        }
        if (colIndex == costLimitColIndex) {
            prmtBox = (KDBizPromptBox)((KDTDefaultCellEditor)this.tblMain.getColumn(colIndex).getEditor()).getComponent();
            this.initCreditLimitF7Filter(prmtBox, rowIndex);
        }
        if (colIndex == payAccountColIndex) {
            prmtBox = (KDBizPromptBox)((KDTDefaultCellEditor)this.tblMain.getColumn(colIndex).getEditor()).getComponent();
            this.initPayAccountF7Filter(prmtBox, rowIndex);
        }
    }

    protected void initPayAccountF7Filter(KDBizPromptBox prmt, int rowIndex) throws BOSException, EASBizException {
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell(ID).getValue();
        IPayableBill ipayable = PayableBillFactory.getRemoteInstance();
        PayableBillInfo info = ipayable.getPayableBillInfo("select *,billMaker.*,Currency.* where id = '" + id + "'");
        CompanyOrgUnitInfo orgUnit = this.currentCompany;
        CurrencyInfo currency = info.getCurrency();
        if (orgUnit != null && orgUnit.getId() != null && currency != null && currency.getId() != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnit.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", null, CompareType.EQUALS));
            filter.setMaskString("(#0 and (#1 or #2))");
            evi.setFilter(filter);
            prmt.setEntityViewInfo(evi);
            prmt.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        boolean isInCredit1;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        int beginDateColIndex = this.tblMain.getColumn(BEGINDATE).getColumnIndex();
        int endDateColIndex = this.tblMain.getColumn(ENDDATE).getColumnIndex();
        int payAccountColIndex = this.tblMain.getColumn(PAYACCOUNT).getColumnIndex();
        int agentProColIndex = this.tblMain.getColumn(AGENTPRO).getColumnIndex();
        int costLimitColIndex = this.tblMain.getColumn(COSTLIMIT).getColumnIndex();
        int billNumberColIndex = this.tblMain.getColumn(BILLNUMBER).getColumnIndex();
        int IsRelBankColIndex = this.tblMain.getColumn(ISRELBANK).getColumnIndex();
        int IsInCreditColIndex = this.tblMain.getColumn(ISINCREDIT).getColumnIndex();
        IRow row1 = this.tblMain.getRow(rowIndex);
        if (colIndex != beginDateColIndex && colIndex != endDateColIndex && colIndex != agentProColIndex && colIndex != payAccountColIndex && colIndex != costLimitColIndex && colIndex != billNumberColIndex && colIndex != IsRelBankColIndex && colIndex != IsInCreditColIndex) {
            return;
        }
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        if (rowIndex == 0) {
            IRow row = this.tblMain.getRow(rowIndex);
            Date beginDate = (Date)row.getCell(BEGINDATE).getValue();
            Date endDate = (Date)row.getCell(ENDDATE).getValue();
            AccountBankInfo payAccount = (AccountBankInfo)row.getCell(PAYACCOUNT).getValue();
            VisualItemInfo agentPro = (VisualItemInfo)row.getCell(AGENTPRO).getValue();
            CreditLimitInfo costLimit = (CreditLimitInfo)row.getCell(COSTLIMIT).getValue();
            NTTypeInfo bizType = (NTTypeInfo)row.getCell(BIZTYPE).getValue();
            String billNumber = (String)row.getCell(BILLNUMBER).getValue();
            BigDecimal amount = (BigDecimal)row.getCell(AMOUNT).getValue();
            boolean isRelBank = this.getIsRelBank(row);
            boolean isInCredit = this.getIsInCredit(row);
            int count = this.tblMain.getRowCount();
            for (int i = rowIndex + 1; i < count; ++i) {
                row = this.tblMain.getRow(i);
                if (colIndex == beginDateColIndex) {
                    row.getCell(BEGINDATE).setValue((Object)beginDate);
                }
                if (colIndex == endDateColIndex) {
                    row.getCell(ENDDATE).setValue((Object)endDate);
                }
                if (colIndex == payAccountColIndex) {
                    row.getCell(PAYACCOUNT).setValue((Object)payAccount);
                }
                if (colIndex == agentProColIndex) {
                    row.getCell(AGENTPRO).setValue((Object)agentPro);
                }
                if (colIndex == IsRelBankColIndex) {
                    this.setIsRelBank(row, isRelBank);
                }
                if (colIndex != IsInCreditColIndex) continue;
                this.setIsInCredit(row, isInCredit);
                if (isInCredit) {
                    row.getCell(COSTLIMIT).getStyleAttributes().setLocked(false);
                    continue;
                }
                row.getCell(COSTLIMIT).setValue(null);
                row.getCell(COSTLIMIT).getStyleAttributes().setLocked(true);
            }
        }
        if (!(isInCredit1 = this.getIsInCredit(row1))) {
            row1.getCell(COSTLIMIT).setValue(null);
        }
    }

    protected boolean getIsRelBank(IRow row) {
        Boolean flag = (Boolean)row.getCell(ISRELBANK).getValue();
        return flag;
    }

    protected void setIsRelBank(IRow row, boolean flag) {
        if (flag) {
            row.getCell(ISRELBANK).setValue((Object)Boolean.TRUE);
        } else {
            row.getCell(ISRELBANK).setValue((Object)Boolean.FALSE);
        }
    }

    protected boolean getIsInCredit(IRow row) {
        Boolean flag = (Boolean)row.getCell(ISINCREDIT).getValue();
        return flag;
    }

    protected void setIsInCredit(IRow row, boolean flag) {
        if (flag) {
            row.getCell(ISINCREDIT).setValue((Object)Boolean.TRUE);
            row.getCell(COSTLIMIT).getStyleAttributes().setLocked(false);
        } else {
            row.getCell(ISINCREDIT).setValue((Object)Boolean.FALSE);
            row.getCell(COSTLIMIT).getStyleAttributes().setLocked(true);
        }
    }

    protected void initCreditLimitF7Filter(KDBizPromptBox prmt, int rowIndex) throws BOSException, EASBizException {
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell(ID).getValue();
        IPayableBill ipayable = PayableBillFactory.getRemoteInstance();
        PayableBillInfo info = ipayable.getPayableBillInfo("select *,ntType.* where id = '" + id + "'");
        BankInfo bank = row.getCell(PAYACCOUNT).getValue() != null ? ((AccountBankInfo)row.getCell(PAYACCOUNT).getValue()).getBank() : null;
        CompanyOrgUnitInfo applyUnit = info.getApplyUnit();
        FinancingProductsInfo financeType = info.getNtType().getFinanceType();
        boolean isRelBank = this.getIsRelBank(row);
        if (bank != null && applyUnit != null) {
            prmt.setEntityViewInfo(FinUtils.getCreditLimitF7Filter((Object)bank, (String)applyUnit.getId().toString(), (boolean)isRelBank, (String)AccessHelper.getId((Object)financeType)));
        } else {
            prmt.setEntityViewInfo(FMClientHelper.getNothingFilter());
        }
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public void actionBatchConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchConfirm_actionPerformed(e);
        this.coll = this.buildBatchColl(this.tblMain);
        IPayableBill iPayableBill = PayableBillFactory.getRemoteInstance();
        List<String> confirmMsgList = this.getConfirmMsg(this.coll);
        if (confirmMsgList.size() > 0) {
            String separator = System.getProperty("line.separator");
            StringBuffer errorDetail = new StringBuffer();
            for (int i = 0; i < confirmMsgList.size(); ++i) {
                errorDetail.append(confirmMsgList.get(i)).append(separator);
            }
            if (MsgBox.showConfirm3a((String)EASResource.getString((String)NT_RESOURCE, (String)"supplierSame"), (String)errorDetail.toString()) == 2) {
                SysUtil.abort();
            }
        }
        Map resultMap = this.batchConfirm2(iPayableBill, (IObjectCollection)this.coll);
        String result = (String)resultMap.get("result");
        String failInfo = (String)resultMap.get("failInfo");
        MsgBox.showDetailAndOK(null, (String)result, (String)failInfo, (int)1);
        this.tblMain.setEnabled(false);
        this.uiWindow.close();
    }

    private List<String> getConfirmMsg(PayableBillCollection coll) {
        ArrayList<String> confirmMsgList = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = (PayableBillInfo)coll.getObject(i);
            if (!info.isIsInCredit()) continue;
            CreditLimitInfo creditLimit = info.getCreditLimit();
            SupplierInfo payee = info.getPayee();
            if (creditLimit == null || creditLimit.getSupplier() == null || payee == null || creditLimit.getSupplier().getId().toString().equals(payee.getId().toString())) continue;
            confirmMsgList.add(MessageFormat.format(EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_supplierNotSame"), i + 1 + "", info.getNumber()));
        }
        return confirmMsgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map batchConfirm2(IPayableBill iPayableBill, IObjectCollection coll) throws BOSException, BgCtrlException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer result = new StringBuffer();
        StringBuffer failInfo = new StringBuffer();
        int size = coll.size();
        int successCount = 0;
        int failCount = 0;
        boolean flag = false;
        if (size <= 0) {
            return null;
        }
        this.getUIContext().put("selectIds", null);
        ArrayList ids = new ArrayList();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        List<String> idList = this.coll2Ids(coll);
        try {
            Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < size; ++i) {
                PayableBillInfo info = (PayableBillInfo)coll.getObject(i);
                try {
                    AccountBankInfo payAccount;
                    Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                    if (!isLocked.booleanValue()) {
                        throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI"));
                    }
                    BillMakeTypeEnum makeType = info.getMakeType();
                    if (BillMakeTypeEnum.ENTRUST.equals((Object)makeType) && (payAccount = info.getOutBankAccount()) == null) {
                        throw new RuntimeException(EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_payerAccount_isNull"));
                    }
                    boolean isInCredit = info.isIsInCredit();
                    if (isInCredit) {
                        CreditLimitInfo creditLimit = info.getCreditLimit();
                        SupplierInfo payee = info.getPayee();
                        if (creditLimit == null) {
                            throw new RuntimeException(EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_creditLimit_isNull"));
                        }
                    }
                    CompanyOrgUnitInfo company = info.getCompany();
                    info.setCompany(info.getBillMaker());
                    FmMbgHelper.checkBizUnitInfo(null, (IObjectValue)info);
                    info.setCompany(company);
                    ids.addAll(iPayableBill.confirm(info));
                    ++successCount;
                    continue;
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (e instanceof MissMatchParticipantException && e.getMessage().endsWith("already bind process instance")) {
                        msg = EASResource.getString((String)NT_RESOURCE, (String)"bill_inworkflow");
                    }
                    logger.error((Object)"BatchEditError", (Throwable)e);
                    flag = true;
                    String BATCHCONFIRM_RESOURCE1 = EASResource.getString((String)NT_RESOURCE, (String)"app_batchConfirm1");
                    String row = "" + (i + 1);
                    failInfo.append(MessageFormat.format(BATCHCONFIRM_RESOURCE1, row, info.getNumber(), msg) + "\n");
                    ++failCount;
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        this.getUIContext().put("selectIds", ids);
        String BATCHCONFRIM_RESOURCE2 = EASResource.getString((String)NT_RESOURCE, (String)"app_batchConfirm2");
        result.append(MessageFormat.format(BATCHCONFRIM_RESOURCE2, "" + size, "" + successCount, "" + failCount));
        map.put("result", result.toString());
        if (flag) {
            map.put("failInfo", failInfo.toString());
        } else {
            map.put("failInfo", "");
        }
        return map;
    }

    private List<String> coll2Ids(IObjectCollection coll) {
        ArrayList<String> list = new ArrayList<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PayableBillInfo info = (PayableBillInfo)coll.getObject(i);
            list.add(info.getId().toString());
        }
        return list;
    }

    public static boolean workFlowIsStart(Context ctx, String billId) throws BOSException {
        boolean isBillStartWorkFlow = false;
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        IEnactmentService service = null;
        UserInfo userInfo = null;
        if (ctx == null) {
            service = EnactmentServiceFactory.createRemoteEnactService();
            userInfo = SysContext.getSysContext().getCurrentUserInfo();
        } else {
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
            userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        }
        String procDefID = service.findSubmitProcDef(bosType, userInfo.getId().toString());
        if (procDefID != null) {
            isBillStartWorkFlow = true;
        }
        return isBillStartWorkFlow;
    }

    protected void verify(PayableBillCollection coll) {
        for (int i = 0; i < coll.size(); ++i) {
            AccountBankInfo payAccount;
            PayableBillInfo info = coll.get(i);
            boolean isInCredit = info.isIsInCredit();
            BillMakeTypeEnum makeType = info.getMakeType();
            if (BillMakeTypeEnum.ENTRUST.equals((Object)makeType) && (payAccount = info.getOutBankAccount()) == null) {
                String BATCHCONFIRM_NOPAYACCOUNT = EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_noPayAccount");
                MsgBox.showInfo((String)MessageFormat.format(BATCHCONFIRM_NOPAYACCOUNT, info.getNumber()));
                SysUtil.abort();
            }
            if (!isInCredit) continue;
            CreditLimitInfo creditLimit = info.getCreditLimit();
            SupplierInfo payee = info.getPayee();
            if (creditLimit == null) {
                String BATCHCONFIRM_NOCREDITLIMIT = EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_noCreditLimit");
                MsgBox.showInfo((String)MessageFormat.format(BATCHCONFIRM_NOCREDITLIMIT, info.getNumber()));
                SysUtil.abort();
            }
            if (creditLimit == null || creditLimit.getSupplier() == null || payee == null) continue;
            this.verifySupplier(creditLimit, payee);
        }
    }

    protected PayableBillCollection buildBatchColl(KDTable table) throws EASBizException, BOSException {
        PayableBillInfo info = null;
        PayableBillCollection coll = new PayableBillCollection();
        IPayableBill iPayableBill = PayableBillFactory.getRemoteInstance();
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            VisualItemInfo bgItem;
            CreditLimitInfo creditLimit;
            String id;
            row = table.getRow(i);
            String string = id = row.getCell(ID) != null ? (String)row.getCell(ID).getValue() : null;
            if (id == null) continue;
            String oql = "select *,Currency.*,Company.*,billMaker.* where id = '" + id + "'";
            info = iPayableBill.getPayableBillInfo(oql);
            info.setDraftNumber(row.getCell(BILLNUMBER).getValue() != null ? (String)row.getCell(BILLNUMBER).getValue() : null);
            info.setIssueDate(row.getCell(BEGINDATE) != null ? (Date)row.getCell(BEGINDATE).getValue() : null);
            info.setExpiredDate(row.getCell(BEGINDATE) != null ? (Date)row.getCell(ENDDATE).getValue() : null);
            info.setOutBankAccount(row.getCell(PAYACCOUNT) != null ? (AccountBankInfo)row.getCell(PAYACCOUNT).getValue() : null);
            info.setIsInCredit(this.getIsInCredit(row));
            info.setIsRelBankInCredit(this.getIsRelBank(row));
            CreditLimitInfo creditLimitInfo = creditLimit = row.getCell(COSTLIMIT) != null ? (CreditLimitInfo)row.getCell(COSTLIMIT).getValue() : null;
            if (creditLimit != null) {
                info.setCreditLimit(creditLimit);
                info.setCreditCurrency(creditLimit.getCurrency());
                info.setCreditCurExRate(creditLimit.getExchangeRate());
                info.setCreditLocalAmt(creditLimit.getLocalAmount());
            }
            VisualItemInfo visualItemInfo = bgItem = row.getCell(AGENTPRO).getValue() != null ? (VisualItemInfo)row.getCell(AGENTPRO).getValue() : null;
            if (bgItem != null) {
                info.setOutBgItemName(bgItem.getName());
                info.setOutBgItemNumber(bgItem.getNumber());
            }
            BankInfo bank = row.getCell(PAYACCOUNT).getValue() != null ? ((AccountBankInfo)row.getCell(PAYACCOUNT).getValue()).getBank() : null;
            info.setInstitution(bank);
            coll.add(info);
        }
        return coll;
    }

    protected void chkIsInCredit_itemStateChanged(ItemEvent e) {
    }

    protected void chkIsRelBank_itemStateChanged(ItemEvent e) {
    }

    protected void verifySupplier(CreditLimitInfo creditLimit, SupplierInfo supplier) {
        if (!creditLimit.getSupplier().getId().toString().equals(supplier.getId().toString()) && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NT_RESOURCE, (String)"supplierSame")) == 1) {
            SysUtil.abort();
        }
    }
}

