/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.AddBatchHelper;
import com.kingdee.eas.fi.cas.ControlTake;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.IPayableBill;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractPayableBillBatchEditUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class PayableBillBatchEditUI
extends AbstractPayableBillBatchEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PayableBillBatchEditUI.class);
    private static final String ID_SET = "idSet";
    private static final String MAKE_TYPE = "makeType";
    private static final String ID = "id";
    private static final String BIZTYPE = "bizType";
    private static final String NUMBER = "number";
    private static final String BILLNUMBER = "billNumber";
    private static final String PAYEE = "payee";
    private static final String CURRENCY = "currency";
    private static final String AMOUNT = "amount";
    private static final String BEGINDATE = "beginDate";
    private static final String ENDDATE = "endDate";
    private static final String PAYACCOUNT = "payAccount";
    private static final String ISINCREDIT = "IsInCredit";
    private static final String ISRELBANK = "IsRelBank";
    private static final String COSTLIMIT = "costLimit";
    private static final String AGENTPRO = "agentPro";
    private static final Color requireField = new Color(250, 250, 210);
    private PayableBillCollection coll = null;
    protected CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    public static final String NT_RESOURCE = "com.kingdee.eas.fm.nt.NtResource";

    public void onLoad() throws Exception {
        super.onLoad();
        Set idSet = (Set)this.getUIContext().get(ID_SET);
        String makeType = (String)this.getUIContext().get(MAKE_TYPE);
        this.initUIProp(makeType);
        this.fillData(idSet);
    }

    protected void fillData(Set idSet) throws BOSException, EASBizException {
        PayableBillCollection coll = this.getColl(idSet);
        PayableBillInfo info = null;
        String currencyID = null;
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            info = coll.get(i);
            if (info == null) continue;
            currencyID = info.getCurrency().getId().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)AMOUNT, (String)currencyID);
            row.getCell(ID).setValue((Object)info.getId().toString());
            row.getCell(BIZTYPE).setValue((Object)info.getNtType());
            row.getCell(NUMBER).setValue((Object)info.getNumber());
            row.getCell(BILLNUMBER).setValue((Object)info.getDraftNumber());
            SupplierInfo payee = info.getPayee();
            CustomerInfo payee1 = info.getPayee1();
            if (payee != null) {
                row.getCell(PAYEE).setValue((Object)payee.getName());
            } else if (payee1 != null) {
                row.getCell(PAYEE).setValue((Object)payee1.getName());
            } else {
                row.getCell(PAYEE).setValue((Object)info.getPayeeName());
            }
            row.getCell(CURRENCY).setValue(info.getCurrency() != null ? info.getCurrency().getName() : null);
            row.getCell(AMOUNT).setValue((Object)info.getAmount());
            row.getCell(BEGINDATE).setValue((Object)info.getIssueDate());
            row.getCell(ENDDATE).setValue((Object)info.getExpiredDate());
            BillMakeTypeEnum makeType = info.getMakeType();
            if (makeType.equals((Object)BillMakeTypeEnum.ENTRUST)) {
                row.getCell(PAYACCOUNT).setValue(null);
                info.setOutBankAccount(null);
                info.setInstitution(null);
            } else {
                row.getCell(PAYACCOUNT).setValue((Object)info.getOutBankAccount());
            }
            row.getCell(COSTLIMIT).setValue((Object)info.getCreditLimit());
            VisualItemInfo vitem = new VisualItemInfo();
            vitem.setName(info.getOutBgItemName());
            vitem.setNumber(info.getOutBgItemNumber());
            row.getCell(AGENTPRO).setValue((Object)vitem);
            boolean isRelBank = info.isIsRelBankInCredit();
            boolean isInCredit = info.isIsInCredit();
            ICellEditor chkIsRelBankedit = ControlTake.getKDCheckBoxEditor();
            ICellEditor chkIsInCreditedit = ControlTake.getKDCheckBoxEditor();
            AddBatchHelper.bindContents((IRow)row, (String)ISRELBANK, (ICellEditor)chkIsRelBankedit);
            AddBatchHelper.bindContents((IRow)row, (String)ISINCREDIT, (ICellEditor)chkIsInCreditedit);
            this.setIsRelBank(row, isRelBank);
            this.setIsInCredit(row, isInCredit);
            ICellEditor chkIsInCreditEdit = ControlTake.getKDCheckBoxEditor();
            AddBatchHelper.bindContents((IRow)row, (String)ISINCREDIT, (ICellEditor)chkIsInCreditEdit);
            KDCheckBox chkIsRelBank = AddBatchHelper.getKDCheckBox((IRow)row, (String)ISRELBANK);
            chkIsRelBank.setSelected(false);
            chkIsRelBank.setEnabled(false);
            KDCheckBox kdCheckBox = AddBatchHelper.getKDCheckBox((IRow)row, (String)ISINCREDIT);
            kdCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PayableBillBatchEditUI.this.chkIsInCredit_itemStateChanged(e);
                }
            });
        }
    }

    protected PayableBillCollection getColl(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("ntType.*"));
        evi.getSelector().add(new SelectorItemInfo("payee.*"));
        evi.getSelector().add(new SelectorItemInfo("payee1.*"));
        evi.getSelector().add(new SelectorItemInfo("Currency.*"));
        evi.getSelector().add(new SelectorItemInfo("OutBankAccount.*"));
        evi.getSelector().add(new SelectorItemInfo("CreditLimit.*"));
        SorterItemInfo sorter = new SorterItemInfo(NUMBER);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.ASCEND);
        sorterColl.add(sorter);
        evi.setSorter(sorterColl);
        IPayableBill ipayable = PayableBillFactory.getRemoteInstance();
        return ipayable.getPayableBillCollection(evi);
    }

    protected void initUIProp(String makeType) throws EASBizException, BOSException {
        this.setUITitle(EASResource.getString((String)NT_RESOURCE, (String)"client_batchEdit_title"));
        this.tblMain.checkParsed();
        this.btnBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnBatchSubmit.setEnabled(true);
        this.tblMain.getColumn(BEGINDATE).getStyleAttributes().setBackground(requireField);
        this.tblMain.getColumn(ENDDATE).getStyleAttributes().setBackground(requireField);
        this.tblMain.getColumn(PAYACCOUNT).getStyleAttributes().setBackground(requireField);
        KDDatePicker editor1 = new KDDatePicker();
        editor1.setRequired(true);
        editor1.setVisible(true);
        editor1.setEnabled(true);
        KDTDefaultCellEditor cellEditor1 = new KDTDefaultCellEditor(editor1);
        this.tblMain.getColumn(BEGINDATE).setEditor((ICellEditor)cellEditor1);
        this.tblMain.getColumn(BEGINDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDDatePicker editor2 = new KDDatePicker();
        editor2.setRequired(true);
        editor2.setVisible(true);
        editor2.setEnabled(true);
        KDTDefaultCellEditor cellEditor2 = new KDTDefaultCellEditor(editor2);
        this.tblMain.getColumn(ENDDATE).setEditor((ICellEditor)cellEditor2);
        this.tblMain.getColumn(ENDDATE).getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        KDBizPromptBox editor3 = new KDBizPromptBox();
        editor3.setEditable(true);
        editor3.setDisplayFormat("$name$");
        editor3.setEditFormat("$number$");
        editor3.setCommitFormat("$simpleCode$;$number$;$name$");
        editor3.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        String companyName = this.currentCompany.getName();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.name", (Object)companyName, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        editor3.setEntityViewInfo(viewInfo);
        KDTDefaultCellEditor cellEditor3 = new KDTDefaultCellEditor((IKDEditor)editor3);
        this.tblMain.getColumn(PAYACCOUNT).setEditor((ICellEditor)cellEditor3);
        KDBizPromptBox editor4 = new KDBizPromptBox();
        FMClientHelper.initBgItemF7((KDBizPromptBox)editor4, null, (boolean)true, (boolean)true);
        KDTDefaultCellEditor cellEditor4 = new KDTDefaultCellEditor((IKDEditor)editor4);
        this.tblMain.getColumn(AGENTPRO).setEditor((ICellEditor)cellEditor4);
        KDBizPromptBox editor5 = new KDBizPromptBox();
        editor5.setEditable(true);
        editor5.setEditFormat("$number$");
        editor5.setCommitFormat("$number$");
        editor5.setDisplayFormat("$number$");
        editor5.setQueryInfo("com.kingdee.eas.fm.fin.app.F7CreditLimitQuery");
        KDTDefaultCellEditor cellEditor5 = new KDTDefaultCellEditor((IKDEditor)editor5);
        this.tblMain.getColumn(COSTLIMIT).setEditor((ICellEditor)cellEditor5);
        ObjectValueRender avrCreditLimit = new ObjectValueRender();
        avrCreditLimit.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblMain.getColumn(COSTLIMIT).setRenderer((IBasicRender)avrCreditLimit);
        KDComboBox editor8 = new KDComboBox();
        Iterator iter = NTClientHelper.getNTTypesBySuperGroup(NTTypeGroupEnum.PAYABLE).iterator();
        while (iter.hasNext()) {
            NTTypeInfo element = (NTTypeInfo)iter.next();
            editor8.addItem((Object)element);
        }
        KDTDefaultCellEditor cellEditor8 = new KDTDefaultCellEditor((JComboBox)editor8);
        this.tblMain.getColumn(BIZTYPE).setEditor((ICellEditor)cellEditor8);
        KDFormattedTextField editor9 = new KDFormattedTextField();
        editor9.setDataType(1);
        editor9.setPrecision(2);
        editor9.setHorizontalAlignment(4);
        editor9.setSupportedEmpty(true);
        KDTDefaultCellEditor cellEditor9 = new KDTDefaultCellEditor((JTextField)editor9);
        this.tblMain.getColumn(AMOUNT).setEditor((ICellEditor)cellEditor9);
        if (makeType.equals(BillMakeTypeEnum.SUB.getAlias())) {
            this.tblMain.getColumn(BIZTYPE).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(NUMBER).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(PAYEE).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(CURRENCY).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(AMOUNT).getStyleAttributes().setLocked(true);
        }
        if (makeType.equals(BillMakeTypeEnum.SELF.getAlias())) {
            this.tblMain.getColumn(NUMBER).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(PAYEE).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(CURRENCY).getStyleAttributes().setLocked(true);
        }
    }

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet, String makeType) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ID_SET, (Object)idSet);
        uiContext.put((Object)MAKE_TYPE, (Object)makeType);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PayableBillBatchEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        return uiWindow;
    }

    public PayableBillCollection getResultColl() {
        return this.coll;
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        KDBizPromptBox prmtBox;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        int beginDateColIndex = this.tblMain.getColumn(BEGINDATE).getColumnIndex();
        int endDateColIndex = this.tblMain.getColumn(ENDDATE).getColumnIndex();
        int payAccountColIndex = this.tblMain.getColumn(PAYACCOUNT).getColumnIndex();
        int agentProColIndex = this.tblMain.getColumn(AGENTPRO).getColumnIndex();
        int costLimitColIndex = this.tblMain.getColumn(COSTLIMIT).getColumnIndex();
        int bizTypeColIndex = this.tblMain.getColumn(BIZTYPE).getColumnIndex();
        int billNumberColIndex = this.tblMain.getColumn(BILLNUMBER).getColumnIndex();
        int amountColIndex = this.tblMain.getColumn(AMOUNT).getColumnIndex();
        int IsRelBankColIndex = this.tblMain.getColumn(ISRELBANK).getColumnIndex();
        int IsInCreditColIndex = this.tblMain.getColumn(ISINCREDIT).getColumnIndex();
        if (colIndex != beginDateColIndex && colIndex != endDateColIndex && colIndex != agentProColIndex && colIndex != payAccountColIndex && colIndex != costLimitColIndex && colIndex != bizTypeColIndex && colIndex != billNumberColIndex && colIndex != amountColIndex && colIndex != IsRelBankColIndex && colIndex != IsInCreditColIndex) {
            return;
        }
        if (colIndex == costLimitColIndex) {
            prmtBox = (KDBizPromptBox)((KDTDefaultCellEditor)this.tblMain.getColumn(colIndex).getEditor()).getComponent();
            this.initCreditLimitF7Filter(prmtBox, rowIndex);
        }
        if (colIndex == payAccountColIndex) {
            prmtBox = (KDBizPromptBox)((KDTDefaultCellEditor)this.tblMain.getColumn(colIndex).getEditor()).getComponent();
            this.initPayAccountF7Filter(prmtBox, rowIndex);
        }
    }

    protected void initPayAccountF7Filter(KDBizPromptBox prmt, int rowIndex) throws BOSException, EASBizException {
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell(ID).getValue();
        IPayableBill ipayable = PayableBillFactory.getRemoteInstance();
        PayableBillInfo info = ipayable.getPayableBillInfo("select *,billMaker.*,Currency.* where id = '" + id + "'");
        CompanyOrgUnitInfo orgUnit = info.getBillMaker();
        CurrencyInfo currency = info.getCurrency();
        if (orgUnit != null && orgUnit.getId() != null && currency != null && currency.getId() != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnit.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", null, CompareType.EQUALS));
            filter.setMaskString("(#0 and (#1 or #2))");
            evi.setFilter(filter);
            prmt.setEntityViewInfo(evi);
            prmt.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        boolean isInCredit1;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        int beginDateColIndex = this.tblMain.getColumn(BEGINDATE).getColumnIndex();
        int endDateColIndex = this.tblMain.getColumn(ENDDATE).getColumnIndex();
        int payAccountColIndex = this.tblMain.getColumn(PAYACCOUNT).getColumnIndex();
        int agentProColIndex = this.tblMain.getColumn(AGENTPRO).getColumnIndex();
        int costLimitColIndex = this.tblMain.getColumn(COSTLIMIT).getColumnIndex();
        int bizTypeColIndex = this.tblMain.getColumn(BIZTYPE).getColumnIndex();
        int billNumberColIndex = this.tblMain.getColumn(BILLNUMBER).getColumnIndex();
        int amountColIndex = this.tblMain.getColumn(AMOUNT).getColumnIndex();
        int IsRelBankColIndex = this.tblMain.getColumn(ISRELBANK).getColumnIndex();
        int IsInCreditColIndex = this.tblMain.getColumn(ISINCREDIT).getColumnIndex();
        if (colIndex != beginDateColIndex && colIndex != endDateColIndex && colIndex != agentProColIndex && colIndex != payAccountColIndex && colIndex != costLimitColIndex && colIndex != bizTypeColIndex && colIndex != billNumberColIndex && colIndex != amountColIndex && colIndex != IsRelBankColIndex && colIndex != IsInCreditColIndex) {
            return;
        }
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        IRow row1 = this.tblMain.getRow(rowIndex);
        if (colIndex == IsInCreditColIndex) {
            if (this.getIsInCredit(row1)) {
                row1.getCell(COSTLIMIT).getStyleAttributes().setLocked(false);
            } else {
                row1.getCell(COSTLIMIT).getStyleAttributes().setLocked(true);
            }
        }
        if (rowIndex == 0) {
            IRow row = this.tblMain.getRow(rowIndex);
            Date beginDate = (Date)row.getCell(BEGINDATE).getValue();
            Date endDate = (Date)row.getCell(ENDDATE).getValue();
            AccountBankInfo payAccount = (AccountBankInfo)row.getCell(PAYACCOUNT).getValue();
            VisualItemInfo agentPro = (VisualItemInfo)row.getCell(AGENTPRO).getValue();
            NTTypeInfo bizType = (NTTypeInfo)row.getCell(BIZTYPE).getValue();
            String billNumber = (String)row.getCell(BILLNUMBER).getValue();
            BigDecimal amount = (BigDecimal)row.getCell(AMOUNT).getValue();
            boolean isRelBank = this.getIsRelBank(row);
            boolean isInCredit = this.getIsInCredit(row);
            if (colIndex == IsInCreditColIndex) {
                if (isInCredit) {
                    row.getCell(COSTLIMIT).getStyleAttributes().setLocked(false);
                } else {
                    row.getCell(COSTLIMIT).getStyleAttributes().setLocked(true);
                }
            }
            int count = this.tblMain.getRowCount();
            for (int i = rowIndex + 1; i < count; ++i) {
                row = this.tblMain.getRow(i);
                if (colIndex == beginDateColIndex) {
                    row.getCell(BEGINDATE).setValue((Object)beginDate);
                }
                if (colIndex == endDateColIndex) {
                    row.getCell(ENDDATE).setValue((Object)endDate);
                }
                if (colIndex == payAccountColIndex) {
                    row.getCell(PAYACCOUNT).setValue((Object)payAccount);
                }
                if (colIndex == agentProColIndex) {
                    row.getCell(AGENTPRO).setValue((Object)agentPro);
                }
                if (colIndex == amountColIndex) {
                    row.getCell(AMOUNT).setValue((Object)amount);
                }
                if (colIndex != bizTypeColIndex) continue;
                row.getCell(BIZTYPE).setValue((Object)bizType);
            }
        }
        if (!(isInCredit1 = this.getIsInCredit(row1))) {
            row1.getCell(COSTLIMIT).setValue(null);
        }
    }

    protected boolean getIsRelBank(IRow row) {
        Boolean flag = (Boolean)row.getCell(ISRELBANK).getValue();
        return flag;
    }

    protected void setIsRelBank(IRow row, boolean flag) {
        if (flag) {
            row.getCell(ISRELBANK).setValue((Object)Boolean.TRUE);
        } else {
            row.getCell(ISRELBANK).setValue((Object)Boolean.FALSE);
        }
    }

    protected boolean getIsInCredit(IRow row) {
        Boolean flag = (Boolean)row.getCell(ISINCREDIT).getValue();
        return flag;
    }

    protected void setIsInCredit(IRow row, boolean flag) {
        if (flag) {
            row.getCell(ISINCREDIT).setValue((Object)Boolean.TRUE);
            row.getCell(COSTLIMIT).getStyleAttributes().setLocked(false);
        } else {
            row.getCell(ISINCREDIT).setValue((Object)Boolean.FALSE);
            row.getCell(COSTLIMIT).getStyleAttributes().setLocked(true);
        }
    }

    protected void initCreditLimitF7Filter(KDBizPromptBox prmt, int rowIndex) throws BOSException, EASBizException {
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell(ID).getValue();
        IPayableBill ipayable = PayableBillFactory.getRemoteInstance();
        PayableBillInfo info = ipayable.getPayableBillInfo("select *,ntType.* where id = '" + id + "'");
        BankInfo bank = row.getCell(PAYACCOUNT).getValue() != null ? ((AccountBankInfo)row.getCell(PAYACCOUNT).getValue()).getBank() : null;
        CompanyOrgUnitInfo applyUnit = info.getApplyUnit();
        FinancingProductsInfo financeType = info.getNtType().getFinanceType();
        boolean isRelBank = this.getIsRelBank(row);
        if (bank != null && applyUnit != null) {
            prmt.setEntityViewInfo(FinUtils.getCreditLimitF7Filter((Object)bank, (String)applyUnit.getId().toString(), (boolean)isRelBank, (String)AccessHelper.getId((Object)financeType)));
        } else {
            prmt.setEntityViewInfo(FMClientHelper.getNothingFilter());
        }
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchSubmit_actionPerformed(e);
        this.coll = this.buildBatchColl(this.tblMain);
        this.verify(this.coll);
        IPayableBill iPayableBill = PayableBillFactory.getRemoteInstance();
        Map resultMap = this.batchEdit(iPayableBill, (IObjectCollection)this.coll);
        String result = (String)resultMap.get("result");
        String failInfo = (String)resultMap.get("failInfo");
        MsgBox.showDetailAndOK(null, (String)result, (String)failInfo, (int)1);
        this.tblMain.setEnabled(false);
        this.uiWindow.close();
    }

    protected Map batchEdit(IPayableBill iPayableBill, IObjectCollection colls) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer result = new StringBuffer();
        StringBuffer failInfo = new StringBuffer();
        int size = colls.size();
        int successCount = 0;
        int failCount = 0;
        boolean flag = false;
        if (size <= 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            PayableBillInfo info = (PayableBillInfo)colls.getObject(i);
            try {
                BankInfo bankInfo = new BankInfo();
                BankInfo bankId = info.getInstitution();
                if (bankId != null) {
                    bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bankId.getId()));
                }
                info.setInstitutionName(bankInfo.getName());
                iPayableBill.submit((CoreBaseInfo)info);
                ++successCount;
                continue;
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (e instanceof MissMatchParticipantException && e.getMessage().endsWith("already bind process instance")) {
                    msg = EASResource.getString((String)NT_RESOURCE, (String)"bill_inworkflow");
                }
                e.printStackTrace();
                logger.error((Object)"BatchEditError", (Throwable)e);
                flag = true;
                String BATCHEDIT_RESOURCE1 = EASResource.getString((String)NT_RESOURCE, (String)"app_batchEdit1");
                String row = "" + (i + 1);
                failInfo.append(MessageFormat.format(BATCHEDIT_RESOURCE1, row, info.getNumber(), msg));
                ++failCount;
            }
        }
        String BATCHEDIT_RESOURCE2 = EASResource.getString((String)NT_RESOURCE, (String)"app_batchEdit2");
        result.append(MessageFormat.format(BATCHEDIT_RESOURCE2, "" + size, "" + successCount, "" + failCount));
        map.put("result", result.toString());
        if (flag) {
            map.put("failInfo", failInfo.toString());
        } else {
            map.put("failInfo", "");
        }
        return map;
    }

    public static boolean workFlowIsStart(Context ctx, String billId) throws BOSException {
        boolean isBillStartWorkFlow = false;
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        IEnactmentService service = null;
        UserInfo userInfo = null;
        if (ctx == null) {
            service = EnactmentServiceFactory.createRemoteEnactService();
            userInfo = SysContext.getSysContext().getCurrentUserInfo();
        } else {
            service = EnactmentServiceFactory.createEnactService((Context)ctx);
            userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        }
        String procDefID = service.findSubmitProcDef(bosType, userInfo.getId().toString());
        if (procDefID != null) {
            isBillStartWorkFlow = true;
        }
        return isBillStartWorkFlow;
    }

    protected void verify(PayableBillCollection coll) {
        for (int i = 0; i < coll.size(); ++i) {
            PayableBillInfo info = coll.get(i);
            boolean isInCredit = info.isIsInCredit();
            AccountBankInfo payAccount = info.getOutBankAccount();
            if (payAccount == null) {
                String BATCHCONFIRM_NOPAYACCOUNT = EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_noPayAccount");
                MsgBox.showInfo((String)MessageFormat.format(BATCHCONFIRM_NOPAYACCOUNT, info.getNumber()));
                SysUtil.abort();
            }
            if (!isInCredit) continue;
            CreditLimitInfo creditLimit = info.getCreditLimit();
            SupplierInfo payee = info.getPayee();
            if (creditLimit == null) {
                String BATCHCONFIRM_NOCREDITLIMIT = EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_noCreditLimit");
                MsgBox.showInfo((String)MessageFormat.format(BATCHCONFIRM_NOCREDITLIMIT, info.getNumber()));
                SysUtil.abort();
            }
            if (creditLimit == null || creditLimit.getSupplier() == null || payee == null) continue;
            this.verifySupplier(creditLimit, payee);
        }
    }

    protected PayableBillCollection buildBatchColl(KDTable table) throws EASBizException, BOSException {
        PayableBillInfo info = null;
        PayableBillCollection coll = new PayableBillCollection();
        IPayableBill iPayableBill = PayableBillFactory.getRemoteInstance();
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            VisualItemInfo bgItem;
            CreditLimitInfo creditLimit;
            BigDecimal amount;
            String id;
            row = table.getRow(i);
            String string = id = row.getCell(ID) != null ? (String)row.getCell(ID).getValue() : null;
            if (id == null) continue;
            info = iPayableBill.getPayableBillInfo("where id = '" + id + "'");
            info.setNtType(row.getCell(BIZTYPE).getValue() != null ? (NTTypeInfo)row.getCell(BIZTYPE).getValue() : null);
            info.setDraftNumber(row.getCell(BILLNUMBER).getValue() != null ? (String)row.getCell(BILLNUMBER).getValue() : null);
            BigDecimal bigDecimal = amount = row.getCell(AMOUNT).getValue() != null ? (BigDecimal)row.getCell(AMOUNT).getValue() : null;
            if (amount != null) {
                info.setAmount(amount);
                BigDecimal rate = info.getLocalCurExRate();
                BigDecimal localAmount = null;
                if (rate != null) {
                    localAmount = amount.multiply(rate);
                }
                info.setAmountLocalCur(localAmount);
                BigDecimal assureAmount = info.getAssureAmount();
                BigDecimal balance = amount.subtract(assureAmount);
                info.setBalance(balance);
            }
            info.setIssueDate(row.getCell(BEGINDATE) != null ? (Date)row.getCell(BEGINDATE).getValue() : null);
            info.setExpiredDate(row.getCell(BEGINDATE) != null ? (Date)row.getCell(ENDDATE).getValue() : null);
            info.setOutBankAccount(row.getCell(PAYACCOUNT) != null ? (AccountBankInfo)row.getCell(PAYACCOUNT).getValue() : null);
            if (row.getCell(PAYACCOUNT) != null && row.getCell(PAYACCOUNT).getValue() != null) {
                info.setInstitution(((AccountBankInfo)row.getCell(PAYACCOUNT).getValue()).getBank());
            }
            info.setIsInCredit(this.getIsInCredit(row));
            info.setIsRelBankInCredit(this.getIsRelBank(row));
            CreditLimitInfo creditLimitInfo = creditLimit = row.getCell(COSTLIMIT) != null ? (CreditLimitInfo)row.getCell(COSTLIMIT).getValue() : null;
            if (creditLimit != null) {
                info.setCreditLimit(creditLimit);
                BigDecimal assureAmt = BigDecimal.ZERO;
                if (info.getAmount() == null) {
                    info.setCreditCurExRate(FMConstants.ZERO);
                    info.setCreditLocalAmt(FMConstants.ZERO);
                } else {
                    if (info.getAssureAmount() != null) {
                        assureAmt = info.getAssureAmount();
                    }
                    PayableBillInfo paybillInfo = iPayableBill.getPayableBillInfo("select *,company.*,Currency.* where id = '" + id + "'");
                    int precision = paybillInfo.getCurrency().getPrecision();
                    if (paybillInfo.getCurrency().getId().equals((Object)creditLimit.getCurrency().getId())) {
                        info.setCreditCurExRate(FMConstants.ONE);
                    } else {
                        ExchangeRateInfo exchangeInfo = FMHelper.getExRateInfo((CurrencyInfo)paybillInfo.getCurrency(), (CurrencyInfo)creditLimit.getCurrency(), (CompanyOrgUnitInfo)paybillInfo.getCompany(), (Date)new Date());
                        info.setCreditCurExRate(exchangeInfo.getConvertRate());
                        precision = exchangeInfo.getPrecision();
                    }
                    BigDecimal creditLocalAmt = info.getAmount().subtract(assureAmt).multiply(info.getCreditCurExRate()).setScale(precision, 4);
                    info.setCreditLocalAmt(creditLocalAmt);
                }
            } else {
                info.setCreditLimit(null);
                info.setCreditCurrency(null);
                info.setCreditCurExRate(FMConstants.ZERO);
                info.setCreditLocalAmt(FMConstants.ZERO);
            }
            if (!info.isCanEdit()) {
                String batchConfirm_noBatchEdit = EASResource.getString((String)NT_RESOURCE, (String)"client_batchConfirm_noBatchEdit");
                MsgBox.showInfo((String)MessageFormat.format(batchConfirm_noBatchEdit, info.getNumber()));
                SysUtil.abort();
            }
            VisualItemInfo visualItemInfo = bgItem = row.getCell(AGENTPRO).getValue() != null ? (VisualItemInfo)row.getCell(AGENTPRO).getValue() : null;
            if (bgItem != null) {
                info.setOutBgItemName(bgItem.getName());
                info.setOutBgItemNumber(bgItem.getNumber());
            }
            coll.add(info);
        }
        return coll;
    }

    protected void chkIsInCredit_itemStateChanged(ItemEvent e) {
        KDCheckBox chkIsInCredit = (KDCheckBox)e.getSource();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        KDCheckBox chkIsRelBank = AddBatchHelper.getKDCheckBox((IRow)row, (String)ISRELBANK);
        if (!chkIsInCredit.isSelected()) {
            chkIsRelBank.setSelected(false);
            chkIsRelBank.setEnabled(false);
            row.getCell(ISRELBANK).setValue((Object)Boolean.FALSE);
            row.getCell(COSTLIMIT).setValue(null);
        } else {
            chkIsRelBank.setSelected(true);
            chkIsRelBank.setEnabled(true);
            row.getCell(ISRELBANK).setValue((Object)Boolean.TRUE);
        }
    }

    protected void chkIsRelBank_itemStateChanged(ItemEvent e) {
    }

    protected void verifySupplier(CreditLimitInfo creditLimit, SupplierInfo supplier) {
        if (!creditLimit.getSupplier().getId().toString().equals(supplier.getId().toString()) && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NT_RESOURCE, (String)"supplierSame")) == 1) {
            SysUtil.abort();
        }
    }
}

