/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PayableBillViewDataProvider
extends DefaultNoteDataProvider
implements IPrintActionListener {
    private List<String> idList;

    public PayableBillViewDataProvider(List<String> idList) {
        this.idList = idList;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        if (dataSource.getId().equals("EReceiptViewDataProvider")) {
            return this.getPayableBillData(dataSource);
        }
        return super.getData(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet getPayableBillData(R1PrintDataSource dataSource) throws BOSException, EASBizException, SQLException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set(this.idList), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("contractId", null, CompareType.NOTEQUALS));
        view.getSelector().add("*");
        PayableBillCollection coll = PayableBillFactory.getRemoteInstance().getPayableBillCollection(view);
        PayableBillInfo info = coll.get(0);
        List pdfList = new ArrayList();
        if (info.isIsDownload()) {
            ArrayList<String> contractList = new ArrayList<String>();
            contractList.add(info.getContractId().toString());
            pdfList = PayableBillFactory.getRemoteInstance().nvaContract(contractList);
        } else {
            pdfList = PayableBillFactory.getRemoteInstance().downloadContract(FMHelper.list2Set(this.idList));
        }
        String ATTACTMENT_FIELD = "id";
        DynamicRowSet drs = new DynamicRowSet(1);
        for (int i = 0; i < 1; ++i) {
            ColInfo ci = new ColInfo();
            ci.colType = -2;
            ci.columnName = "id";
            ci.nullable = 1;
            drs.setColInfo(i + 1, ci);
        }
        drs.beforeFirst();
        ArrayList<byte[]> newPdfList = new ArrayList<byte[]>();
        for (int j = 0; j < pdfList.size(); ++j) {
            ByteArrayInputStream in = new ByteArrayInputStream((byte[])pdfList.get(j));
            PDDocument document = null;
            try {
                document = PDDocument.load((InputStream)in);
                Splitter splitter = new Splitter();
                List pages = splitter.split(document);
                for (PDDocument next : pages) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    next.save((OutputStream)output);
                    newPdfList.add(output.toByteArray());
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (int n = 0; n < newPdfList.size(); ++n) {
            drs.moveToInsertRow();
            drs.updateBytes(ATTACTMENT_FIELD, (byte[])newPdfList.get(n));
            drs.insertRow();
        }
        drs.beforeFirst();
        return drs;
    }

    public void beforePrintOrPreview() {
    }

    public void beforePreview() {
    }

    public void beforePrint() {
    }

    public void closePreview() {
    }
}

