/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.client.RepaymentFilterParam;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.client.AbstractPayableCashBillFilterUI;
import com.kingdee.eas.fm.nt.client.CSF7SelectorSupplier;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayableCashBillFilterUI
extends AbstractPayableCashBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PayableCashBillFilterUI.class);
    private BillSourceEnum billSource;

    public PayableCashBillFilterUI(BillSourceEnum billSource) throws Exception {
        this.billSource = billSource;
    }

    public PayableCashBillFilterUI() throws Exception {
    }

    protected void init() throws Exception {
        super.init();
        if (this.billSource == BillSourceEnum.BYECDS) {
            this.chkShowNoConfirmBill.setVisible(false);
        }
        CSF7SelectorSupplier arg0 = new CSF7SelectorSupplier((IUIObject)this, this.prmtPayee);
        this.prmtPayee.setSelector((KDPromptSelector)arg0);
    }

    public void clear() {
        super.clear();
        this.chkShowNoConfirmBill.setSelected(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        RepaymentFilterParam param = (RepaymentFilterParam)super.getParam();
        param.setSourceType(2);
        param.setShowNoConfirmBill(this.chkShowNoConfirmBill.isSelected());
        if (this.billSource != null) {
            param.setSource(this.billSource.getValue());
        }
        if (this.prmtPayee != null && this.prmtPayee.getData() != null) {
            if (this.prmtPayee.getData() instanceof String) {
                param.setPrmtPayee(this.prmtPayee.getData().toString());
            } else {
                param.setPrmtPayee(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtPayee)[0]);
            }
        }
        return param;
    }

    protected Class getParamClass() {
        return RepaymentFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        super.setParam(param);
        RepaymentFilterParam filterParam = (RepaymentFilterParam)param;
        this.chkShowNoConfirmBill.setSelected(filterParam.isShowNoConfirmBill());
        try {
            if (filterParam.getPrmtPayee() != null) {
                Set set = FMHelper.asSet((String)filterParam.getPrmtPayee());
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                ev.setFilter(filter);
                SupplierCollection collSupplier = null;
                ISupplier supplier = SupplierFactory.getRemoteInstance();
                collSupplier = supplier.getSupplierCollection(ev);
                if (!EmptyUtil.isEmpty((Object)collSupplier)) {
                    this.prmtPayee.setData((Object)collSupplier.toArray());
                } else {
                    CustomerCollection collCustomer = null;
                    ICustomer customer = CustomerFactory.getRemoteInstance();
                    collCustomer = customer.getCustomerCollection(ev);
                    if (!EmptyUtil.isEmpty((Object)collCustomer)) {
                        this.prmtPayee.setData((Object)collCustomer.toArray());
                    }
                }
            }
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public boolean verify() {
        NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)this.dpBeginDate.getValue(), (Date)this.dpEndDate.getValue());
        return super.verify();
    }
}

