/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.CompanyF7Factory;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.IPayableTransferBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableTransferBillFactory;
import com.kingdee.eas.fm.nt.PayableTransferBillInfo;
import com.kingdee.eas.fm.nt.TransferBillTypeEnum;
import com.kingdee.eas.fm.nt.client.AbstractPayableTransferEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class PayableTransferEditUI
extends AbstractPayableTransferEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PayableTransferEditUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo bassCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
    private int curCurrencyPrecision = 2;
    private IObjectCollection payableCol = null;
    private CurrencyInfo curCurrency = null;
    private TransferBillTypeEnum billType = null;

    private void setCurCurrencyPrecision() {
        if (this.payableCol == null || this.payableCol.size() == 0) {
            return;
        }
        PayableBillInfo billInfo = (PayableBillInfo)this.payableCol.getObject(0);
        this.curCurrencyPrecision = billInfo.getCurrency().getPrecision();
        this.curCurrency = billInfo.getCurrency();
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtPayableBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getPayableBgItemProps()[0]);
        super.storeFields();
        String billNumber = "";
        BigDecimal amt = Constants.ZERO;
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            amt = amt.add((BigDecimal)row.getCell("amount").getValue());
            String number = row.getCell("number").getValue().toString();
            if ((billNumber + number).length() <= 250) {
                billNumber = billNumber + number + ",";
            }
            PayableBillInfo info = this.getPayableBill(row.getCell("id").getValue().toString());
            this.editData.getPayableEntrys().add(info);
        }
        if (billNumber.length() > 0) {
            billNumber = billNumber.substring(0, billNumber.length() - 1);
        }
        this.editData.setCurrency(this.curCurrency);
        this.editData.setSrcBillNumber(billNumber);
        this.editData.setAmount(amt);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.payableCol = (IObjectCollection)this.getUIContext().get("PayableColl");
        this.billType = (TransferBillTypeEnum)((Object)this.getUIContext().get("BillType"));
        if (this.payableCol == null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("transfer", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSelector().add(new SelectorItemInfo("Currency.*"));
            view.getSelector().add(new SelectorItemInfo("Type.*"));
            view.getSelector().add(new SelectorItemInfo("billMaker.*"));
            view.getSelector().add(new SelectorItemInfo("ntType.*"));
            PayableBillCollection coll = PayableBillFactory.getRemoteInstance().getPayableBillCollection(view);
            this.payableCol = coll;
            this.billType = this.editData.getTransferTpye();
            FMClientHelper.setSelectObject((KDComboBox)this.comobCurrency, (Object)this.editData.getCurrency());
        }
        this.setCurCurrencyPrecision();
        this.init();
        this.fillTable(this.payableCol);
        if (this.billType == TransferBillTypeEnum.In) {
            this.labApplyCompany.setVisible(true);
            this.labApplyCS.setVisible(false);
            this.labApplyRen.setVisible(true);
            this.labApplyRen1.setVisible(false);
            CompanyF7Factory.initCompanyBizUnitF7((IUIObject)this, (KDBizPromptBox)this.prmtApplyCompany);
        } else {
            this.labApplyCompany.setVisible(false);
            this.labApplyCS.setVisible(true);
            this.labApplyRen.setVisible(false);
            this.labApplyRen1.setVisible(true);
        }
        NTHelper.initCSF7Supplier((IUIObject)this, this.prmtApply, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierQueryWithDefaultStandardForVoucher");
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtApplicant);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, null, (boolean)true, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtPayableBgItem, null, (boolean)true, (boolean)true);
        Boolean iswf = (Boolean)this.getUIContext().get("isFromConfirm");
        if (iswf != null && iswf.booleanValue()) {
            this.pkDate.setEnabled(false);
            this.prmtApplicant.setEnabled(false);
            this.prmtApplyCompany.setEnabled(false);
            this.prmtOppAccount.setEnabled(false);
            this.prmtProject.setEnabled(false);
            this.txtDescription.setEnabled(false);
            this.prmtBgItem.setEnabled(false);
            this.prmtFundFlowItem.setEnabled(false);
            this.prmtPayableBgItem.setEnabled(true);
            this.prmtFundFlowItemRec.setEnabled(true);
        } else {
            this.prmtPayableBgItem.setEnabled(false);
            this.prmtBgItem.setEnabled(true);
            this.prmtFundFlowItem.setEnabled(true);
            this.prmtFundFlowItemRec.setEnabled(false);
        }
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, null);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.lcpayableBgItem, (KDLabelContainer)this.contFundFlowItemRec, null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData == null) {
            return;
        }
        if (this.editData.getTransferTpye() == TransferBillTypeEnum.In) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"313_PayableTransferEditUI"));
            this.prmtApplyCompany.setData((Object)this.editData.getApplyCompany());
            this.prmtApplicant.setData((Object)this.editData.getApplicant());
            if (this.editData.getConfirmer() != null) {
                FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
                this.pkDate.setEnabled(false);
                this.prmtOppAccount.setEnabled(true);
                this.prmtOppAccount.setEditable(true);
            }
        } else {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"314_PayableTransferEditUI"));
            if (this.editData.getApplyCustomer() != null) {
                this.prmtApply.setData((Object)this.editData.getApplyCustomer());
            } else if (this.editData.getApplySupplier() != null) {
                this.prmtApply.setData((Object)this.editData.getApplySupplier());
            } else {
                this.prmtApply.setValue((Object)this.editData.getApplyName());
            }
            this.txtApplicant.setText(this.editData.getApplicantName());
        }
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtPayableBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getPayableBgItemProps()[0]);
    }

    private void init() throws EASBizException, BOSException {
        FinUtils.initCurrencyComboBox((KDComboBox)this.comobCurrency);
        FMClientHelper.setSelectObject((KDComboBox)this.comobCurrency, (Object)this.curCurrency);
        this.comobCurrency.setEnabled(false);
        this.txtAmount.setEnabled(false);
        this.menuBar.setVisible(false);
        this.actionViewBgBalance.setEnabled(true);
        this.actionAttachment.setVisible(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setRemoveingZeroInDispaly(false);
    }

    private PayableBillInfo getPayableBill(String id) {
        for (PayableBillInfo element : this.payableCol) {
            if (!id.equals(element.getId().toString())) continue;
            return element;
        }
        return null;
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("applyCompany.*");
        sic.add("applicant.*");
        sic.add("fpItem.*");
        sic.add("oppAccount.*");
        sic.add("applyCustomer.*");
        sic.add("applySupplier.*");
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("fppayableItem.*"));
        sic.add(new SelectorItemInfo("payableBgItemId"));
        sic.add(new SelectorItemInfo("payableBgItemNumber"));
        sic.add(new SelectorItemInfo("payableBgItemName"));
        return sic;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.checkFinalCheckout();
        if (this.billType == TransferBillTypeEnum.In) {
            this.editData.setApplyCompany((CompanyOrgUnitInfo)this.prmtApplyCompany.getData());
            if (this.prmtApplyCompany.getData() != null) {
                this.editData.setApplyName(this.prmtApplyCompany.getData().toString());
            } else {
                this.editData.setApplyName(this.prmtApplyCompany.getText());
            }
            this.editData.setApplicant((PersonInfo)this.prmtApplicant.getData());
            this.editData.setApplicantName(this.prmtApplicant.getText());
        } else {
            this.editData.setApplySupplier(this.getSupplier(this.prmtApply.getData()));
            this.editData.setApplyCustomer(this.getCustomer(this.prmtApply.getData()));
            if (this.prmtApply.getData() != null) {
                this.editData.setApplyName(this.prmtApply.getData().toString());
            } else {
                this.editData.setApplyName(this.prmtApply.getText());
            }
            this.editData.setApplicantName(this.txtApplicant.getText());
        }
        Boolean iswf = (Boolean)this.getUIContext().get("isFromConfirm");
        if (iswf != null && iswf.booleanValue()) {
            boolean isCreateReceiving = false;
            boolean isNTAssociaWithRP = NTHelper.getParam4Boolean(null, "NT014", false);
            if (isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"isGenReceivingBill")) == 0) {
                isCreateReceiving = true;
            }
            UserInfo userinfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            this.editData.setConfirmer(userinfo);
            ((IPayableTransferBill)this.getBizInterface()).confirm((IObjectValue)this.editData, isCreateReceiving);
            super.actionSubmit_actionPerformed(e);
        } else {
            boolean isCreateReceiving = false;
            boolean isNTAssociaWithRP = NTHelper.getParam4Boolean(null, "NT014", false);
            ArrayList ids = new ArrayList();
            if (!EmptyUtil.isEmpty((Object)this.editData.getId())) {
                IBOTRelation botRelation = BOTRelationFactory.getRemoteInstance();
                ids = botRelation.getDestObjIdByDestType(this.editData.getId().toString(), new PaymentBillInfo().getBOSType().toString());
            }
            if (EmptyUtil.isEmpty(ids) && isNTAssociaWithRP && MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"isGenPaymentBill")) == 0) {
                isCreateReceiving = true;
            }
            this.editData.setCreatePayment(isCreateReceiving);
            super.actionSubmit_actionPerformed(e);
        }
        this.getUIWindow().close();
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    private CustomerInfo getCustomer(Object obj) {
        if (obj instanceof CustomerInfo) {
            return (CustomerInfo)obj;
        }
        return null;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public static void createNewTransferBill(Object owner, TransferBillTypeEnum type, IObjectCollection coll) throws EASBizException, BOSException {
        PayableTransferBillInfo billInfo = PayableTransferEditUI.createPayableTransferBill(type);
        UIContext uiCtx = new UIContext(owner);
        uiCtx.put((Object)"InitDataObject", (Object)billInfo);
        uiCtx.put((Object)"PayableColl", (Object)coll);
        uiCtx.put((Object)"BillType", (Object)type);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PayableTransferEditUI.class.getName(), (Map)uiCtx, null, OprtState.ADDNEW);
        editUI.show();
    }

    private static PayableTransferBillInfo createPayableTransferBill(TransferBillTypeEnum type) throws BOSException, EASBizException {
        PayableTransferBillInfo billInfo = new PayableTransferBillInfo();
        billInfo.setTransferDate(DateUtil.getDayBegin());
        billInfo.setTransferTpye(type);
        billInfo.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        billInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
        billInfo.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        return billInfo;
    }

    public boolean isModify() {
        return false;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PayableTransferBillFactory.getRemoteInstance();
    }

    private void fillTable(IObjectCollection coll) {
        String numberFormat_AMT = FMClientHelper.getKDTNumFormat((int)this.curCurrencyPrecision);
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        BigDecimal amt = Constants.ZERO;
        if (coll == null) {
            return;
        }
        StyleAttributes styleAttributes = null;
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = this.tblMain.addRow();
            CoreBaseInfo vo = (CoreBaseInfo)coll.getObject(i);
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)vo, (Field)new Field(this.tblMain.getColumnKey(j))));
            }
            if (vo instanceof PayableBillInfo) {
                PayableBillInfo billInfo = (PayableBillInfo)vo;
                row.getCell("number").setValue((Object)billInfo.getDraftNumber());
            }
            styleAttributes = row.getCell("amount").getStyleAttributes();
            amt = amt.add((BigDecimal)row.getCell("amount").getValue());
            styleAttributes.setNumberFormat(numberFormat_AMT);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.txtAmount.setPrecision(this.curCurrencyPrecision);
        this.txtAmount.setValue((Object)amt);
        IRow row = this.tblMain.addRow();
        row.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
        row.getCell("amount").setValue((Object)amt);
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getStyleAttributes().setNumberFormat(numberFormat_AMT);
        row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setEditable(false);
    }

    @Override
    public void prmtApplyCompany_dataChanged(DataChangeEvent e) {
        this.prmtApplicant.setData(null);
    }

    @Override
    protected void prmtApplicant_willCommit(CommitEvent e) throws Exception {
        this.setApplicantFilter();
    }

    @Override
    protected void prmtApplicant_willShow(SelectorEvent e) throws Exception {
        this.setApplicantFilter();
    }

    private void setApplicantFilter() throws BOSException {
        CompanyOrgUnitInfo orgInfo = (CompanyOrgUnitInfo)this.prmtApplyCompany.getData();
        PersonPromptBox prmtApplicantPerson = new PersonPromptBox((IUIObject)this);
        prmtApplicantPerson.showAllChildren();
        if (orgInfo != null && orgInfo.isIsAdminOrgUnit()) {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sel = new SelectorItemCollection();
            sel.add("id");
            view.setSelector(sel);
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(orgInfo.getLongNumber() + "%"), CompareType.LIKE));
            view.setFilter(filter);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId());
            }
            prmtApplicantPerson.setExpandAdmin(orgInfo.getId().toString());
            FilterItemInfo item = new FilterItemInfo("AdminOrgUnit.id", idSet, CompareType.INCLUDE);
            try {
                FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtApplicant, (FilterItemInfo)item);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
        this.prmtApplicant.setSelector((KDPromptSelector)prmtApplicantPerson);
    }

    @Override
    public void prmtOppAccount_willShow(SelectorEvent e) throws Exception {
        if (this.comobCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo info = (CurrencyInfo)this.comobCurrency.getSelectedItem();
        NTHelper.setF7AccountEvi((IUIObject)this, info.getId().toString(), this.currentCompany, this.prmtOppAccount);
    }

    @Override
    protected void prmtOppAccount_willCommit(CommitEvent e) throws Exception {
        if (this.comobCurrency.getSelectedItem() == null) {
            e.setCanceled(true);
            return;
        }
        CurrencyInfo info = (CurrencyInfo)this.comobCurrency.getSelectedItem();
        NTHelper.setF7AccountEvi((IUIObject)this, info.getId().toString(), this.currentCompany, this.prmtOppAccount);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.nt.app.PayableTransferBill", null, (IObjectValue)this.editData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkDate);
        if (this.billType == TransferBillTypeEnum.In) {
            if (EmptyUtil.isEmpty((Object)this.prmtApplyCompany.getValue())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"481_PayableTransferEditUI"));
                this.prmtApplyCompany.requestFocus();
                this.abort();
            }
        } else if (EmptyUtil.isEmpty((Object)this.prmtApply.getValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"481_PayableTransferEditUI"));
            this.prmtApply.requestFocus();
            this.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comobCurrency);
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            Date issueDate = (Date)row.getCell("IssueDate").getValue();
            Date expiredDate = (Date)row.getCell("ExpiredDate").getValue();
            if (((Date)this.pkDate.getValue()).before(issueDate)) {
                throw new NTException(NTException.TRANSFERDATEMUSTAFTERISSUEDATE);
            }
            if (!((Date)this.pkDate.getValue()).after(expiredDate)) continue;
            throw new NTException(NTException.TRANSFERDATEMUSTBEFOREEXPIREDATE);
        }
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)this.editData.getTransferDate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

