/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.IRecCheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.RecChequeFactory;
import com.kingdee.eas.fm.nt.RecChequeHelper;
import com.kingdee.eas.fm.nt.RecChequeInfo;
import com.kingdee.eas.fm.nt.RecChequeStatueEnum;
import com.kingdee.eas.fm.nt.client.AbstractRecChequeBookInUI;
import com.kingdee.eas.fm.nt.client.RecChequeTDDelegate;
import com.kingdee.eas.fm.nt.client.util.RecChequeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RecChequeBookInUI
extends AbstractRecChequeBookInUI {
    private static final Logger logger = CoreUIObject.getLogger(RecChequeBookInUI.class);
    private CurrencyInfo currency = null;

    @Override
    public void loadFields() {
        this.prmtPayer.setValue(this.getPayer());
        this.prmtRemitter.setValue(this.getRemitter());
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (RecChequeStatueEnum.RECEIPT.equals((Object)this.editData.getState())) {
            this.chkReceipt.setSelected(true);
        } else if (RecChequeStatueEnum.ABANDON.equals((Object)this.editData.getState()) && RecChequeStatueEnum.RECEIPT.equals((Object)this.editData.getAbandonState())) {
            this.chkReceipt.setSelected(true);
        } else {
            this.chkReceipt.setSelected(this.editData.isReceipt());
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.comboNtType, (Object)this.editData.getNtType());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        Object payer = this.prmtPayer.getValue();
        if (payer instanceof SupplierInfo) {
            this.editData.setPayerS((SupplierInfo)payer);
            this.editData.setPayerC(null);
            this.editData.setPayer(null);
        } else if (payer instanceof CustomerInfo) {
            this.editData.setPayerC((CustomerInfo)payer);
            this.editData.setPayerS(null);
            this.editData.setPayer(null);
        } else if (payer instanceof String) {
            this.editData.setPayer((String)payer);
            this.editData.setPayerC(null);
            this.editData.setPayerS(null);
        }
        Object remitter = this.prmtRemitter.getValue();
        if (remitter instanceof SupplierInfo) {
            this.editData.setRemitterS((SupplierInfo)remitter);
            this.editData.setRemitterC(null);
            this.editData.setRemitter(null);
        } else if (remitter instanceof CustomerInfo) {
            this.editData.setRemitterC((CustomerInfo)remitter);
            this.editData.setRemitterS(null);
            this.editData.setRemitter(null);
        } else if (remitter instanceof String) {
            this.editData.setRemitter((String)remitter);
            this.editData.setRemitterC(null);
            this.editData.setRemitterS(null);
        }
        this.editData.setReceipt(this.chkReceipt.isSelected());
        if (this.editData.isIsQuota()) {
            this.editData.setAmount(null);
        } else {
            this.editData.setCeiling(null);
        }
    }

    public void onLoad() throws Exception {
        this.currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.currentCompany);
        if (!this.currentCompany.isIsBizUnit() && (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()))) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        Map listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtamount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtceiling);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtreceiptAmount);
        RecChequeUtil.initComboNtType(this.comboNtType);
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
        super.onLoad();
        RecChequeUtil.initPrmtSupplierCustomer((IUIObject)this, this.prmtPayer, this.currentCompany);
        RecChequeUtil.initPrmtSupplierCustomer((IUIObject)this, this.prmtRemitter, this.currentCompany);
        RecChequeUtil.initPrmtAdminOrg((IUIObject)this, this.prmtdepartment);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtDealer);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtpayeeBank);
        RecChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtpayeeBankAcct, this.currentCompany, null, null);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
        this.actionAuditResult.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.setBizActionState(OprtState.VIEW.equals(this.getOprtState()));
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        this.btnViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.mentViewBdg.setVisible(true);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(company);
        String boName = "com.kingdee.eas.fm.nt.app.RecCheque";
        BgCtrlParamCollection coll = new BgCtrlParamCollection();
        coll.add(RecChequeBookInUI.getParam(this.editData));
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)boName, (BgCtrlParamCollection)coll, (IObjectValue)this.editData);
    }

    private static BgCtrlParamInfo getParam(RecChequeInfo info) {
        BgCtrlParamInfo ctrlInfo = new BgCtrlParamInfo();
        if (info.getId() != null) {
            ctrlInfo.setSrcBillId(info.getId().toString());
        }
        ctrlInfo.setSrcBillNumber(info.getNumber());
        ctrlInfo.setOrgUnitId(info.getCompany().getId().toString());
        ctrlInfo.setBizDate(info.getBizDate());
        ctrlInfo.setCurrencyId(info.getCurrency().getId().toString());
        ctrlInfo.setCurrencyNumber(info.getCurrency().getNumber());
        if (info.getProject() != null) {
            ctrlInfo.setItemCombinNumber(info.getProject().getNumber());
            ctrlInfo.setItemCombinName(info.getProject().getName());
        }
        ctrlInfo.setAmount(info.getAmount());
        return ctrlInfo;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setVisible(true);
        this.actionSave.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkflowList.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionRemoveLine.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionPre.setVisible(true);
        this.actionFirst.setVisible(true);
        this.actionNext.setVisible(true);
        this.actionLast.setVisible(true);
        RecChequeInfo info = (RecChequeInfo)this.getDataObject();
        int precision = info.getCurrency().getPrecision();
        if (precision == 0) {
            precision = 2;
        }
        this.txtamount.setPrecision(precision);
        this.txtceiling.setPrecision(precision);
        this.txtreceiptAmount.setPrecision(precision);
    }

    protected void initViewStatus() {
        super.initViewStatus();
        RecChequeInfo info = (RecChequeInfo)this.getDataObject();
        FMClientHelper.setCompEnable((IKDComponent[])this.getBookComponents(), (boolean)true);
        FMClientHelper.setCompEnable((IKDComponent[])this.getReceiptComponents(), (boolean)true);
        RecChequeUtil.setComponentsRequired(this.getReceiptComponents(), false);
        if (RecChequeStatueEnum.ABANDON.equals((Object)info.getState()) || RecChequeHelper.isAlreadyGenBill(info)) {
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(false);
        }
        if (FSClientHelper.isClearingHouseCompany((CompanyOrgUnitInfo)this.currentCompany) && !this.currentCompany.getId().equals((Object)info.getCompany().getId())) {
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(false);
        }
        if (!this.currentCompany.isIsBizUnit()) {
            this.actionAddNew.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionCopy.setEnabled(false);
        }
    }

    protected void initAddNewStatus() {
        super.initAddNewStatus();
        FMClientHelper.setCompEnable((IKDComponent[])this.getBookComponents(), (boolean)true);
        FMClientHelper.setCompEnable((IKDComponent[])this.getReceiptComponents(), (boolean)true);
        RecChequeUtil.setComponentsRequired(this.getBookRequiedComponents(), true);
        this.initReceiptFieldState();
        this.initQuatoField();
    }

    protected void initEditStatus() {
        super.initEditStatus();
        RecChequeInfo info = (RecChequeInfo)this.getDataObject();
        this.actionPre.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        if (RecChequeStatueEnum.ABANDON.equals((Object)info.getState()) || info.getJouranl() != null || info.isFivouchered()) {
            FMClientHelper.setCompEnable((IKDComponent[])this.getBookComponents(), (boolean)false);
            FMClientHelper.setCompEnable((IKDComponent[])this.getReceiptComponents(), (boolean)false);
        } else if (RecChequeStatueEnum.NEW.equals((Object)info.getState())) {
            FMClientHelper.setCompEnable((IKDComponent[])this.getBookComponents(), (boolean)true);
            FMClientHelper.setCompEnable((IKDComponent[])this.getReceiptComponents(), (boolean)true);
            this.initReceiptFieldState();
            this.initQuatoField();
        } else if (RecChequeStatueEnum.RECEIPT.equals((Object)info.getState())) {
            FMClientHelper.setCompEnable((IKDComponent[])this.getBookComponents(), (boolean)false);
            FMClientHelper.setCompEnable((IKDComponent[])this.getReceiptComponents(), (boolean)false);
            RecChequeUtil.setComponentsRequired(this.getBookComponents(), false);
            this.prmtoppAcct.setEnabled(true);
        } else if (RecChequeStatueEnum.ENDORSE.equals((Object)info.getState())) {
            FMClientHelper.setCompEnable((IKDComponent[])this.getBookComponents(), (boolean)false);
            FMClientHelper.setCompEnable((IKDComponent[])this.getReceiptComponents(), (boolean)false);
            this.prmtoppAcct.setEnabled(true);
        }
    }

    protected void initFindViewStatus() {
        super.initFindViewStatus();
        FMClientHelper.setCompEnable((IKDComponent[])this.getBookComponents(), (boolean)true);
        FMClientHelper.setCompEnable((IKDComponent[])this.getReceiptComponents(), (boolean)true);
        RecChequeUtil.setComponentsRequired(this.getBookComponents(), false);
        RecChequeUtil.setComponentsRequired(this.getReceiptComponents(), false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionRecord.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        newData.setNull("id");
        newData.setNull("number");
        newData.setNull("endorseDate");
        newData.setNull("endorser");
        newData.setNull("endorserS");
        newData.setNull("endorserC");
        newData.setNull("abandonDate");
        newData.setNull("abandonReason");
        newData.setNull("abandonState");
        newData.setNull("jouranl");
        newData.setBoolean("fivouchered", false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.editData.getIssueDate().compareTo(this.editData.getExpiredDate()) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"327_RecChequeBookInUI"));
            this.pkexpiredDate.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.isReceipt()) {
            CurrencyInfo currencyInfo;
            BankInfo bank = this.editData.getPayeeBank();
            AccountBankInfo acct = this.editData.getPayeeBankAcct();
            CurrencyInfo currency = this.editData.getCurrency();
            if (acct != null && bank != null && acct.getBank() != null && !acct.getBank().getId().equals((Object)bank.getId())) {
                throw new NTException(NTException.BANKNOTMATCH);
            }
            if (acct != null && currency != null && (currencyInfo = acct.getCurrency()) instanceof CurrencyInfo && !currencyInfo.getId().equals((Object)currency.getId())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"328_RecChequeBookInUI"));
                this.prmtpayeeBankAcct.requestFocus();
                SysUtil.abort();
            }
            if (this.editData.getReceiveDate().compareTo(this.editData.getReceiptDate()) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"329_RecChequeBookInUI"));
                this.pkreceiptDate.requestFocus();
                SysUtil.abort();
            }
            if (this.editData.getReceiptDate().compareTo(this.editData.getExpiredDate()) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"330_RecChequeBookInUI"));
                this.pkreceiptDate.requestFocus();
                SysUtil.abort();
            }
            if (this.editData.isIsQuota() && (Constants.ZERO.compareTo(this.editData.getReceiptAmount()) >= 0 || this.editData.getReceiptAmount().compareTo(this.editData.getCeiling()) > 0)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"331_RecChequeBookInUI"));
                this.txtreceiptAmount.requestFocus();
                SysUtil.abort();
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("payeeBank.*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.*"));
        sic.add(new SelectorItemInfo("department.*"));
        sic.add(new SelectorItemInfo("oppAcct.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("dealer.*"));
        sic.add(new SelectorItemInfo("receiptAcct.*"));
        sic.add(new SelectorItemInfo("payerS.name"));
        sic.add(new SelectorItemInfo("payerS.number"));
        sic.add(new SelectorItemInfo("payerC.name"));
        sic.add(new SelectorItemInfo("payerC.number"));
        sic.add(new SelectorItemInfo("remitterS.name"));
        sic.add(new SelectorItemInfo("remitterS.number"));
        sic.add(new SelectorItemInfo("remitterC.name"));
        sic.add(new SelectorItemInfo("remitterC.number"));
        sic.add(new SelectorItemInfo("Pproject.id"));
        sic.add(new SelectorItemInfo("Pproject.name"));
        sic.add(new SelectorItemInfo("Pproject.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        return sic;
    }

    @Override
    protected IObjectValue createNewData() {
        RecChequeInfo objectValue = null;
        if (this.getUIContext().get("RECCHEQUEID") != null) {
            String id = (String)this.getUIContext().get("RECCHEQUEID");
            this.getUIContext().put("RECCHEQUEID", null);
            try {
                objectValue = RecChequeFactory.getRemoteInstance().getRecChequeInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
                if (RecChequeStatueEnum.RECEIPT.equals((Object)objectValue.getState())) {
                    objectValue.setReceipt(true);
                }
                this.setFieldsNull((AbstractObjectValue)objectValue);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                objectValue = new RecChequeInfo();
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                objectValue = new RecChequeInfo();
            }
            if (objectValue.getState() == RecChequeStatueEnum.ABANDON) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"332_RecChequeBookInUI"));
                SysUtil.abort();
            }
            if (RecChequeStatueEnum.ENDORSE == objectValue.getState()) {
                objectValue.setState(RecChequeStatueEnum.NEW);
            }
        } else {
            objectValue = new RecChequeInfo();
            objectValue.setIsQuota(false);
            objectValue.setReceipt(false);
            objectValue.setCurrency(this.currency);
            Date date = DateTimeUtils.truncateDate((Date)new Date());
            objectValue.setReceiveDate(date);
            objectValue.setIssueDate(date);
            objectValue.setExpiredDate(DateTimeUtils.addDay((Date)date, (long)10L));
            objectValue.setState(RecChequeStatueEnum.NEW);
        }
        objectValue.setCompany(this.currentCompany);
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return objectValue;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.pkreceiveDate.requestFocus();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (FMHelper.isEmpty((Object)this.prmtRemitter.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"482_RecChequeBookInUI"));
            this.prmtRemitter.requestFocus();
            SysUtil.abort();
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.editData.setEdit(true);
        }
        super.actionSubmit_actionPerformed(e);
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
        this.setBizActionState(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.actionTDPrint.setEnabled(false);
        this.actionTDPrintPreview.setEnabled(false);
        this.actionRecord.setEnabled(false);
        super.actionCopy_actionPerformed(e);
    }

    @Override
    public void actionRecord_actionPerformed(ActionEvent e) throws Exception {
        super.actionRecord_actionPerformed(e);
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"333_RecChequeBookInUI"));
            SysUtil.abort();
        }
        if (!this.editData.getState().equals((Object)RecChequeStatueEnum.RECEIPT)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"323_RecChequeBatchBookUI"));
            SysUtil.abort();
        }
        IRecCheque recCheque = RecChequeFactory.getRemoteInstance();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        recCheque.record(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"334_RecChequeBookInUI"));
        this.actionRecord.setEnabled(false);
        this.actionSubmit.setEnabled(false);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        RecChequeTDDelegate data = new RecChequeTDDelegate(idList, true);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/RecCheque", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        RecChequeTDDelegate data = new RecChequeTDDelegate(idList, false);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/RecCheque", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setBizActionState(true);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setBizActionState(true);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setBizActionState(true);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setBizActionState(true);
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currency;
        super.comboCurrency_itemStateChanged(e);
        if (e.getStateChange() == 1 && (currency = (CurrencyInfo)this.comboCurrency.getSelectedItem()) != null) {
            this.txtamount.setPrecision(currency.getPrecision());
            this.txtceiling.setPrecision(currency.getPrecision());
            this.txtreceiptAmount.setPrecision(currency.getPrecision());
        }
    }

    @Override
    protected void chkisQuota_itemStateChanged(ItemEvent e) throws Exception {
        Object o;
        boolean isReceipt;
        boolean isQuato;
        super.chkisQuota_itemStateChanged(e);
        boolean bl = isQuato = e.getStateChange() == 1;
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()) && RecChequeStatueEnum.NEW.equals((Object)this.editData.getState())) {
            this.setQuatoField(isQuato, true);
        }
        if ((isReceipt = this.chkReceipt.isSelected()) && (o = this.comboNtType.getSelectedItem()) instanceof NTTypeInfo) {
            NTTypeInfo nt = (NTTypeInfo)o;
            BigDecimal amount = Constants.ZERO;
            amount = !isQuato ? this.txtamount.getBigDecimalValue() : this.txtceiling.getBigDecimalValue();
            this.updateReceiptFieldState(isReceipt, nt.isIsCash(), isQuato, amount, true);
        }
    }

    @Override
    protected void chkReceipt_itemStateChanged(ItemEvent e) throws Exception {
        super.chkReceipt_itemStateChanged(e);
        Object o = this.comboNtType.getSelectedItem();
        boolean isCash = true;
        boolean isQuato = this.chkisQuota.isSelected();
        if (o instanceof NTTypeInfo) {
            NTTypeInfo nt = (NTTypeInfo)o;
            isCash = nt.isIsCash();
        }
        boolean isReceipt = e.getStateChange() == 1;
        BigDecimal amount = Constants.ZERO;
        if (this.txtamount.isEnabled()) {
            amount = this.txtamount.getBigDecimalValue();
        }
        if (this.txtceiling.isEnabled()) {
            amount = this.txtceiling.getBigDecimalValue();
        }
        this.updateReceiptFieldState(isReceipt, isCash, isQuato, amount, true);
    }

    @Override
    protected void comboNtType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboNtType_itemStateChanged(e);
        boolean isReceipt = this.chkReceipt.isSelected();
        if (isReceipt) {
            NTTypeInfo nt = (NTTypeInfo)e.getItem();
            boolean isCash = nt.isIsCash();
            boolean isQuato = this.chkisQuota.isSelected();
            BigDecimal amount = Constants.ZERO;
            if (!isQuato) {
                amount = this.txtamount.getBigDecimalValue();
            }
            if (this.txtceiling.isEnabled()) {
                amount = this.txtceiling.getBigDecimalValue();
            }
            this.updateReceiptFieldState(isReceipt, isCash, isQuato, amount, true);
        }
    }

    @Override
    protected void prmtpayeeBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtpayeeBankAcct_dataChanged(e);
        Object v = e.getNewValue();
        if (v instanceof AccountBankInfo) {
            NTTypeInfo nt;
            AccountBankInfo acct = (AccountBankInfo)v;
            if (acct.getBank().getId() != null) {
                BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(acct.getBank().getId()));
                this.prmtpayeeBank.setValue((Object)bank);
            }
            if ((nt = (NTTypeInfo)this.comboNtType.getSelectedItem()) != null && !nt.isIsCash() && acct.getAccount() != null) {
                AccountViewInfo acctView = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(acct.getAccount().getId()));
                this.prmtreceiptAcct.setValue((Object)acctView);
            }
        }
    }

    @Override
    protected void prmtpayeeBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtpayeeBank_dataChanged(e);
    }

    @Override
    protected void prmtpayeeBankAcct_willCommit(CommitEvent e) throws Exception {
        Object c;
        super.prmtpayeeBankAcct_willCommit(e);
        BankInfo bank = null;
        CurrencyInfo currency = null;
        Object v = this.prmtpayeeBank.getValue();
        if (v instanceof BankInfo) {
            bank = (BankInfo)v;
        }
        if ((c = this.comboCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            currency = (CurrencyInfo)c;
        }
        RecChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtpayeeBankAcct, this.currentCompany, bank, currency);
    }

    @Override
    protected void prmtpayeeBankAcct_willShow(SelectorEvent e) throws Exception {
        Object c;
        super.prmtpayeeBankAcct_willShow(e);
        BankInfo bank = null;
        CurrencyInfo currency = null;
        Object v = this.prmtpayeeBank.getValue();
        if (v instanceof BankInfo) {
            bank = (BankInfo)v;
        }
        if ((c = this.comboCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            currency = (CurrencyInfo)c;
        }
        RecChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtpayeeBankAcct, this.currentCompany, bank, currency);
    }

    @Override
    protected void prmtreceiptAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtreceiptAcct_willShow(e);
        this.initAcctView(this.prmtreceiptAcct, true);
    }

    @Override
    protected void prmtreceiptAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtreceiptAcct_willCommit(e);
        this.initAcctView(this.prmtreceiptAcct, true);
    }

    @Override
    protected void prmtoppAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtoppAcct_willShow(e);
        this.initAcctView(this.prmtoppAcct, false);
    }

    @Override
    protected void prmtoppAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtoppAcct_willCommit(e);
        this.initAcctView(this.prmtoppAcct, false);
    }

    @Override
    protected void prmtPayer_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayer_dataChanged(e);
        Object c = e.getNewValue();
        if (c instanceof SupplierInfo) {
            SupplierInfo info = (SupplierInfo)c;
            this.prmtRemitter.setValue((Object)info);
            CSBankInfo cs = FMHelper.getCSBankInfo(null, (Object)info, (String)this.currentCompany.getId().toString());
            if (cs.getBank() != null) {
                this.txtpayerBank.setText(cs.getBank());
            }
            if (cs.getBankAccount() != null) {
                this.txtpayerBankAcct.setText(cs.getBankAccount());
            }
        } else if (c instanceof CustomerInfo) {
            CustomerInfo info = (CustomerInfo)c;
            this.prmtRemitter.setValue((Object)info);
            CSBankInfo cs = FMHelper.getCSBankInfo(null, (Object)info, (String)this.currentCompany.getId().toString());
            if (cs.getBank() != null) {
                this.txtpayerBank.setText(cs.getBank());
            }
            if (cs.getBankAccount() != null) {
                this.txtpayerBankAcct.setText(cs.getBankAccount());
            }
        } else if (c instanceof String) {
            this.prmtRemitter.setValue(c);
        }
    }

    @Override
    protected void txtamount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtamount_dataChanged(e);
        if (this.txtamount.isEnabled() && this.chkReceipt.isSelected() && !this.txtreceiptAmount.isEnabled()) {
            this.txtreceiptAmount.setValue((Object)this.txtamount.getBigDecimalValue());
        }
    }

    @Override
    protected void pkissueDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkissueDate_dataChanged(e);
        if (this.pkissueDate.getTimestamp() != null) {
            this.pkexpiredDate.setValue((Object)DateTimeUtils.addDay((Date)this.pkissueDate.getTimestamp(), (long)10L));
        }
    }

    private void initAcctView(KDBizPromptBox box, boolean isCash) throws EASBizException, BOSException {
        Object item = this.comboCurrency.getSelectedItem();
        CurrencyInfo currency = item instanceof CurrencyInfo ? (CurrencyInfo)item : FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.currentCompany);
        String id = isCash ? currency.getId().toString() : null;
        RecChequeUtil.initPrmtAcctView((IUIObject)this, box, this.currentCompany, id, isCash);
    }

    private void setBizActionState(boolean isSaved) {
        if (isSaved && this.currentCompany.isIsBizUnit()) {
            boolean receipt = false;
            boolean notRecorded = false;
            if (RecChequeStatueEnum.RECEIPT.equals((Object)this.editData.getState())) {
                this.editData.setReceipt(true);
                receipt = true;
                notRecorded = this.editData.getJouranl() == null;
            }
            this.actionTDPrint.setEnabled(receipt);
            this.actionTDPrintPreview.setEnabled(receipt);
            this.actionRecord.setEnabled(notRecorded);
        } else {
            this.actionTDPrint.setEnabled(false);
            this.actionTDPrintPreview.setEnabled(false);
            this.actionRecord.setEnabled(false);
        }
    }

    private void initReceiptFieldState() {
        RecChequeInfo info = (RecChequeInfo)this.getDataObject();
        boolean isCash = true;
        if (info.getNtType() != null) {
            isCash = info.getNtType().isIsCash();
        }
        BigDecimal amount = info.isIsQuota() ? info.getCeiling() : info.getAmount();
        this.updateReceiptFieldState(info.isReceipt(), isCash, info.isIsQuota(), amount, false);
    }

    private void updateReceiptFieldState(boolean isReceipt, boolean isCash, boolean isQuato, BigDecimal amount, boolean isEvent) {
        RecChequeInfo info = (RecChequeInfo)this.getDataObject();
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()) && RecChequeStatueEnum.NEW.equals((Object)info.getState())) {
            this.setReceiptField(isCash, isQuato, isReceipt, amount, isEvent);
        }
    }

    private void setReceiptField(boolean isCash, boolean isQuato, boolean isReceipt, BigDecimal amount, boolean isEvent) {
        this.pkreceiptDate.setEnabled(isReceipt);
        this.pkreceiptDate.setRequired(isReceipt);
        this.txtreceiptAmount.setEnabled(isQuato && isReceipt);
        this.txtreceiptAmount.setRequired(isReceipt);
        if (isEvent && isReceipt) {
            this.txtreceiptAmount.setValue((Object)amount);
        }
        this.prmtpayeeBank.setEnabled(!isCash && isReceipt);
        this.prmtpayeeBank.setRequired(!isCash && isReceipt);
        if (isCash && isEvent && isReceipt) {
            this.prmtpayeeBank.setValue(null);
        }
        this.prmtpayeeBankAcct.setEnabled(!isCash && isReceipt);
        this.prmtpayeeBankAcct.setRequired(!isCash && isReceipt);
        this.prmtreceiptAcct.setEnabled(isCash && isReceipt);
        this.prmtreceiptAcct.setRequired(isCash && isReceipt);
        if (!isCash && isEvent && isReceipt && this.prmtpayeeBankAcct.getValue() == null) {
            this.prmtreceiptAcct.setValue(null);
        }
        this.prmtoppAcct.setEnabled(isReceipt);
        this.prmtProject.setEnabled(isReceipt);
        this.prmtBgItem.setEnabled(isReceipt);
        this.prmtFundFlowItem.setEnabled(isReceipt);
        this.txtDescription.setEnabled(isReceipt);
        if (!isReceipt) {
            this.txtDescription.setText(null);
            this.pkreceiptDate.setValue(null);
            this.prmtProject.setValue(null);
            this.prmtBgItem.setValue(null);
            this.prmtFundFlowItem.setValue(null);
            this.txtreceiptAmount.setValue(null);
            this.prmtpayeeBank.setValue(null);
            this.prmtoppAcct.setValue(null);
            this.prmtreceiptAcct.setValue(null);
            this.prmtpayeeBankAcct.setValue(null);
        }
    }

    private void initQuatoField() {
        RecChequeInfo info = (RecChequeInfo)this.getDataObject();
        this.setQuatoField(info.isIsQuota(), false);
    }

    private void setQuatoField(boolean isQuato, boolean isEvent) {
        this.txtceiling.setRequired(isQuato);
        this.txtceiling.setEnabled(isQuato);
        this.txtamount.setRequired(!isQuato);
        this.txtamount.setEnabled(!isQuato);
        if (isEvent) {
            if (isQuato) {
                this.txtamount.setValue(null);
            } else {
                this.txtceiling.setValue(null);
            }
        }
    }

    private IKDComponent[] getBookComponents() {
        return new IKDComponent[]{this.pkreceiveDate, this.pkissueDate, this.pkexpiredDate, this.comboCurrency, this.comboNtType, this.prmtDealer, this.prmtdepartment, this.prmtPayer, this.prmtRemitter, this.txtamount, this.txtceiling, this.txtNumber, this.txtpayerBank, this.txtpayerBankAcct, this.txtusage, this.chkisQuota};
    }

    private IKDComponent[] getBookRequiedComponents() {
        return new IKDComponent[]{this.pkreceiveDate, this.pkissueDate, this.pkexpiredDate, this.comboCurrency, this.comboNtType, this.prmtRemitter, this.txtNumber};
    }

    private IKDComponent[] getReceiptComponents() {
        return new IKDComponent[]{this.chkReceipt, this.pkreceiptDate, this.txtreceiptAmount, this.prmtpayeeBank, this.prmtpayeeBankAcct, this.prmtProject, this.prmtBgItem, this.prmtoppAcct, this.prmtreceiptAcct, this.txtDescription};
    }

    private Object getPayer() {
        String c = null;
        if (this.editData.getPayer() != null) {
            c = this.editData.getPayer();
        } else if (this.editData.getPayerS() != null) {
            c = this.editData.getPayerS();
        } else if (this.editData.getPayerC() != null) {
            c = this.editData.getPayerC();
        }
        return c;
    }

    private Object getRemitter() {
        String c = null;
        if (this.editData.getRemitter() != null) {
            c = this.editData.getRemitter();
        } else if (this.editData.getRemitterS() != null) {
            c = this.editData.getRemitterS();
        } else if (this.editData.getRemitterC() != null) {
            c = this.editData.getRemitterC();
        }
        return c;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        if (RecChequeStatueEnum.ENDORSE == this.editData.getState()) {
            return "endorsedate";
        }
        return "receiptDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionEdit", "actionSubmit"};
    }
}

