/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.FundBgF7Manager;
import com.kingdee.eas.fm.common.client.TableBindHandler;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.nt.IRecCheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.RecChequeCollection;
import com.kingdee.eas.fm.nt.RecChequeFactory;
import com.kingdee.eas.fm.nt.RecChequeHelper;
import com.kingdee.eas.fm.nt.RecChequeInfo;
import com.kingdee.eas.fm.nt.client.AbstractRecChequeEndorseUI;
import com.kingdee.eas.fm.nt.client.util.RecChequeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JComponent;

public class RecChequeEndorseUI
extends AbstractRecChequeEndorseUI {
    private final CompanyOrgUnitInfo currentCompany;
    private final CurrencyInfo currency;
    private boolean isSave = true;
    private RecChequeCollection editDatas = new RecChequeCollection();
    private TableBindHandler tableHandler = new TableBindHandler();
    private FundBgF7Manager fundBg = new FundBgF7Manager();

    public RecChequeEndorseUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.currentCompany);
    }

    public void onLoad() throws Exception {
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        this.initTable();
        RecChequeUtil.initComboNtType(this.comboNtType);
        this.comboNtType.removeItemAt(0);
        super.onLoad();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        RecChequeUtil.initPrmtSupplierCustomer((IUIObject)this, this.prmtEndorser, this.currentCompany);
        RecChequeUtil.initPrmtAcctView((IUIObject)this, this.prmtOppAcct, this.currentCompany, this.currency.getId().toString(), false);
        RecChequeUtil.initPrmtNumber(this.currentCompany, this.prmtNumber, "ENDORSER", this.getSelectors(), this.getNTTypeInfo());
        if (this.editData.getNtType() == null) {
            this.comboNtType.setSelectedIndex(0);
        }
        this.MenuItemView.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.btnViewBdg.setVisible(true);
        this.contBgItem.setVisible(false);
        this.contBgDimension.setVisible(false);
        this.actionViewBdgBalance.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        Object c = this.prmtEndorser.getValue();
        if (c instanceof SupplierInfo) {
            this.editData.setEndorserS((SupplierInfo)c);
            this.editData.setEndorserC(null);
            this.editData.setEndorser(null);
        } else if (c instanceof CustomerInfo) {
            this.editData.setEndorserC((CustomerInfo)c);
            this.editData.setEndorserS(null);
            this.editData.setEndorser(null);
        } else if (c instanceof String) {
            this.editData.setEndorser((String)c);
            this.editData.setEndorserC(null);
            this.editData.setEndorserS(null);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.setSelectObject((KDComboBox)this.comboNtType, (Object)this.editData.getNtType());
        this.prmtNumber.setValue((Object)this.editDatas.toArray());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        this.editData.setCompany(company);
        String boName = "com.kingdee.eas.fm.nt.app.RecCheque";
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)boName, null, (IObjectValue)this.editData);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("payeeBank.*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.*"));
        sic.add(new SelectorItemInfo("department.*"));
        sic.add(new SelectorItemInfo("oppAcct.*"));
        sic.add(new SelectorItemInfo("dealer.*"));
        sic.add(new SelectorItemInfo("remitterS.name"));
        sic.add(new SelectorItemInfo("remitterC.name"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        return sic;
    }

    protected IObjectValue createNewData() {
        RecChequeInfo info;
        ArrayList list = (ArrayList)this.getUIContext().get("RECCHEQUEIDS");
        if (list == null) {
            info = new RecChequeInfo();
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
            evi.setFilter(filter);
            evi.setSelector(this.getSelectors());
            try {
                this.editDatas = RecChequeFactory.getRemoteInstance().getRecChequeCollection(evi);
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            info = this.editDatas.get(0);
        }
        info.setEndorseDate(new Date());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RecChequeFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBdgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionSubmitOption.setVisible(false);
    }

    public boolean isModify() {
        return !this.isSave && super.isModify();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.comboNtType.requestFocus();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtEndorser, (boolean)true);
        int l = this.editDatas.size();
        for (int i = 0; i < l; ++i) {
            RecChequeInfo info = this.editDatas.get(i);
            if (info.getIssueDate().compareTo(info.getEndorseDate()) <= 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"335_RecChequeEndorseUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeTableFields();
        this.verifyInput(e);
        this.checkFinalCheckout();
        ((IRecCheque)this.getBizInterface()).endorse(this.editDatas);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"336_RecChequeEndorseUI"));
        this.actionSubmit.setEnabled(false);
        FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
        this.isSave = true;
    }

    @Override
    protected void comboNtType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboNtType_itemStateChanged(e);
        NTTypeInfo ntType = this.getNTTypeInfo();
        if (ntType != null) {
            this.prmtNumber.setValue(null);
            FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtNumber, (FilterItemInfo)new FilterItemInfo("ntType.id", (Object)ntType.getId()));
        }
    }

    private NTTypeInfo getNTTypeInfo() {
        Object obj = this.comboNtType.getSelectedItem();
        if (obj != null && obj instanceof NTTypeInfo) {
            return (NTTypeInfo)obj;
        }
        return null;
    }

    @Override
    protected void prmtNumber_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtNumber_dataChanged(e);
        AccessHelper.getF7Datas((KDBizPromptBox)this.prmtNumber, (IObjectCollection)this.editDatas);
        this.loadTableFields((IObjectCollection)this.editDatas);
        this.isSave = false;
    }

    @Override
    protected void prmtNumber_preChange(PreChangeEvent e) throws Exception {
        super.prmtNumber_preChange(e);
        Object c = e.getData();
        if (c instanceof Object[]) {
            Object[] data = (Object[])c;
            if (data.length < 2) {
                e.setResult(1);
                return;
            }
            RecChequeCollection coll = new RecChequeCollection();
            int l = data.length;
            for (int i = 0; i < l; ++i) {
                coll.add((RecChequeInfo)data[i]);
            }
            if (!RecChequeHelper.isCanEndorse(coll)) {
                e.setResult(-1);
            }
        } else if (c instanceof RecChequeInfo) {
            e.setResult(1);
        } else {
            e.setResult(-1);
        }
    }

    private void initTable() throws EASBizException, BOSException {
        this.tblMain.putBindContents("editData", this.getTableBindingFields());
        this.tblMain.checkParsed();
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)false);
        KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)false, null);
        int pre = this.currency.getPrecision();
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isQuota");
        RecChequeUtil.initFormattedTextCell(this.tblMain, "ceiling", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "amount", pre);
        KDComboBox comboNtType = RecChequeUtil.initComboBoxCell(this.tblMain, "ntType");
        KDComboBox comboCurrency = RecChequeUtil.initComboBoxCell(this.tblMain, "currency");
        RecChequeUtil.initComboNtType(comboNtType);
        FMClientHelper.initComboCurrency((KDComboBox)comboCurrency);
        this.tblMain.getColumn("ntType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("currency").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("isQuota").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("ceiling").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("amount").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("remitter").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("expiredDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("number").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("remitter").getStyleAttributes().setNumberFormat("@");
    }

    private void loadTableFields(IObjectCollection coll) {
        this.tableHandler.bindDataToTable(this.tblMain, coll);
        if (coll == null || coll.size() <= 0) {
            return;
        }
        int pre = this.editDatas.get(0).getCurrency().getPrecision();
        RecChequeUtil.initFormattedTextCell(this.tblMain, "ceiling", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "amount", pre);
        BigDecimal amountSum = Constants.ZERO;
        int l = this.tblMain.getRowCount();
        for (int i = 0; i < l; ++i) {
            ICell cAmount = this.tblMain.getRow(i).getCell("amount");
            ICell cRemitter = this.tblMain.getRow(i).getCell("remitter");
            cRemitter.setValue(this.getRemitter(i));
            Object amount = cAmount.getValue();
            if (!(amount instanceof BigDecimal)) continue;
            amountSum = amountSum.add((BigDecimal)amount);
        }
        String numberFmt = FMClientHelper.getNumberFtm((int)pre);
        this.insertSumRow(amountSum, numberFmt);
    }

    private void storeTableFields() {
        this.tableHandler.bindTableToData(this.tblMain, (IObjectCollection)this.editDatas, RecChequeInfo.class.getName());
        this.storeFields();
        if (this.editDatas != null && this.editDatas.size() > 0) {
            this.editDatas.removeObject(this.editDatas.size() - 1);
        }
        int l = this.editDatas.size();
        for (int i = 0; i < l; ++i) {
            RecChequeInfo info = this.editDatas.get(i);
            info.setEndorseDate(this.editData.getEndorseDate());
            info.setEndorser(this.editData.getEndorser());
            info.setEndorserC(this.editData.getEndorserC());
            info.setEndorserS(this.editData.getEndorserS());
            info.setPayeeBank(this.editData.getPayeeBank());
            info.setPayeeBankAcct(this.editData.getPayeeBankAcct());
            info.setOppAcct(this.editData.getOppAcct());
            info.setDescription(this.editData.getDescription());
            info.setOutBgItemId(this.editData.getOutBgItemId());
            info.setOutBgItemName(this.editData.getOutBgItemName());
            info.setOutBgItemNumber(this.editData.getOutBgItemNumber());
            info.setPproject(this.editData.getPproject());
        }
    }

    private String[] getTableBindingFields() {
        return new String[]{"ntType", "number", "expiredDate", "remitter", "isQuota", "ceiling", "currency", "amount"};
    }

    private void insertSumRow(BigDecimal amountSum, String formatString) {
        if (amountSum == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
        row.getCell("amount").setValue((Object)amountSum);
        row.getCell("amount").getStyleAttributes().setNumberFormat(formatString);
    }

    private Object getRemitter(int i) {
        String c = null;
        if (this.editDatas.get(i).getRemitter() != null) {
            c = this.editDatas.get(i).getRemitter();
        } else if (this.editDatas.get(i).getRemitterS() != null) {
            c = this.editDatas.get(i).getRemitterS().getName();
        } else if (this.editDatas.get(i).getRemitterC() != null) {
            c = this.editDatas.get(i).getRemitterC().getName();
        }
        return c;
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)this.editData.getEndorseDate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

