/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMBudgetFacadeFactory;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFmMbgUsed;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.FundBgF7TableManager;
import com.kingdee.eas.fm.common.client.TableBindHandler;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.nt.IRecCheque;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.RecChequeCollection;
import com.kingdee.eas.fm.nt.RecChequeFactory;
import com.kingdee.eas.fm.nt.RecChequeHelper;
import com.kingdee.eas.fm.nt.RecChequeInfo;
import com.kingdee.eas.fm.nt.client.AbstractRecChequeReceiptUI;
import com.kingdee.eas.fm.nt.client.RecChequeTDDelegate;
import com.kingdee.eas.fm.nt.client.util.RecChequeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.ma.budget.client.BgBalanceViewUI;
import com.kingdee.eas.ma.control.BgControlFacadeFactory;
import com.kingdee.eas.ma.control.face.IBudgetBalance;
import com.kingdee.eas.ma.fm.client.FmMbgBalanceUI4Cheque;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RecChequeReceiptUI
extends AbstractRecChequeReceiptUI {
    private final CompanyOrgUnitInfo currentCompany;
    private final CurrencyInfo currency;
    private boolean isSave = true;
    private static final Color c = new Color(0xF6F6BF);
    private RecChequeCollection editDatas = new RecChequeCollection();
    private TableBindHandler tableHandler = new TableBindHandler();
    private FundBgF7TableManager fundBgTable = new FundBgF7TableManager();

    public RecChequeReceiptUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.currentCompany);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadTableFields((IObjectCollection)this.editDatas);
        int n = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            FMClientHelper.loadFieldsBgItem((ICell)this.tblMain.getCell(i, "bgItem"), (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        }
        this.fundBgTable.initFundBgF7((CoreUI)this, this.currentCompany.getId().toString(), this.tblMain, "bgItem", "fundFlowItem", "extendItem", FundFlowDirection.IN);
        this.fundBgTable.loadFields((IObjectCollection)this.editDatas);
        FMClientHelper.setSelectObject((KDComboBox)this.comboNtType, (Object)this.editData.getNtType());
        this.prmtNumber.setValue((Object)this.editDatas.toArray());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        int n = this.tblMain.getRowCount() - 1;
        for (int i = 0; i < n; ++i) {
            RecChequeInfo info = this.editDatas.get(i);
            if (info == null) continue;
            FMClientHelper.storeFieldsBgItem((ICell)this.tblMain.getCell(i, "bgItem"), (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
        }
        this.fundBgTable.storeFields((IFmMbgUsed)this.editData, (IObjectCollection)this.editDatas);
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        this.initTable();
        RecChequeUtil.initComboNtType(this.comboNtType);
        super.onLoad();
        RecChequeUtil.initPrmtBank((IUIObject)this, this.prmtPayeeBank);
        RecChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtPayeeBankAcct, this.currentCompany, null, null);
        RecChequeUtil.initPrmtAcctView((IUIObject)this, this.prmtReceiptAcct, this.currentCompany, this.currency.getId().toString(), true);
        RecChequeUtil.initPrmtNumber(this.currentCompany, this.prmtNumber, "RECEIPT", this.getSelectors(), this.getNTTypeInfo());
        if (this.editData.getNtType() == null) {
            this.comboNtType.setSelectedIndex(0);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.btnViewBdg.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        FMClientHelper.initFpOrBgF7Item((boolean)false, (IColumn)this.tblMain.getColumn("project"), (IColumn)this.tblMain.getColumn("bgItem"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        Date receiptDate = this.pkReceiptDate.getSqlDate();
        int l = this.editDatas.size();
        for (int i = 0; i < l; ++i) {
            RecChequeInfo info = this.editDatas.get(i);
            java.util.Date receiveDate = info.getIssueDate();
            java.util.Date expiredDate = info.getExpiredDate();
            if (info.getReceiptAmount() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"348_RecChequeReceiptUI"));
                SysUtil.abort();
            }
            if (info.isIsQuota() && info.getReceiptAmount().compareTo(info.getCeiling()) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"349_RecChequeReceiptUI"));
                SysUtil.abort();
            }
            if (receiveDate.after(receiptDate)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"350_RecChequeReceiptUI"));
                SysUtil.abort();
            }
            if (!receiptDate.after(expiredDate)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"351_RecChequeReceiptUI"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.storeTableFields();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        int l = this.editDatas.size();
        for (int i = 0; i < l; ++i) {
            RecChequeInfo info = this.editDatas.get(i);
            info.setCompany(company);
        }
        String boName = "com.kingdee.eas.fm.nt.app.RecCheque";
        this.viewBgBalance((Component)((Object)this), boName, null, this.editDatas);
    }

    private void viewBgBalance(Component owner, String boName, BgCtrlParamCollection paramColl, RecChequeCollection editDatas) throws BOSException, EASBizException {
        if (FmMbgHelper.isMBG_C001(null, (String)this.currentCompany.getId().toString())) {
            UIContext ctx = new UIContext((Object)owner);
            ArrayList<IBudgetBalance> bbList = new ArrayList<IBudgetBalance>();
            int size = editDatas.size();
            for (int i = 0; i < size; ++i) {
                bbList.add(BgControlFacadeFactory.getRemoteInstance().queryBalance((IObjectValue)editDatas.get(i)));
            }
            ctx.put((Object)"BBList", bbList);
            UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FmMbgBalanceUI4Cheque.class.getName(), (Map)ctx).show();
            return;
        }
        BgCtrlResultCollection coll = (BgCtrlResultCollection)FMBudgetFacadeFactory.getRemoteInstance().viewBdgBanalce((IObjectCollection)editDatas);
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"BGBALANCE", (Object)coll);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgBalanceViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionRecord.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionViewBdgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionSubmit.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_submit"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionSubmitOption.setVisible(false);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            boolean isCash = true;
            if (this.editData != null && this.editData.getNtType() != null) {
                isCash = this.editData.getNtType().isIsCash();
            }
            this.updateReceiptAcctState(isCash);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("payeeBank.*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.*"));
        sic.add(new SelectorItemInfo("department.*"));
        sic.add(new SelectorItemInfo("oppAcct.*"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("Pproject.name"));
        sic.add(new SelectorItemInfo("Pproject.number"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("dealer.name"));
        sic.add(new SelectorItemInfo("remitterS.name"));
        sic.add(new SelectorItemInfo("remitterC.name"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        return sic;
    }

    protected IObjectValue createNewData() {
        RecChequeInfo info;
        ArrayList list = (ArrayList)this.getUIContext().get("RECCHEQUEIDS");
        if (list == null) {
            info = new RecChequeInfo();
        } else {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
            evi.setFilter(filter);
            evi.setSelector(this.getSelectors());
            try {
                this.editDatas = RecChequeFactory.getRemoteInstance().getRecChequeCollection(evi);
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            info = this.editDatas.get(0);
        }
        info.setReceiptDate(new java.util.Date());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RecChequeFactory.getRemoteInstance();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.comboNtType.requestFocus();
    }

    public boolean isModify() {
        return !this.isSave && super.isModify();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.storeTableFields();
        this.verifyInput(e);
        this.checkFinalCheckout();
        ((IRecCheque)this.getBizInterface()).receipt(this.editDatas);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"352_RecChequeReceiptUI"));
        this.actionSubmit.setEnabled(false);
        FMClientHelper.setComponentEnable((JComponent)((Object)this), (boolean)false);
        this.setSaved(true);
        this.setSave(true);
        this.isSave = true;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.editDatas == null || this.editDatas.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"353_RecChequeReceiptUI"));
            return;
        }
        if (!this.isSave()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"326_RecChequeBatchBookUI"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < this.editDatas.size(); ++i) {
            idList.add(this.editDatas.get(i).getId().toString());
        }
        RecChequeTDDelegate data = new RecChequeTDDelegate(idList, true);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/RecCheque", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editDatas == null || this.editDatas.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"353_RecChequeReceiptUI"));
            return;
        }
        if (!this.isSave()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"326_RecChequeBatchBookUI"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < this.editDatas.size(); ++i) {
            idList.add(this.editDatas.get(i).getId().toString());
        }
        RecChequeTDDelegate data = new RecChequeTDDelegate(idList, false);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/RecCheque", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionRecord_actionPerformed(ActionEvent e) throws Exception {
        super.actionRecord_actionPerformed(e);
        if (this.editDatas == null || this.editDatas.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"353_RecChequeReceiptUI"));
            return;
        }
        if (!this.isSave()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"326_RecChequeBatchBookUI"));
            return;
        }
        IRecCheque recCheque = RecChequeFactory.getRemoteInstance();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < this.editDatas.size(); ++i) {
            idSet.add(this.editDatas.get(i).getId().toString());
        }
        recCheque.record(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"334_RecChequeBookInUI"));
        this.actionRecord.setEnabled(false);
    }

    @Override
    protected void comboNtType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboNtType_itemStateChanged(e);
        NTTypeInfo ntType = this.getNTTypeInfo();
        if (ntType != null) {
            this.prmtNumber.setValue(null);
            FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtNumber, (FilterItemInfo)new FilterItemInfo("ntType.id", (Object)ntType.getId()));
            this.updateReceiptAcctState(ntType.isIsCash());
        }
    }

    private NTTypeInfo getNTTypeInfo() {
        Object obj = this.comboNtType.getSelectedItem();
        if (obj != null && obj instanceof NTTypeInfo) {
            return (NTTypeInfo)obj;
        }
        return null;
    }

    @Override
    protected void prmtNumber_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtNumber_dataChanged(e);
        AccessHelper.getF7Datas((KDBizPromptBox)this.prmtNumber, (IObjectCollection)this.editDatas);
        this.loadTableFields((IObjectCollection)this.editDatas);
        if (this.editDatas != null && this.editDatas.size() > 0) {
            this.editData = this.editDatas.get(0);
            this.prmtReceiptAcct.setValue(null);
            this.prmtPayeeBank.setValue(null);
            this.prmtPayeeBankAcct.setValue(null);
        }
        this.isSave = false;
    }

    @Override
    protected void prmtNumber_preChange(PreChangeEvent e) throws Exception {
        super.prmtNumber_preChange(e);
        Object c = e.getData();
        if (c instanceof Object[]) {
            Object[] data = (Object[])c;
            if (data.length < 2) {
                e.setResult(1);
                return;
            }
            RecChequeCollection coll = new RecChequeCollection();
            int l = data.length;
            for (int i = 0; i < l; ++i) {
                coll.add((RecChequeInfo)data[i]);
            }
            if (!RecChequeHelper.isCanReceipt(coll)) {
                e.setResult(-1);
            }
        } else if (c instanceof RecChequeInfo) {
            e.setResult(1);
        } else {
            e.setResult(-1);
        }
    }

    @Override
    protected void prmtReceiptAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtReceiptAcct_willCommit(e);
    }

    @Override
    protected void prmtReceiptAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtReceiptAcct_willShow(e);
    }

    @Override
    protected void prmtPayeeBankAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtPayeeBankAcct_willCommit(e);
        BankInfo bank = null;
        CurrencyInfo currency = this.editData.getCurrency();
        Object v = this.prmtPayeeBank.getValue();
        if (v instanceof BankInfo) {
            bank = (BankInfo)v;
        }
        RecChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtPayeeBankAcct, this.currentCompany, bank, currency);
    }

    @Override
    protected void prmtPayeeBankAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtPayeeBankAcct_willShow(e);
        BankInfo bank = null;
        CurrencyInfo currency = this.editData.getCurrency();
        Object v = this.prmtPayeeBank.getValue();
        if (v instanceof BankInfo) {
            bank = (BankInfo)v;
        }
        RecChequeUtil.initPrmtBankAcct((IUIObject)this, this.prmtPayeeBankAcct, this.currentCompany, bank, currency);
    }

    @Override
    protected void prmtPayeeBank_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayeeBank_dataChanged(e);
    }

    @Override
    protected void prmtPayeeBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayeeBankAcct_dataChanged(e);
        Object v = e.getNewValue();
        if (v instanceof AccountBankInfo) {
            NTTypeInfo nt;
            AccountBankInfo acct = (AccountBankInfo)v;
            if (acct.getBank().getId() != null) {
                BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(acct.getBank().getId()));
                this.prmtPayeeBank.setValue((Object)bank);
            }
            if ((nt = (NTTypeInfo)this.comboNtType.getSelectedItem()) != null && !nt.isIsCash() && acct.getAccount() != null) {
                AccountViewInfo acctView = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(acct.getAccount().getId()));
                this.prmtReceiptAcct.setValue((Object)acctView);
            }
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        if (e.getValue() == null) {
            return;
        }
        if (this.tblMain.getColumnKey(e.getColIndex()).equals("receiptAmount")) {
            BigDecimal receiptSum = Constants.ZERO;
            int len = this.tblMain.getRowCount() - 1;
            for (int i = 0; i < len; ++i) {
                BigDecimal receiptAmount = (BigDecimal)this.tblMain.getRow(i).getCell("receiptAmount").getValue();
                if (receiptAmount == null) continue;
                receiptSum = receiptSum.add(receiptAmount);
            }
            this.tblMain.getRow(len).getCell("receiptAmount").setValue((Object)receiptSum);
        }
    }

    private void initTable() throws Exception {
        this.tblMain.putBindContents("editData", this.getTableBindingFields());
        this.tblMain.checkParsed();
        KDTableHelper.updateEnterWithTab((KDTable)this.tblMain, (boolean)false);
        KDTableHelper.downArrowAutoAddRow((KDTable)this.tblMain, (boolean)false, null);
        int pre = this.currency.getPrecision();
        RecChequeUtil.initCheckBoxCell(this.tblMain, "isQuota");
        RecChequeUtil.initFormattedTextCell(this.tblMain, "ceiling", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "amount", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "receiptAmount", pre);
        KDComboBox comboNtType = RecChequeUtil.initComboBoxCell(this.tblMain, "ntType");
        KDComboBox comboCurrency = RecChequeUtil.initComboBoxCell(this.tblMain, "currency");
        KDBizPromptBox prmtOppAcct = RecChequeUtil.initF7Cell(this.tblMain, "oppAcct");
        KDBizPromptBox prmtProject = RecChequeUtil.initF7Cell(this.tblMain, "Pproject");
        KDBizPromptBox prmtBgItem = RecChequeUtil.initF7Cell(this.tblMain, "bgItem");
        RecChequeUtil.initComboNtType(comboNtType);
        FMClientHelper.initComboCurrency((KDComboBox)comboCurrency);
        RecChequeUtil.initPrmtAcctView((IUIObject)this, prmtOppAcct, this.currentCompany, this.currency.getId().toString(), false);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.tblMain.getColumn("ntType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("currency").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("isQuota").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("ceiling").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("amount").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("remitter").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("expireDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("expireDate").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("remitter").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("receiptAmount").getStyleAttributes().setBackground(c);
    }

    private void loadTableFields(IObjectCollection coll) {
        this.tableHandler.bindDataToTable(this.tblMain, coll);
        if (coll == null || coll.size() <= 0) {
            return;
        }
        BigDecimal amountSum = Constants.ZERO;
        BigDecimal receiptSum = Constants.ZERO;
        int pre = this.editDatas.get(0).getCurrency().getPrecision();
        RecChequeUtil.initFormattedTextCell(this.tblMain, "ceiling", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "amount", pre);
        RecChequeUtil.initFormattedTextCell(this.tblMain, "receiptAmount", pre);
        int l = this.tblMain.getRowCount();
        for (int i = 0; i < l; ++i) {
            ICell cCeiling = this.tblMain.getRow(i).getCell("ceiling");
            ICell cAmount = this.tblMain.getRow(i).getCell("amount");
            ICell cReceiptAmount = this.tblMain.getRow(i).getCell("receiptAmount");
            ICell cIsQuota = this.tblMain.getRow(i).getCell("isQuota");
            ICell cRemitter = this.tblMain.getRow(i).getCell("remitter");
            cRemitter.setValue(this.getRemitter(i));
            cIsQuota.setValue((Object)this.editDatas.get(i).isIsQuota());
            if (this.editDatas.get(i).isIsQuota()) {
                cReceiptAmount.getStyleAttributes().setLocked(false);
            } else {
                cReceiptAmount.getStyleAttributes().setLocked(true);
                cReceiptAmount.setValue(cAmount.getValue());
            }
            Object amount = cAmount.getValue();
            Object receiptAmount = cReceiptAmount.getValue();
            if (amount instanceof BigDecimal) {
                amountSum = amountSum.add((BigDecimal)amount);
            }
            if (receiptAmount instanceof BigDecimal) {
                receiptSum = receiptSum.add((BigDecimal)receiptAmount);
            }
            cAmount.getStyleAttributes().setNumberFormat(RecChequeUtil.getKDTCurrencyFormat(pre));
            cReceiptAmount.getStyleAttributes().setNumberFormat(RecChequeUtil.getKDTCurrencyFormat(pre));
            cCeiling.getStyleAttributes().setNumberFormat(RecChequeUtil.getKDTCurrencyFormat(pre));
        }
        String numberFmt = FMClientHelper.getNumberFtm((int)pre);
        this.insertSumRow(amountSum, receiptSum, numberFmt);
    }

    private void storeTableFields() {
        this.tableHandler.bindTableToData(this.tblMain, (IObjectCollection)this.editDatas, RecChequeInfo.class.getName());
        if (this.editDatas != null && this.editDatas.size() > 0) {
            this.editDatas.removeObject(this.editDatas.size() - 1);
        }
        int l = this.editDatas.size();
        for (int i = 0; i < l; ++i) {
            RecChequeInfo info = this.editDatas.get(i);
            info.setReceiptDate(this.pkReceiptDate.getSqlDate());
            info.setPayeeBank((BankInfo)this.prmtPayeeBank.getValue());
            info.setPayeeBankAcct((AccountBankInfo)this.prmtPayeeBankAcct.getValue());
            info.setReceiptAcct((AccountViewInfo)this.prmtReceiptAcct.getValue());
            info.setDescription(this.txtSummary.getText());
            FMClientHelper.storeFieldsBgItem((ICell)this.tblMain.getCell(i, "bgItem"), (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
        }
    }

    private String[] getTableBindingFields() {
        return new String[]{"ntType", "number", "expiredDate", "remitter", "isQuota", "ceiling", "currency", "amount", "receiptAmount", "oppAcct", "bgItem", "bgDimension", "Pproject"};
    }

    private void insertSumRow(BigDecimal amountSum, BigDecimal receiptSum, String formatString) {
        if (amountSum == null || receiptSum == null) {
            return;
        }
        IRow row = this.tblMain.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
        row.getCell("amount").setValue((Object)amountSum);
        row.getCell("amount").getStyleAttributes().setNumberFormat(formatString);
        row.getCell("receiptAmount").setValue((Object)receiptSum);
        row.getCell("receiptAmount").getStyleAttributes().setNumberFormat(formatString);
    }

    private void updateReceiptAcctState(boolean isCash) {
        if (isCash) {
            this.prmtReceiptAcct.setEnabled(true);
            this.prmtReceiptAcct.setRequired(true);
            this.prmtPayeeBank.setEnabled(false);
            this.prmtPayeeBank.setRequired(false);
            this.prmtPayeeBank.setValue(null);
            this.prmtPayeeBankAcct.setEnabled(false);
            this.prmtPayeeBankAcct.setRequired(false);
            this.prmtPayeeBankAcct.setValue(null);
        } else {
            this.prmtReceiptAcct.setEnabled(false);
            this.prmtReceiptAcct.setRequired(false);
            this.prmtReceiptAcct.setValue(null);
            this.prmtPayeeBank.setEnabled(true);
            this.prmtPayeeBank.setRequired(true);
            this.prmtPayeeBankAcct.setEnabled(true);
            this.prmtPayeeBankAcct.setRequired(true);
        }
    }

    private Object getRemitter(int i) {
        String c = null;
        if (this.editDatas.get(i).getRemitter() != null) {
            c = this.editDatas.get(i).getRemitter();
        } else if (this.editDatas.get(i).getRemitterS() != null) {
            c = this.editDatas.get(i).getRemitterS().getName();
        } else if (this.editDatas.get(i).getRemitterC() != null) {
            c = this.editDatas.get(i).getRemitterC().getName();
        }
        return c;
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (java.util.Date)this.editData.getReceiptDate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

