/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.nt.NTDateFormat;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceipBillTDQueryDelegate
implements BOSQueryDelegate {
    private static final Logger logger = CoreUIObject.getLogger(ReceipBillTDQueryDelegate.class);
    private Set ids = null;
    private IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fm.nt.app.ReceiptBillTDQuery");

    public ReceipBillTDQueryDelegate(Set id) {
        this.ids = id;
    }

    public ReceipBillTDQueryDelegate(List id) {
        this.ids = new HashSet(id);
    }

    public IRowSet execute(BOSQueryDataSource arg0) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qpk);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            logger.info((Object)exec.getSQL());
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                Date date = iRowSet.getDate("receiptDate");
                if (date != null) {
                    NTDateFormat format = new NTDateFormat();
                    String capDate = format.format(date);
                    int signOne = capDate.indexOf(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"213_ChequeTDQueryDelegate"));
                    int signTwo = capDate.indexOf(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"214_ChequeTDQueryDelegate"));
                    String year = capDate.substring(0, signOne);
                    String month = capDate.substring(signOne + 1, signTwo);
                    String day = capDate.substring(signTwo + 1);
                    day = day.substring(0, day.length() - 1);
                    iRowSet.updateString("year", year);
                    iRowSet.updateString("month", month);
                    iRowSet.updateString("day", day);
                }
                int precision = iRowSet.getInt("currency.precision");
                BigDecimal amount = iRowSet.getBigDecimal("amount");
                if (amount == null) continue;
                iRowSet.updateBigDecimal("amount", amount.setScale(precision, 4));
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return iRowSet;
    }
}

