/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.IReceiptBill;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.NoteKindEnum;
import com.kingdee.eas.fm.nt.ReceiptBillCollection;
import com.kingdee.eas.fm.nt.ReceiptBillFactory;
import com.kingdee.eas.fm.nt.ReceiptBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceiptBillEditUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.fm.nt.client.ReceipBillTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.util.ReceiptBillUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.SwingUtilities;

public class ReceiptBillEditUI
extends AbstractReceiptBillEditUI {
    private Locale locale = SysContext.getSysContext().getLocale();

    public void onLoad() throws Exception {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"companyisnull"));
            SysUtil.abort();
        }
        HashSet<Integer> receiptSet = new HashSet<Integer>();
        receiptSet.add(new Integer(41));
        receiptSet.add(new Integer(42));
        receiptSet.add(new Integer(91));
        receiptSet.add(new Integer(61));
        receiptSet.add(new Integer(20));
        receiptSet.add(new Integer(82));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group", receiptSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE, CompareType.EQUALS));
        NTClientHelper.initEmptyNTTypeComboxByFilter(this.comboNtType, true, filter);
        FMClientHelper.initComboCurrency((KDComboBox)this.prmtCurrency, (boolean)true);
        ReceiptBillUtil.initF7BankAccount(this.prmtPayeeBankAcct);
        this.txtAmount.setNegatived(false);
        this.txtAmount.setPrecision(FMClientHelper.getLocalCurPre());
        this.txtDescription.setMaxLength(80);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        super.onLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("ntType.*");
        sic.add("currency.*");
        sic.add("payeeBankAcct.*");
        return sic;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        int oldIndex = this.idList.getCurrentIndex();
        if (oldIndex < 0) {
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        }
        if (oldIndex >= this.idList.size()) {
            this.btnPre.setEnabled(false);
            this.btnFirst.setEnabled(false);
        }
        if (this.getOprtState() == OprtState.ADDNEW) {
            this.txtNumber.setEditable(true);
            this.txtPayeeName.setEnabled(false);
            this.txtKeeper.setEditable(false);
        } else if (this.oprtState.equals(OprtState.EDIT)) {
            this.txtPayeeName.setEnabled(false);
            this.txtNumber.setEditable(false);
            this.txtKeeper.setEditable(false);
            this.editData = (ReceiptBillInfo)this.getDataObject();
            if (this.editData != null && this.editData.getPayeeBankAcct() != null && this.editData.getPayeeBankAcct().getCurrency() != null) {
                this.prmtCurrency.setEnabled(false);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocusInWindow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.actionViewDoProccess.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionViewSubmitProccess.setEnabled(false);
        this.actionViewSubmitProccess.setVisible(false);
        this.actionSendMessage.setEnabled(false);
        this.actionSendMessage.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.menuWorkflow.setEnabled(false);
        this.menuWorkflow.setVisible(false);
        this.btnTDPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.btnTDPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getNtType() != null && this.editData.getNtType().getId() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboNtType, (Object)this.editData.getNtType());
        }
        if (this.editData.getCurrency() == null) {
            this.prmtCurrency.setSelectedItem((Object)SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.prmtCurrency, (Object)this.editData.getCurrency());
        }
        this.prmtPayeeBankAcct.setValue((Object)this.editData.getPayeeBankAcct());
    }

    @Override
    public void storeFields() {
        this.editData.setCurrency((CurrencyInfo)this.prmtCurrency.getSelectedItem());
        if (this.comboNtType.getItemCount() > 0 && this.comboNtType.getSelectedIndex() >= 0 && this.comboNtType.getSelectedItem() != null) {
            this.editData.setNtType((NTTypeInfo)this.comboNtType.getSelectedItem());
        }
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return ReceiptBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReceiptBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ReceiptBillInfo objectValue = new ReceiptBillInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setCompany(this.currentCompany);
        objectValue.setReceiptDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.editData != null) {
            objectValue.setNtType(this.editData.getNtType());
        }
        objectValue.setPayeeName(this.currentCompany.getName());
        objectValue.setNoteKind(NoteKindEnum.receiptBill);
        objectValue.setKeeper(ContextHelperFactory.getRemoteInstance().getCurrentUser().getName());
        ReceiptBillUtil.setAutoNumber(objectValue, NoteKindEnum.receiptBill);
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        if (this.editData != null) {
            IReceiptBill recebill = ReceiptBillFactory.getRemoteInstance();
            if (this.editData.getId() == null) {
                EntityViewInfo eviForCtrls = new EntityViewInfo();
                FilterInfo filters = new FilterInfo();
                filters.getFilterItems().add(new FilterItemInfo("company", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
                eviForCtrls.setFilter(filters);
                ReceiptBillCollection rececoll = recebill.getReceiptBillCollection(eviForCtrls);
                ReceiptBillInfo binfo = rececoll.get(rececoll.size() - 1);
                if (binfo != null) {
                    String number = binfo.getNumber();
                    String numberstring = "";
                    String charstring = "";
                    int count = number.length();
                    for (int i = 0; i < count; ++i) {
                        if (!String.valueOf(number.charAt(count - (i + 1))).matches("\\d")) {
                            charstring = number.substring(0, count - i);
                            break;
                        }
                        numberstring = numberstring + number.charAt(count - (i + 1));
                        charstring = number.substring(0, count - (i + 1));
                    }
                    StringBuffer sd = new StringBuffer(numberstring);
                    numberstring = sd.reverse().toString();
                    int numberleght = numberstring.length();
                    if (numberstring.equals("") || numberstring == null) {
                        this.txtNumber.setText("");
                    } else {
                        String chars;
                        int charint = Integer.valueOf(numberstring);
                        if ((chars = String.valueOf(++charint)).length() < numberleght) {
                            int counti = numberleght - chars.length();
                            for (int iop = 0; iop < counti; ++iop) {
                                charstring = charstring + "0";
                            }
                        }
                        this.txtNumber.setText(charstring + String.valueOf(charint));
                    }
                }
            }
            this.editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        }
        this.txtNumber.setEnabled(true);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEditable(false);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (!(this.oprtState.equals(OprtState.VIEW) || this.editData.getId() != null && this.isSave() && !this.isModify())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        ReceipBillTDQueryDelegate data = null;
        ArrayList<String> id = new ArrayList<String>();
        id.add(this.editData.getId().toString());
        data = new ReceipBillTDQueryDelegate(id);
        appHlp.printPreview("/FM/NT/Receipt", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrintPreview_actionPerformed(e);
        if (!(this.oprtState.equals(OprtState.VIEW) || this.editData.getId() != null && this.isSave() && !this.isModify())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        ReceipBillTDQueryDelegate data = null;
        ArrayList<String> id = new ArrayList<String>();
        id.add(this.editData.getId().toString());
        data = new ReceipBillTDQueryDelegate(id);
        appHlp.printPreview("/FM/NT/Receipt", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.enableTDButton();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.enableTDButton();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.enableTDButton();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.enableTDButton();
    }

    @Override
    protected void prmtCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.prmtCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo infos = (CurrencyInfo)this.prmtCurrency.getSelectedItem();
        if (infos != null) {
            this.txtAmount.setPrecision(infos.getPrecision());
        }
    }

    @Override
    protected void prmtPayeeBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayeeBankAcct_dataChanged(e);
        AccountBankInfo bankAcct = (AccountBankInfo)e.getNewValue();
        if (bankAcct == null) {
            return;
        }
        if (bankAcct.getCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(bankAcct.getCurrency().getId().toString()));
            FMClientHelper.setSelectObject((KDComboBox)this.prmtCurrency, (Object)currency);
            this.prmtCurrency.setEnabled(false);
        } else {
            this.prmtCurrency.setEnabled(true);
        }
        if (bankAcct.getBank() != null) {
            BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bankAcct.getBank().getId()));
            this.txtPayeeBank.setText(bank.getName());
            this.txtPayeeBank.setEnabled(false);
        } else {
            this.txtPayeeBank.setEnabled(true);
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtAmount_dataChanged(e);
        BigDecimal amount = this.txtAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(Constants.MAX_VALUE) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.txtAmount.setValue(null);
            this.txtCapitalization.setText(null);
            SysUtil.abort();
        }
        if (this.txtAmount.getBigDecimalValue() == null) {
            this.txtCapitalization.setText("");
        } else {
            this.txtCapitalization.setText(GlUtils.getChineseFormat((BigDecimal)this.txtAmount.getBigDecimalValue(), (boolean)true, (Locale)this.locale));
        }
    }

    private void enableTDButton() {
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "receiptDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionEdit", "actionSubmit"};
    }
}

