/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterParamBase;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.NtRpcCacheInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivableBillFilterUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.fm.nt.client.ReceivableFilterParam;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReceivableBillFilterUI
extends AbstractReceivableBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableBillFilterUI.class);
    private NtRpcCacheInfo rpcCacheInfo;
    private static final String RESOURCES = "com.kingdee.eas.fm.nt.ReceivableBill";
    private BillSourceEnum billSource;

    public ReceivableBillFilterUI() throws Exception {
        NtRpcCacheInfo paramInfo = new NtRpcCacheInfo();
        paramInfo.setBatchImplClassName("com.kingdee.eas.fm.nt.app.NTBatchFetcher");
        this.rpcCacheInfo = (NtRpcCacheInfo)FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData((FmRpcCacheInfo)paramInfo);
        this.combobillState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public ReceivableBillFilterUI(BillSourceEnum billSource) throws Exception {
        NtRpcCacheInfo paramInfo = new NtRpcCacheInfo();
        paramInfo.setBatchImplClassName("com.kingdee.eas.fm.nt.app.NTBatchFetcher");
        this.rpcCacheInfo = (NtRpcCacheInfo)FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData((FmRpcCacheInfo)paramInfo);
        this.combobillState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.billSource = billSource;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initCompanyState() {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany) || this.rpcCacheInfo.isClearingHouse()) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.chkIA.setEnabled(false);
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    public void init() throws Exception {
        super.init();
        this.initCurrency();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.bassCurrency);
        FMClientHelper.setSelectObject((KDComboBox)this.combobillState, (Object)((Object)BillStateEnum.SAVED));
        this.pkbeginTakeDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkendTakeDate.setValue((Object)DateUtil.getEndDayOfCurMonth());
        this.checkShowCom.setSelected(false);
        this.checkSplit.setSelected(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void initCurrency() throws Exception {
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (CurrencyCollection)this.rpcCacheInfo.getAllCurrencyColl(), (boolean)false);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.rpcCacheInfo.getCurrentCurrency());
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        ReceivableFilterParam param = new ReceivableFilterParam();
        param.setBeginTakeDate((Date)this.pkbeginTakeDate.getValue());
        param.setEndTakeDate((Date)this.pkendTakeDate.getValue());
        if (!(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        } else {
            param.setCurrencyId(null);
        }
        if (!(this.combobillState.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setBillstate((BillStateEnum)((Object)this.combobillState.getSelectedItem()));
        } else {
            param.setBillstate(null);
        }
        if (this.billSource != null) {
            param.setSource(this.billSource.getValue());
        }
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setShowCom(this.checkShowCom.isSelected());
        param.setCreateOrgID(this.currentCompany.getId().toString());
        param.setSplit(this.checkSplit.isSelected());
        return param;
    }

    public void setParam(Object param) {
        ReceivableFilterParam para = (ReceivableFilterParam)((Object)param);
        if (para == null) {
            return;
        }
        this.pkbeginTakeDate.setValue((Object)para.getBeginTakeDate());
        this.pkendTakeDate.setValue((Object)para.getEndTakeDate());
        this.setCompanyIdSet(para.getCompanyIdSet());
        if (para.getCurrencyId() != null) {
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)para.getCurrencyId()));
            currency.setName(para.getCurrencyName());
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (para.getBillstate() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.combobillState, (Object)((Object)para.getBillstate()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.combobillState, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        this.checkShowCom.setSelected(para.isShowCom());
        this.checkSplit.setSelected(para.isSplit());
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)this.pkbeginTakeDate.getValue(), (Date)this.pkendTakeDate.getValue());
        return super.verify();
    }

    protected Class getParamClass() {
        return ReceivableFilterParam.class;
    }

    public void setCustomerParams(CustomerParams cp) {
        Object param = this.getFilterParamFromCP(cp);
        ReceivableFilterParam para = (ReceivableFilterParam)((Object)param);
        if (!this.currentCompany.getId().toString().equals(para.getCreateOrgID()) && param != null && param instanceof FMFilterParamBase) {
            FMFilterParamBase paramBase = (FMFilterParamBase)param;
            paramBase.setCompanyIdSet(this.getCompanyIdSet());
        }
        this.setParam(param);
    }
}

