/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.IWage;
import com.kingdee.eas.fm.fin.WageBillEntryCollection;
import com.kingdee.eas.fm.fin.WageBillEntryFactory;
import com.kingdee.eas.fm.fin.WageBillEntryInfo;
import com.kingdee.eas.fm.fin.WageCollection;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillMediumEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.NTPHelper;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFacadeFactory;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReceivablePledgeDetailCollection;
import com.kingdee.eas.fm.nt.ReceivablePledgeDetailFactory;
import com.kingdee.eas.fm.nt.ReceivablePledgeDetailInfo;
import com.kingdee.eas.fm.nt.ReceivablePledgeParam;
import com.kingdee.eas.fm.nt.client.AbstractReceivablePledgeListUI;
import com.kingdee.eas.fm.nt.client.DraftUpdateStatusListUI;
import com.kingdee.eas.fm.nt.client.ReceivablePledgeExChangeUI;
import com.kingdee.eas.fm.nt.client.ReceivablePledgeFilterUI;
import com.kingdee.eas.fm.nt.client.ReceivablePledgeUI;
import com.kingdee.eas.fm.nt.client.util.FMToolTipUtil;
import com.kingdee.eas.fm.nt.vo.FMToolTipInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ReceivablePledgeListUI
extends AbstractReceivablePledgeListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivablePledgeListUI.class);
    protected ReceivablePledgeFilterUI filterUI;
    private static final String NTRESOURCE_PATH = "com.kingdee.eas.fm.nt.client.NtResource";
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    private String allTotal = EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"allTotal");
    private String currencyTotal = EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"currencyTotal");
    private String pledgeTotal = EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"pledgeTotal");
    protected boolean isShowEntry = false;

    public ReceivablePledgeListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)currentCompany);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionDisPledge.setEnabled(true);
        this.actionAuditResult.setVisible(false);
        this.actionExchange.setEnabled(true);
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionReleaseFailedBill.setVisible(false);
        this.actionCommitToBE.setVisible(false);
        this.actionSynForceStatus.setVisible(false);
        this.tblMain.getColumn("noteBillNumber").getStyleAttributes().setWrapText(true);
        this.tblMain.refresh();
        this.refreshEntry();
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        FMToolTipUtil.setToolTipInfo((JComponent)this.menuItemRemove, new FMToolTipInfo("menuItemRemove", EASResource.getString((String)NTRESOURCE_PATH, (String)"ReceivablePledgeListUI_menuItemRemove"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.menuItemCancelDisPledge, new FMToolTipInfo("menuItemCancelDisPledge", EASResource.getString((String)NTRESOURCE_PATH, (String)"ReceivablePledgeListUI_menuItemCancelDisPledge"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.menuItemDisPledge, new FMToolTipInfo("menuItemDisPledge", EASResource.getString((String)NTRESOURCE_PATH, (String)"ReceivablePledgeListUI_menuItemDisPledge"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnDisPledge, new FMToolTipInfo("btnDisPledge", EASResource.getString((String)NTRESOURCE_PATH, (String)"ReceivablePledgeListUI_btnDisPledge"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnCancelDisPledge, new FMToolTipInfo("btnCancelDisPledge", EASResource.getString((String)NTRESOURCE_PATH, (String)"ReceivablePledgeListUI_btnCancelDisPledge"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnRemove, new FMToolTipInfo("btnRemove", EASResource.getString((String)NTRESOURCE_PATH, (String)"ReceivablePledgeListUI_btnRemove"), ""));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDisPledge.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_trusteeship"));
        this.actionCancelDisPledge.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceltrusteeship"));
        this.actionExchange.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_replace"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionLocate.setVisible(false);
        this.actionCommitToBE.setVisible(false);
        this.actionBatchCommitToBE.setVisible(false);
        this.actionSynBillStatus.setVisible(false);
        this.actionEditStatus.setVisible(false);
        this.actionReleaseFailedBill.setVisible(false);
        this.menuItemNoteCancel.setVisible(false);
        this.actionNoteCancel.setVisible(false);
        this.actionSynBillStatus.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_courseoffer"));
        this.actionEditStatus.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_checkpolicy"));
        this.actionNoteCancel.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelpledge"));
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
    }

    public void executeQuery(FilterParam param) throws BOSException {
        FilterInfo filter = param.getFilter();
        for (FilterItemInfo filterItem : filter.getFilterItems()) {
            Object obj;
            if (filterItem == null || filterItem.getPropertyName() == null || !"billEntrys.seq".equals(filterItem.getPropertyName()) || !((obj = filterItem.getCompareValue()) instanceof Integer)) continue;
            Integer cpInte = (Integer)obj;
            if (cpInte == 1) {
                this.isIsShowEntry(false);
                continue;
            }
            if (cpInte != 0) continue;
            this.isIsShowEntry(true);
        }
        super.executeQuery(param);
    }

    public boolean isIsShowEntry() {
        return this.isShowEntry;
    }

    public void isIsShowEntry(boolean isShowEntry) {
        this.isShowEntry = isShowEntry;
    }

    protected void refreshEntry() {
        String[] hideEntryRows = new String[]{"noteBillNumber", "nttype", "billAmout", "takeDate", "deliver", "issuedate", "expiredate", "acceptanceBankName", "elecBillStatus", "bankReturnStatus", "bankReturnMsg", "isCommitCancel", "isNoteCancel", "noteStatus", "cirStatus"};
        int n = hideEntryRows.length;
        for (int i = 0; i < n; ++i) {
            if (this.tblMain.getColumn(hideEntryRows[i]) == null) continue;
            this.tblMain.getColumn(hideEntryRows[i]).getStyleAttributes().setHided(!this.isShowEntry);
        }
        this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("bankReturnMsg").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("isCommitCancel").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("isNoteCancel").getStyleAttributes().setHided(true);
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "company", "billMedium", "status", "pledgeDate", "currency", "pledgeAmt", "billAmt", "contract", "pledger", "isAntiPledge", "fiVouchered", "voucherNumber", "digest", "oppAccountView", "isCommitToBE", "amountlocalcur", "usedAmt", "balanceAmt", "CurrencyID"};
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.refreshEntry();
    }

    protected void execQuery() {
        this.tblMain.setRefresh(false);
        if (this.filterUI != null) {
            ReceivablePledgeParam param = (ReceivablePledgeParam)this.getFilterParam();
            if (param != null && param.isDispTotal()) {
                KDTFootManager footRowManager;
                this.tblMain.getDataRequestManager().setDataRequestMode(0);
                this.tblMain.getGroupManager().setGroup(true);
                int amountIndex = this.tblMain.getColumnIndex("pledgeAmt");
                int naturalAmtIndex = this.tblMain.getColumnIndex("amountlocalcur");
                if (this.getUIContext().get("isGroup4Pledger") == null) {
                    this.getUIContext().put("isGroup4Pledger", this.tblMain.getColumn("pledger").isGroup());
                }
                if (this.getUIContext().get("isGroup4Currency") == null) {
                    this.getUIContext().put("isGroup4Currency", this.tblMain.getColumn("currency").isGroup());
                }
                this.tblMain.getGroupManager().setTotalize(true);
                if (param.getCurrency() == null) {
                    this.tblMain.getColumn(naturalAmtIndex).setStat(true);
                    this.tblMain.getColumn(amountIndex).setStat(false);
                    this.tblMain.getColumn(naturalAmtIndex).getStyleAttributes().setHided(false);
                }
                IRow row0 = this.tblMain.getGroupManager().getStatRowTemplate(-1);
                row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                row0.getCell(0).setValue((Object)this.allTotal);
                if (param.getCurrency() == null) {
                    row0.getCell(naturalAmtIndex).setExpressions("SUM");
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setLocked(true);
                    row0.getCell(amountIndex).setExpressions(null);
                } else {
                    row0.getCell(amountIndex).setExpressions("SUM");
                    row0.getCell(amountIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row0.getCell(amountIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                    row0.getCell(amountIndex).getStyleAttributes().setLocked(true);
                }
                row0 = this.tblMain.getGroupManager().getStatRowTemplate(1);
                row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                row0.getCell(1).setValue((Object)this.currencyTotal);
                row0.getCell(amountIndex).setExpressions("SUM");
                row0.getCell(amountIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row0.getCell(amountIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                row0.getCell(amountIndex).getStyleAttributes().setLocked(true);
                if (param.getCurrency() == null) {
                    row0.getCell(naturalAmtIndex).setExpressions("SUM");
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setLocked(true);
                }
                if ((footRowManager = this.tblMain.getFootManager()) != null && footRowManager.getFoot() != null) {
                    footRowManager.getFoot().removeRows();
                }
            } else {
                this.tblMain.getDataRequestManager().setDataRequestMode(1);
                this.tblMain.getGroupManager().setGroup(true);
                if (this.getUIContext().get("isGroup4Pledger") != null) {
                    this.tblMain.getColumn("pledger").setGroup(((Boolean)this.getUIContext().get("isGroup4Pledger")).booleanValue());
                }
                if (this.getUIContext().get("isGroup4Currency") != null) {
                    this.tblMain.getColumn("currency").setGroup(((Boolean)this.getUIContext().get("isGroup4Currency")).booleanValue());
                }
                this.tblMain.getColumn("amountlocalcur").getStyleAttributes().setHided(true);
                KDTFootManager footRowManager = this.tblMain.getFootManager();
                if (footRowManager != null && footRowManager.getFoot().size() <= 0) {
                    footRowManager.addFootRow(0);
                }
            }
        } else {
            this.tblMain.getDataRequestManager().setDataRequestMode(1);
            this.tblMain.getGroupManager().setGroup(false);
            this.tblMain.getColumn("amountlocalcur").getStyleAttributes().setHided(true);
        }
        if (this.mainQuery.getFilter() != null && !this.mainQuery.getFilter().getFilterItems().isEmpty()) {
            FilterInfo bfilter = new FilterInfo();
            bfilter.getFilterItems().add(new FilterItemInfo("isRelationRec", (Object)Boolean.TRUE));
            try {
                this.mainQuery.getFilter().mergeFilter(bfilter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
        this.appendFootRow();
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
        this.tblMain.refresh();
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        if (row != null) {
            if (this.getBOTPViewStatus() == 1) {
                return row;
            }
            if (!EmptyUtil.isEmpty((Object)((Object)this.filterUI))) {
                ReceivablePledgeParam param = (ReceivablePledgeParam)this.getFilterParam();
                CurrencyInfo curreny = null;
                if (param != null) {
                    curreny = param.getCurrency();
                }
                int prec = 4;
                if (!EmptyUtil.isEmpty((CoreBaseInfo)curreny) && !EmptyUtil.isEmpty((Object)curreny.getId())) {
                    prec = FMClientHelper.getPrecOfCurrency((BOSUuid)curreny.getId());
                }
                for (int i = 0; i < this.getPrecColName().length; ++i) {
                    if (EmptyUtil.isEmpty((Object)this.tblMain.getFootRow(0))) continue;
                    this.tblMain.getFootRow(0).getCell(this.getPrecColName()[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)prec));
                }
            }
        }
        return row;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        WageInfo sourceBill;
        if (this.getSelectedKeyValue() != null) {
            super.tblMain_tableSelectChanged(e);
            this.actionDisPledge.setEnabled(true);
            this.actionCancelDisPledge.setEnabled(true);
            this.actionExchange.setEnabled(true);
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(true);
            this.actionTraceUp.setEnabled(true);
            this.actionTraceDown.setEnabled(true);
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
            this.actionReleaseFailedBill.setEnabled(true);
        } else {
            this.actionDisPledge.setEnabled(false);
            this.actionCancelDisPledge.setEnabled(false);
            this.actionExchange.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionTraceUp.setEnabled(false);
            this.actionTraceDown.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
        }
        this.checkSelected();
        ArrayList idList = this.getSelectedIDs();
        if (idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        if (BOSUuid.isValid((String)id, (boolean)true)) {
            sourceBill = ((IWage)this.getBizInterface()).getWageInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            this.actionEdit.setEnabled(!sourceBill.isFiVouchered());
            this.actionDisPledge.setEnabled(!sourceBill.isIsAntiWage());
            this.actionCommitToBE.setEnabled(sourceBill.getBillStatus() == FinBillStatusEnum.AUDITED && !sourceBill.isIsCommitToBE());
            this.actionBatchCommitToBE.setEnabled(sourceBill.getBillStatus() == FinBillStatusEnum.AUDITED && !sourceBill.isIsCommitToBE());
            this.actionSynBillStatus.setEnabled(sourceBill.isIsCommitToBE() && this.isbankProcessing(sourceBill));
            this.actionReleaseFailedBill.setEnabled(sourceBill.isIsCommitToBE());
            this.actionEdit.setEnabled(!sourceBill.isIsCommitToBE());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("wageId", (Object)id));
            view.setFilter(fi);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            ReceivableBillCollection coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
            boolean hasRec = false;
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
                for (int i = 0; i < coll.size(); ++i) {
                    ReceivableBillInfo info = coll.get(i);
                    if (!info.getBillState().equals((Object)BillStateEnum.GATHERED)) continue;
                    hasRec = true;
                    break;
                }
            }
            this.actionCancelDisPledge.setEnabled(sourceBill.isIsAntiWage() && !hasRec);
            if (this.getAuditStatus()) {
                this.actionAudit.setEnabled(true);
                this.actionAntiAudit.setEnabled(false);
            } else {
                this.actionAudit.setEnabled(false);
                this.actionAntiAudit.setEnabled(true);
            }
        } else {
            this.actionDisPledge.setEnabled(false);
            this.actionCancelDisPledge.setEnabled(false);
            this.actionExchange.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
            this.actionTraceUp.setEnabled(false);
            this.actionTraceDown.setEnabled(false);
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
            return;
        }
        this.actionDisPledge.setEnabled(!sourceBill.isIsCommitToBE());
        this.actionCancelDisPledge.setEnabled(!sourceBill.isIsCommitToBE());
        this.actionExchange.setEnabled(!sourceBill.isIsCommitToBE());
        this.actionRemove.setEnabled(!sourceBill.isIsCommitToBE() || sourceBill.isIsCommitToBE() && this.isBankReturnStatus(sourceBill, true));
        this.actionEditStatus.setEnabled(sourceBill.isIsCommitToBE() && this.existBEException(sourceBill));
        this.actionAntiAudit.setEnabled(!sourceBill.isIsCommitToBE());
    }

    private boolean isbankProcessing(WageInfo info) throws BOSException {
        boolean flg = false;
        WageBillEntryCollection billEntrys = info.getBillEntrys();
        for (int i = 0; i < billEntrys.size(); ++i) {
            WageBillEntryInfo wageBillEntryInfo = billEntrys.get(i);
            if (wageBillEntryInfo.getBankReturnStatus() == null || wageBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION && wageBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_PROCESSING && wageBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.EB_PROCESSING) continue;
            return true;
        }
        return flg;
    }

    private boolean existBEException(WageInfo sourceBill) {
        boolean exist = false;
        WageBillEntryCollection billEntrys = sourceBill.getBillEntrys();
        for (int i = 0; i < billEntrys.size(); ++i) {
            WageBillEntryInfo wageBillEntryInfo = billEntrys.get(i);
            if (wageBillEntryInfo.getBankReturnStatus() == null || wageBillEntryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public boolean getAuditStatus() {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < indexs.length; ++i) {
            boolean submitStatus;
            IRow row = this.tblMain.getRow(indexs[i]);
            BizEnumValueDTO status = (BizEnumValueDTO)row.getCell("status").getValue();
            if (status == null) {
                return false;
            }
            boolean bl = submitStatus = status.getInt() == 1;
            if (!submitStatus) continue;
            return true;
        }
        return false;
    }

    public ArrayList getSelectedIDs() {
        ArrayList<String> list = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = this.tblMain.getRow(selectRows[i]).getCell("id");
            if (cell == null || cell.getValue() == null || list.contains(id = cell.getValue().toString())) continue;
            list.add(id);
        }
        return list;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            if (this.getSelectedKeyValue() != null && !"\u603b\u8ba1".equals(this.getSelectedKeyValue())) {
                actView.actionPerformed(evt);
            }
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIName() {
        return ReceivablePledgeUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WageFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceivablePledgeFilterUI(BillSourceEnum.BYHAND);
        }
        return this.filterUI;
    }

    protected String getCurrencyIdColName() {
        return "CurrencyID";
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        ReceivablePledgeParam param;
        IRow row = null;
        String currencyId = null;
        String numberFormat = null;
        StyleAttributes styleAttributes = null;
        if (e == null) {
            return;
        }
        tblMain.checkParsed();
        if (this.filterUI != null && (param = (ReceivablePledgeParam)this.getFilterParam()) != null && param.isDispTotal()) {
            for (int i = 0; i < tblMain.getRowCount3() - 1; ++i) {
                row = tblMain.getRow(i);
                Object value = row.getCell("CurrencyID").getValue();
                if (value == null) continue;
                if (currencyId == null || !value.equals(currencyId)) {
                    currencyId = (String)value;
                    numberFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
                }
                if (currencyId == null) continue;
                styleAttributes = row.getCell("billAmt").getStyleAttributes();
                styleAttributes.setNumberFormat(numberFormat);
                styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                styleAttributes = row.getCell("pledgeAmt").getStyleAttributes();
                styleAttributes.setNumberFormat(numberFormat);
                styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                styleAttributes = row.getCell("usedAmt").getStyleAttributes();
                styleAttributes.setNumberFormat(numberFormat);
                styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                styleAttributes = row.getCell("balanceAmt").getStyleAttributes();
                styleAttributes.setNumberFormat(numberFormat);
                styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                styleAttributes = row.getCell("amountlocalcur").getStyleAttributes();
                styleAttributes.setNumberFormat(numberFormat);
                styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue();
            if (currencyId == null) continue;
            String[] formatCol = this.getPrecColName();
            for (int j = 0; j < formatCol.length; ++j) {
                FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
            }
        }
    }

    protected String[] getPrecColName() {
        return new String[]{"billAmt", "pledgeAmt", "usedAmt", "balanceAmt", "amountlocalcur"};
    }

    @Override
    public void actionDisPledge_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String wageid = this.getSelectedKeyValue();
        List idList = this.getAssociatedBill4OnlyOne(wageid, true);
        if (idList.size() == 1) {
            ReceivableBillFactory.getRemoteInstance().disPledge(idList, wageid);
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"oprState", (Object)"disPledge");
            uiContext.put((Object)"ID", (Object)wageid);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivablePledgeUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        this.refreshList();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String wageid = this.getSelectedKeyValue();
        List idList = this.getAssociatedBill4OnlyOne(wageid, false);
        if (this.getWageBillStatus(wageid)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource.RemovePrompt"));
            SysUtil.abort();
        }
        if (idList.size() == 1) {
            ReceivableBillFactory.getRemoteInstance().cancelPledge(idList, wageid);
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"oprState", (Object)"cancelPledge");
            uiContext.put((Object)"ID", (Object)wageid);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivablePledgeUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        this.refreshList();
    }

    @Override
    public void actionCancelDisPledge_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String wageid = this.getSelectedKeyValue();
        List idList = this.getAssociatedBill4OnlyOne(wageid, true);
        if (idList.size() == 1) {
            ReceivableBillFactory.getRemoteInstance().cancelDisPledge(idList, wageid);
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"oprState", (Object)"cancelDisPledge");
            uiContext.put((Object)"ID", (Object)wageid);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivablePledgeUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        this.refreshList();
    }

    private List getAssociatedBill4OnlyOne(String wageid, Boolean isCancle) throws BOSException {
        ArrayList<ReceivableBillInfo> idList = new ArrayList<ReceivableBillInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("wage", (Object)wageid));
        view.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("receivable.*"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        ReceivablePledgeDetailCollection coll = ReceivablePledgeDetailFactory.getRemoteInstance().getReceivablePledgeDetailCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            ReceivablePledgeDetailInfo pledgeDetail = (ReceivablePledgeDetailInfo)coll.getObject(i);
            try {
                Date verifyDate = isCancle != false ? new Date() : pledgeDetail.getPledgeDate();
                FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)verifyDate);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        if (coll.size() == 1) {
            ReceivablePledgeDetailInfo pledgeDetail = (ReceivablePledgeDetailInfo)coll.getObject(0);
            ReceivableBillInfo recBillInfo = pledgeDetail.getReceivable();
            recBillInfo.setIsDisPledge(pledgeDetail.isIsDisPledge());
            recBillInfo.setIsPledge(pledgeDetail.isIsPledge());
            recBillInfo.setClose(pledgeDetail.isIsClose());
            recBillInfo.setLastWageId(pledgeDetail.getLastWageId());
            recBillInfo.setPledgeDetailId(pledgeDetail.getId().toString());
            idList.add(recBillInfo);
            if (recBillInfo.isClose()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"369_ReceivablePledgeListUI"));
                SysUtil.abort();
            }
        }
        return idList;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionEdit)) {
            uiContext.put((Object)"oprState", (Object)"edit");
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean canEdit;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        if (this.getWageBillStatus(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource.EditPrompt"));
            SysUtil.abort();
        }
        if (!(canEdit = ReceivableBillFacadeFactory.getRemoteInstance().checkWageCanEdit(BOSUuid.read((String)id)))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource.wageCantEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.refreshList();
    }

    @Override
    public void actionExchange_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String wageid = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(wageid);
        WageInfo wageInfo = WageFactory.getRemoteInstance().getWageInfo((IObjectPK)pk);
        if (!this.getWageBillStatus(wageid) || wageInfo.isIsAntiWage()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource.ExchangePrompt"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"oprState", (Object)"exchangePledge");
        uiContext.put((Object)"ID", (Object)wageid);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivablePledgeExChangeUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refreshList();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIDs();
        if (pks.size() <= 0) {
            return;
        }
        Set set = FMHelper.list2Set((List)pks);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        evi.setSelector(this.getSelectors());
        WageCollection wageColl = WageFactory.getRemoteInstance().getWageCollection(evi);
        int count = wageColl.size();
        for (int i = 0; i < count; ++i) {
            WageInfo wageInfo = wageColl.get(i);
            FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)wageInfo.getIssuedate());
        }
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)pks);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        WageFactory.getRemoteInstance().audit(set);
        this.refresh(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIDs();
        if (pks.size() <= 0) {
            return;
        }
        Set set = FMHelper.list2Set((List)pks);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        evi.setSelector(this.getSelectors());
        WageCollection wageColl = WageFactory.getRemoteInstance().getWageCollection(evi);
        int count = wageColl.size();
        for (int i = 0; i < count; ++i) {
            WageInfo wageInfo = wageColl.get(i);
            FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)wageInfo.getIssuedate());
        }
        WageFactory.getRemoteInstance().antiAudit(set);
        this.showMessage();
        this.refresh(e);
    }

    private boolean getWageBillStatus(String wageid) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(wageid);
        try {
            WageInfo wageInfo = WageFactory.getRemoteInstance().getWageInfo((IObjectPK)pk);
            return wageInfo.getBillStatus().getValue() == 3;
        }
        catch (EASBizException e) {
            this.handUIException(e);
            return true;
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name", "billNumber"};
        return locateNames;
    }

    private List getSelectedRows() {
        ArrayList<IRow> rows = new ArrayList<IRow>();
        IBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                rows.add(row);
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBatchCommitToBE_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashMap<Object, Object> numberMap = new HashMap<Object, Object>();
        List rows = this.getSelectedRows();
        for (int i = 0; i < rows.size(); ++i) {
            IRow row = (IRow)rows.get(i);
            String id = (String)row.getCell("id").getValue();
            numberMap.put(row.getCell(this.getKeyFieldName()).getValue(), row.getCell("noteBillNumber").getValue());
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        HashSet idSet = new HashSet();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)idList);
            ArrayList<BankPayResult> resultLockList = new ArrayList<BankPayResult>();
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (!boolResult.booleanValue()) {
                    BankPayResult resultInfo = new BankPayResult();
                    resultInfo.setId(idList.get(i).toString());
                    resultInfo.setNumber((String)numberMap.get(idList.get(i)));
                    resultInfo.setErrorDetail("\u5355\u636e\u5df2\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u94f6\u4f01");
                    resultLockList.add(resultInfo);
                    continue;
                }
                idSet.add(idList.get(i));
            }
            if (idSet.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"602_EndorsementBillListUI"));
                SysUtil.abort();
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            evi.setSelector(this.getSelectors());
            WageCollection wageColl = WageFactory.getRemoteInstance().getWageCollection(evi);
            HashSet<String> canCommitIdSet = new HashSet<String>();
            int count = wageColl.size();
            for (int i = 0; i < count; ++i) {
                BankPayResult resultInfo;
                WageInfo wageInfo = wageColl.get(i);
                if (wageInfo.getBillMedium() != BillMediumEnum.ELECTRONIC) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(wageInfo.getId().toString());
                    resultInfo.setNumber(wageInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u7535\u7968\u624d\u53ef\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (wageInfo.getBillStatus() != FinBillStatusEnum.AUDITED) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(wageInfo.getId().toString());
                    resultInfo.setNumber(wageInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u5ba1\u6279\u72b6\u6001\u7684\u8d28\u62bc\u5355\u624d\u53ef\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (wageInfo.isIsCommitToBE() && this.existBankReturnStatus(wageInfo)) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(wageInfo.getId().toString());
                    resultInfo.setNumber(wageInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (wageInfo.isIsCommitToBE()) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(wageInfo.getId().toString());
                    resultInfo.setNumber(wageInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u5df2\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u4e0d\u80fd\u518d\u6b21\u63d0\u4ea4\u94f6\u4f01\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                if (wageInfo.isIsCommitToBE() && this.isCommitToBEFinished(wageInfo)) {
                    resultInfo = new BankPayResult();
                    resultInfo.setId(wageInfo.getId().toString());
                    resultInfo.setNumber(wageInfo.getNumber().toString());
                    resultInfo.setErrorDetail("\u5df2\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\u5904\u7406\u5b8c\u6210\u3002");
                    resultLockList.add(resultInfo);
                    continue;
                }
                canCommitIdSet.add(wageInfo.getId().toString());
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            ArrayList commitResult = WageFactory.getRemoteInstance().batchCommitToBE(canCommitIdSet);
            commitResult.addAll(resultLockList);
            if (commitResult.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"044_COMMITTOBE_SUCCESS"));
            } else {
                StringBuffer errorDetail = new StringBuffer();
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"629_PledgeRevokeBillListUI"));
                for (int j = 0; j < commitResult.size(); ++j) {
                    BankPayResult resultInfo = (BankPayResult)commitResult.get(j);
                    if (resultInfo.getErrorDetail() == null) continue;
                    errorDetail.append(resultInfo.getNumber()).append(":  ");
                    errorDetail.append(resultInfo.getErrorDetail());
                    errorDetail.append("\n");
                }
                int all = idList.size();
                int error = commitResult.size();
                BigDecimal succ = new BigDecimal(all).subtract(new BigDecimal(error));
                MsgBox.showDetailAndOK(null, (String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"607_EndorsementBillListUI") + succ + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"630_PledgeRevokeBillListUI") + error + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"631_PledgeRevokeBillListUI")), (String)errorDetail.toString(), (int)0);
            }
        }
        finally {
            ArrayList list = new ArrayList(idSet);
            iMutex.batchReleaseObjIDForUpdate(list);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCommitToBE_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            String id = idList.get(0).toString();
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                WageInfo wageInfo;
                if (!iMutex.requestObjIDForUpdate(id)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
                if ((wageInfo = this.getWageInfo(id)).getBillMedium() != BillMediumEnum.ELECTRONIC) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"016_IS_NOT_ELECBILL"));
                    SysUtil.abort();
                }
                if (wageInfo.isIsCommitToBE() && this.existBankReturnStatus(wageInfo)) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"012_BE_PROCESSING_WAITING"));
                    SysUtil.abort();
                }
                if (wageInfo.isIsCommitToBE() && this.isCommitToBEFinished(wageInfo)) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"043_COMMITTOBE_FINISHED"));
                    SysUtil.abort();
                }
                int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
                boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
                if (EBSstatus != 1 || !isContain) {
                    MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                    SysUtil.abort();
                }
                WageFactory.getRemoteInstance().commitToBE(wageInfo);
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"044_COMMITTOBE_SUCCESS"));
            }
            finally {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        this.refreshList();
    }

    @Override
    public void actionReleaseFailedBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"011_SINGLE_ROW_PROCESS"));
            SysUtil.abort();
        } else {
            WageInfo wageInfo = this.getWageInfo(idList.get(0).toString());
            List canReleaseList = this.getCanReleaseList(wageInfo);
            if (wageInfo.isIsCommitToBE() && canReleaseList.size() > 0 && canReleaseList.size() < wageInfo.getBillEntrys().size()) {
                ReceivableBillFactory.getRemoteInstance().cancelPledge(canReleaseList, idList.get(0).toString());
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"066_RELEASEFAILEDBILL_RESULT", (Object[])new String[]{String.valueOf(canReleaseList.size())}));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"013_CONDITION_CAN_RELEASE"));
                SysUtil.abort();
            }
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSynBillStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate((List)idList);
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (boolResult.booleanValue()) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            IWage iwage = WageFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("number");
            selectors.add("isCommitToBE");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            view.setSelector(selectors);
            WageCollection coll = iwage.getWageCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                WageInfo info = coll.get(i);
                if (info.isIsCommitToBE()) continue;
                MsgBox.showInfo((String)(info.getNumber() + EASResource.getString((String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS")));
                SysUtil.abort();
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            BatchExecuteResult result = (BatchExecuteResult)iwage.synBillStatus(idSet);
            NTPHelper.showActionResult((Component)((Object)this), result);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate((List)idList);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSynForceStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean is = false;
        try {
            is = iMutex.requestBizObjIDForUpdate("wage");
            if (!is) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"649_ReceivablePledgeListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            IWage iwage = WageFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("number");
            selectors.add("isCommitToBE");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            view.setSelector(selectors);
            WageCollection coll = iwage.getWageCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                WageInfo info = coll.get(i);
                if (info.isIsCommitToBE()) continue;
                MsgBox.showInfo((String)(info.getNumber() + EASResource.getString((String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS")));
                SysUtil.abort();
            }
            int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
            boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
            if (EBSstatus != 1 || !isContain) {
                MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
                SysUtil.abort();
            }
            BatchExecuteResult result = (BatchExecuteResult)iwage.synForceStatus(idSet);
            NTPHelper.showActionResult((Component)((Object)this), result);
        }
        finally {
            if (is) {
                iMutex.releaseObjIDForUpdate("wage");
            }
        }
        this.refreshList();
    }

    private WageInfo getWageInfo(String id) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Currency.*"));
        selector.add(new SelectorItemInfo("Institution.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.ntType.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.id"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.name"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.bankAccountNumber"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.id"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.name"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.number"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorseDate"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.company.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedCompany.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedSupplier.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedCustomer.*"));
        selector.add(new SelectorItemInfo("billEntrys.company.*"));
        selector.add(new SelectorItemInfo("billEntrys.*"));
        WageInfo info = WageFactory.getRemoteInstance().getWageInfo((IObjectPK)new ObjectUuidPK(id), selector);
        return info;
    }

    private boolean existBankReturnStatus(WageInfo info) throws BOSException {
        boolean exist = false;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("wageId", (Object)info.getId().toString()));
        view.setFilter(fi);
        WageBillEntryCollection billEntrys = info.getBillEntrys();
        for (int i = 0; i < billEntrys.size(); ++i) {
            WageBillEntryInfo entry = billEntrys.get(i);
            if (entry.getBankReturnStatus() != null && !BankReturnStatusEnum.EB_PROCESSING.equals((Object)entry.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_PROCESSING.equals((Object)entry.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)entry.getBankReturnStatus())) continue;
            exist = true;
            break;
        }
        return exist;
    }

    private boolean isCommitToBEFinished(WageInfo info) throws BOSException {
        boolean exist = true;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("wageId", (Object)info.getId().toString()));
        view.setFilter(fi);
        ReceivableBillCollection coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo entry = coll.get(i);
            if (BankReturnStatusEnum.BANK_FAIL.equals((Object)entry.getBankReturnStatus()) || BankReturnStatusEnum.BANK_SUCCESS.equals((Object)entry.getBankReturnStatus())) continue;
            exist = false;
            break;
        }
        return exist;
    }

    private boolean isBankReturnStatus(WageInfo info, boolean rejected) throws BOSException {
        boolean flg = true;
        WageBillEntryCollection billEntrys = info.getBillEntrys();
        for (int i = 0; i < billEntrys.size(); ++i) {
            WageBillEntryInfo wageBillEntryInfo = billEntrys.get(i);
            if (wageBillEntryInfo.getBankReturnStatus() != null) {
                if (rejected) {
                    if (wageBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL || wageBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL) continue;
                    flg = false;
                    break;
                }
                if (wageBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) continue;
                flg = false;
                break;
            }
            flg = false;
            break;
        }
        return flg;
    }

    private List getCanReleaseList(WageInfo info) throws BOSException {
        WageBillEntryCollection billEntrys = info.getBillEntrys();
        ArrayList<ReceivableBillInfo> list = new ArrayList<ReceivableBillInfo>();
        boolean failCount = false;
        for (int i = 0; i < billEntrys.size(); ++i) {
            WageBillEntryInfo wageBillEntryInfo = billEntrys.get(i);
            ReceivableBillInfo recInfo = billEntrys.get(i).getReceivableBill();
            if (!BankReturnStatusEnum.COMMIT_FAIL.equals((Object)wageBillEntryInfo.getBankReturnStatus()) && !BankReturnStatusEnum.BANK_FAIL.equals((Object)wageBillEntryInfo.getBankReturnStatus())) continue;
            list.add(recInfo);
        }
        return list;
    }

    @Override
    public void actionEditStatus_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        WageCollection coll = this.getWageColl(idSet);
        if (!this.existBEException(coll)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"597_DiscountBillListUI"));
            SysUtil.abort();
        }
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus != 1 || !isContain) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", this.getBEExceptionColl(coll));
        String uiName = DraftUpdateStatusListUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        List<Map<String, Object>> statusList = ((DraftUpdateStatusListUI)uiWindow.getUIObject()).getStatusList();
        if (statusList == null) {
            return;
        }
        BatchExecuteResult result = (BatchExecuteResult)WageFactory.getRemoteInstance().updateEntryStatus((List)idList, statusList);
        NTPHelper.showActionResult((Component)((Object)this), result);
        this.refreshList();
    }

    private WageCollection getWageColl(Set idSet) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billEntrys.id"));
        sic.add(new SelectorItemInfo("billEntrys.elecBillStatus"));
        sic.add(new SelectorItemInfo("billEntrys.bankReturnStatus"));
        sic.add(new SelectorItemInfo("billEntrys.bankReturnMsg"));
        sic.add(new SelectorItemInfo("billEntrys.isNoteCancel"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        view.setSelector(sic);
        WageCollection coll = ((IWage)this.getBizInterface()).getWageCollection(view);
        return coll;
    }

    private boolean existBEException(WageCollection coll) {
        WageInfo info;
        boolean exist = false;
        for (int i = 0; i < coll.size() && !(exist = this.existBEException(info = coll.get(i))); ++i) {
        }
        return exist;
    }

    private List<Map<String, Object>> getBEExceptionColl(WageCollection coll) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < coll.size(); ++i) {
            WageInfo wageInfo = coll.get(i);
            WageBillEntryCollection entrys = wageInfo.getBillEntrys();
            for (int j = 0; j < entrys.size(); ++j) {
                WageBillEntryInfo entryInfo = entrys.get(j);
                if (entryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", entryInfo.getId().toString());
                map.put("draftNumber", entryInfo.getReceivableBill().getDraftNumber());
                list.add(map);
            }
        }
        return list;
    }

    @Override
    public void actionNoteCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectedIDs = this.getSelectedIdValues();
        ArrayList entryIdList = this.getSelectedEntryIdValues();
        int EBSstatus = BankFacadeFactory.getRemoteInstance().getEBSstatus();
        boolean isContain = BankFacadeFactory.getRemoteInstance().isVersion4Note();
        if (EBSstatus != 1 || !isContain) {
            MsgBox.showInfo((String)EASResource.getString((String)NTP_RES, (String)"061_BE_SERVICE_FAILURE"));
            SysUtil.abort();
        }
        BatchExecuteResult result = (BatchExecuteResult)((IWage)this.getBizInterface()).noteCancels((List)selectedIDs, new HashSet(entryIdList));
        NTPHelper.showActionResult((Component)((Object)this), result);
        this.refreshList();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add(new SelectorItemInfo("billEntrys.*"));
        sic.add(new SelectorItemInfo("billEntrys.elecBillStatus"));
        sic.add(new SelectorItemInfo("billEntrys.bankReturnStatus"));
        sic.add(new SelectorItemInfo("billEntrys.bankReturnMsg"));
        sic.add(new SelectorItemInfo("billEntrys.isNoteCancel"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.draftNumber"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.company.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.ntType.*"));
        return sic;
    }

    protected ArrayList getSelectedEntryIdValues() {
        int mode = 0;
        ArrayList blockList = this.tblMain.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            this.tblMain.setRowCount(this.getRowCountFromDB());
            this.tblMain.reLayoutAndPaint();
        }
        ArrayList selectList = new ArrayList();
        List selectKeyIdFields = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        return ListUiHelper.getSelectedIdValues((KDTable)this.tblMain, (String)this.getEntriesPKName(), selectList, selectKeyIdFields);
    }

    public String getEntriesPKName() {
        return "entrys.id";
    }

    protected WageBillEntryCollection getWageBillEntryColl(ArrayList idList) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("receivableBill.*"));
        sic.add(new SelectorItemInfo("receivableBill.currency.*"));
        sic.add(new SelectorItemInfo("receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("parent.isCommitToBE"));
        sic.add(new SelectorItemInfo("parent.Institution.*"));
        view.setSelector(sic);
        WageBillEntryCollection coll = new WageBillEntryCollection();
        try {
            coll = WageBillEntryFactory.getRemoteInstance().getWageBillEntryCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return coll;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            ReceivablePledgeListUI.this.setListUITable(ReceivablePledgeListUI.this.tblMain, e);
        }
    }
}

