/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivableRecBatchUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ReceivableRecBatchUI
extends AbstractReceivableRecBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableRecBatchUI.class);
    private CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private IObjectCollection receivableCol = null;
    private CurrencyInfo curCurrency = null;
    private CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.curCompany);
    private UserInfo curUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private int curCurrencyPrecision = 2;
    private int baseCurrencyPrecision = FMClientHelper.getPrecOfCurrency((BOSUuid)this.baseCurrency.getId());
    private CompanyOrgUnitInfo currentCompany;

    private void setCurCurrencyPrecision() {
        if (this.receivableCol == null || this.receivableCol.size() == 0) {
            return;
        }
        IObjectValue ov = this.receivableCol.getObject(0);
        if (ov instanceof ReceivableBillInfo) {
            ReceivableBillInfo billInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
            this.curCurrencyPrecision = billInfo.getCurrency().getPrecision();
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.receivableCol = (IObjectCollection)this.getUIContext().get("ReceivableColl");
        this.setCurCurrencyPrecision();
        if (this.receivableCol == null || this.receivableCol.size() == 0) {
            return;
        }
        ReceivableBillInfo billInfo = (ReceivableBillInfo)this.receivableCol.getObject(0);
        this.curCurrency = billInfo.getCurrency();
        this.txtExRate.setDataType(1);
        this.txtExRate.setPrecision(4);
        this.txtExRate.setRoundingMode(4);
        this.txtExRate.setHorizontalAlignment(4);
        this.txtExRate.setRemoveingZeroInDispaly(true);
        this.txtExRate.setNegatived(false);
        ExchangeRateInfo exchangeInfo = FMClientHelper.getExRateInfo((String)this.curCompany.getId().toString(), (String)this.curCurrency.getId().toString(), (String)this.baseCurrency.getId().toString(), (Date)((Date)this.pkDate.getValue()));
        if (exchangeInfo != null) {
            this.txtExRate.setPrecision(exchangeInfo.getPrecision());
            this.txtExRate.setValue((Object)exchangeInfo.getConvertRate());
        } else {
            this.txtExRate.setPrecision(5);
            this.txtExRate.setValue((Object)Constants.ONE);
        }
        if (this.curCurrency.getId().toString().equals(this.baseCurrency.getId().toString())) {
            this.txtExRate.setEnabled(false);
        }
        this.fillTable(this.receivableCol);
        this.actionAttachment.setVisible(false);
        this.actionSubmit.setEnabled(true);
        this.actionViewBgBalance.setEnabled(true);
        CompanyOrgUnitInfo trustedCompany = (CompanyOrgUnitInfo)this.getUIContext().get("TrustedCompany");
        if (trustedCompany != null) {
            this.curCompany = trustedCompany;
        }
        this.setCostCenterF7();
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
    }

    protected void setCostCenterF7() {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(this.curCompany.getCU().getId().toString());
        try {
            String param = this.getSysParam("NT031");
            if (null != param && param.equals("0")) {
                costCenterF7.showCheckBoxOfShowingAllOUs();
                costCenterF7.setIsCUFilter(false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public String getSysParam(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), number);
        if (null != param) {
            return param;
        }
        return "0";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
    }

    private void fillTotalAmt(DataChangeEvent eventObj) {
        BigDecimal amt = Constants.ZERO;
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (i == this.tblMain.getSelectManager().getActiveRowIndex()) continue;
            amt = amt.add((BigDecimal)row.getCell("actAmt").getValue());
        }
        BigDecimal newValue = (BigDecimal)eventObj.getNewValue();
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("actAmt").setValue((Object)amt.add(newValue));
    }

    private void fillTable(IObjectCollection coll) {
        String numberFormat_AMT = FMClientHelper.getKDTNumFormat((int)this.curCurrencyPrecision);
        String numberLocFormat_AMT = FMClientHelper.getKDTNumFormat((int)this.baseCurrencyPrecision);
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        BigDecimal amt = Constants.ZERO;
        BigDecimal actAmt = Constants.ZERO;
        BigDecimal naturalAmt = Constants.ZERO;
        if (coll == null) {
            return;
        }
        this.tblMain.getColumn("exchangeRate").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("exchangeRate").getStyleAttributes().setNumberFormat("%r-[ ]0.5n");
        this.tblMain.getColumn("actLocAmt").setWidth(120);
        KDFormattedTextField txtLocAmt = new KDFormattedTextField();
        txtLocAmt.setDataType(1);
        txtLocAmt.setPrecision(this.baseCurrencyPrecision);
        this.tblMain.getColumn("actLocAmt").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtLocAmt));
        StyleAttributes styleAttributes = null;
        HashSet<AccountBankInfo> payeeAccountSet = new HashSet<AccountBankInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = this.tblMain.addRow();
            CoreBaseInfo vo = (CoreBaseInfo)coll.getObject(i);
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                if (this.tblMain.getColumnKey(j).equals("actAmt") || this.tblMain.getColumnKey(j).equals("actLocAmt")) continue;
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)vo, (Field)new Field(this.tblMain.getColumnKey(j))));
            }
            if (vo instanceof ReceivableBillInfo) {
                ReceivableBillInfo billInfo = (ReceivableBillInfo)vo;
                payeeAccountSet.add(billInfo.getPayeeAccount());
                row.getCell("number").setValue((Object)billInfo.getDraftNumber());
            } else if (vo instanceof PayableBillInfo) {
                PayableBillInfo billInfo = (PayableBillInfo)vo;
                row.getCell("number").setValue((Object)billInfo.getDraftNumber());
            }
            row.getCell("actAmt").setValue(row.getCell("billAmt").getValue());
            row.getCell("actLocAmt").setValue((Object)((BigDecimal)row.getCell("actAmt").getValue()).multiply(this.txtExRate.getBigDecimalValue()));
            styleAttributes = row.getCell("billAmt").getStyleAttributes();
            amt = amt.add((BigDecimal)row.getCell("billAmt").getValue());
            styleAttributes.setNumberFormat(numberFormat_AMT);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            styleAttributes = row.getCell("actAmt").getStyleAttributes();
            styleAttributes.setNumberFormat(numberFormat_AMT);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            styleAttributes = row.getCell("actLocAmt").getStyleAttributes();
            styleAttributes.setNumberFormat(numberLocFormat_AMT);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            styleAttributes = row.getCell("exchangeRate").getStyleAttributes();
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            styleAttributes = row.getCell("naturalAmt").getStyleAttributes();
            styleAttributes.setNumberFormat(numberLocFormat_AMT);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (row.getCell("actAmt").getValue() != null) {
                actAmt = actAmt.add((BigDecimal)row.getCell("actAmt").getValue());
            }
            if (row.getCell("naturalAmt").getValue() == null) continue;
            naturalAmt = naturalAmt.add((BigDecimal)row.getCell("naturalAmt").getValue());
        }
        if (payeeAccountSet.size() == 1) {
            this.prmtPayeeAccountBank.setValue(payeeAccountSet.iterator().next());
        }
        FinHelper.setLockColumn((KDTable)this.tblMain, (String[])new String[]{"number", "ntType", "currency", "actAmt", "billAmt", "issuesDate", "naturalAmt", "actLocAmt", "exchangeRate", "takeDate", "expiredDate", "deliverName", "acceptanceBankName"}, (boolean)true);
        IRow row = this.tblMain.addRow();
        row.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
        row.getCell("billAmt").setValue((Object)amt);
        row.getCell("actAmt").setValue((Object)actAmt);
        row.getCell("actLocAmt").setValue((Object)actAmt.multiply(this.txtExRate.getBigDecimalValue()));
        row.getCell("naturalAmt").setValue((Object)naturalAmt);
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getStyleAttributes().setNumberFormat("%r-[ ]0.2n");
        row.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    protected void prmtPayeeAccountBank_willShow(SelectorEvent e) throws Exception {
        String companyId = this.curCompany.getId().toString();
        this.prmtPayeeAccountBank.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo evi = CasRecPayHandler.getAccountBankEvi((String)companyId, null);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.curCurrency.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter.setMaskString("(#0 or #1)");
        evi.getFilter().mergeFilter(filter, "and");
        this.prmtPayeeAccountBank.setEntityViewInfo(evi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtPayeeAccountBank.setSelectorCollection(selectors);
    }

    @Override
    protected void prmtPayeeAccountBank_dataChanged(DataChangeEvent e) throws Exception {
        boolean isNotNull;
        boolean bl = isNotNull = e.getNewValue() != null;
        if (!isNotNull) {
            this.txtPayeeBank.setUserObject(null);
            this.txtPayeeBank.setText(null);
            return;
        }
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtPayeeAccountBank.getValue();
        IBank iBank = BankFactory.getRemoteInstance();
        BankInfo bankInfo = iBank.getBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getBank().getId()));
        this.txtPayeeBank.setUserObject((Object)bankInfo);
        this.txtPayeeBank.setText(bankInfo.getName());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceivingBillFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)((Date)this.pkDate.getValue()));
        ReceivingBillInfo recBillInfo = new ReceivingBillInfo();
        recBillInfo.setBizDate((Date)this.pkDate.getValue());
        recBillInfo.setRecDate((Date)this.pkDate.getValue());
        recBillInfo.setDescription(this.txtRemark.getText());
        recBillInfo.setPayeeBank((BankInfo)this.txtPayeeBank.getUserObject());
        recBillInfo.setPayeeAccountBank((AccountBankInfo)this.prmtPayeeAccountBank.getData());
        recBillInfo.setPayeeAccount(recBillInfo.getPayeeAccountBank().getAccount());
        recBillInfo.setExchangeRate(this.txtExRate.getBigDecimalValue());
        FMBgItemProp bgItemProp = recBillInfo.getBgItemProps()[0];
        if (this.prmtBgItem.getValue() == null) {
            recBillInfo.setString(bgItemProp.getBgItemIDProp(), null);
            recBillInfo.setString(bgItemProp.getBgItemNumberProp(), null);
            recBillInfo.setString(bgItemProp.getBgItemNameProp(), null);
        } else {
            VisualItemInfo bgItem = (VisualItemInfo)this.prmtBgItem.getValue();
            String bgItemId = bgItem.getId() == null ? null : bgItem.getId().toString();
            recBillInfo.setOppBgItemId(bgItemId);
            recBillInfo.setOppBgItemNumber(bgItem.getNumber());
            recBillInfo.setOppBgItemName(bgItem.getName());
        }
        if (this.prmtCostCenter.getData() != null) {
            recBillInfo.setCostCenter((CostCenterOrgUnitInfo)this.prmtCostCenter.getData());
        }
        ReceivableBillFactory.getRemoteInstance().batchReceiving(recBillInfo, (ReceivableBillCollection)this.receivableCol);
        this.getUIWindow().close();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayeeAccountBank);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        ReceivingBillInfo info = new ReceivingBillInfo();
        info.setCompany(this.curCompany);
        info.setBizDate((Date)this.pkDate.getValue());
        info.setCurrency(this.curCurrency);
        info.setCostCenter((CostCenterOrgUnitInfo)this.prmtCostCenter.getData());
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fi.cas.app.ReceivingBill", null, (IObjectValue)info);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        BigDecimal amt = new BigDecimal("0");
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            amt = amt.add((BigDecimal)this.tblMain.getRow(i).getCell("actLocAmt").getValue());
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("actLocAmt").setValue((Object)amt);
    }

    @Override
    protected void pkDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkDate_dataChanged(e);
        BigDecimal exchange = FMClientHelper.getExRate((String)this.curCompany.getId().toString(), (String)this.curCurrency.getId().toString(), (String)this.baseCurrency.getId().toString(), (Date)((Date)this.pkDate.getValue()));
        this.txtExRate.setValue((Object)exchange);
    }

    @Override
    protected void txtExRate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        BigDecimal amt = new BigDecimal("0");
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            this.tblMain.getRow(i).getCell("actLocAmt").setValue((Object)((BigDecimal)e.getNewValue()).multiply((BigDecimal)this.tblMain.getRow(i).getCell("actAmt").getValue()));
            amt = amt.add((BigDecimal)this.tblMain.getRow(i).getCell("actLocAmt").getValue());
        }
        this.tblMain.getRow(this.tblMain.getRowCount() - 1).getCell("actLocAmt").setValue((Object)amt);
    }

    public boolean destroyWindow() {
        this.releaseLockObject();
        return super.destroyWindow();
    }

    private void releaseLockObject() {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            idList.add(this.tblMain.getRow(i).getCell("id").getValue().toString());
        }
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.batchReleaseObjIDForUpdate(idList);
    }
}

