/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.CasReceivingBillUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivableRecQueryUI;
import com.kingdee.eas.fm.nt.client.ReceivableRecFilterUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class ReceivableRecQueryUI
extends AbstractReceivableRecQueryUI {
    protected ReceivableRecFilterUI filterUI;

    public ReceivableRecQueryUI() throws Exception {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)currentCompany);
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    protected String getCurrencyIdColName() {
        return "currency.id";
    }

    protected String[] getPrecColName() {
        return new String[]{"actAmt"};
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceivableRecFilterUI(BillSourceEnum.BYHAND);
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionViewBgBalance.setEnabled(true);
        this.actionSum.setEnabled(true);
        this.tblMain.getColumn("id").setGroup(true);
        this.tblMain.getColumn("compnay").setGroup(true);
    }

    @Override
    protected String getEditUIName() {
        return CasReceivingBillUI.class.getName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionRemove.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_chooseout"));
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        for (int i = 0; i < idList.size(); ++i) {
            ReceivingBillInfo info = ((IReceivingBill)this.getBizInterface()).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()), this.getSelectors());
            if (info == null) continue;
            FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)info.getRecDate());
        }
        ReceivableBillFactory.getRemoteInstance().removeGather(idList);
        this.refreshList();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "FINDVIEW") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "FINDVIEW");
        uiWindow.show();
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        for (int i = 0; i < this.getPrecColName().length; ++i) {
            this.tblMain.getFootRow(0).getCell(this.getPrecColName()[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
        }
        return row;
    }

    protected boolean isFootVisible() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("oppAccount.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("sourcebillid"));
        sic.add(new SelectorItemInfo("oppBgItemName"));
        sic.add(new SelectorItemInfo("oppBgItemNumber"));
        sic.add(new SelectorItemInfo("oppBgItemIds"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue();
            if (currencyId == null) continue;
            String[] formatCol = this.getPrecColName();
            for (int j = 0; j < formatCol.length; ++j) {
                FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
            }
        }
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ReceivingBillInfo info = ((IReceivingBill)this.getBizInterface()).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fi.cas.app.ReceivingBill", null, (IObjectValue)info);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ReceivingBillInfo info = ((IReceivingBill)this.getBizInterface()).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        boolean isWriteOffBill = false;
        if (!FMHelper.isEmpty((String)info.getSourceBillId()) && BOSUuid.read((String)info.getSourceBillId()).getType().equals((Object)new ReceivableBillInfo().getBOSType())) {
            ReceivableBillInfo recBillInfo = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            isWriteOffBill = recBillInfo.isIsWriteOff();
        }
        this.actionRemove.setEnabled(!isWriteOffBill);
        this.actionVoucher.setEnabled(!isWriteOffBill && !info.isFiVouchered());
        this.actionDelVoucher.setEnabled(info.isFiVouchered());
    }

    @Override
    public void actionSum_actionPerformed(ActionEvent e) throws Exception {
        super.actionSum_actionPerformed(e);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        String msg = FMClientHelper.sumList((KDTable)this.tblMain, (String)"receivingBill", (String)"actAmt");
        MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name", "receivableBillNumber"};
        return locateNames;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = this.tblMain.getColumn("id").getColumnIndex();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            ReceivableRecQueryUI.this.setListUITable(ReceivableRecQueryUI.this.tblMain, e);
        }
    }
}

