/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.client.AbstractReceivableTrusteeFilterUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.fm.nt.client.ReceivableTrustFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ReceivableTrusteeFilterUI
extends AbstractReceivableTrusteeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableTrusteeFilterUI.class);
    private static final String RESOURCES = "com.kingdee.eas.fm.nt.ReceivableBill";
    protected CurrencyInfo bassCurrency;

    public ReceivableTrusteeFilterUI() throws Exception {
        this.bassCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtTrusteeBank);
        this.comboBillState.addItem((Object)BillStateEnum.SAVED);
        this.comboBillState.addItem((Object)BillStateEnum.Audit);
        this.comboBillState.addItem((Object)BillStateEnum.GATHERED);
        this.comboBillState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.chkDispTotal.setSelected(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        ReceivableTrustFilterParam param = new ReceivableTrustFilterParam();
        param.setBeginDate((Date)this.pkBeginDate.getValue());
        param.setEndDate((Date)this.pkEndDate.getValue());
        param.setDispTotal(this.chkDispTotal.isSelected());
        Object value = this.prmtTrusteeBank.getData();
        HashSet<String> idSet = new HashSet<String>();
        if (value instanceof Object[]) {
            Object[] data = (Object[])value;
            if (data[0] != null) {
                BankInfo[] info = new BankInfo[data.length];
                for (int i = 0; i < data.length; ++i) {
                    info[i] = (BankInfo)data[i];
                    idSet.add(((BankInfo)data[i]).getId().toString());
                }
            }
        } else if (value != null) {
            idSet.add(((BankInfo)value).getId().toString());
        }
        param.setTrusteeBankIdSet(idSet);
        if (FMSysDefinedEnum.SELECT_ALL.equals(this.comboCurrency.getSelectedItem())) {
            param.setCurrency(null);
        } else {
            param.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        }
        if (!(this.comboBillState.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setBillstate((BillStateEnum)((Object)this.comboBillState.getSelectedItem()));
        } else {
            param.setBillstate(null);
        }
        return param;
    }

    protected Class getParamClass() {
        return ReceivableTrustFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return false;
    }

    public void setParam(Object param) {
        ReceivableTrustFilterParam para = (ReceivableTrustFilterParam)param;
        this.pkBeginDate.setValue((Object)para.getBeginDate());
        this.pkEndDate.setValue((Object)para.getEndDate());
        this.chkDispTotal.setSelected(para.isDispTotal());
        String[] companyIds = para.getCompanyIds();
        this.setCompanyIds(companyIds);
        try {
            this.prmtTrusteeBank.setValue((Object)super.getBaseInfoFromIdSet(para.getTrusteeBankIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (para.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)para.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (para.getBillstate() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboBillState, (Object)((Object)para.getBillstate()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboBillState, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    public void clear() {
        super.clear();
        this.pkBeginDate.setValue((Object)DateUtil.getDayBegin());
        this.pkEndDate.setValue((Object)DateUtil.getDayBegin());
        this.chkDispTotal.setSelected(false);
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.bassCurrency);
            FMClientHelper.setSelectObject((KDComboBox)this.comboBillState, (Object)((Object)BillStateEnum.SAVED));
            this.prmtTrusteeBank.setValue(null);
        }
        catch (Exception e) {
            MsgBox.showWarning((String)e.getMessage());
            SysUtil.abort();
        }
    }

    public boolean verify() {
        NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)this.pkBeginDate.getValue(), (Date)this.pkEndDate.getValue());
        return super.verify();
    }
}

