/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivableTrusteeListUI;
import com.kingdee.eas.fm.nt.client.ReceivableBillEditUI;
import com.kingdee.eas.fm.nt.client.ReceivableBillListUI;
import com.kingdee.eas.fm.nt.client.ReceivableRecBatchUI;
import com.kingdee.eas.fm.nt.client.ReceivableTrustFilterParam;
import com.kingdee.eas.fm.nt.client.ReceivableTrusteeFilterUI;
import com.kingdee.eas.fm.nt.client.ReceivableTrusteeUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceivableTrusteeListUI
extends AbstractReceivableTrusteeListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableTrusteeListUI.class);
    private CompanyOrgUnitInfo currentCompany;
    ReceivableTrusteeFilterUI filterUI;
    private static final String NTRESOURCE_PATH = "com.kingdee.eas.fm.nt.client.NtResource";
    private String allTotal = EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"allTotal");
    private String currencyTotal = EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"currencyTotal");
    private String trusteeTotal = EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"trusteeTotal");
    private KDTRow footRow;
    protected static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";

    public ReceivableTrusteeListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceivableTrusteeFilterUI();
        }
        return this.filterUI;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.tblMain.setEditable(false);
        this.tblMain.refresh();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
    }

    protected String getEditUIName() {
        return ReceivableBillEditUI.class.getName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCancelTrustee.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_trusteeship"));
        this.actionGather.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceivableBillFactory.getRemoteInstance();
    }

    @Override
    public void actionCancelTrustee_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"InitDataObject", (Object)this.getSelectedIDs());
        uiContext.put((Object)"uitype", (Object)new Integer(3));
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivableTrusteeUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refreshList();
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
    }

    public ArrayList getSelectedIDs() {
        ArrayList<String> list = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            String id;
            ICell cell = this.tblMain.getRow(selectRows[i]).getCell("id");
            if (cell == null || cell.getValue() == null || list.contains(id = cell.getValue().toString())) continue;
            list.add(id);
        }
        return list;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
    }

    protected void execQuery() {
        this.tblMain.setRefresh(false);
        if (this.filterUI != null) {
            ReceivableTrustFilterParam param = (ReceivableTrustFilterParam)this.getFilterParam();
            if (param.isDispTotal()) {
                this.tblMain.getDataRequestManager().setDataRequestMode(0);
                this.tblMain.getGroupManager().setGroup(true);
                String trusteeBankIndex = "trustBank";
                String currencyIndex = "currency";
                String amountIndex = "amount";
                String naturalAmtIndex = "naturalAmt";
                this.tblMain.getColumn(trusteeBankIndex).setGroup(true);
                this.tblMain.getColumn(currencyIndex).setGroup(true);
                this.tblMain.getGroupManager().setTotalize(true);
                this.tblMain.getColumn(trusteeBankIndex).setStat(true);
                this.tblMain.getColumn(currencyIndex).setStat(true);
                this.tblMain.getColumn(naturalAmtIndex).setStat(true);
                this.tblMain.getColumn(amountIndex).setStat(true);
                IRow row0 = this.tblMain.getGroupManager().getStatRowTemplate(-1);
                row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                row0.getCell(0).setValue((Object)this.allTotal);
                if (param.getCurrency() == null) {
                    row0.getCell(naturalAmtIndex).setExpressions("SUM");
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                    row0.getCell(amountIndex).setExpressions(null);
                } else {
                    row0.getCell(amountIndex).setExpressions("SUM");
                    row0.getCell(amountIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row0.getCell(amountIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                    row0.getCell(naturalAmtIndex).setExpressions(null);
                }
                row0 = this.tblMain.getGroupManager().getStatRowTemplate(0);
                row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
                row0.getCell(0).setValue((Object)this.trusteeTotal);
                if (param.getCurrency() == null) {
                    row0.getCell(naturalAmtIndex).setExpressions("SUM");
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                    row0.getCell(amountIndex).setExpressions(null);
                } else {
                    row0.getCell(amountIndex).setExpressions("SUM");
                    row0.getCell(amountIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row0.getCell(amountIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                    row0.getCell(naturalAmtIndex).setExpressions(null);
                }
                row0 = this.tblMain.getGroupManager().getStatRowTemplate(1);
                row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
                row0.getCell(1).setValue((Object)this.currencyTotal);
                row0.getCell(amountIndex).setExpressions("SUM");
                row0.getCell(amountIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row0.getCell(amountIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                if (param.getCurrency() == null) {
                    row0.getCell(naturalAmtIndex).setExpressions("SUM");
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row0.getCell(naturalAmtIndex).getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
                } else {
                    row0.getCell(naturalAmtIndex).setExpressions(null);
                }
                KDTFootManager footRowManager = this.tblMain.getFootManager();
                if (footRowManager != null && footRowManager.getFoot() != null) {
                    footRowManager.getFoot().removeRows();
                }
            } else {
                this.tblMain.getDataRequestManager().setDataRequestMode(1);
                this.tblMain.getGroupManager().setGroup(false);
                KDTFootManager footRowManager = this.tblMain.getFootManager();
                if (footRowManager != null && footRowManager.getFoot().size() <= 0) {
                    footRowManager.addFootRow(0);
                }
            }
        } else {
            this.tblMain.getDataRequestManager().setDataRequestMode(1);
            this.tblMain.getGroupManager().setGroup(false);
        }
        super.execQuery();
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
        if (this.tblMain.getFootManager() != null && this.tblMain.getFootManager().getFoot().size() > 0) {
            this.tblMain.getFootRow(0).getCell("amount").getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.tblMain.refresh();
        this.actionRefresh_actionPerformed(e);
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedKeyValue() != null) {
            super.actionView_actionPerformed(e);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIDs();
        if (idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        ReceivableBillInfo sourceBill = ((IReceivableBill)this.getBizInterface()).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.actionGather.setEnabled(sourceBill.getBillState() != BillStateEnum.GATHERED);
        this.actionCancelGather.setEnabled(sourceBill.getBillState() == BillStateEnum.GATHERED && !sourceBill.isIsWriteOff());
        if (sourceBill.isIsTrustee() && !sourceBill.isIsConfirmTrustee() || sourceBill.isIsTrustee() && sourceBill.isIsConfirmTrustee() && !sourceBill.isIsInWF()) {
            this.actionCancelTrustee.setEnabled(true);
        } else {
            this.actionCancelTrustee.setEnabled(false);
        }
    }

    @Override
    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIDs();
        if (idList.size() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ReceivableColl", (Object)new ReceivableBillListUI().getReceivableList4Gather(idList));
        if (idList.size() == 1) {
            Date currDate = DateTimeUtils.truncateDate((Date)new Date());
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            for (int i = 0; i < selectRows.length; ++i) {
                IRow row = this.tblMain.getRow(selectRows[i]);
                Date expiredDate = (Date)row.getCell("expiredDate").getValue();
                if (expiredDate.compareTo(currDate) <= 0 || MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"454_NotBillDueDate")) == 0) continue;
                return;
            }
        } else {
            this.checkSelected4Gather();
            this.checkGather(idList);
        }
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReceivableRecBatchUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    private void checkGather(ArrayList idList) throws BOSException {
        ArrayList msg = new ArrayList();
        StringBuffer str = new StringBuffer();
        Set idSet = FMHelper.list2Set((List)idList);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        ReceivableBillCollection coll = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo billInfo = coll.get(i);
            if (billInfo.getOutPledgeID() != null) {
                str.append(EASResource.getString((String)NTP_RES, (String)"134_BILL_OutPledge", (Object[])new String[]{billInfo.getDraftNumber()}));
                str.append("\r\n");
                continue;
            }
            if (billInfo.getTrusteeOutBill() != null) {
                str.append(EASResource.getString((String)NTP_RES, (String)"l135_BILL_TrusteeOutBill", (Object[])new String[]{billInfo.getDraftNumber()}));
                str.append("\r\n");
                continue;
            }
            if (billInfo.getTrusteeToPledgeBill() != null) {
                str.append(EASResource.getString((String)NTP_RES, (String)"136_BILL_TrusteeToPledgeBill", (Object[])new String[]{billInfo.getDraftNumber()}));
                str.append("\r\n");
                continue;
            }
            if (!billInfo.isIsPledgeToTrustee()) continue;
            str.append(EASResource.getString((String)NTP_RES, (String)"137_BILL_IsPledgeToTrustee", (Object[])new String[]{billInfo.getDraftNumber()}));
            str.append("\r\n");
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)NTP_RES, (String)"003_CHECK_FAIL"), (String)str.toString(), (int)1);
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancelGather_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIDs();
        if (idList.size() == 0) {
            return;
        }
        for (int i = 0; i < idList.size(); ++i) {
            String id = (String)idList.get(i);
            ReceivableBillInfo info = ReceivableBillFactory.getRemoteInstance().getReceivableBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (info != null) {
                FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)info.getTrustDate());
            }
            ReceivableBillFactory.getRemoteInstance().cancelGather(BOSUuid.read((String)id));
        }
        this.refreshList();
    }

    private void checkSelected4Gather() throws NTException {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            Date expiredDate = (Date)row.getCell("expiredDate").getValue();
            if (!new Date().before(expiredDate)) continue;
            throw new NTException(NTException.RECEIVABLECHECK);
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"number", "name", "draftNumber"};
        return locateNames;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(ReceivableTrusteeListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            ReceivableTrustFilterParam param;
            IRow row = null;
            String currencyId = null;
            tblMain.checkParsed();
            if (ReceivableTrusteeListUI.this.filterUI != null && (param = (ReceivableTrustFilterParam)ReceivableTrusteeListUI.this.getFilterParam()).isDispTotal()) {
                for (int i = 0; i < tblMain.getRowCount1() - 1; ++i) {
                    row = tblMain.getRow(i);
                    Object value = row.getCell("currency.id").getValue();
                    if (value == null) continue;
                    if (currencyId == null || !value.equals(currencyId)) {
                        currencyId = (String)value;
                    }
                    if (currencyId == null) continue;
                    FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"naturalAmt", (String)currencyId);
                }
                return;
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                currencyId = (String)row.getCell("currency.id").getValue();
                if (EmptyUtil.isEmpty((String)currencyId)) continue;
                FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"naturalAmt", (String)currencyId);
            }
        }
    }
}

