/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReceivableTrusteeUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ReceivableTrusteeUI
extends AbstractReceivableTrusteeUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivableTrusteeUI.class);
    private IObjectCollection truestedCol = null;
    public static final String UI_TYPE = "uitype";
    public static final int Trustee_OF_Confirm = 2;
    public static final int Trustee_OF_Save = 1;
    public static final int Trustee_OF_Cancel = 3;
    public static final int Trusteed_OF_ConfirmCancel = 4;
    IRow rowtotal = null;
    private int UI_Type;

    public ReceivableTrusteeUI() throws Exception {
        this.initWorkButton();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.tblMain.getSelectManager().setSelectMode(2);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtTrusteeBank, null, (boolean)true);
        this.setTruestedCol();
        this.fillTable(this.truestedCol);
        this.UI_Type = (Integer)this.getUIContext().get(UI_TYPE);
        switch (this.UI_Type) {
            case 1: {
                this.contTrusteeDate.setVisible(true);
                this.contTrusteeBank.setVisible(true);
                this.contCancelTrusteeDate.setVisible(false);
                this.contCancelTrustee.setVisible(false);
                this.kDLabelContainerRemark.setVisible(true);
                break;
            }
            case 3: {
                this.contTrusteeDate.setVisible(false);
                this.contTrusteeBank.setVisible(false);
                this.contCancelTrusteeDate.setVisible(true);
                this.contCancelTrustee.setVisible(true);
                this.kDLabelContainerRemark.setVisible(false);
                this.prmtCancelTrustee.setValue((Object)ContextHelperFactory.getRemoteInstance().getCurrentUser());
                break;
            }
            case 2: 
            case 4: {
                this.contTrusteeDate.setVisible(false);
                this.contTrusteeBank.setVisible(false);
                this.contCancelTrusteeDate.setVisible(false);
                this.contCancelTrustee.setVisible(false);
                this.kDLabelContainerRemark.setVisible(false);
                this.tblMain.setBounds(new Rectangle(10, 10, 779, 274));
                this.add((Component)this.tblMain, null);
            }
        }
        this.txtRemark.setMaxLength(60);
    }

    private void setTruestedCol() {
        HashSet idList = new HashSet((ArrayList)this.getUIContext().get("InitDataObject"));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("currency.*"));
        view.getSelector().add(new SelectorItemInfo("company.*"));
        view.getSelector().add(new SelectorItemInfo("ntType.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idList, CompareType.INCLUDE));
        view.setFilter(filter);
        ReceivableBillCollection recColl = null;
        try {
            recColl = ReceivableBillFactory.getRemoteInstance().getReceivableBillCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.truestedCol = recColl;
    }

    public boolean destroyWindow() {
        this.releaseLockObject();
        return super.destroyWindow();
    }

    private void releaseLockObject() {
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < this.truestedCol.size(); ++i) {
            ReceivableBillInfo vo = (ReceivableBillInfo)this.truestedCol.getObject(i);
            idList.add(vo.getId().toString());
        }
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.batchReleaseObjIDForUpdate(idList);
    }

    private void fillTable(IObjectCollection coll) {
        int i;
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        if (coll == null) {
            return;
        }
        StyleAttributes styleAttributes = null;
        this.UI_Type = (Integer)this.getUIContext().get(UI_TYPE);
        BigDecimal total = new BigDecimal(0.0);
        for (i = 0; i < coll.size(); ++i) {
            ReceivableBillInfo vo = (ReceivableBillInfo)coll.getObject(i);
            IRow row = this.tblMain.addRow();
            for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                if (this.tblMain.getColumnKey(j).equals("selected")) continue;
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)vo, (Field)new Field(this.tblMain.getColumnKey(j))));
                if (!this.tblMain.getColumnKey(j).equals("connectAmount")) {
                    row.getCell(j).getStyleAttributes().setLocked(true);
                    continue;
                }
                if (this.UI_Type != 3) continue;
                row.getCell(j).getStyleAttributes().setLocked(true);
            }
            row.getCell("number").setValue((Object)vo.getDraftNumber());
            styleAttributes = row.getCell("billAmt").getStyleAttributes();
            styleAttributes.setNumberFormat("%r-[ ]0.2n");
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            total = total.add((BigDecimal)row.getCell("billAmt").getValue());
        }
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell("selected").setValue((Object)new Boolean(true));
        }
        this.rowtotal = this.tblMain.addRow();
        this.rowtotal.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI"));
        this.rowtotal.getCell("billAmt").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDecimalFormatString());
        this.rowtotal.getStyleAttributes().setLocked(true);
        this.rowtotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        this.rowtotal.getCell("billAmt").setValue((Object)total);
        this.rowtotal.getCell("billAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void initWorkButton() {
        this.menuItemExitCurrent.setVisible(false);
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
    }

    private boolean isSelected(String id) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(1).getValue().equals(EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"239_DiscountBillBatchEditUI")) || !id.equals(row.getCell("id").getValue().toString()) || row.getCell("selected").getValue() == null || !((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.truestedCol == null) {
            this.getUIWindow().close();
            return;
        }
        BankInfo bank = (BankInfo)this.prmtTrusteeBank.getValue();
        String digest = EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceivableBill", (String)"TrusteeBank");
        CoreBaseCollection col = new CoreBaseCollection();
        this.verify(this.UI_Type);
        if (this.UI_Type == 1) {
            FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)((Date)this.dpTrusteeDate.getValue()));
        }
        if (this.UI_Type == 3) {
            FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)((Date)this.dpCancelTrusteeDate.getValue()));
        }
        if (this.isSelectedOne()) {
            switch (this.UI_Type) {
                case 1: {
                    int i = 0;
                    for (ReceivableBillInfo element : this.truestedCol) {
                        if (!this.isSelected(element.getId().toString())) continue;
                        element.setTrustDate((Date)this.dpTrusteeDate.getValue());
                        element.setTrusteeBank(bank);
                        element.setTrusteeCompany(bank.getRelatedCompany());
                        element.setDigest(digest + bank.getName());
                        element.setIsTrustee(true);
                        element.setIsInWF(true);
                        element.setRemark(this.txtRemark.getText());
                        this.tblMain.getValueAt(i, this.tblMain.getColumnIndex("connectAmount"));
                        element.setConnectAmount((String)this.tblMain.getValueAt(i, this.tblMain.getColumnIndex("connectAmount")));
                        ++i;
                        col.add((CoreBaseInfo)element);
                    }
                    ReceivableBillFactory.getRemoteInstance().trust((IObjectCollection)col);
                    break;
                }
                case 2: {
                    int j = 0;
                    for (ReceivableBillInfo element : this.truestedCol) {
                        if (!this.isSelected(element.getId().toString())) continue;
                        element.setIsConfirmTrustee(true);
                        element.setIsInWF(false);
                        element.setRemark(this.txtRemark.getText());
                        element.setConnectAmount((String)this.tblMain.getValueAt(j, this.tblMain.getColumnIndex("connectAmount")));
                        ++j;
                        col.add((CoreBaseInfo)element);
                    }
                    ReceivableBillFactory.getRemoteInstance().update(col);
                    break;
                }
                case 3: {
                    for (ReceivableBillInfo element : this.truestedCol) {
                        if (!this.isSelected(element.getId().toString())) continue;
                        element.setConfirmCancel(false);
                        if (!element.isIsConfirmTrustee()) {
                            element.setIsInWF(false);
                        } else {
                            element.setIsInWF(true);
                        }
                        col.add((CoreBaseInfo)element);
                    }
                    ReceivableBillFactory.getRemoteInstance().cancelTrust((IObjectCollection)col);
                    break;
                }
                default: {
                    for (ReceivableBillInfo element : this.truestedCol) {
                        if (!this.isSelected(element.getId().toString())) continue;
                        element.setConfirmCancel(true);
                        element.setPledgeDetailId("ddd");
                        col.add((CoreBaseInfo)element);
                    }
                    ReceivableBillFactory.getRemoteInstance().cancelTrust((IObjectCollection)col);
                }
            }
        }
        this.getUIWindow().close();
    }

    public boolean isSelectedOne() {
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell("selected").getValue() == null || !((Boolean)row.getCell("selected").getValue()).booleanValue()) continue;
            return true;
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        SysUtil.abort();
        return false;
    }

    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void verify(int UI_Type) throws Exception {
        if (UI_Type == 1) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtTrusteeBank);
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpTrusteeDate);
        }
        if (UI_Type == 3) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpCancelTrusteeDate);
        }
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (UI_Type == 1 && ((Date)this.dpTrusteeDate.getValue()).before((Date)row.getCell("takeDate").getValue())) {
                throw new NTException(NTException.TRUSTEDDATEAFTERISSUEDATE);
            }
            if (UI_Type != 3 || !((Date)this.dpCancelTrusteeDate.getValue()).before((Date)row.getCell("trustDate").getValue())) continue;
            throw new NTException(NTException.CANCELTRUSTEDATEAFTERTRUSTDATE);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        BigDecimal total = new BigDecimal(0.0);
        for (int i = 0; i < this.tblMain.getRowCount() - 1; ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell("selected").getValue();
            Boolean isSelected = (Boolean)this.tblMain.getCell(row.getRowIndex(), 0).getValue();
            if (!isSelected.booleanValue()) continue;
            total = total.add((BigDecimal)this.tblMain.getCell(row.getRowIndex(), this.tblMain.getColumnIndex("billAmt")).getValue());
        }
        this.rowtotal.getCell("billAmt").setValue((Object)total);
    }
}

