/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.IProvince;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.NoteKindEnum;
import com.kingdee.eas.fm.nt.ReceiptBillFactory;
import com.kingdee.eas.fm.nt.ReceiptBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractRemitBillEditUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.fm.nt.client.TeleOrderTDDelegate;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.fm.nt.client.util.ReceiptBillUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;

public class RemitBillEditUI
extends AbstractRemitBillEditUI {
    private boolean modefiedBoth = false;
    private final ProvinceInfo localProvince;
    private final CityInfo localCity;
    private Locale locale = SysContext.getSysContext().getLocale();

    public RemitBillEditUI() throws Exception {
        if (this.currentCompany.isIsAdminOrgUnit()) {
            Object[] values = ReceiptBillUtil.getAddressByAdminOrgId(this.currentCompany.getId().toString());
            if (values != null) {
                this.localProvince = (ProvinceInfo)values[0];
                this.localCity = (CityInfo)values[1];
            } else {
                this.localProvince = null;
                this.localCity = null;
            }
        } else {
            this.localProvince = null;
            this.localCity = null;
        }
    }

    public void onLoad() throws Exception {
        Map listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        if (!this.oprtState.equals(OprtState.VIEW) && !this.currentCompany.isIsBizUnit()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"companyisnull"));
            SysUtil.abort();
        }
        HashSet<Integer> remitSet = new HashSet<Integer>();
        remitSet.add(new Integer(1));
        remitSet.add(new Integer(11));
        remitSet.add(new Integer(51));
        remitSet.add(new Integer(52));
        remitSet.add(new Integer(7));
        remitSet.add(new Integer(91));
        remitSet.add(new Integer(3));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group", remitSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE, CompareType.EQUALS));
        NTClientHelper.initEmptyNTTypeComboxByFilter(this.comboNtType, true, filter);
        FMClientHelper.initComboCurrency((KDComboBox)this.prmtCurrency, (boolean)true);
        this.txtAmount.setNegatived(false);
        this.txtAmount.setPrecision(FMClientHelper.getLocalCurPre());
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        super.onLoad();
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtSigner);
        ReceiptBillUtil.initF7BankAccount(this.prmtPayerBankAcct);
        ChequeUtil.setSupplierF7((CoreUIObject)this, this.prmtPayeeName, this.currentCompany);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.comboNtType.setEnabled(true);
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        ExtendParser txtPayeeBankAcctNumParser = new ExtendParser(this.txtPayeeBankAcct);
        this.txtPayeeBankAcct.setCommitParser((IParser)txtPayeeBankAcctNumParser);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        int oldIndex = this.idList.getCurrentIndex();
        if (oldIndex < 0) {
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
        }
        if (this.oprtState.equals(OprtState.VIEW) && this.currentCompany.isIsCompanyOrgUnit()) {
            this.actionAddNew.setEnabled(true);
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(false);
        }
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.txtNumber.setEditable(true);
            this.txtKeeper.setEditable(false);
        }
        if (this.oprtState.equals(OprtState.EDIT)) {
            this.txtNumber.setEditable(false);
            this.txtKeeper.setEditable(false);
            this.txtPayerName.setEditable(false);
            this.editData = (ReceiptBillInfo)this.getDataObject();
            if (this.editData != null && this.editData.getPayeeBankAcct() != null && this.editData.getPayeeBankAcct().getCurrency() != null) {
                this.prmtCurrency.setEnabled(false);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocusInWindow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.actionViewDoProccess.setEnabled(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionViewSubmitProccess.setEnabled(false);
        this.actionViewSubmitProccess.setVisible(false);
        this.actionSendMessage.setEnabled(false);
        this.actionSendMessage.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.menuWorkflow.setEnabled(false);
        this.menuWorkflow.setVisible(false);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        NTTypeInfo ntType = this.editData.getNtType();
        if (ntType != null && ntType.getId() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboNtType, (Object)ntType);
        }
        if (this.editData.getCurrency() == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.prmtCurrency, (Object)this.editData.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.prmtCurrency, (Object)this.editData.getCurrency());
        }
        if (this.editData.getInProvince() != null) {
            this.prmtInProvince.setValue((Object)this.editData.getInProvince());
        } else {
            this.prmtInProvince.setValue((Object)this.editData.getInProName());
        }
        if (this.editData.getInCity() != null) {
            this.prmtInCity.setValue((Object)this.editData.getInCity());
        } else {
            this.prmtInCity.setValue((Object)this.editData.getInCityName());
        }
        this.prmtPayeeName.setValue((Object)this.editData.getPayerName());
        this.txtPayeeBankAcct.setText(this.editData.getPayerBankAcct());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("inProvince.*"));
        sic.add(new SelectorItemInfo("inCity.*"));
        sic.add(new SelectorItemInfo("inProName"));
        sic.add(new SelectorItemInfo("inCityName"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("payeeBankAcct.*"));
        sic.add(new SelectorItemInfo("payerBankAcct"));
        return sic;
    }

    @Override
    public void storeFields() {
        Object c;
        super.storeFields();
        Object p = this.prmtInProvince.getValue();
        if (p != null) {
            if (p instanceof ProvinceInfo) {
                ProvinceInfo provinceInfo = (ProvinceInfo)p;
                this.editData.setInProvince(provinceInfo);
                this.editData.setInProName(null);
            } else if (p instanceof String) {
                this.editData.setInProvince(null);
                this.editData.setInProName(p.toString());
            }
        }
        if ((c = this.prmtInCity.getValue()) != null) {
            if (c instanceof CityInfo) {
                CityInfo cityInfo = (CityInfo)c;
                this.editData.setInCity(cityInfo);
                this.editData.setInCityName(null);
            } else if (c instanceof String) {
                this.editData.setInCity(null);
                this.editData.setInCityName(c.toString());
            }
        }
        this.editData.setCurrency((CurrencyInfo)this.prmtCurrency.getSelectedItem());
        this.editData.setPayerName(this.prmtPayeeName.getText());
        this.editData.setPayerBankAcct(this.txtPayeeBankAcct.getText());
    }

    protected String getClassAlise() {
        return EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"OutBill");
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
    }

    @Override
    protected String getEditUIName() {
        return RemitBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReceiptBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        ReceiptBillInfo objectValue = new ReceiptBillInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        objectValue.setCompany(this.currentCompany);
        objectValue.setReceiptDate(DateTimeUtils.truncateDate((Date)new Date()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        NTTypeInfo teleorder = null;
        try {
            teleorder = NTTypeFactory.getRemoteInstance().getNTTypeInfo((IObjectPK)new ObjectUuidPK("NE9M9QEREADgAAhvwKgSFRyakBM="), sic);
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        objectValue.setNtType(teleorder);
        objectValue.setPayeeName(this.currentCompany.getName());
        objectValue.setNoteKind(NoteKindEnum.remitBill);
        objectValue.setKeeper(ContextHelperFactory.getRemoteInstance().getCurrentUser().getName());
        objectValue.setOutProvince(this.localProvince);
        objectValue.setOutCity(this.localCity);
        ReceiptBillUtil.setAutoNumber(objectValue, NoteKindEnum.remitBill);
        return objectValue;
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        this.setSaved(false);
    }

    protected void initListener() {
        super.initListener();
        ReceiptBillUtil.enableTxtInput((KDPromptBox)this.prmtPayeeName);
        ReceiptBillUtil.enableTxtInput((KDPromptBox)this.prmtInProvince);
        ReceiptBillUtil.enableTxtInput((KDPromptBox)this.prmtInCity);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        if (!(this.oprtState.equals(OprtState.VIEW) || this.editData.getId() != null && this.isSaved() && !this.isModify())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> id = new ArrayList<String>();
        id.add(this.editData.getId().toString());
        NTTypeGroupEnum group = this.editData.getNtType().getGroup();
        if (group == null) {
            this.storeFields();
            group = this.editData.getNtType().getGroup();
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        TeleOrderTDDelegate data = new TeleOrderTDDelegate(id);
        appHlp.print("/FM/NT/TeleOrder", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrintPreview_actionPerformed(e);
        if (!(this.oprtState.equals(OprtState.VIEW) || this.editData.getId() != null && this.isSaved() && !this.isModify())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> id = new ArrayList<String>();
        id.add(this.editData.getId().toString());
        NTTypeGroupEnum group = this.editData.getNtType().getGroup();
        if (group == null) {
            this.storeFields();
            group = this.editData.getNtType().getGroup();
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        TeleOrderTDDelegate data = new TeleOrderTDDelegate(id);
        appHlp.printPreview("/FM/NT/TeleOrder", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    protected void prmtCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.prmtCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo infos = (CurrencyInfo)this.prmtCurrency.getSelectedItem();
        if (infos != null) {
            this.txtAmount.setPrecision(infos.getPrecision());
        }
    }

    @Override
    protected void prmtPayerBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayerBankAcct_dataChanged(e);
        Object acctBank = e.getNewValue();
        if (acctBank instanceof AccountBankInfo) {
            AccountBankInfo bankAcct = (AccountBankInfo)acctBank;
            IBank iabn = BankFactory.getRemoteInstance();
            BankInfo bankinfo = iabn.getBankInfo((IObjectPK)new ObjectUuidPK(bankAcct.getBank().getId()));
            this.txtPayerBank.setText(bankinfo.getName());
            if (bankAcct.getCurrency() != null) {
                String currencyID = bankAcct.getCurrency().getId().toString();
                CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
                FMClientHelper.setSelectObject((KDComboBox)this.prmtCurrency, (Object)currency);
                this.prmtCurrency.setEnabled(false);
            } else {
                this.prmtCurrency.setEnabled(true);
            }
        } else {
            this.prmtCurrency.setEnabled(true);
        }
    }

    @Override
    protected void prmtPayeeName_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayeeName_dataChanged(e);
        Object supplierInfo = e.getNewValue();
        if (supplierInfo instanceof SupplierInfo) {
            SupplierInfo supplier = (SupplierInfo)supplierInfo;
            ReceiptBillUtil.setBankAcctBySupplier(supplier, this.txtPayeeBankAcct, this.txtPayeeBank);
            this.modefiedBoth = true;
            ReceiptBillUtil.setAddressBySupplier(supplier, (KDPromptBox)this.prmtInProvince, (KDPromptBox)this.prmtInCity);
            this.modefiedBoth = false;
        } else if (supplierInfo instanceof String) {
            this.prmtPayeeName.commitEdit();
        }
    }

    @Override
    protected void prmtInProvince_dataChanged(DataChangeEvent e) throws Exception {
        if (this.modefiedBoth) {
            return;
        }
        this.modefiedBoth = true;
        this.prmtInCity.setValue(null);
        this.modefiedBoth = false;
    }

    @Override
    protected void prmtOutProvince_dataChanged(DataChangeEvent e) throws Exception {
        if (this.modefiedBoth) {
            return;
        }
        this.modefiedBoth = true;
        this.prmtOutCity.setValue(null);
        this.modefiedBoth = false;
    }

    @Override
    protected void prmtOutCity_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOutCity_dataChanged(e);
        if (this.modefiedBoth) {
            return;
        }
        Object newValue = e.getNewValue();
        if (newValue instanceof CityInfo) {
            CityInfo city = (CityInfo)newValue;
            Object p = this.prmtOutProvince.getValue();
            ProvinceInfo pii = city.getProvince();
            if (pii != null && p instanceof ProvinceInfo) {
                ProvinceInfo pi = (ProvinceInfo)p;
                if (!pii.getId().equals((Object)pi.getId())) {
                    IProvince provinceBean = ProvinceFactory.getRemoteInstance();
                    CoreBaseInfo province = provinceBean.getValue((IObjectPK)new ObjectUuidPK(pii.getId()));
                    this.modefiedBoth = true;
                    this.prmtOutProvince.setData((Object)province);
                    this.modefiedBoth = false;
                }
            } else if (p == null && pii != null) {
                IProvince provinceBean = ProvinceFactory.getRemoteInstance();
                CoreBaseInfo province = provinceBean.getValue((IObjectPK)new ObjectUuidPK(pii.getId()));
                this.modefiedBoth = true;
                this.prmtOutProvince.setData((Object)province);
                this.modefiedBoth = false;
            }
        }
    }

    @Override
    protected void prmtOutCity_willCommit(CommitEvent e) throws Exception {
        this.initPrmtCity(this.prmtOutProvince, this.prmtOutCity);
    }

    @Override
    protected void prmtOutCity_willShow(SelectorEvent e) throws Exception {
        this.initPrmtCity(this.prmtOutProvince, this.prmtOutCity);
    }

    @Override
    protected void prmtInCity_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtInCity_dataChanged(e);
        if (this.modefiedBoth) {
            return;
        }
        Object newValue = e.getNewValue();
        if (newValue instanceof CityInfo) {
            CityInfo city = (CityInfo)newValue;
            Object p = this.prmtInProvince.getValue();
            ProvinceInfo pii = city.getProvince();
            if (pii != null && p instanceof ProvinceInfo) {
                ProvinceInfo pi = (ProvinceInfo)p;
                if (!pii.getId().equals((Object)pi.getId())) {
                    IProvince provinceBean = ProvinceFactory.getRemoteInstance();
                    CoreBaseInfo province = provinceBean.getValue((IObjectPK)new ObjectUuidPK(pii.getId()));
                    this.modefiedBoth = true;
                    this.prmtInProvince.setData((Object)province);
                    this.modefiedBoth = false;
                }
            } else if (p == null && pii != null) {
                IProvince provinceBean = ProvinceFactory.getRemoteInstance();
                CoreBaseInfo province = provinceBean.getValue((IObjectPK)new ObjectUuidPK(pii.getId()));
                this.modefiedBoth = true;
                this.prmtInProvince.setData((Object)province);
                this.modefiedBoth = false;
            }
        }
    }

    @Override
    protected void prmtInCity_willCommit(CommitEvent e) throws Exception {
        this.initPrmtCity(this.prmtInProvince, this.prmtInCity);
    }

    @Override
    protected void prmtInCity_willShow(SelectorEvent e) throws Exception {
        this.initPrmtCity(this.prmtInProvince, this.prmtInCity);
    }

    private void initPrmtCity(KDBizPromptBox prmtProvince, KDBizPromptBox prmtCity) throws Exception {
        if (this.modefiedBoth) {
            return;
        }
        Object val = prmtProvince.getValue();
        if (val instanceof ProvinceInfo) {
            ProvinceInfo province = (ProvinceInfo)val;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("province.id", (Object)province.getId()));
            filter.getFilterItems().add(new FilterItemInfo("province.id", null, CompareType.EMPTY));
            filter.setMaskString("#0 or #1");
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            prmtCity.setEntityViewInfo(evi);
            prmtCity.getQueryAgent().resetRuntimeEntityView();
        } else {
            prmtCity.setEntityViewInfo(new EntityViewInfo());
        }
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtAmount_dataChanged(e);
        BigDecimal amount = this.txtAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(Constants.MAX_VALUE) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.txtAmount.setValue(null);
            this.txtCapitalization.setText(null);
            SysUtil.abort();
        }
        if (this.txtAmount.getBigDecimalValue() == null) {
            this.txtCapitalization.setText("");
        } else {
            this.txtCapitalization.setText(GlUtils.getChineseFormat((BigDecimal)this.txtAmount.getBigDecimalValue(), (boolean)true, (Locale)this.locale));
        }
    }

    @Override
    protected void txtPayeeBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        SupplierCompanyBankInfo bankInfo;
        Object o = this.txtPayeeBankAcct.getData();
        if (o instanceof SupplierCompanyBankInfo && (bankInfo = (SupplierCompanyBankInfo)o) != null) {
            this.txtPayeeBank.setText(bankInfo.getBank());
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "ReceiptDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionEdit", "actionSubmit", "actionRemove"};
    }
}

