/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.IReturnBill;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.ReturnBillFactory;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractReturnPayableBillListUI;
import com.kingdee.eas.fm.nt.client.ReturnBillFilterUI;
import com.kingdee.eas.fm.nt.client.ReturnBillUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReturnPayableBillListUI
extends AbstractReturnPayableBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReturnPayableBillListUI.class);
    ReturnBillFilterUI filterUI;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static final String NT_RES = "com.kingdee.eas.fm.nt.NtResource";

    public ReturnPayableBillListUI() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    protected String getEditUIName() {
        return ReturnBillUI.class.getName();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void onshows() {
        this.tblMain.getColumn("bgItem").getStyleAttributes().setHided(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionCancelReturnBil.setEnabled(true);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.onshows();
    }

    protected void execQuery() {
        FilterInfo filter;
        if (this.getBOTPViewStatus() == 1 && (filter = NTHelper.mergeFilter4RPCreateFrom(this.currentCompany, this.getUIContext(), "PaymentBill")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("srcBillState", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("srcBillState", (Object)new Integer(5)));
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
        this.onshows();
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        this.tblMain.getFootRow(0).getCell("amount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
        return row;
    }

    protected boolean isFootVisible() {
        return true;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.setEnabled(true);
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionCancelReturnBil.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelreturnticket"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
        this.actionBook.setVisible(false);
        this.actionCancelBook.setVisible(false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReturnBillFactory.getRemoteInstance();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        ReturnBillInfo billInfo = ((IReturnBill)this.getBizInterface()).getReturnBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.actionVoucher.setEnabled(!billInfo.isFivouchered() && FMHelper.isEmpty((String)billInfo.getRpBillId()));
        this.actionDelVoucher.setEnabled(billInfo.isFivouchered());
        this.actionCancelReturnBil.setEnabled(!billInfo.isFivouchered());
        if (billInfo.getPayableBill() != null) {
            PayableBillInfo payInfo = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billInfo.getPayableBill().getId().toString())));
            boolean bCurCompany = this.currentCompany.getId().toString().equals(billInfo.getCompany().getId().toString());
            boolean bWillConfirmed = this.currentCompany.getId().toString().equals(payInfo.getApplyUnit().getId().toString());
            this.actionConfirm.setEnabled(bWillConfirmed && billInfo.getConfirmer() == null && !bCurCompany);
        }
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReturnBillFilterUI();
            this.filterUI.getUIContext().put("returnbilltype", new Integer(2));
        }
        return this.filterUI;
    }

    @Override
    public void actionCancelReturnBil_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        ReturnBillInfo billInfo = ((IReturnBill)this.getBizInterface()).getReturnBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        PayableBillInfo sourceBill = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billInfo.getSrcBillId())), sic);
        if (sourceBill.getMakeType().equals((Object)BillMakeTypeEnum.SUB) && billInfo.getConfirmer() != null) {
            MsgBox.showWarning((String)EASResource.getString((String)NT_RES, (String)"cannotCancelReturn"));
            SysUtil.abort();
        }
        FMClientHelper.checkParamFMJZ001((SystemEnum)SystemEnum.NT_MANAGEMENT, (Date)billInfo.getReturnDate());
        PayableBillFactory.getRemoteInstance().cancelReturnBill(sourceBill);
        this.refreshList();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        return sic;
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ReturnBillInfo billInfo = ((IReturnBill)this.getBizInterface()).getReturnBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (billInfo == null) {
            return;
        }
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"fromInfo", (Object)billInfo);
        uiCtx.put((Object)"isPayableConfirm", (Object)new Boolean(true));
        uiCtx.put((Object)"ID", (Object)id);
        IUIWindow editUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReturnBillUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
        editUI.show();
        this.refreshList();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(ReturnPayableBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            StyleAttributes styleAttributes = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                styleAttributes = row.getCell("amount").getStyleAttributes();
                styleAttributes.setNumberFormat("%r-[ ]0.2n");
                styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (row.getCell("billType") == null) continue;
                row.getCell("billType").setValue((Object)PayableBillStateEnum.getEnum((Integer)row.getCell("billType").getValue()));
            }
        }
    }
}

