/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.fm.ctl.RptLetterOfGuaranteeDetailFacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class RptPayableBillDetailBaseHandler
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.nt.client.RptPayableResource";
    private static String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    protected BigDecimal amountUnit = null;
    private HashMap GuaranteeMap = new HashMap();

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    public RptPayableBillDetailBaseHandler(FilterInfo filterInfo, KDTable kdt, AmountUnitEnum uni) {
        super(filterInfo, kdt);
        this.amountUnit = new BigDecimal(String.valueOf(uni.getValue()));
        try {
            this.GuaranteeMap = this.getGurantee();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RptPayableBillDetailBaseHandler(FilterInfo filterInfo, SorterItemCollection sorter, KDTable kdt, AmountUnitEnum uni) {
        super(filterInfo, sorter, kdt);
        this.amountUnit = new BigDecimal(String.valueOf(uni.getValue()));
        try {
            this.GuaranteeMap = this.getGurantee();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getQueryPath() {
        return "com.kingdee.eas.fm.nt.app.RptCommercialDraftDetailQuery";
    }

    public void endDataFill() {
        super.endDataFill();
        this.setMergeTotalValue();
        this.kdt.getSelectManager().setSelectMode(2);
    }

    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected abstract void insertHeadRow();

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("type").setValue((Object)this.getResString("type"));
        headRow.getCell("company").setValue((Object)this.getResString("company"));
        headRow.getCell("issueUnit").setValue((Object)this.getResString("issueUnit"));
        headRow.getCell("number").setValue((Object)this.getResString("draftNumber"));
        headRow.getCell("bank").setValue((Object)this.getResString("bank"));
        headRow.getCell("currency").setValue((Object)this.getResString("currency"));
        headRow.getCell("amount").setValue((Object)this.getResString("amount"));
        headRow.getCell("assureProportion").setValue((Object)this.getResString("assureProportion"));
        headRow.getCell("assureAmount").setValue((Object)this.getResString("assureAmount"));
        headRow.getCell("balance").setValue((Object)this.getResString("balance"));
        headRow.getCell("issueDate").setValue((Object)this.getResString("issueDate"));
        headRow.getCell("expiredDate").setValue((Object)this.getResString("expiredDate"));
        headRow.getCell("bizDate").setValue((Object)this.getResString("bizDate"));
        headRow.getCell("localAmount").setValue((Object)this.getResString("localAmount"));
        headRow.getCell("payee").setValue((Object)this.getResString("payee"));
        headRow.getCell("isIncredit").setValue((Object)this.getResString("isIncredit"));
        headRow.getCell("garanteeType").setValue((Object)this.getResString("garanteeType"));
        headRow.getCell("garantee").setValue((Object)this.getResString("garantee"));
        headRow.getCell("discountRate").setValue((Object)this.getResString("discountRate"));
        headRow.getCell("discount").setValue((Object)this.getResString("discount"));
        headRow.getCell("discountDate").setValue((Object)this.getResString("discountDate"));
        headRow.getCell("remark").setValue((Object)this.getResString("remark"));
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            row.getCell("type").setValue((Object)rs.getString("ntType.name"));
            row.getCell("company").setValue((Object)rs.getString("company.name"));
            row.getCell("issueUnit").setValue((Object)rs.getString("issueUnit"));
            row.getCell("number").setValue((Object)rs.getString("draftNumber"));
            row.getCell("bank").setValue((Object)rs.getString("Institution.name"));
            row.getCell("currency").setValue((Object)rs.getString("Currency.name"));
            row.getCell("amount").setValue((Object)rs.getBigDecimal("Amount").divide(this.amountUnit, 10, 4));
            BigDecimal aProportion = rs.getBigDecimal("assureProportion");
            if (aProportion == null) {
                aProportion = Constants.ZERO;
            }
            row.getCell("assureProportion").setValue((Object)aProportion.divide(this.amountUnit, 10, 4));
            row.getCell("assureAmount").setValue((Object)rs.getBigDecimal("assureAmount").divide(this.amountUnit, 10, 4));
            BigDecimal balance = ((BigDecimal)row.getCell("amount").getValue()).subtract((BigDecimal)row.getCell("assureAmount").getValue());
            row.getCell("balance").setValue((Object)balance);
            row.getCell("issueDate").setValue((Object)rs.getDate("IssueDate"));
            row.getCell("expiredDate").setValue((Object)rs.getDate("ExpiredDate"));
            Date date = rs.getDate("useRepayment.bizDate");
            if (date != null) {
                row.getCell("bizDate").setValue((Object)date);
            } else {
                row.getCell("bizDate").setValue((Object)"");
            }
            BigDecimal bAmount = rs.getBigDecimal("useRepayment.LocalAmount");
            BigDecimal amount = rs.getBigDecimal("Amount");
            if (bAmount != null) {
                row.getCell("localAmount").setValue((Object)amount.divide(this.amountUnit, 10, 4));
            } else {
                bAmount = Constants.ZERO;
                row.getCell("localAmount").setValue((Object)bAmount);
            }
            row.getCell("payee").setValue((Object)rs.getString("Payee"));
            row.getCell("isIncredit").setValue((Object)(rs.getBoolean("IsInCredit") ? yes : no));
            row.getCell("garanteeType").setValue((Object)rs.getString("GaranteeType.name"));
            row.getCell("garantee").setValue(this.GuaranteeMap.get(rs.getString("id")));
            row.getCell("discountRate").setValue((Object)rs.getBigDecimal("DiscountRate"));
            if (rs.getBigDecimal("Discount") != null) {
                row.getCell("discount").setValue((Object)rs.getBigDecimal("Discount").divide(this.amountUnit, 10, 4));
            }
            row.getCell("discountDate").setValue((Object)rs.getDate("DiscountDate"));
            row.getCell("remark").setValue((Object)rs.getString("Remark"));
            row.setUserObject((Object)rs.getString("id"));
        }
    }

    protected static void initDecimalCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
    }

    protected void setMergeTotalValue() {
        BigDecimal balanceSubTotal = Constants.ZERO;
        BigDecimal balanceTypeSubTotal = Constants.ZERO;
        BigDecimal balanceTotal = Constants.ZERO;
        int n = this.kdt.getRowCount();
        if (this.kdt.getRow(0) != null) {
            IRow firstRow = this.kdt.getRow(0);
            BigDecimal balanceTemp = new BigDecimal(firstRow.getCell("balance").getValue().toString());
            balanceSubTotal = balanceSubTotal.add(balanceTemp);
            balanceTypeSubTotal = balanceTypeSubTotal.add(balanceTemp);
            for (int i = 1; i < n - 1; ++i) {
                IRow iRow = this.kdt.getRow(i);
                if (iRow.getCell(5).getValue() != null) {
                    String s2 = iRow.getUserObject().toString();
                    balanceTemp = new BigDecimal(iRow.getCell("balance").getValue().toString());
                    Object s3 = this.kdt.getRow(i - 1).getCell(2).getValue();
                    Object s4 = this.kdt.getRow(i - 1).getUserObject();
                    if (s3 != null && s4.equals(s2)) continue;
                    balanceSubTotal = balanceSubTotal.add(balanceTemp);
                    balanceTypeSubTotal = balanceTypeSubTotal.add(balanceTemp);
                    continue;
                }
                Object s5 = this.kdt.getRow(i - 1).getCell(5).getValue();
                if (this.kdt.getRow(i - 2) == null) continue;
                Object s6 = this.kdt.getRow(i).getCell(0).getValue();
                if (s5 != null) continue;
                iRow.getCell("balance").setValue((Object)balanceSubTotal);
                balanceSubTotal = Constants.ZERO;
                if (!FMRptClientUtils.getSumTotalResString().equals(s6)) continue;
                iRow.getCell("balance").setValue((Object)balanceTypeSubTotal);
                balanceTotal = balanceTotal.add(balanceTypeSubTotal);
                balanceTypeSubTotal = Constants.ZERO;
            }
            IRow lastRow = this.kdt.getRow(n - 1);
            lastRow.getCell("balance").setValue((Object)balanceTotal);
        }
    }

    public HashMap getGurantee() throws BOSException {
        HashMap GuaranteeMap = RptLetterOfGuaranteeDetailFacadeFactory.getRemoteInstance().ReturnGuarantee(this.filterInfo, this.sorter, "t_nt_payablebill", this.getQueryPath());
        return GuaranteeMap;
    }
}

