/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.client.AbstractRptPayableMatureFilterUI;
import com.kingdee.eas.framework.report.util.RptParams;
import java.util.Date;
import java.util.Set;

public class RptPayableMatureFilterUI
extends AbstractRptPayableMatureFilterUI {
    private final CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private final CurrencyInfo currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.company);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
    }

    private void initControl() throws Exception {
        this.dpDateFrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpDateFrom.setSupportedEmpty(false);
        this.dpDateTo.setValue((Object)new Date());
        this.dpDateTo.setSupportedEmpty(false);
        this.prmtBank.setEnabledMultiSelection(true);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank);
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (KDDatePicker)this.dpDateFrom, (KDDatePicker)this.dpDateTo);
        return super.verify();
    }

    public void clear() {
        super.clear();
        this.prmtBank.setValue(null);
        this.dpDateFrom.setValue((Object)DateUtil.getSQLBegin((Date)DateUtil.getFirstDayOfCurMonth()));
        this.dpDateTo.setValue((Object)DateUtil.getSQLEnd((Date)new Date()));
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.currency);
    }

    public RptParams getCustomCondition() {
        RptParams param = new RptParams();
        param.setObject("companyIdSet", (Object)this.companyIdSet);
        param.setObject("dateFrom", (Object)DateUtil.getSQLBegin((Date)((Date)this.dpDateFrom.getValue())));
        param.setObject("dateTo", (Object)DateUtil.getSQLEnd((Date)((Date)this.dpDateTo.getValue())));
        Object val = this.comboCurrency.getSelectedItem();
        if (val instanceof CurrencyInfo) {
            param.setObject("currency", val);
        } else {
            param.setObject("currency", null);
        }
        param.setObject("bank", (Object)FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBank)));
        return param;
    }

    public void setCustomCondition(RptParams params) {
        Set bankIds;
        this.dpDateFrom.setValue(params.getObject("dateFrom"));
        this.dpDateTo.setValue(params.getObject("dateTo"));
        Object val = params.getObject("currency");
        if (val instanceof CurrencyInfo) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)val);
        }
        if ((bankIds = (Set)params.getObject("bank")) != null && bankIds.size() > 0) {
            try {
                IBank bank = BankFactory.getRemoteInstance();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankIds, CompareType.INCLUDE));
                view.setFilter(filter);
                this.prmtBank.setValue((Object)bank.getCollection(view).toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            this.prmtBank.setValue(null);
        }
    }
}

