/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.client.AbstractRptPayableTransferSumFilterUI;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class RptPayableTransferSumFilterUI
extends AbstractRptPayableTransferSumFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptPayableTransferSumFilterUI.class);
    public Set bankIdSet = null;
    public Set typeIdSet = null;

    public RptPayableTransferSumFilterUI() throws Exception {
        FinUtils.initCurrencyComboBox((KDComboBox)this.comboCurrency);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtInstitution, (Boolean)new Boolean(true));
        this.comboTransferType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        try {
            this.onInit(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void doInit() {
        this.initFirstDayOfMonth(this.pkFromDate);
        this.pkToDate.setValue((Object)new Date());
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.kDCheckBoxCommercial.setSelected(false);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany) && !FSClientHelper.isClearingHouseCompanyId((String)currentCompany.getId().toString())) {
            this.chkIA.setEnabled(false);
            this.btnSelectCompany.setEnabled(false);
            this.btnSelectCompany.setVisible(false);
        } else {
            this.chkIA.setEnabled(true);
            this.btnSelectCompany.setEnabled(true);
            this.btnSelectCompany.setVisible(true);
        }
    }

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.doInit();
    }

    private void initFirstDayOfMonth(KDDatePicker kdDate) {
        Date date = new Date();
        GregorianCalendar firstDay = new GregorianCalendar();
        firstDay.add(5, -(date.getDate() - 1));
        kdDate.setValue((Object)firstDay.getTime());
    }

    private Set getF7Bank() {
        String sql = " SELECT DISTINCT \"INSTITUTION\".FID AS \"INSTITUTION.ID\" FROM T_NT_PayableBill AS \"COMMERCIALDRAFT\" INNER JOIN T_BD_Bank AS \"INSTITUTION\" ON \"COMMERCIALDRAFT\".FInstitutionId = \"INSTITUTION\".FID";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        HashSet<String> companyIdSetToBankIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                companyIdSetToBankIdSet.add(rs.getString("Institution.id"));
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        return companyIdSetToBankIdSet;
    }

    protected Set getBankCompanyIdSet() {
        Set bankIdSet = this.getIdSetFromF7(this.prmtInstitution).size() < 1 ? this.getF7Bank() : this.getIdSetFromF7(this.prmtInstitution);
        if (this.kDCheckBoxCommercial.isSelected()) {
            bankIdSet.addAll(this.companyIdSet);
            return bankIdSet;
        }
        return bankIdSet;
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        rcm.setProperty("companyIdSet", (Object)this.companyIdSet);
        this.bankIdSet = this.getBankCompanyIdSet();
        rcm.setProperty("bankIdSet", (Object)this.bankIdSet);
        this.typeIdSet = this.getTypeIdSet();
        rcm.setProperty("typeIdSet", (Object)this.typeIdSet);
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params);
        rcm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.bankIdSet = this.getBankCompanyIdSet();
        this.typeIdSet = this.getTypeIdSet();
        super.setCustomCondition(params);
    }

    private Set getTypeIdSet() {
        HashSet typeIdSet = new HashSet();
        if (this.kDCheckBoxCommercial.isSelected()) {
            typeIdSet.clear();
            typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_BankAccept));
            typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_CommerceAccept));
            return typeIdSet;
        }
        typeIdSet.clear();
        typeIdSet.addAll(NTHelper.getNTTypesByGroup(NTTypeGroupEnum.PAYABLE_BankAccept));
        return typeIdSet;
    }

    protected TreeModel getCompanyTreeModel() throws Exception {
        if (FSClientHelper.isCHUser()) {
            return FSClientHelper.getOrgTreeModelForCHUser();
        }
        return super.getCompanyTreeModel();
    }

    public boolean verify() {
        NTClientHelper.compBeginDateAndEndDate((Component)((Object)this), (Date)this.pkFromDate.getValue(), (Date)this.pkToDate.getValue());
        return super.verify();
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }
}

