/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.nt.NTReportRcvResultInfo;
import com.kingdee.eas.fm.nt.NTRptRcvBillFilterParam;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;

public class RptReceivableBillAnalyseHandler
implements IFMDetailRptHandler {
    protected KDTable tblMain;
    protected int queryType;
    private String amtUnit;
    private CompanyOrgUnitInfo currentCompany;
    private int precisionLocalCurrency = 2;
    private boolean bMutilCompany = false;
    protected NTRptRcvBillFilterParam filterParam;
    String assureBillid = null;
    boolean flagEmptyUsed = false;
    BigDecimal returnAll = Constants.ZERO;
    BigDecimal preBillAmtall = Constants.ZERO;
    BigDecimal billAmtall = Constants.ZERO;
    BigDecimal endorseAmtall = Constants.ZERO;
    BigDecimal discountAmtall = Constants.ZERO;
    BigDecimal discountIntall = Constants.ZERO;
    BigDecimal gatherAmtall = Constants.ZERO;
    BigDecimal rtnAmtall = Constants.ZERO;
    BigDecimal tranLendAmtall = Constants.ZERO;
    BigDecimal outAllall = Constants.ZERO;
    BigDecimal returnBillAmtall = Constants.ZERO;
    IContextHelper iContextHelper = ContextHelperFactory.getRemoteInstance();
    CompanyOrgUnitInfo companyInfo = this.iContextHelper.getCurrentCompany();
    boolean canShow = this.iContextHelper.getBooleanParam("CTL001", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));

    protected RptReceivableBillAnalyseHandler(KDTable kdt, NTRptRcvBillFilterParam filterParam) {
        this.tblMain = kdt;
        this.queryType = 2;
        this.filterParam = filterParam;
    }

    private boolean hasBalance(String delivername, RowSet rs, List balanceList) {
        boolean hasAmt = false;
        try {
            block4: while (rs.next()) {
                String companyid = rs.getString("fcompanyid");
                for (int i = 0; i < balanceList.size(); ++i) {
                    NTReportRcvResultInfo info = (NTReportRcvResultInfo)balanceList.get(i);
                    if (FMHelper.isEmpty((String)delivername)) {
                        delivername = "";
                    }
                    if (FMHelper.isEmpty((String)info.getDelivername())) {
                        info.setDelivername("");
                    }
                    if (!info.getCompanyid().equals(companyid) || !info.getDelivername().trim().equals(delivername.trim()) || info.getStartTermBalance().compareTo(Constants.ZERO) <= 0 && rs.getBigDecimal("endorseAmt").compareTo(Constants.ZERO) <= 0 && rs.getBigDecimal("discountAmt").compareTo(Constants.ZERO) <= 0 && rs.getBigDecimal("discountInt").compareTo(Constants.ZERO) <= 0 && rs.getBigDecimal("gatherAmt").compareTo(Constants.ZERO) <= 0 && rs.getBigDecimal("rtnAmt").compareTo(Constants.ZERO) <= 0 && rs.getBigDecimal("tranLendAmt").compareTo(Constants.ZERO) <= 0) continue;
                    hasAmt = true;
                    continue block4;
                }
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        try {
            rs.beforeFirst();
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return hasAmt;
    }

    private boolean hasBalanceByDeliver(String delivername, List balanceList) {
        boolean b = false;
        NTReportRcvResultInfo info = null;
        for (int i = 0; i < balanceList.size(); ++i) {
            info = (NTReportRcvResultInfo)balanceList.get(i);
            if (!info.getDelivername().trim().equals(delivername.trim()) || FMHelper.isEmpty((Object)info.getStartTermBalance()) || info.getStartTermBalance().compareTo(Constants.ZERO) <= 0) continue;
            b = true;
        }
        return b;
    }

    private NTReportRcvResultInfo getResultInfo(String delivername, String companyid, List balanceList) {
        NTReportRcvResultInfo info = null;
        for (int i = 0; i < balanceList.size(); ++i) {
            info = (NTReportRcvResultInfo)balanceList.get(i);
            if (!info.getCompanyid().equals(companyid) || !info.getDelivername().trim().equals(delivername.trim())) continue;
            return info;
        }
        return null;
    }

    private ArrayList transformCollToList(CompanyOrgUnitCollection coll) {
        ArrayList<String> list = new ArrayList<String>();
        for (CompanyOrgUnitInfo object : coll) {
            list.add(object.getId().toString());
        }
        return list;
    }

    public void filldata() throws SQLException, EASBizException, BOSException {
        this.tblMain.setRefresh(false);
        List delivernames = new ArrayList();
        String[] companyids = this.filterParam.getCompanyIds();
        HashMap<String, CompanyOrgUnitInfo> hmCompany = new HashMap<String, CompanyOrgUnitInfo>();
        ArrayList alCompany = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])companyids), CompareType.INCLUDE));
        view.setFilter(fi);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        for (CompanyOrgUnitInfo object : coll) {
            hmCompany.put(object.getId().toString(), object);
        }
        if (FMHelper.isEmpty((Object[])this.filterParam.getDelivers())) {
            delivernames = ReceivableBillFactory.getRemoteInstance().getAllDelivers(this.getFilterParam());
            Object[] delivernamesObject = delivernames.toArray();
            String[] delivernamesString = new String[delivernamesObject.length];
            for (int i = 0; i < delivernamesObject.length; ++i) {
                delivernamesString[i] = delivernamesObject[i].toString();
            }
            this.filterParam.setDelivers(delivernamesString);
        }
        List lstTermBalanceByDeliver = ReceivableBillFactory.getRemoteInstance().getAnalyseBalanceByDeliver(this.getFilterParam());
        Map rowSetMap = ReceivableBillFactory.getRemoteInstance().getReceivableBillAnalyseByDeliver(this.getFilterParam());
        boolean hasAmt = false;
        int deliverCount = 0;
        String[] deliverIdSet = this.filterParam.getDelivers();
        for (int i = 0; i < deliverIdSet.length; ++i) {
            String companyname;
            CompanyOrgUnitInfo companyInfo;
            int j;
            int rowcount = 0;
            String delivername = deliverIdSet[i];
            RowSet deliverRs = (RowSet)rowSetMap.get(delivername);
            this.filterParam.setDeliver(delivername);
            alCompany = this.transformCollToList(coll);
            if (deliverRs.next()) {
                deliverRs.beforeFirst();
                while (deliverRs.next()) {
                    for (j = 0; j < alCompany.size(); ++j) {
                        companyInfo = (CompanyOrgUnitInfo)hmCompany.get(alCompany.get(j));
                        companyname = companyInfo.getName();
                        String companyIdString = companyInfo.getId().toString();
                        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) continue;
                        this.bMutilCompany = true;
                        if (deliverRs == null) {
                            return;
                        }
                        if (!deliverRs.getString("fcompanyid").equals(companyIdString)) continue;
                        NTReportRcvResultInfo info = this.getResultInfo(delivername, companyIdString, lstTermBalanceByDeliver);
                        IRow row = this.tblMain.addRow();
                        ++rowcount;
                        ++deliverCount;
                        row.getCell("deliverName").setValue((Object)delivername);
                        row.getCell("companyName").setValue((Object)companyname);
                        BigDecimal startTermBalance = Constants.ZERO;
                        if (!FMHelper.isEmpty((Object)info)) {
                            if (!FMHelper.isEmpty((Object)info.getStartTermBalance())) {
                                startTermBalance = info.getStartTermBalance();
                                row.getCell("preBillAmt").setValue((Object)startTermBalance);
                            }
                        } else {
                            row.getCell("preBillAmt").setValue((Object)Constants.ZERO);
                        }
                        if (!FMHelper.isEmpty((Object)deliverRs.getBigDecimal("billAmt"))) {
                            row.getCell("billAmt").setValue((Object)deliverRs.getBigDecimal("billAmt"));
                        } else {
                            row.getCell("billAmt").setValue((Object)Constants.ZERO);
                        }
                        if (!FMHelper.isEmpty((Object)deliverRs.getBigDecimal("endorseAmt"))) {
                            row.getCell("endorseAmt").setValue((Object)deliverRs.getBigDecimal("endorseAmt"));
                        } else {
                            row.getCell("endorseAmt").setValue((Object)Constants.ZERO);
                        }
                        if (!FMHelper.isEmpty((Object)deliverRs.getBigDecimal("discountAmt"))) {
                            row.getCell("discountAmt").setValue((Object)deliverRs.getBigDecimal("discountAmt"));
                        } else {
                            row.getCell("discountAmt").setValue((Object)Constants.ZERO);
                        }
                        if (!FMHelper.isEmpty((Object)deliverRs.getBigDecimal("discountInt"))) {
                            row.getCell("discountInt").setValue((Object)deliverRs.getBigDecimal("discountInt"));
                        } else {
                            row.getCell("discountInt").setValue((Object)Constants.ZERO);
                        }
                        if (!FMHelper.isEmpty((Object)deliverRs.getBigDecimal("gatherAmt"))) {
                            row.getCell("gatherAmt").setValue((Object)deliverRs.getBigDecimal("gatherAmt"));
                        } else {
                            row.getCell("gatherAmt").setValue((Object)Constants.ZERO);
                        }
                        if (!FMHelper.isEmpty((Object)deliverRs.getBigDecimal("tranLenAmt"))) {
                            row.getCell("tranLendAmt").setValue((Object)deliverRs.getBigDecimal("tranLenAmt"));
                        } else {
                            row.getCell("tranLendAmt").setValue((Object)Constants.ZERO);
                        }
                        if (!FMHelper.isEmpty((Object)deliverRs.getBigDecimal("rtnAmt"))) {
                            row.getCell("rtnAmt").setValue((Object)deliverRs.getBigDecimal("rtnAmt"));
                        } else {
                            row.getCell("rtnAmt").setValue((Object)Constants.ZERO);
                        }
                        BigDecimal endorseAmount = (BigDecimal)row.getCell("endorseAmt").getValue();
                        BigDecimal discountAmount = (BigDecimal)row.getCell("discountAmt").getValue();
                        BigDecimal discountInt = (BigDecimal)row.getCell("discountInt").getValue();
                        BigDecimal gatherAmt = (BigDecimal)row.getCell("gatherAmt").getValue();
                        BigDecimal tranLendAmt = (BigDecimal)row.getCell("tranLendAmt").getValue();
                        BigDecimal rtnAmt = (BigDecimal)row.getCell("rtnAmt").getValue();
                        BigDecimal outAllAmount = endorseAmount.add(discountAmount).add(gatherAmt).add(tranLendAmt).add(rtnAmt);
                        row.getCell("outAll").setValue((Object)outAllAmount);
                        BigDecimal billAmount = (BigDecimal)row.getCell("billAmt").getValue();
                        BigDecimal returnAmount = startTermBalance.add(billAmount);
                        returnAmount = returnAmount.subtract(outAllAmount);
                        row.getCell("lastAmt").setValue((Object)returnAmount);
                        alCompany.remove(companyIdString);
                        --j;
                    }
                }
                this.setTotalToDeliver(rowcount, delivername);
                continue;
            }
            if (!this.hasBalanceByDeliver(delivername, lstTermBalanceByDeliver)) continue;
            for (j = 0; j < companyids.length; ++j) {
                companyInfo = (CompanyOrgUnitInfo)hmCompany.get(companyids[j]);
                companyname = companyInfo.getName();
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) continue;
                this.bMutilCompany = true;
                BigDecimal termBalance = Constants.ZERO;
                if (deliverRs == null) {
                    return;
                }
                String companyIdString = companyInfo.getId().toString();
                NTReportRcvResultInfo info = this.getResultInfo(delivername, companyIdString, lstTermBalanceByDeliver);
                if (info == null) continue;
                IRow row = this.tblMain.addRow();
                ++rowcount;
                ++deliverCount;
                row.getCell("deliverName").setValue((Object)delivername);
                row.getCell("companyName").setValue((Object)companyname);
                if (!FMHelper.isEmpty((Object)info)) {
                    if (!FMHelper.isEmpty((Object)info.getStartTermBalance())) {
                        row.getCell("preBillAmt").setValue((Object)info.getStartTermBalance());
                        row.getCell("lastAmt").setValue((Object)info.getStartTermBalance());
                    } else {
                        row.getCell("preBillAmt").setValue((Object)Constants.ZERO);
                        row.getCell("lastAmt").setValue((Object)Constants.ZERO);
                    }
                }
                row.getCell("billAmt").setValue((Object)Constants.ZERO);
                row.getCell("endorseAmt").setValue((Object)Constants.ZERO);
                row.getCell("discountAmt").setValue((Object)Constants.ZERO);
                row.getCell("discountInt").setValue((Object)Constants.ZERO);
                row.getCell("gatherAmt").setValue((Object)Constants.ZERO);
                row.getCell("tranLendAmt").setValue((Object)Constants.ZERO);
                row.getCell("rtnAmt").setValue((Object)Constants.ZERO);
                row.getCell("outAll").setValue((Object)Constants.ZERO);
            }
            this.setTotalToDeliver(rowcount, delivername);
        }
        if (deliverCount > 0) {
            IRow row = this.tblMain.addRow();
            row.getCell("deliverName").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"total"));
            row.getCell("preBillAmt").setValue((Object)this.preBillAmtall);
            row.getCell("billAmt").setValue((Object)this.billAmtall);
            row.getCell("endorseAmt").setValue((Object)this.endorseAmtall);
            row.getCell("discountAmt").setValue((Object)this.discountAmtall);
            row.getCell("discountInt").setValue((Object)this.discountIntall);
            row.getCell("gatherAmt").setValue((Object)this.gatherAmtall);
            row.getCell("rtnAmt").setValue((Object)this.rtnAmtall);
            row.getCell("tranLendAmt").setValue((Object)this.tranLendAmtall);
            row.getCell("outAll").setValue((Object)this.outAllall);
            row.getCell("lastAmt").setValue((Object)this.returnBillAmtall);
            row.getCell("deliverName").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        }
    }

    private void setTotalToDeliver(int rowcount, String delivername) {
        IRow row = this.tblMain.addRow();
        BigDecimal preBillAmt = Constants.ZERO;
        BigDecimal billAmt = Constants.ZERO;
        BigDecimal endorseAmt = Constants.ZERO;
        BigDecimal discountAmt = Constants.ZERO;
        BigDecimal discountInt = Constants.ZERO;
        BigDecimal gatherAmt = Constants.ZERO;
        BigDecimal rtnAmt = Constants.ZERO;
        BigDecimal tranLendAmt = Constants.ZERO;
        BigDecimal outAll = Constants.ZERO;
        BigDecimal lastAmt = Constants.ZERO;
        int count = this.tblMain.getRowCount() - 1 - rowcount;
        for (int ii = 0; ii < rowcount; ++ii) {
            IRow currow = this.tblMain.getRow(count + ii);
            BigDecimal preAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("preBillAmt").getValue())) {
                preAmount = (BigDecimal)currow.getCell("preBillAmt").getValue();
            }
            BigDecimal billAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("billAmt").getValue())) {
                billAmount = (BigDecimal)currow.getCell("billAmt").getValue();
            }
            BigDecimal endorseAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("endorseAmt").getValue())) {
                endorseAmount = (BigDecimal)currow.getCell("endorseAmt").getValue();
            }
            BigDecimal discountAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("discountAmt").getValue())) {
                discountAmount = (BigDecimal)currow.getCell("discountAmt").getValue();
            }
            BigDecimal discountIntAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("discountInt").getValue())) {
                discountIntAmount = (BigDecimal)currow.getCell("discountInt").getValue();
            }
            BigDecimal gatherAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("gatherAmt").getValue())) {
                gatherAmount = (BigDecimal)currow.getCell("gatherAmt").getValue();
            }
            BigDecimal tranLendAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("tranLendAmt").getValue())) {
                tranLendAmount = (BigDecimal)currow.getCell("tranLendAmt").getValue();
            }
            BigDecimal rtnAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("rtnAmt").getValue())) {
                rtnAmount = (BigDecimal)currow.getCell("rtnAmt").getValue();
            }
            BigDecimal outAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("outAll").getValue())) {
                outAmount = (BigDecimal)currow.getCell("outAll").getValue();
            }
            BigDecimal lastAmount = Constants.ZERO;
            if (!FMHelper.isEmpty((Object)currow.getCell("lastAmt").getValue())) {
                lastAmount = (BigDecimal)currow.getCell("lastAmt").getValue();
            }
            preBillAmt = preBillAmt.add(preAmount);
            billAmt = billAmt.add(billAmount);
            endorseAmt = endorseAmt.add(endorseAmount);
            discountAmt = discountAmt.add(discountAmount);
            discountInt = discountInt.add(discountIntAmount);
            gatherAmt = gatherAmt.add(gatherAmount);
            rtnAmt = rtnAmt.add(rtnAmount);
            tranLendAmt = tranLendAmt.add(tranLendAmount);
            outAll = outAll.add(outAmount);
            lastAmt = lastAmt.add(lastAmount);
        }
        row.getCell("companyName").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTRptResource", (String)"subtotal"));
        row.getCell("deliverName").setValue((Object)delivername);
        row.getCell("preBillAmt").setValue((Object)preBillAmt);
        row.getCell("billAmt").setValue((Object)billAmt);
        row.getCell("endorseAmt").setValue((Object)endorseAmt);
        row.getCell("discountAmt").setValue((Object)discountAmt);
        row.getCell("discountInt").setValue((Object)discountInt);
        row.getCell("gatherAmt").setValue((Object)gatherAmt);
        row.getCell("rtnAmt").setValue((Object)rtnAmt);
        row.getCell("tranLendAmt").setValue((Object)tranLendAmt);
        row.getCell("outAll").setValue((Object)outAll);
        row.getCell("lastAmt").setValue((Object)lastAmt);
        this.preBillAmtall = this.preBillAmtall.add(preBillAmt);
        this.billAmtall = this.billAmtall.add(billAmt);
        this.endorseAmtall = this.endorseAmtall.add(endorseAmt);
        this.discountAmtall = this.discountAmtall.add(discountAmt);
        this.discountIntall = this.discountIntall.add(discountInt);
        this.gatherAmtall = this.gatherAmtall.add(gatherAmt);
        this.rtnAmtall = this.rtnAmtall.add(rtnAmt);
        this.tranLendAmtall = this.tranLendAmtall.add(tranLendAmt);
        this.outAllall = this.outAllall.add(outAll);
        this.returnBillAmtall = this.returnBillAmtall.add(lastAmt);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
    }

    protected void beforeFillRow(IRowSet rs, IRow row) {
    }

    protected void afterFillRow(IRowSet rs, IRow row) throws SQLException {
    }

    public FilterParam getFilterParam() {
        return this.filterParam;
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)key);
    }

    private void initDecimalCol(ICell cell, int precision) {
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
    }

    public void initHeader() {
        this.tblMain.removeRows();
        this.tblMain.getGroupManager().removeGroup();
        this.tblMain.setEditable(false);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getGroupManager().setOrientation(1);
        this.tblMain.getColumn("deliverName").setGroup(true);
        this.tblMain.getColumn("preAll").setWidth(0);
        this.tblMain.getColumn("preTrustAmt").setWidth(0);
        this.tblMain.getColumn("preIssueAmt").setWidth(0);
        this.tblMain.getColumn("returnBillAmt").setWidth(0);
        this.tblMain.getColumn("returnTrustAmt").setWidth(0);
        this.tblMain.getColumn("returnIssueAmt").setWidth(0);
        this.tblMain.getColumn("preBillAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("preBillAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("billAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("billAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("endorseAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("endorseAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("discountAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("discountAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("discountInt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("discountInt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("gatherAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("gatherAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("rtnAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("rtnAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("tranLendAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("tranLendAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("outAll").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("outAll").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("lastAmt").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.tblMain.getColumn("lastAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void setTableStateRow() {
    }

    public void endDataFill() {
        this.tblMain.getGroupManager().group();
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.filldata();
    }

    public IRowSet getRowSet() throws BOSException {
        return null;
    }
}

