/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.client.AbstractSetPayableExpiredUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SetPayableExpiredUI
extends AbstractSetPayableExpiredUI {
    private static final Logger logger = CoreUIObject.getLogger(SetPayableExpiredUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.txtIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.txtExpiredDate);
        ArrayList payableBillID = (ArrayList)this.getUIContext().get("ID");
        Date issueDate = (Date)this.txtIssueDate.getValue();
        Date expiredDate = (Date)this.txtExpiredDate.getValue();
        if (!expiredDate.after(issueDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"298_PayableBillEditUI"));
            this.txtExpiredDate.requestFocus();
            this.abort();
        }
        if (payableBillID.size() > 0) {
            if (!this.isIssueDateAndExpiredDate(payableBillID, issueDate, expiredDate)) {
                return;
            }
            PayableBillFactory.getRemoteInstance().upIssueOrExpiredDate(payableBillID, issueDate, expiredDate);
        }
        this.uiWindow.close();
    }

    public boolean isIssueDateAndExpiredDate(ArrayList payableBillID, Date issueDate, Date expiredDate) throws BOSException {
        HashSet idSet = new HashSet();
        for (int i = 0; i < payableBillID.size(); ++i) {
            idSet.add(payableBillID.get(i));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("CreditLimit.*");
        evi.getSelector().add("DiscountDate");
        evi.getSelector().add("applyDate");
        evi.getSelector().add("acceptDate");
        evi.setFilter(filter);
        PayableBillCollection payableCollection = PayableBillFactory.getRemoteInstance().getPayableBillCollection(evi);
        for (int i = 0; i < payableCollection.size(); ++i) {
            PayableBillInfo info = payableCollection.get(i);
            if (info.getCreditLimit() != null && (issueDate.getTime() <= info.getCreditLimit().getIssueDate().getTime() || issueDate.getTime() >= info.getCreditLimit().getExpiredDate().getTime())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"307_PayableBillEditUI"));
                this.abort();
            }
            if (info.getAcceptDate() != null && (issueDate.getTime() > info.getAcceptDate().getTime() || expiredDate.getTime() < info.getAcceptDate().getTime())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"295_PayableBillAcceptUI"));
                this.abort();
            }
            if (info.getApplyDate() != null && issueDate.getTime() > info.getApplyDate().getTime()) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"374_SetPayableExpiredUI"));
                this.abort();
            }
            if (info.getDiscountDate() == null || issueDate.getTime() <= info.getDiscountDate().getTime() && expiredDate.getTime() >= info.getDiscountDate().getTime()) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"299_PayableBillEditUI"));
            this.abort();
        }
        return true;
    }
}

