/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IProvince;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.nt.ChequeAppRecFactory;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeCollection;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeHelper;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.ICheque;
import com.kingdee.eas.fm.nt.IChequeAppRec;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.client.AbstractTeleOrderApplyUI;
import com.kingdee.eas.fm.nt.client.ChequeTDQueryDelegate;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.fm.nt.client.util.ReceiptBillUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TeleOrderApplyUI
extends AbstractTeleOrderApplyUI {
    private static final Logger logger = CoreUIObject.getLogger(TeleOrderApplyUI.class);
    private boolean ntModefied = false;
    private boolean remitIn1Modefied = false;
    private boolean remitIn2Modefied = false;
    private boolean modefiedBoth = false;
    private CompanyOrgUnitInfo currentCompany;
    private ProvinceInfo localProvince;
    private CityInfo localCity;
    private CurrencyInfo currency;
    private boolean isCompanyFilter;

    @Override
    public void storeFields() {
        Object c;
        super.storeFields();
        this.editData.setPayeeAcctNumber(this.txtPayeeAcctNumber.getText());
        this.editData.setPayeeName(this.prmtPayeeName.getText());
        Object pSup = this.prmtPayeeName.getData();
        if (pSup instanceof SupplierInfo) {
            SupplierInfo ps = (SupplierInfo)pSup;
            this.editData.setPayeeSupplier(ps);
        }
        if (this.editData.getApplyRec() != null) {
            this.editData.getApplyRec().setApplyCompany((CompanyOrgUnitInfo)this.prmtCompany.getData());
        }
        this.editData.setActualBankAcct((AccountBankInfo)this.prmtactualBankAcct.getData());
        this.editData.setPayeeName(this.prmtPayeeName.getText());
        this.editData.setCurrency((CurrencyInfo)this.cmbCurrency.getSelectedItem());
        Object p = this.prmtRemitInAddr1.getValue();
        if (p != null) {
            if (p instanceof ProvinceInfo) {
                ProvinceInfo provinceInfo = (ProvinceInfo)p;
                this.editData.setRemitInAddr1(provinceInfo);
                this.editData.setRemitInName1(null);
            } else if (p instanceof String) {
                this.editData.setRemitInAddr1(null);
                this.editData.setRemitInName1(p.toString());
            }
        }
        if ((c = this.prmtRemitInAddr2.getValue()) != null) {
            if (c instanceof CityInfo) {
                CityInfo cityInfo = (CityInfo)c;
                this.editData.setRemitInAddr2(cityInfo);
                this.editData.setRemitInName2(null);
            } else if (c instanceof String) {
                this.editData.setRemitInAddr2(null);
                this.editData.setRemitInName2(c.toString());
            }
        }
    }

    @Override
    public void loadFields() {
        this.modefiedBoth = true;
        super.loadFields();
        if (this.cbIdentityType.getSelectedItem() == null) {
            this.cbIdentityType.setSelectedIndex(0);
        }
        this.modefiedBoth = false;
        this.prmtactualBankAcct.setValue((Object)this.editData.getActualBankAcct());
        this.prmtPayeeName.setText(this.editData.getPayeeName());
        this.prmtPayeeName.setValue((Object)this.editData.getPayeeName());
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbCurrency, (Object)this.editData.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbCurrency, (Object)this.currency);
        }
        this.modefiedBoth = true;
        if (this.editData.getRemitInAddr1() == null) {
            this.prmtRemitInAddr1.setValue((Object)this.editData.getRemitInName1());
        } else {
            this.prmtRemitInAddr1.setValue((Object)this.editData.getRemitInAddr1());
        }
        if (this.editData.getRemitInAddr2() == null) {
            this.prmtRemitInAddr2.setValue((Object)this.editData.getRemitInName2());
        } else {
            this.prmtRemitInAddr2.setValue((Object)this.editData.getRemitInAddr2());
        }
        this.txtPayeeAcctNumber.setText(this.editData.getPayeeAcctNumber());
        this.modefiedBoth = false;
        if (this.editData.getActualBankAcct() != null) {
            this.prmtCompany.setValue((Object)this.editData.getKeepCompany());
        } else {
            AccountBankInfo accout = (AccountBankInfo)this.prmtBankAcct.getValue();
            if (accout != null) {
                ObjectUuidPK objPk = new ObjectUuidPK(accout.getCompany().getId().toString());
                try {
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)objPk);
                    this.prmtCompany.setValue((Object)company);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initListener() {
        super.initListener();
        ReceiptBillUtil.enableTxtInput((KDPromptBox)this.prmtPayeeName);
        ReceiptBillUtil.enableTxtInput((KDPromptBox)this.prmtRemitInAddr1);
        ReceiptBillUtil.enableTxtInput((KDPromptBox)this.prmtRemitInAddr2);
    }

    public void onLoad() throws Exception {
        Object[] values;
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.prmtactualBankAcct.setDisplayFormat("$bankaccountnumber$");
        this.currency = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)this.currentCompany);
        this.isCompanyFilter = ContextHelperFactory.getRemoteInstance().getBooleanParam("NT028", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        if (!this.currentCompany.isIsBizUnit()) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        if (this.currentCompany.isIsAdminOrgUnit() && (values = ReceiptBillUtil.getAddressByAdminOrgId(this.currentCompany.getId().toString())) != null) {
            this.localProvince = (ProvinceInfo)values[0];
            this.localCity = (CityInfo)values[1];
        }
        FMClientHelper.initComboCurrency((KDComboBox)this.cmbCurrency, (boolean)false);
        ChequeUtil.setAsstActSelector((CoreUIObject)this, this.prmtPayeeName, this.currentCompany.getId().toString());
        ChequeUtil.initTeleOrderF7((IUIObject)this, this.prmtNumber, this.getSelectors());
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtApplicant);
        FilterItemInfo item = new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtBankAcct, (FilterItemInfo)item);
        if (this.isCompanyFilter) {
            FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtBankAcct, (FilterItemInfo)new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bank.*");
        sic.add("currency.*");
        sic.add("company.*");
        this.prmtBankAcct.setSelectorCollection(sic);
        this.prmtactualBankAcct.setEnabled(false);
        super.onLoad();
        ChequeUtil.setSupplierF7((CoreUIObject)this, this.prmtPayeeName, this.currentCompany);
        if (this.cmbCurrency.getSelectedItem() != null) {
            this.txtAmount.setPrecision(((CurrencyInfo)this.cmbCurrency.getSelectedItem()).getPrecision());
        }
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        if (this.getOprtState() == OprtState.EDIT || this.getOprtState() == OprtState.VIEW) {
            this.prmtNumber.setValue((Object)this.editData);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.prmtRemitOutAddr1.getValue() == null || this.prmtRemitOutAddr2.getValue() == null) {
                this.prmtRemitOutAddr1.setEnabled(true);
                this.prmtRemitOutAddr2.setEnabled(true);
            }
            if (this.prmtApplicant.getValue() == null) {
                this.prmtApplicant.setEnabled(true);
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.ntModefied = false;
        this.remitIn1Modefied = false;
        this.remitIn2Modefied = false;
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.prmtactualBankAcct.setDisplayFormat("$bankaccountnumber$");
        ExtendParser txtPayeeBankAcctNumParser = new ExtendParser(this.txtPayeeAcctNumber);
        this.txtPayeeAcctNumber.setCommitParser((IParser)txtPayeeBankAcctNumParser);
        Object pbfro = this.getUIContext().get("PaymentBillForReimburse");
        if (pbfro != null) {
            PaymentBillInfo pbInfo = (PaymentBillInfo)pbfro;
            this.prmtCompany.setValue((Object)pbInfo.getCompany());
            this.prmtCompany.setEnabled(false);
            this.prmtNumber.setEnabled(false);
            this.prmtBankAcct.setDataNoNotify((Object)pbInfo.getPayerAccountBank());
            this.prmtBankAcct.setEnabled(false);
            this.pkIssueDate.setValue((Object)pbInfo.getBizDate());
            FMClientHelper.setSelectObject((KDComboBox)this.cmbCurrency, (Object)pbInfo.getCurrency());
            this.txtAmount.setValue((Object)pbInfo.getActPayAmt());
            this.txtAmount.setEnabled(false);
            this.cmbCurrency.setEnabled(false);
            if (pbInfo.getPayeeName() != null && !pbInfo.getPayeeName().trim().equals("")) {
                this.prmtPayeeName.setValue((Object)pbInfo.getPayeeName());
                this.prmtPayeeName.setEnabled(false);
            } else {
                this.prmtPayeeName.setEnabled(true);
                this.prmtPayeeName.setRequired(true);
            }
            if (pbInfo.getPayeeAccountBank() != null && !pbInfo.getPayeeAccountBank().trim().equals("")) {
                this.txtPayeeAcctNumber.setText(pbInfo.getPayeeAccountBank());
                this.txtPayeeAcctNumber.setEnabled(false);
            } else {
                this.txtPayeeAcctNumber.setEnabled(true);
            }
            if (pbInfo.getPayeeBank() != null && !pbInfo.getPayeeBank().trim().equals("")) {
                this.txtPayeeAcctBank.setText(pbInfo.getPayeeBank());
                this.txtPayeeAcctBank.setEnabled(false);
            } else {
                this.txtPayeeAcctBank.setEnabled(true);
            }
            this.txtUsage.setText(pbInfo.getUsage());
            this.textAreaDescb.setText(pbInfo.getDescription());
            this.prmtRemitInAddr1.setValue((Object)pbInfo.getRecProvince());
            this.prmtRemitInAddr2.setValue((Object)pbInfo.getRecCity());
        }
        this.contPassword.setBoundLabelText("\u652f\u4ed8\u4e1a\u52a1\u7801");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionAbandon.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_blankout"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionSave.setEnabled(false);
        this.actionSave.setVisible(false);
        this.actionTraceUp.setEnabled(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceDown.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.actionNextPerson.setVisible(false);
        this.actionMultiapprove.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        ChequeInfo info = (ChequeInfo)this.getDataObject();
        this.actionAbandon.setEnabled(ChequeHelper.isCanAbandon(info));
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtBank.setEnabled(false);
            this.prmtCompany.setEnabled(false);
            this.prmtKeeper.setEnabled(false);
            this.prmtRemitOutAddr1.setEnabled(false);
            this.prmtRemitOutAddr2.setEnabled(false);
            this.prmtApplicant.setEnabled(false);
            if (info.getBankAcct() != null || info.getBank() == null) {
                this.prmtBankAcct.setEnabled(false);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.prmtBank.setEnabled(false);
            this.prmtCompany.setEnabled(false);
            this.prmtKeeper.setEnabled(false);
            this.prmtBankAcct.setEnabled(false);
            this.prmtNumber.setEnabled(false);
        }
        if (info.getCurrency() == null) {
            this.cmbCurrency.setEnabled(true);
        } else {
            this.cmbCurrency.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add("state");
        sic.add("bank.id");
        sic.add("bank.name");
        sic.add("bank.number");
        sic.add("bankAcct.id");
        sic.add("bankAcct.name");
        sic.add("bankAcct.number");
        sic.add("bankAcct.company.id");
        sic.add("bankAcct.company.name");
        sic.add("bankAcct.company.number");
        sic.add("bankAcct.company.isAdminOrgUnit");
        sic.add("bankAcct.company.cu.*");
        sic.add("keepCompany.id");
        sic.add("keepCompany.name");
        sic.add("keepCompany.cu");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.precision");
        sic.add("keeper.id");
        sic.add("keeper.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("remitInAddr1.*");
        sic.add("remitInAddr2.*");
        sic.add("remitInName1");
        sic.add("remitInName1");
        sic.add("remitOutAddr1.*");
        sic.add("remitOutAddr2.*");
        sic.add("applyRec.applicant.id");
        sic.add("applyRec.applicant.name");
        sic.add("applyRec.applicant.number");
        sic.add("applyRec.applyCompany.id");
        sic.add("applyRec.applyCompany.name");
        sic.add("applyRec.applyCompany.number");
        sic.add(new SelectorItemInfo("actualBankAcct.id"));
        sic.add(new SelectorItemInfo("actualBankAcct.number"));
        sic.add(new SelectorItemInfo("actualBankAcct.name"));
        sic.add(new SelectorItemInfo("actualBankAcct.bankAccountNumber"));
        return sic;
    }

    protected String getClassAlise() {
        return NTTypeGroupEnum.TELE_ORDER.toString();
    }

    public boolean isModify() {
        return super.isModify() || this.ntModefied || this.remitIn1Modefied || this.remitIn2Modefied;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (EmptyUtil.isEmpty((String)this.prmtPayeeName.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"469_PayableBillBatchInputUI"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((String)this.prmtRemitInAddr1.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"491_TeleOrderApplyUI"));
            SysUtil.abort();
        }
        if (EmptyUtil.isEmpty((String)this.prmtRemitInAddr2.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"492_TeleOrderApplyUI"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        java.util.Date purDate = this.editData.getPurDate();
        Date issueDate = this.pkIssueDate.getSqlDate();
        if (purDate.after(issueDate)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"purDataBeforeIssue"));
            SysUtil.abort();
        }
    }

    public ICoreBase getBizInterface() throws Exception {
        return ChequeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ChequeInfo cheque;
        Object selectId = this.getUIContext().get("ID");
        if (selectId != null) {
            try {
                cheque = ChequeFactory.getRemoteInstance().getChequeInfo((IObjectPK)new ObjectUuidPK(selectId.toString()), this.getSelectors());
                this.prmtNumber.setValue((Object)cheque);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                cheque = new ChequeInfo();
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                cheque = new ChequeInfo();
            }
        } else {
            cheque = new ChequeInfo();
        }
        cheque.setIssueDate(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()));
        cheque.setRemitOutAddr1(this.localProvince);
        cheque.setRemitOutAddr2(this.localCity);
        return cheque;
    }

    @Override
    protected void prmtNumber_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtNumber_dataChanged(e);
        Object newValue = e.getNewValue();
        if (newValue instanceof ChequeInfo) {
            ChequeInfo info = (ChequeInfo)newValue;
            info.setIssueDate(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()));
            this.setDataObject((IObjectValue)info);
            this.loadFields();
            this.resetComponents();
            this.prmtactualBankAcct.setEnabled(true);
        } else {
            this.prmtactualBankAcct.setEnabled(false);
        }
    }

    @Override
    protected void prmtRemitInAddr1_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtRemitInAddr1_dataChanged(e);
        if (this.isSameValue(e)) {
            this.remitIn1Modefied = true;
        }
        if (this.modefiedBoth) {
            return;
        }
        this.modefiedBoth = true;
        this.prmtRemitInAddr2.setValue(null);
        this.modefiedBoth = false;
    }

    private boolean isSameValue(DataChangeEvent e) {
        if (e.getOldValue() != null && e.getNewValue() != null && !e.getOldValue().equals(e.getNewValue())) {
            return true;
        }
        return e.getOldValue() == null && e.getNewValue() != null;
    }

    @Override
    protected void prmtRemitInAddr2_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtRemitInAddr2_dataChanged(e);
        if (this.isSameValue(e)) {
            this.remitIn2Modefied = true;
        }
        if (this.modefiedBoth) {
            return;
        }
        Object newValue = e.getNewValue();
        if (newValue instanceof CityInfo) {
            CityInfo city = (CityInfo)newValue;
            Object p = this.prmtRemitInAddr1.getValue();
            ProvinceInfo pii = city.getProvince();
            if (pii != null && p instanceof ProvinceInfo) {
                ProvinceInfo pi = (ProvinceInfo)p;
                if (!pii.getId().equals((Object)pi.getId())) {
                    IProvince provinceBean = ProvinceFactory.getRemoteInstance();
                    CoreBaseInfo province = provinceBean.getValue((IObjectPK)new ObjectUuidPK(pii.getId()));
                    this.modefiedBoth = true;
                    this.prmtRemitInAddr1.setData((Object)province);
                    this.modefiedBoth = false;
                }
            } else if (p == null && pii != null) {
                IProvince provinceBean = ProvinceFactory.getRemoteInstance();
                CoreBaseInfo province = provinceBean.getValue((IObjectPK)new ObjectUuidPK(pii.getId()));
                this.modefiedBoth = true;
                this.prmtRemitInAddr1.setData((Object)province);
                this.modefiedBoth = false;
            }
        }
    }

    @Override
    protected void prmtRemitInAddr2_willShow(SelectorEvent e) throws Exception {
        super.prmtRemitInAddr2_willShow(e);
        this.initPrmtCity(this.prmtRemitInAddr1, this.prmtRemitInAddr2);
    }

    @Override
    protected void prmtRemitInAddr2_willCommit(CommitEvent e) throws Exception {
        super.prmtRemitInAddr2_willCommit(e);
        this.initPrmtCity(this.prmtRemitInAddr1, this.prmtRemitInAddr2);
    }

    @Override
    protected void prmtRemitOutAddr1_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtRemitOutAddr1_dataChanged(e);
        if (this.modefiedBoth) {
            return;
        }
        this.modefiedBoth = true;
        this.prmtRemitOutAddr2.setValue(null);
        this.modefiedBoth = false;
    }

    @Override
    protected void prmtRemitOutAddr2_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtRemitOutAddr2_dataChanged(e);
        if (this.modefiedBoth) {
            return;
        }
        Object newValue = e.getNewValue();
        if (newValue instanceof CityInfo) {
            CityInfo city = (CityInfo)newValue;
            Object p = this.prmtRemitOutAddr1.getValue();
            ProvinceInfo pii = city.getProvince();
            if (pii != null && p instanceof ProvinceInfo) {
                ProvinceInfo pi = (ProvinceInfo)p;
                if (!pii.getId().equals((Object)pi.getId())) {
                    IProvince provinceBean = ProvinceFactory.getRemoteInstance();
                    CoreBaseInfo province = provinceBean.getValue((IObjectPK)new ObjectUuidPK(pii.getId()));
                    this.modefiedBoth = true;
                    this.prmtRemitOutAddr1.setData((Object)province);
                    this.modefiedBoth = false;
                }
            } else if (p == null && pii != null) {
                IProvince provinceBean = ProvinceFactory.getRemoteInstance();
                CoreBaseInfo province = provinceBean.getValue((IObjectPK)new ObjectUuidPK(pii.getId()));
                this.modefiedBoth = true;
                this.prmtRemitOutAddr1.setData((Object)province);
                this.modefiedBoth = false;
            }
        }
    }

    @Override
    protected void prmtRemitOutAddr2_willCommit(CommitEvent e) throws Exception {
        super.prmtRemitOutAddr2_willCommit(e);
        this.initPrmtCity(this.prmtRemitOutAddr1, this.prmtRemitOutAddr2);
    }

    @Override
    protected void prmtRemitOutAddr2_willShow(SelectorEvent e) throws Exception {
        super.prmtRemitOutAddr2_willShow(e);
        this.initPrmtCity(this.prmtRemitOutAddr1, this.prmtRemitOutAddr2);
    }

    private void initPrmtCity(KDBizPromptBox prmtProvince, KDBizPromptBox prmtCity) throws Exception {
        if (this.modefiedBoth) {
            return;
        }
        Object val = prmtProvince.getValue();
        if (val instanceof ProvinceInfo) {
            ProvinceInfo province = (ProvinceInfo)val;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("province.id", (Object)province.getId()));
            filter.getFilterItems().add(new FilterItemInfo("province.id", null, CompareType.EMPTY));
            filter.setMaskString("#0 or #1");
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            prmtCity.setEntityViewInfo(evi);
            prmtCity.getQueryAgent().resetRuntimeEntityView();
        } else {
            prmtCity.setEntityViewInfo(new EntityViewInfo());
        }
    }

    @Override
    protected void prmtPayeeName_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayeeName_dataChanged(e);
        Object value = e.getNewValue();
        if (value instanceof SupplierInfo) {
            SupplierInfo supplier = (SupplierInfo)value;
            ReceiptBillUtil.setBankAcctBySupplier(supplier, this.txtPayeeAcctNumber, this.txtPayeeAcctBank);
            this.modefiedBoth = true;
            ReceiptBillUtil.setAddressBySupplier(supplier, (KDPromptBox)this.prmtRemitInAddr1, (KDPromptBox)this.prmtRemitInAddr2);
            this.modefiedBoth = false;
        }
    }

    @Override
    protected void prmtPayeeName_willShow(SelectorEvent e) throws Exception {
        super.prmtPayeeName_willShow(e);
        if (this.prmtCompany.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"375_TeleOrderApplyUI"));
            e.setCanceled(true);
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        ChequeUtil.setSupplierF7((CoreUIObject)this, this.prmtPayeeName, company);
        this.prmtPayeeName.setCurrentCtrlUnit(company.getCU());
        this.prmtPayeeName.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void cmbCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currency;
        super.cmbCurrency_itemStateChanged(e);
        if (e.getStateChange() == 1 && (currency = (CurrencyInfo)this.cmbCurrency.getSelectedItem()) != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
        }
    }

    @Override
    protected void prmtBankAcct_willShow(SelectorEvent e) throws Exception {
        Object bank = this.prmtBank.getValue();
        if (bank instanceof BankInfo) {
            FilterItemInfo bankfilter = new FilterItemInfo("bank.id", (Object)((BankInfo)bank).getId());
            FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtBankAcct, (FilterItemInfo)bankfilter);
            this.prmtBankAcct.getQueryAgent().resetRuntimeEntityView();
        }
        super.prmtBankAcct_willShow(e);
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAcct_dataChanged(e);
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            Object value = e.getNewValue();
            if (value instanceof AccountBankInfo) {
                AccountBankInfo info = (AccountBankInfo)value;
                if (info.getCompany() != null) {
                    this.prmtCompany.setValue((Object)info.getCompany());
                    if (this.prmtactualBankAcct.getData() == null) {
                        this.prmtCompany.setValue((Object)info.getCompany());
                    }
                    if (info.getCompany().isIsAdminOrgUnit()) {
                        Object[] address = ReceiptBillUtil.getAddressByAdminOrgId(info.getCompany().getId().toString());
                        if (address != null) {
                            this.modefiedBoth = true;
                            if (address[0] != null && address[0] instanceof ProvinceInfo) {
                                this.editData.setRemitOutAddr1((ProvinceInfo)address[0]);
                                this.prmtRemitOutAddr1.setValue(address[0]);
                                this.prmtRemitOutAddr1.setEnabled(false);
                            }
                            if (address[1] != null && address[1] instanceof CityInfo) {
                                this.editData.setRemitOutAddr2((CityInfo)address[1]);
                                this.prmtRemitOutAddr2.setValue(address[1]);
                                this.prmtRemitOutAddr2.setEnabled(false);
                            }
                            this.modefiedBoth = false;
                        } else {
                            this.prmtRemitOutAddr1.setEnabled(true);
                            this.prmtRemitOutAddr2.setEnabled(true);
                        }
                    } else {
                        this.prmtRemitOutAddr1.setEnabled(true);
                        this.prmtRemitOutAddr2.setEnabled(true);
                    }
                } else {
                    this.prmtRemitOutAddr1.setEnabled(true);
                    this.prmtRemitOutAddr2.setEnabled(true);
                }
                if (info.getCurrency() != null) {
                    FMClientHelper.setSelectObject((KDComboBox)this.cmbCurrency, (Object)info.getCurrency());
                    this.cmbCurrency.setEnabled(false);
                } else {
                    this.cmbCurrency.setEnabled(true);
                }
            } else if (this.prmtactualBankAcct.getData() == null) {
                this.prmtCompany.setValue(null);
            }
        }
    }

    @Override
    protected void prmtApplicant_willShow(SelectorEvent e) throws Exception {
        super.prmtApplicant_willShow(e);
        Object com = this.prmtCompany.getValue();
        if (com instanceof CompanyOrgUnitInfo) {
            PersonPromptBox selector = (PersonPromptBox)this.prmtApplicant.getSelector();
            selector.showAllChildren();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)com;
            if (company.isIsAdminOrgUnit()) {
                selector.setExpandAdmin(company.getId().toString());
            }
        }
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
        Object value = e.getNewValue();
        if (value != null && value instanceof CompanyOrgUnitInfo) {
            this.prmtApplicant.setEnabled(true);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        if (!(this.isSave() || OprtState.VIEW.equals(this.getOprtState()) || this.getOprtState().equals("FINDVIEW"))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), true);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isSave() && !OprtState.VIEW.equals(this.getOprtState())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"saveBeforeTD"));
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.ReceiptBill", (String)"errmasg"));
            return;
        }
        ChequeTDQueryDelegate data = new ChequeTDQueryDelegate(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FM/NT/CHEQUE", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (!this.isModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"RepeatSummit"));
            return;
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.doApply();
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"TeleOrderApplySuccess"));
            this.setIsShowTextOnly(true);
            this.showMessage();
            Object pbfro = this.getUIContext().get("PaymentBillForReimburse");
            if (pbfro != null) {
                PaymentBillInfo pbInfo = (PaymentBillInfo)pbfro;
                PaymentBillFactory.getRemoteInstance().chequeReimburse(this.editData.getId().toString(), pbInfo.getId().toString());
            }
        } else if (this.getOprtState() == OprtState.EDIT) {
            IChequeAppRec iRec = ChequeAppRecFactory.getRemoteInstance();
            iRec.update((IObjectPK)new ObjectUuidPK(this.editData.getApplyRec().getId()), (CoreBaseInfo)this.editData.getApplyRec());
            super.actionSubmit_actionPerformed(e);
        }
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.ntModefied = false;
        this.remitIn1Modefied = false;
        this.remitIn2Modefied = false;
    }

    @Override
    public void actionAbandon_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbandon_actionPerformed(e);
        if (!this.isSave() && !this.getOprtState().equals(OprtState.VIEW)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"376_TeleOrderApplyUI"));
            return;
        }
        int result1 = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.gnt.GntResource", (String)"isCanceled"));
        if (result1 == 0) {
            if (this.editData.getState() == ChequeStatusEnum.Canceled) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NtResource", (String)"RepeatSummit"));
                return;
            }
            HashSet<String> set = new HashSet<String>();
            set.add(this.editData.getId().toString());
            ChequeFactory.getRemoteInstance().abandon(set);
            this.editData.setState(ChequeStatusEnum.Canceled);
        }
    }

    private void doApply() throws Exception {
        ICheque iCheque = (ICheque)this.getBizInterface();
        ChequeCollection coll = new ChequeCollection();
        coll.add(this.editData);
        ChequeAppRecInfo recInfo = new ChequeAppRecInfo();
        recInfo.setApplicant((PersonInfo)this.prmtApplicant.getData());
        recInfo.setCeiling(this.editData.getAmount());
        recInfo.setApplyCompany((CompanyOrgUnitInfo)this.prmtCompany.getData());
        this.editData.setApplyRec(recInfo);
        iCheque.apply(coll);
    }

    private void resetComponents() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return;
        }
        if (this.editData.getCurrency() != null) {
            this.cmbCurrency.setEnabled(false);
        } else {
            this.cmbCurrency.setEnabled(true);
        }
        if (this.prmtBankAcct.getValue() != null) {
            this.prmtBankAcct.setEnabled(false);
            if (this.prmtRemitOutAddr1.getValue() != null && this.prmtRemitOutAddr2.getValue() != null) {
                this.prmtRemitOutAddr1.setEnabled(false);
                this.prmtRemitOutAddr2.setEnabled(false);
            } else {
                this.prmtRemitOutAddr1.setEnabled(true);
                this.prmtRemitOutAddr2.setEnabled(true);
            }
        } else {
            this.prmtBankAcct.setEnabled(true);
            this.prmtRemitOutAddr1.setEnabled(true);
            this.prmtRemitOutAddr2.setEnabled(true);
            String bankId = ((BankInfo)this.prmtBank.getValue()).getId().toString();
            FilterItemInfo filterItem = new FilterItemInfo("bank.id", (Object)bankId);
            try {
                FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtNumber, (FilterItemInfo)filterItem);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected void txtPayeeAcctNumber_dataChanged(DataChangeEvent e) throws Exception {
        SupplierCompanyBankInfo bankInfo;
        Object o = this.txtPayeeAcctNumber.getData();
        if (o instanceof SupplierCompanyBankInfo && (bankInfo = (SupplierCompanyBankInfo)o) != null) {
            this.txtPayeeAcctBank.setText(bankInfo.getBank());
        }
    }

    protected void prmtActualBankAcct_willCommit(CommitEvent e) throws Exception {
        this.initPrmtActualBankAcct();
    }

    @Override
    protected void prmtactualBankAcct_willShow(SelectorEvent e) throws Exception {
        this.initPrmtActualBankAcct();
    }

    private void initPrmtActualBankAcct() throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.editData.getKeepCompany().getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtactualBankAcct.setEntityViewInfo(evi);
        Object currencyInfo = this.cmbCurrency.getSelectedItem();
        if (currencyInfo instanceof CurrencyInfo) {
            FilterInfo currencyFilter = new FilterInfo();
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)currencyInfo).getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            currencyFilter.setMaskString("#0 or #1");
            this.prmtactualBankAcct.getEntityViewInfo().getFilter().mergeFilter(currencyFilter, "AND");
        }
        this.prmtactualBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtactualBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            AccountBankInfo accout = (AccountBankInfo)this.prmtBankAcct.getValue();
            if (accout != null) {
                ObjectUuidPK objPk = new ObjectUuidPK(accout.getCompany().getId().toString());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)objPk);
                this.prmtCompany.setValue((Object)company);
            } else {
                this.prmtCompany.setValue(null);
            }
        } else {
            this.prmtCompany.setValue((Object)this.editData.getKeepCompany());
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "issueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit"};
    }
}

