/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.nt.client.util;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.nt.client.util.FMToolTipAreaCtrl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JToolTip;

public class FMToolTip
extends JToolTip {
    private static final long serialVersionUID = 2228388150743642931L;
    private FMToolTipAreaCtrl scrollPane;
    private int rowCount = 8;
    private int lineWidth = 190;
    private String urlTitle = "";

    public FMToolTip(String toolTipTxt, String url) {
        Vector lines;
        if (!EmptyUtil.isEmpty((String)url)) {
            String[] urls = url.split(";");
            this.urlTitle = urls[0];
            lines = this.initLines(toolTipTxt + " " + this.urlTitle, 145);
        } else {
            lines = this.initLines(toolTipTxt, 145);
        }
        this.rowCount = lines.size() < 8 ? lines.size() : 8;
        this.lineWidth = lines.size() == 1 ? this.lineWidth : 190;
        this.scrollPane = new FMToolTipAreaCtrl();
        this.scrollPane.setEditable(false);
        this.scrollPane.setLocation(0, 0);
        this.scrollPane.setSize(this.lineWidth, this.rowCount * 17 + 6);
        this.scrollPane.setSelectionStart(0);
        this.scrollPane.setSelectionEnd(0);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        if (this.rowCount < 8) {
            this.scrollPane.setVerticalScrollBarPolicy(21);
        }
        this.scrollPane.setText(this.getFormatString(lines), url);
        this.add((Component)((Object)this.scrollPane), "Center");
    }

    private String getFormatString(Vector lines) {
        StringBuffer str = new StringBuffer();
        if (lines != null) {
            for (int i = 0; i < lines.size(); ++i) {
                str.append(lines.elementAt(i).toString());
            }
        }
        if (str.toString().contains(" " + this.urlTitle)) {
            return str.toString().substring(0, str.toString().length() - 1 - this.urlTitle.length());
        }
        return str.toString();
    }

    protected Vector initLines(String str, int maxWidth) {
        Vector<String> lines = new Vector<String>(32);
        if (str.contains("\n")) {
            String[] lineSbs = str.split("\n");
            for (int i = 0; i < lineSbs.length; ++i) {
                lines.add(lineSbs[i]);
            }
            return lines;
        }
        Font font = new Font("\u5b8b\u4f53", 0, 10);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        String paragraphString = null;
        StringTokenizer st = new StringTokenizer(str, "\n");
        while (st.hasMoreTokens() && lines.size() < 32) {
            paragraphString = st.nextToken().trim();
            StringBuilder lineSb = new StringBuilder();
            int lineWidth = 0;
            boolean firstLineInParagraph = true;
            for (int i = 0; i < paragraphString.length(); ++i) {
                char c = paragraphString.charAt(i);
                lineSb.append(c);
                if ((lineWidth += fontMetrics.charWidth(c)) > maxWidth) {
                    String line = lineSb.toString();
                    if (FMToolTip.isInWord(line.toString(), line.length() - 1)) {
                        int breakIndex = this.getPreWordBreak(line, line.length() - 1);
                        String lineToAdd = line.substring(0, breakIndex);
                        lines.add(lineToAdd);
                        lineSb = new StringBuilder(line.substring(breakIndex));
                    } else {
                        lines.add(lineSb.substring(0, lineSb.length() - 1));
                        lineSb = new StringBuilder(lineSb.substring(lineSb.length() - 1));
                    }
                    lineWidth = 0;
                    for (int j = 0; j < lineSb.length(); ++j) {
                        lineWidth += fontMetrics.charWidth(lineSb.charAt(j));
                    }
                }
                if (!firstLineInParagraph && lineSb.length() >= 2 && lineSb.charAt(0) == ' ' && lineSb.charAt(1) != ' ') {
                    lineSb = new StringBuilder(lineSb.substring(1));
                    lineWidth -= fontMetrics.charWidth(' ');
                }
                firstLineInParagraph = false;
            }
            if (lineSb.length() > 0) {
                lines.add(lineSb.toString());
            }
            this.lineWidth = (int)((double)lineWidth * 1.39);
        }
        String lastLineStr = lines.get(lines.size() - 1).toString();
        if (lastLineStr.trim().length() == 1 && "!,.?\uff01\uff0c\u3002\uff1f".indexOf(lastLineStr.trim()) != -1) {
            lines.remove(lines.size() - 1);
        }
        return lines;
    }

    private static boolean isInWord(String source, int index) {
        if (index <= 0 || index >= source.length()) {
            return false;
        }
        char c = source.charAt(index);
        char pc = source.charAt(index - 1);
        if (FMToolTip.isCJKCharacter(pc)) {
            return FMToolTip.isPunctuation(c);
        }
        if (FMToolTip.isCJKCharacter(c)) {
            return false;
        }
        return !Character.isWhitespace(c) && !Character.isWhitespace(pc);
    }

    private int getPreWordBreak(String line, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (FMToolTip.isInWord(line, i)) continue;
            return i;
        }
        return fromIndex;
    }

    private static boolean isPunctuation(char c) {
        int type = Character.getType(c);
        HashSet<Integer> punctuationTypes = new HashSet<Integer>();
        punctuationTypes.add(23);
        punctuationTypes.add(20);
        punctuationTypes.add(22);
        punctuationTypes.add(30);
        punctuationTypes.add(29);
        punctuationTypes.add(24);
        punctuationTypes.add(21);
        boolean isPunctuation = punctuationTypes.contains(type);
        return isPunctuation;
    }

    private static boolean isCJKCharacter(char c) {
        Character.UnicodeBlock[] cjkBlocks;
        int[][] cjkUnicodeRanges;
        for (int[] range : cjkUnicodeRanges = new int[][]{{12288, 40959}, {11904, 12031}, {12032, 12245}, {11904, 12019}, {63744, 64217}, {59413, 59503}, {58368, 58856}, {58880, 59087}, {12272, 12287}, {65040, 65055}, {44032, 55215}, {4352, 4607}}) {
            if (range[0] > c || c > range[1]) continue;
            return true;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        for (Character.UnicodeBlock cjkBlock : cjkBlocks = new Character.UnicodeBlock[]{Character.UnicodeBlock.CJK_COMPATIBILITY, Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B}) {
            if (!cjkBlock.equals(unicodeBlock)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.lineWidth, this.rowCount * 17 + 6);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int width = (int)this.getPreferredSize().getWidth();
        int height = (int)this.getPreferredSize().getHeight();
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(Color.CYAN);
        g2d.fillRect(0, 0, width, height);
        g2d.setPaint(oldPaint);
        if (this.getTipText() != null) {
            g2d.drawString(this.getTipText(), 10, 20);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.scrollPane.repaint();
    }

    public FMToolTipAreaCtrl getScrollPane() {
        return this.scrollPane;
    }
}

