/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionFactory;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingCollection;
import com.kingdee.eas.fm.recon.SipgFmReconMappingFactory;
import com.kingdee.eas.fm.recon.SipgFmReconMappingInfo;
import com.kingdee.eas.fm.recon.SipgReconType;
import com.kingdee.eas.fm.recon.client.AbstractFmReconCenterFilterUI;
import com.kingdee.eas.fm.recon.client.FmReconCenterFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FmReconCenterFilterUI
extends AbstractFmReconCenterFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FmReconCenterFilterUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmSettleResource";
    private static final String FMRECON_RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmReconResource";
    private UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    protected Class getParamClass() {
        return FmReconCenterFilterParam.class;
    }

    public Object getParam() {
        FmReconCenterFilterParam param = new FmReconCenterFilterParam();
        if (!(this.kdstates.getSelectedItem() instanceof FMSysDefinedEnum)) {
            param.setReconedStatus((SipgReconType)((Object)this.kdstates.getSelectedItem()));
        }
        param.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        param.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        param.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        param.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        param.setRadUnPosted(this.radUnPosted.isSelected());
        return param;
    }

    public void setParam(Object param) {
        FmReconCenterFilterParam filterParam = (FmReconCenterFilterParam)param;
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.radUnPosted.setSelected(filterParam.isRadUnPosted());
        if (filterParam.getReconedStatus() == null) {
            this.kdstates.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            this.kdstates.setSelectedItem((Object)filterParam.getReconedStatus());
        }
    }

    public boolean verify() {
        if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiEndYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth)) {
            this.spiBeginYear.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"18_ENDPERIOD_LESS_BEGINPERIOD"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Date now = new Date();
        Date one = new Date(now.getYear(), now.getMonth() - 1, now.getDay());
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo period = PeriodUtils.getPeriodInfo(null, (Date)now, (CompanyOrgUnitInfo)company);
        this.spiBeginYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spiBeginMonth.setValue((Object)new Integer(period.getPeriodNumber()));
        this.spiEndYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spiEndMonth.setValue((Object)(new Integer(period.getPeriodNumber()) + 1));
        if (this.kdstates.getItemCount() < FMSysDefinedEnum.getEnumList().size()) {
            this.kdstates.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
        this.kdstates.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.radUnPosted.setSelected(false);
    }

    public HashMap getQueryParams() throws BOSException {
        HashMap<String, Object> hmParams = new HashMap<String, Object>();
        if (!(this.kdstates.getSelectedItem() instanceof FMSysDefinedEnum)) {
            hmParams.put("reconedStatus", (Object)((SipgReconType)((Object)this.kdstates.getSelectedItem())));
        } else {
            hmParams.put("reconedStatus", null);
        }
        CompanyOrgUnitCollection companyOrgUnitCollection = this.getcompanyColl();
        hmParams.put("companycollection", companyOrgUnitCollection);
        PeriodCollection collection = this.getcollection(companyOrgUnitCollection);
        Set<Object> periodIds = new HashSet();
        periodIds = this.getPeriodIds(collection);
        hmParams.put("periodIds", periodIds);
        hmParams.put("Periodcollection", collection);
        SipgFmReconMappingInfo sipgFmReconMappingInfo = this.getMapping(companyOrgUnitCollection);
        hmParams.put("reconMapping", sipgFmReconMappingInfo);
        SipgFmReconDirectionInfo sipgFmReconDirectionInfo = this.getDirection();
        hmParams.put("reconDirection", sipgFmReconDirectionInfo);
        hmParams.put("radUnPosted", this.radUnPosted.isSelected());
        return hmParams;
    }

    private PeriodCollection getcollection(CompanyOrgUnitCollection companyOrgUnitCollection) throws BOSException {
        CompanyOrgUnitInfo info = companyOrgUnitCollection.get(0);
        PeriodCollection periocColl = PeriodHelper.getPeriodColl(null, (String)info.getAccountPeriodType().getId().toString(), (int)this.spiBeginYear.getIntegerVlaue(), (int)this.spiBeginMonth.getIntegerVlaue(), (int)this.spiEndYear.getIntegerVlaue(), (int)this.spiEndMonth.getIntegerVlaue());
        return periocColl;
    }

    private CompanyOrgUnitCollection getcompanyColl() throws BOSException {
        CompanyOrgUnitCollection collection = new CompanyOrgUnitCollection();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        ev.setFilter(filter);
        collection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
        String typeid = null;
        for (int i = 0; i < collection.size(); ++i) {
            CompanyOrgUnitInfo info = collection.get(i);
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)info)) {
                collection.remove(info);
                continue;
            }
            if (!this.hasperssion(info.getId())) {
                collection.remove(info);
                continue;
            }
            if (typeid == null) {
                typeid = info.getAccountPeriodType().getId().toString();
                continue;
            }
            if (typeid.equals(info.getAccountPeriodType().getId().toString())) continue;
            collection.remove(info);
        }
        if (collection.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"005_perssionCompany"));
            SysUtil.abort();
        }
        return collection;
    }

    private boolean hasperssion(BOSUuid orgPK) {
        String[] perssions = new String[]{"LOAN_RECON", "RECEIVABLE_RECON", "PAYABLE_RECON", "CONSIGNLOAN_RECON", "CONSIGNINTERST_RECON", "TIMEDEOPSIT_RECON", "LOANINTERST_RECON"};
        try {
            IPermission permission = PermissionFactory.getRemoteInstance();
            for (int i = 0; i < perssions.length; ++i) {
                boolean hasperssion = permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.currentUser.getId()), (IObjectPK)new ObjectUuidPK(orgPK), perssions[i]);
                if (!hasperssion) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private Set<String> getPeriodIds(PeriodCollection collection) {
        HashSet<String> periodIds = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            periodIds.add(collection.get(i).getId().toString());
        }
        return periodIds;
    }

    private SipgFmReconDirectionInfo getDirection() throws BOSException {
        SipgFmReconDirectionInfo directionInfo = new SipgFmReconDirectionInfo();
        SipgFmReconDirectionCollection collection = new SipgFmReconDirectionCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        evi.setFilter(filter);
        collection = SipgFmReconDirectionFactory.getRemoteInstance().getSipgFmReconDirectionCollection(evi);
        if (collection == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"002_nodirection"));
            SysUtil.abort();
        } else {
            directionInfo = collection.get(0);
        }
        return directionInfo;
    }

    private SipgFmReconMappingInfo getMapping(CompanyOrgUnitCollection companyOrgUnitCollection) throws BOSException {
        SipgFmReconMappingInfo mappingInfo = new SipgFmReconMappingInfo();
        SipgFmReconMappingCollection mappingCollection = new SipgFmReconMappingCollection();
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo cuInfo = companyOrgUnitCollection.get(i);
            EntityViewInfo evis = new EntityViewInfo();
            FilterInfo filters = new FilterInfo();
            filters.getFilterItems().add(new FilterItemInfo("company", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
            evis.setFilter(filters);
            mappingCollection.addCollection(SipgFmReconMappingFactory.getRemoteInstance().getSipgFmReconMappingCollection(evis));
            if (mappingCollection.size() > 0) break;
        }
        if (mappingCollection.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"003_nomapping"));
            SysUtil.abort();
        }
        return mappingInfo;
    }

    protected void init() throws Exception {
        this.initPeriod();
        this.companyIds = new String[]{this.currentCompany.getId().toString()};
        FMClientHelper.manageAccountLevelRange((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndMonth);
    }

    public void clear() {
        try {
            this.onLoad();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initPeriod() throws EASBizException, BOSException {
        if (this.currentCompany != null && this.currentCompany.isIsBizUnit() && this.currentCompany != null && this.currentCompany.isIsBizUnit()) {
            PeriodHelper.initPeriodSpinner((KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth);
            PeriodHelper.initPeriodSpinner((KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth);
        }
    }
}

