/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.recon.FmReconResultCollection;
import com.kingdee.eas.fm.recon.FmReconResultFactory;
import com.kingdee.eas.fm.recon.FmReconResultInfo;
import com.kingdee.eas.fm.recon.ISipgFmReconFacade;
import com.kingdee.eas.fm.recon.SipgFmBizTypeEnum;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionFactory;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconFacadeFactory;
import com.kingdee.eas.fm.recon.SipgFmReconMappingCollection;
import com.kingdee.eas.fm.recon.SipgFmReconMappingFactory;
import com.kingdee.eas.fm.recon.SipgFmReconMappingInfo;
import com.kingdee.eas.fm.recon.SipgReconType;
import com.kingdee.eas.fm.recon.client.AbstractFmReconResultHeadList;
import com.kingdee.eas.fm.recon.client.FmReconCenterFilterUI;
import com.kingdee.eas.fm.recon.client.FmReconFilterParam;
import com.kingdee.eas.fm.recon.client.SipgFmReconConsignLoanUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconConsignmentBillUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconFinancingAccountUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconFundTransferBillUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconFundTransferInterestBillUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconInterestUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconLoanBillUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconPayableBillUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconReceivableBillUI;
import com.kingdee.eas.fm.recon.client.SipgFmReconTimeDeopsitUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FmReconResultHeadList
extends AbstractFmReconResultHeadList {
    private static final Logger logger = CoreUIObject.getLogger(FmReconResultHeadList.class);
    private FmReconCenterFilterUI filterUI;
    private IContextHelper contextHelp = ContextHelperFactory.getRemoteInstance();
    HashMap hmMapping = new HashMap();
    PeriodInfo reconPeriod;
    private static final String FMRECON_RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmReconResource";
    HashMap inParam = new HashMap();
    private CompanyOrgUnitInfo orgUnitInfo;
    private Color YES_COLOR = new Color(0, 128, 0);
    private Color NO_COLOR = new Color(255, 0, 0);
    private Color NoReconed_COLOR = new Color(255, 255, 0);
    private UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void executeQuery(FilterParam param) throws BOSException {
        this.inParam = this.filterUI.getQueryParams();
        PeriodCollection collection = (PeriodCollection)this.inParam.get("Periodcollection");
        CompanyOrgUnitCollection orgUnitCollection = (CompanyOrgUnitCollection)this.inParam.get("companycollection");
        Set directionIds = this.getDirectionIds();
        Set mapingIds = new HashSet();
        HashSet filtermapingIds = new HashSet();
        Set periodIds = (Set)this.inParam.get("periodIds");
        for (int o = 0; o < orgUnitCollection.size(); ++o) {
            this.orgUnitInfo = orgUnitCollection.get(o);
            mapingIds = (Set)this.getMappingIds(this.orgUnitInfo).get("mapingIds");
            filtermapingIds.addAll(mapingIds);
            if (mapingIds == null) continue;
            for (int c = 0; c < collection.size(); ++c) {
                HashSet addmapingIds = new HashSet(mapingIds);
                this.reconPeriod = collection.get(c);
                EntityViewInfo evis = new EntityViewInfo();
                FilterInfo filters = new FilterInfo();
                filters.getFilterItems().add(new FilterItemInfo("company", (Object)this.orgUnitInfo.getId().toString(), CompareType.EQUALS));
                filters.getFilterItems().add(new FilterItemInfo("mapping", mapingIds, CompareType.INCLUDE));
                filters.getFilterItems().add(new FilterItemInfo("direction", (Object)directionIds, CompareType.INCLUDE));
                filters.getFilterItems().add(new FilterItemInfo("PeriodEntry", (Object)this.reconPeriod.getId().toString(), CompareType.EQUALS));
                evis.setFilter(filters);
                FmReconResultCollection resultColl = FmReconResultFactory.getRemoteInstance().getFmReconResultCollection(evis);
                for (int i = 0; i < resultColl.size(); ++i) {
                    String mappingId = resultColl.get(i).getMapping().getId().toString();
                    addmapingIds.remove(mappingId);
                }
                try {
                    if (addmapingIds.size() <= 0) continue;
                    this.addResult(addmapingIds);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
        }
        if (filtermapingIds.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"003_nomapping"));
            SysUtil.abort();
        }
        FmReconFilterParam filterParam = new FmReconFilterParam();
        if (this.inParam.get("reconedStatus") != null) {
            filterParam.setReconedStatus((SipgReconType)((Object)this.inParam.get("reconedStatus")));
        }
        filterParam.setDirectionIds(directionIds);
        filterParam.setMapingIds(filtermapingIds);
        filterParam.setPeriodIds(periodIds);
        super.executeQuery((FilterParam)filterParam);
    }

    protected void execQuery() {
        super.execQuery();
        this.tblMain.checkParsed();
        this.fillColor();
    }

    public void fillColor() {
        IRow row = null;
        this.tblMain.setRefresh(false);
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            ICell statescell = row.getCell("states");
            ICell diffcell = row.getCell("diffAmount");
            ICell timecell = row.getCell("sipgTime");
            BizEnumValueInfo enumValueInfo = (BizEnumValueInfo)row.getCell("states").getValue();
            Object reconType = enumValueInfo.getValue();
            if (reconType.toString().equals("1")) {
                statescell.getStyleAttributes().setBackground(this.YES_COLOR);
                diffcell.getStyleAttributes().setBackground(this.YES_COLOR);
                timecell.getStyleAttributes().setBackground(this.YES_COLOR);
                continue;
            }
            if (reconType.toString().equals("2")) {
                statescell.getStyleAttributes().setBackground(this.NO_COLOR);
                diffcell.getStyleAttributes().setBackground(this.NO_COLOR);
                timecell.getStyleAttributes().setBackground(this.NO_COLOR);
                continue;
            }
            if (!reconType.toString().equals("0")) continue;
            statescell.getStyleAttributes().setBackground(this.NoReconed_COLOR);
            diffcell.getStyleAttributes().setBackground(this.NoReconed_COLOR);
            timecell.getStyleAttributes().setBackground(this.NoReconed_COLOR);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    private void addResult(Set mapingIds) throws EASBizException, BOSException {
        CoreBaseCollection resultCollection = new CoreBaseCollection();
        UserInfo creator = this.contextHelp.getCurrentUser();
        Iterator it = mapingIds.iterator();
        while (it.hasNext()) {
            FmReconResultInfo resultInfo = new FmReconResultInfo();
            String id = (String)it.next();
            SipgFmReconMappingInfo mappingInfo = SipgFmReconMappingFactory.getRemoteInstance().getSipgFmReconMappingInfo((IObjectPK)new ObjectUuidPK(id));
            SipgFmReconDirectionInfo directionInfo = this.getdiretion(mappingInfo.getFmBizType());
            if (directionInfo == null) continue;
            resultInfo.setMapping(mappingInfo);
            resultInfo.setDirection(directionInfo);
            resultInfo.setPeriodEntry(this.reconPeriod);
            resultInfo.setFmBizType(mappingInfo.getFmBizType());
            resultInfo.setCompany(this.orgUnitInfo);
            resultInfo.setCreator(creator);
            resultInfo.setReconedStatus(SipgReconType.NoReconed);
            resultCollection.add((CoreBaseInfo)resultInfo);
        }
        FmReconResultFactory.getRemoteInstance().save(resultCollection);
    }

    private SipgFmReconDirectionInfo getdiretion(SipgFmBizTypeEnum fmBizType) throws BOSException {
        SipgFmReconDirectionCollection directionCollection = new SipgFmReconDirectionCollection();
        SipgFmReconDirectionInfo directionInfo = new SipgFmReconDirectionInfo();
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("bizType", (Object)new Integer(fmBizType.getValue()), CompareType.EQUALS));
        evis.setFilter(filters);
        directionCollection = SipgFmReconDirectionFactory.getRemoteInstance().getSipgFmReconDirectionCollection(evis);
        if (directionCollection.size() == 0) {
            return null;
        }
        directionInfo = directionCollection.get(0);
        return directionInfo;
    }

    private HashMap getMappingIds(CompanyOrgUnitInfo orgUnitInfo2) throws BOSException {
        HashSet<String> mapingIds = new HashSet<String>();
        SipgFmReconMappingCollection mappingCollection = new SipgFmReconMappingCollection();
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgUnitInfo2.getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        evis.setFilter(filters);
        mappingCollection = SipgFmReconMappingFactory.getRemoteInstance().getSipgFmReconMappingCollection(evis);
        if (mappingCollection.size() == 0) {
            this.hmMapping.put("mapingIds", null);
            this.hmMapping.put("mappingColl", null);
        } else {
            for (int i = 0; i < mappingCollection.size(); ++i) {
                boolean hasperssion = this.hasperssion(mappingCollection.get(i).getFmBizType(), orgUnitInfo2.getId());
                mapingIds.add(mappingCollection.get(i).getId().toString());
            }
        }
        this.hmMapping.put("mapingIds", mapingIds);
        this.hmMapping.put("mappingColl", mappingCollection);
        return this.hmMapping;
    }

    private boolean hasperssion(SipgFmBizTypeEnum fmBizType, BOSUuid orgPK) {
        String perssion = null;
        switch (Integer.parseInt(fmBizType.getValue())) {
            case 1: {
                perssion = "RECEIVABLE_RECON";
                break;
            }
            case 2: {
                perssion = "PAYABLE_RECON";
                break;
            }
            case 3: {
                perssion = "LOAN_RECON";
                break;
            }
            case 4: {
                perssion = "TIMEDEOPSIT_RECON";
                break;
            }
            case 5: {
                perssion = "CONSIGNLOAN_RECON";
                break;
            }
            case 6: {
                perssion = "LOANINTERST_RECON";
                break;
            }
            case 7: {
                perssion = "CONSIGNINTERST_RECON";
            }
        }
        try {
            IPermission permission = PermissionFactory.getRemoteInstance();
            boolean hasperssion = permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.currentUser.getId()), (IObjectPK)new ObjectUuidPK(orgPK), perssion);
            if (hasperssion) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private Set getDirectionIds() throws BOSException {
        HashSet<String> directionIds = new HashSet<String>();
        SipgFmReconDirectionCollection directionCollection = new SipgFmReconDirectionCollection();
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        evis.setFilter(filters);
        directionCollection = SipgFmReconDirectionFactory.getRemoteInstance().getSipgFmReconDirectionCollection(evis);
        if (directionCollection.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"002_nodirection"));
            SysUtil.abort();
        } else {
            for (int i = 0; i < directionCollection.size(); ++i) {
                directionIds.add(directionCollection.get(i).getId().toString());
            }
        }
        return directionIds;
    }

    @Override
    public void actionRecon_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        for (int i = 0; i < idList.size(); ++i) {
            ISipgFmReconFacade fmReconFacade;
            List result;
            String id = (String)idList.get(i);
            FmReconResultInfo info = FmReconResultFactory.getRemoteInstance().getFmReconResultInfo((IObjectPK)new ObjectUuidPK(id));
            PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(info.getPeriodEntry().getId().toString()));
            SipgFmReconMappingInfo sipgFmReconMappingInfo = SipgFmReconMappingFactory.getRemoteInstance().getSipgFmReconMappingInfo((IObjectPK)new ObjectUuidPK(info.getMapping().getId().toString()));
            SipgFmReconDirectionInfo sipgFmReconDirectionInfo = SipgFmReconDirectionFactory.getRemoteInstance().getSipgFmReconDirectionInfo((IObjectPK)new ObjectUuidPK(info.getDirection().getId().toString()));
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
            this.inParam.put("bizType", info.getFmBizType().getName());
            this.inParam.put("reconPeriod", periodInfo);
            this.inParam.put("reconMapping", sipgFmReconMappingInfo);
            this.inParam.put("reconDirection", sipgFmReconDirectionInfo);
            this.inParam.put("companyInfo", companyOrgUnitInfo);
            if (this.inParam.containsKey("currencyIds")) {
                this.inParam.remove("currencyIds");
            }
            if (this.inParam.containsKey("productIds")) {
                this.inParam.remove("productIds");
            }
            if ((result = (fmReconFacade = SipgFmReconFacadeFactory.getRemoteInstance()).fetchReconResult(this.inParam)) == null) continue;
            fmReconFacade.addReconResult(result, this.inParam);
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"006_reconSucess"));
        this.refreshList();
        SysUtil.abort();
    }

    @Override
    public void actionViewResult_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"007_recon_error01"));
            SysUtil.abort();
        }
        if ((rowIndex = this.tblMain.getSelectManager().getActiveRowIndex()) < 0) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        String currenId = null;
        String productId = null;
        HashSet<String> currenSet = new HashSet<String>();
        HashSet<String> productSet = new HashSet<String>();
        if (row.getCell("currency.id") != null) {
            currenId = (String)row.getCell("currency.id").getValue();
            currenSet.add(currenId);
        }
        if (row.getCell("products.id") != null) {
            productId = (String)row.getCell("products.id").getValue();
            productSet.add(productId);
        }
        String id = (String)idList.get(0);
        FmReconResultInfo info = FmReconResultFactory.getRemoteInstance().getFmReconResultInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getReconedStatus() == SipgReconType.NoReconed) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"007_recon_error02"));
            SysUtil.abort();
        }
        PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(info.getPeriodEntry().getId().toString()));
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        SipgFmReconDirectionInfo sipgFmReconDirectionInfo = SipgFmReconDirectionFactory.getRemoteInstance().getSipgFmReconDirectionInfo((IObjectPK)new ObjectUuidPK(info.getDirection().getId().toString()));
        SipgFmReconMappingInfo sipgFmReconMappingInfo = null;
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("id", (Object)info.getMapping().getId().toString(), CompareType.EQUALS));
        evis.setFilter(filters);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.account.*"));
        sic.add(new SelectorItemInfo("entrys.products.*"));
        sic.add(new SelectorItemInfo("entrys.billType.*"));
        sic.add(new SelectorItemInfo("entrys.Institution.*"));
        sic.add(new SelectorItemInfo("entrys.accountBank.*"));
        sic.add(new SelectorItemInfo("entrys.financeFinancing.*"));
        evis.setSelector(sic);
        SipgFmReconMappingCollection mappingCollection = SipgFmReconMappingFactory.getRemoteInstance().getSipgFmReconMappingCollection(evis);
        if (null != mappingCollection && null != mappingCollection.get(0)) {
            sipgFmReconMappingInfo = mappingCollection.get(0);
        }
        this.inParam.put("bizType", info.getFmBizType().getName());
        this.inParam.put("reconPeriod", periodInfo);
        this.inParam.put("companyInfo", companyOrgUnitInfo);
        this.inParam.put("reconMapping", sipgFmReconMappingInfo);
        this.inParam.put("reconDirection", sipgFmReconDirectionInfo);
        if (!EmptyUtil.isEmpty((String)currenId)) {
            this.inParam.put("currencyIds", currenSet);
        }
        if (!EmptyUtil.isEmpty(productSet)) {
            this.inParam.put("productIds", productSet);
        }
        this.creatUI(this.inParam, info);
    }

    private void creatUI(HashMap inParam, FmReconResultInfo info) throws UIException {
        SecureRandom random = new SecureRandom();
        int i = random.nextInt(51) + 50;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"filterParam", (Object)inParam);
        uiContext.put((Object)"UIClassParam", (Object)String.valueOf(i));
        IUIWindow uiWindow = null;
        SipgFmBizTypeEnum bizTypeEnum = info.getFmBizType();
        switch (Integer.parseInt(bizTypeEnum.getValue())) {
            case 1: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconReceivableBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 2: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconPayableBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 3: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconLoanBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 4: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconTimeDeopsitUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 5: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconConsignmentBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 6: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconInterestUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 7: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconConsignLoanUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 8: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconFundTransferBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 9: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconFundTransferInterestBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
                break;
            }
            case 10: {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(SipgFmReconFinancingAccountUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
            }
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filterUI) {
            this.filterUI = new FmReconCenterFilterUI();
        }
        return this.filterUI;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        String[] keys = new String[]{"PeriodEntry.fmPeriod", "company.name"};
        return keys;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
    }

    protected boolean isCanOrderTable() {
        return false;
    }
}

