/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.recon.SipgFmBillStateEnum;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionFactory;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.client.AbstractSipgFmReconDirectionListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SipgFmReconDirectionListUI
extends AbstractSipgFmReconDirectionListUI {
    private static final String RECON_RES = "com.kingdee.eas.fm.recon.FmReconBaseResource";
    private static final Logger logger = CoreUIObject.getLogger(SipgFmReconDirectionListUI.class);

    protected void beforeExcutQuery(EntityViewInfo arg0) {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cuInfo != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
            try {
                filter.mergeFilter(arg0.getFilter(), "and");
                arg0.setFilter(filter);
            }
            catch (BOSException e) {
                e.printStackTrace();
                MsgBox.showError((String)e.getMessage());
                SysUtil.abort();
            }
        }
        super.beforeExcutQuery(arg0);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionQuery.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionCancel.setVisible(true);
        this.actionCancelCancel.setVisible(true);
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(dformat);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        SelectorItemCollection src = new SelectorItemCollection();
        src.add("id");
        src.add("billState");
        SipgFmReconDirectionInfo info = SipgFmReconDirectionFactory.getRemoteInstance().getSipgFmReconDirectionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), src);
        if (SipgFmBillStateEnum.start.equals((Object)info.getBillState())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RECON_RES, (String)"19_StartDirectionCannotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        Map map = SipgFmReconDirectionFactory.getRemoteInstance().actionCancel(idSet);
        String errorDetail = (String)map.get("errorDetail");
        Integer validCount = (Integer)map.get("validCount");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)RECON_RES, (String)"9_StopFailed", (Object[])new Object[]{validCount, idSet.size() - validCount});
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
        SysUtil.abort();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        Map map = SipgFmReconDirectionFactory.getRemoteInstance().actionCancelCancel(idSet);
        String errorDetail = (String)map.get("errorDetail");
        Integer validCount = (Integer)map.get("validCount");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)RECON_RES, (String)"10_StartFailed", (Object[])new Object[]{validCount, idSet.size() - validCount});
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
        SysUtil.abort();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        Map map = SipgFmReconDirectionFactory.getRemoteInstance().actionRemove(idSet);
        String errorDetail = (String)map.get("errorDetail");
        Integer validCount = (Integer)map.get("validCount");
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)RECON_RES, (String)"34_RemoveFailed", (Object[])new Object[]{validCount, idSet.size() - validCount});
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SipgFmReconDirectionFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        SipgFmReconDirectionInfo objectValue = new SipgFmReconDirectionInfo();
        return objectValue;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }
}

