/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.recon.SipgFmBillStateEnum;
import com.kingdee.eas.fm.recon.SipgFmReconMappingFactory;
import com.kingdee.eas.fm.recon.SipgFmReconMappingInfo;
import com.kingdee.eas.fm.recon.client.AbstractSipgFmReconMappingListUI;
import com.kingdee.eas.fm.recon.client.ISipgFmReconMappingCopy;
import com.kingdee.eas.fm.recon.client.SipgFmReconMappingCopyFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SipgFmReconMappingListUI
extends AbstractSipgFmReconMappingListUI {
    private static final Logger logger = CoreUIObject.getLogger(SipgFmReconMappingListUI.class);
    private static final String RECON_RES = "com.kingdee.eas.fm.recon.FmReconBaseResource";

    protected void beforeExcutQuery(EntityViewInfo arg0) {
        super.beforeExcutQuery(arg0);
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            MsgBox.showWarning((String)EASResource.getString((String)RECON_RES, (String)"46_CompanyUnionCannotMapping"));
            SysUtil.abort();
        }
        if (companyInfo != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
            try {
                filter.mergeFilter(arg0.getFilter(), "and");
                arg0.setFilter(filter);
            }
            catch (BOSException e) {
                e.printStackTrace();
                MsgBox.showError((String)e.getMessage());
                SysUtil.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionCloudFeed.setVisible(false);
        this.actionXunTongFeed.setVisible(false);
        this.actionQuery.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionQueryScheme.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkflowList.setVisible(false);
        this.actionSignature.setVisible(false);
        this.actoinViewSignature.setVisible(false);
        this.actionNumberSign.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionViewDoProccess.setVisible(false);
        this.actionCancel.setVisible(true);
        this.actionCancelCancel.setVisible(true);
        this.actionCopyMapping.setVisible(true);
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(dformat);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SipgFmReconMappingFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        SipgFmReconMappingInfo objectValue = new SipgFmReconMappingInfo();
        return objectValue;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        Map map = SipgFmReconMappingFactory.getRemoteInstance().actionCancel(idSet);
        String errorDetail = (String)map.get("errorDetail");
        Integer validCount = (Integer)map.get("validCount");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)RECON_RES, (String)"9_StopFailed", (Object[])new Object[]{validCount, idSet.size() - validCount});
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
        SysUtil.abort();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        Map map = SipgFmReconMappingFactory.getRemoteInstance().actionCancelCancel(idSet);
        String errorDetail = (String)map.get("errorDetail");
        Integer validCount = (Integer)map.get("validCount");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)RECON_RES, (String)"10_StartFailed", (Object[])new Object[]{validCount, idSet.size() - validCount});
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
        SysUtil.abort();
    }

    @Override
    public void actionCopyMapping_actionPerformed(ActionEvent e) throws Exception {
        ISipgFmReconMappingCopy iSFRMC = SipgFmReconMappingCopyFactory.createInstance();
        String companyID = iSFRMC.showDialogWindow();
        if (companyID == null) {
            SysUtil.abort();
        }
        Map map = SipgFmReconMappingFactory.getRemoteInstance().copyMapping(companyID);
        String errorDetail = (String)map.get("errorDetail");
        Integer validCount = (Integer)map.get("validCount");
        Integer falseCount = (Integer)map.get("falseCount");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)RECON_RES, (String)"11_CopyMappingFailed", (Object[])new Object[]{validCount, falseCount});
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
        SysUtil.abort();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        SelectorItemCollection src = new SelectorItemCollection();
        src.add("id");
        src.add("billState");
        SipgFmReconMappingInfo info = SipgFmReconMappingFactory.getRemoteInstance().getSipgFmReconMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), src);
        if (SipgFmBillStateEnum.start.equals((Object)info.getBillState())) {
            MsgBox.showWarning((String)EASResource.getString((String)RECON_RES, (String)"8_StartMappingCannotEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        Map map = SipgFmReconMappingFactory.getRemoteInstance().actionRemove(idSet);
        String errorDetail = (String)map.get("errorDetail");
        Integer validCount = (Integer)map.get("validCount");
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)RECON_RES, (String)"34_RemoveFailed", (Object[])new Object[]{validCount, idSet.size() - validCount});
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }
}

