/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.recon.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.IO_Period;
import com.kingdee.eas.basedata.assistant.IPeriodType;
import com.kingdee.eas.basedata.assistant.O_PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.recon.SipgFmBizTypeEnum;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionCollection;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionFactory;
import com.kingdee.eas.fm.recon.SipgFmReconDirectionInfo;
import com.kingdee.eas.fm.recon.SipgFmReconMappingCollection;
import com.kingdee.eas.fm.recon.SipgFmReconMappingFactory;
import com.kingdee.eas.fm.recon.SipgFmReconMappingInfo;
import com.kingdee.eas.fm.recon.client.AbstractSipgFmReconQueryFilterBaseUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComboBoxItem;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class SipgFmReconQueryFilterBaseUI
extends AbstractSipgFmReconQueryFilterBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(SipgFmReconQueryFilterBaseUI.class);
    private static final String RECON_RES = "com.kingdee.eas.fm.recon.FmReconBaseResource";
    private static final String FMRECON_RESOURCE_PATH = "com.kingdee.eas.fm.recon.FmReconResource";
    private IO_Period iO_Period;
    private IPeriodType iPeriodType;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cbxReconYear_actionPerformed(ActionEvent e) throws Exception {
        if (!this.cbxReconYear.getSelectedItem().toString().equals("")) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
            evi.setFilter(filter);
        }
        super.cbxReconYear_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo Company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)Company)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FMRECON_RESOURCE_PATH, (String)"004_bizCompany"));
            SysUtil.abort();
        }
        super.onLoad();
        this.cbxReconYear.removeAllItems();
        ComboBoxItem item = new ComboBoxItem();
        item.setKey("-1");
        item.setValue((Object)new Integer(-1));
        int[] years = this.getYears(Company);
        for (int i = 0; i < years.length; ++i) {
            item = new ComboBoxItem();
            item.setKey(String.valueOf(years[i]));
            item.setValue((Object)new Integer(years[i]));
            this.cbxReconYear.addItem((Object)item);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("bizType", (Object)(this.cbxBizType.getSelectedIndex() + 1), CompareType.LIKE));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        this.prmtReconDirection.setEntityViewInfo(evi);
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.LIKE));
        filters.getFilterItems().add(new FilterItemInfo("fmBizType", (Object)(this.cbxBizType.getSelectedIndex() + 1), CompareType.LIKE));
        filters.setMaskString("#0 and #1");
        evis.setFilter(filters);
        this.prmtReconMapping.setEntityViewInfo(evis);
        this.cbxBizType.setEnabled(false);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        EntityViewInfo periodevi = new EntityViewInfo();
        FilterInfo periodevifilter = new FilterInfo();
        periodevifilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        periodevi.setFilter(periodevifilter);
        this.prmtReconPeriod.setEntityViewInfo(periodevi);
        this.prmtReconPeriod.setEditable(false);
        this.kDLabelContainer7.setVisible(true);
        this.kDLabelContainer7.setBounds(new Rectangle(17, 128, 270, 19));
        super.add((Component)this.kDLabelContainer7, null);
        this.radUnPosted.setVisible(true);
        this.radUnPosted.setBounds(new Rectangle(17, 181, 270, 19));
        super.add((Component)this.radUnPosted, null);
    }

    public void onshow() {
        this.kDLabelContainer7.setBounds(new Rectangle(17, 128, 270, 19));
        super.add((Component)this.kDLabelContainer7, null);
        this.radUnPosted.setBounds(new Rectangle(17, 181, 270, 19));
        super.add((Component)this.radUnPosted, null);
    }

    private int[] getYears(CompanyOrgUnitInfo company) throws Exception {
        Object cbType = null;
        String cbTypeid = null;
        if (this.iO_Period == null) {
            this.iO_Period = O_PeriodFactory.getRemoteInstance();
        }
        PeriodTypeInfo info = (PeriodTypeInfo)company.get("accountperiodtype");
        cbTypeid = info.getId().toString();
        return this.iO_Period.getAllPeriodYear(cbTypeid);
    }

    public boolean verify() {
        if (this.prmtReconPeriod.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RECON_RES, (String)"37_ReconPeriodIsNull"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public HashMap getQueryParams() throws BOSException {
        HashMap<String, Object> hmParams = new HashMap<String, Object>();
        hmParams.put("bizType", ((SipgFmBizTypeEnum)((Object)this.cbxBizType.getSelectedItem())).getName());
        hmParams.put("reconYear", this.cbxReconYear.getSelectedItem().toString());
        PeriodInfo sipgFmReconPeriodEntryInfo = (PeriodInfo)this.prmtReconPeriod.getValue();
        hmParams.put("reconPeriod", sipgFmReconPeriodEntryInfo);
        SipgFmReconMappingInfo sipgFmReconMappingInfo = this.getMapping();
        hmParams.put("reconMapping", sipgFmReconMappingInfo);
        SipgFmReconDirectionInfo sipgFmReconDirectionInfo = this.getDirection();
        hmParams.put("reconDirection", sipgFmReconDirectionInfo);
        hmParams.put("Type", (Object)((SipgFmBizTypeEnum)((Object)this.cbxBizType.getSelectedItem())));
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RECON_RES, (String)"38_CompanyUnionCannotRecon"));
            SysUtil.abort();
        }
        Set currencyIds = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency));
        hmParams.put("currencyIds", currencyIds);
        hmParams.put("companyInfo", currentCompany);
        hmParams.put("radUnPosted", this.radUnPosted.isSelected());
        return hmParams;
    }

    private SipgFmReconDirectionInfo getDirection() throws BOSException {
        SipgFmReconDirectionInfo directionInfo = new SipgFmReconDirectionInfo();
        SipgFmReconDirectionCollection collection = new SipgFmReconDirectionCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("bizType", (Object)(this.cbxBizType.getSelectedIndex() + 1), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        evi.setFilter(filter);
        collection = SipgFmReconDirectionFactory.getRemoteInstance().getSipgFmReconDirectionCollection(evi);
        if (collection.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RECON_RES, (String)"39_NoStartDirection"));
            SysUtil.abort();
        } else {
            directionInfo = collection.get(0);
        }
        return directionInfo;
    }

    private SipgFmReconMappingInfo getMapping() throws BOSException {
        SipgFmReconMappingInfo mappingInfo = new SipgFmReconMappingInfo();
        SipgFmReconMappingCollection mappingCollection = new SipgFmReconMappingCollection();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        EntityViewInfo evis = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("fmBizType", (Object)(this.cbxBizType.getSelectedIndex() + 1), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer("2"), CompareType.EQUALS));
        evis.setFilter(filters);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.account.*"));
        sic.add(new SelectorItemInfo("entrys.products.*"));
        sic.add(new SelectorItemInfo("entrys.billType.*"));
        sic.add(new SelectorItemInfo("entrys.Institution.*"));
        sic.add(new SelectorItemInfo("entrys.accountBank.*"));
        sic.add(new SelectorItemInfo("entrys.financeFinancing.*"));
        evis.setSelector(sic);
        mappingCollection = SipgFmReconMappingFactory.getRemoteInstance().getSipgFmReconMappingCollection(evis);
        if (mappingCollection.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RECON_RES, (String)"40_NoStartMapping"));
            SysUtil.abort();
        } else {
            mappingInfo = mappingCollection.get(0);
        }
        return mappingInfo;
    }
}

